#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Features.Transforms.Basis import Basis

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.6.post2'
__CHEETAH_versionTuple__ = (3, 2, 6, 'post', 2)
__CHEETAH_genTime__ = 1634954792.8583395
__CHEETAH_genTimestamp__ = 'Sat Oct 23 13:06:32 2021'
__CHEETAH_src__ = '/home/mattias/xmds-3.0.0/admin/staging/xmds-3.1.0/xpdeint/Features/Transforms/HermiteGaussTwiddleBasis.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class HermiteGaussTwiddleBasis(Basis):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(HermiteGaussTwiddleBasis, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Hermite-Gauss Twiddle basis (Multiplies eigenvalues by i) at line 29, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''Hermite-Gauss Twiddle basis (Multiplies eigenvalues by i)''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def costEstimate(self, basisReps, **KWS):



        ## CHEETAH: generated from @def costEstimate(basisReps) at line 34, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        return min([rep.latticeEstimate for rep in basisReps])
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformFunction(self, transformID, transformDict, function, **KWS):



        ## CHEETAH: generated from @def transformFunction(transformID, transformDict, function) at line 39, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        transformPair = transformDict['transformPair']
        forwardDimRep = transformPair[0][0]
        backwardDimRep = transformPair[1][0]
        isOutOfPlace = transformDict.get('outOfPlace', True)
        write('''static const complex _forward_multipliers[4] = {1, -i, -1, i};
static const complex _backward_multipliers[4] = {1, i, -1, -i};
complex* const __restrict__ source_data = reinterpret_cast<complex* const>(_data_in);
''')
        if isOutOfPlace: # generated from line 48, col 1
            write('''complex* const __restrict__ dest_data = reinterpret_cast<complex* const>(_data_out);
''')
        write('''
const complex* const __restrict__ _multipliers = _forward ? _forward_multipliers : _backward_multipliers;

''')
        featureOrdering = ['OpenMP']
        featureDict = {  'templateString': ''}
        write('''for (long _i0 = 0; _i0 < _prefix_lattice; _i0++) {
  for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 59, col 28
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 59, col 28.
        write('''; _i1++) {
    long multiplier_index = (_i1 & 3);
''')
        if not isOutOfPlace: # generated from line 61, col 5
            write('''    if (multiplier_index == 0) continue;
''')
        write('''    
    const complex multiplier = _multipliers[multiplier_index];
    
    #pragma ivdep
''')
        _v = VFFSL(SL,"insertCodeForFeatures",False)('loopOverVectorsWithInnerContentTemplateBegin', featureOrdering, featureDict) # "${insertCodeForFeatures('loopOverVectorsWithInnerContentTemplateBegin', featureOrdering, featureDict)}" on line 68, col 1
        if _v is not None: write(_filter(_v, rawExpr="${insertCodeForFeatures('loopOverVectorsWithInnerContentTemplateBegin', featureOrdering, featureDict)}")) # from line 68, col 1.
        write('''    for (long _i2 = 0; _i2 < _postfix_lattice; _i2++) {
      ptrdiff_t _index = (_i0 * ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 70, col 33
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 70, col 33.
        write(''' + _i1) * _postfix_lattice + _i2;
''')
        if isOutOfPlace: # generated from line 71, col 7
            write('''      dest_data[_index] = multiplier * source_data[_index];
''')
        else: # generated from line 73, col 7
            write('''      source_data[_index] *= multiplier;
''')
        write('''    }
  }
}
''')
        _v = VFFSL(SL,"insertCodeForFeaturesInReverseOrder",False)('loopOverVectorsWithInnerContentTemplateEnd', featureOrdering, featureDict) # "${insertCodeForFeaturesInReverseOrder('loopOverVectorsWithInnerContentTemplateEnd', featureOrdering, featureDict)}" on line 79, col 1
        if _v is not None: write(_filter(_v, rawExpr="${insertCodeForFeaturesInReverseOrder('loopOverVectorsWithInnerContentTemplateEnd', featureOrdering, featureDict)}")) # from line 79, col 1.
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # HermiteGaussTwiddleBasis.tmpl
        # 
        # Hermite-Gauss Fourier basis using the definite parity of the basis functions to remove
        # half the work.
        # 
        # Created by Graham Dennis on 2009-08-12.
        # 
        # Copyright (c) 2009-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''




''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    supportsInPlaceOperation = True

    matrixType = 'complex'

    _mainCheetahMethod_for_HermiteGaussTwiddleBasis = 'writeBody'

## END CLASS DEFINITION

if not hasattr(HermiteGaussTwiddleBasis, '_initCheetahAttributes'):
    templateAPIClass = getattr(HermiteGaussTwiddleBasis,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(HermiteGaussTwiddleBasis)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=HermiteGaussTwiddleBasis()).run()


