/* kvx-opc.c -- KVX opcode support.
   Copyright (C) 2009-2024 Free Software Foundation, Inc.
   Contributed by Kalray SA.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include <stddef.h>
#include <stdio.h>
#include "bfd.h"
#include "libbfd.h"
#include <elf/kvx.h>
#include <opcode/kvx.h>

int kvx_kv3_v1_regfiles[] = {
  0, 	/* KVX_REGFILE_FIRST_GPR */
  187, 	/* KVX_REGFILE_LAST_GPR */
  0, 	/* KVX_REGFILE_DEC_GPR */
  188, 	/* KVX_REGFILE_FIRST_PGR */
  251, 	/* KVX_REGFILE_LAST_PGR */
  64, 	/* KVX_REGFILE_DEC_PGR */
  252, 	/* KVX_REGFILE_FIRST_QGR */
  267, 	/* KVX_REGFILE_LAST_QGR */
  96, 	/* KVX_REGFILE_DEC_QGR */
  268, 	/* KVX_REGFILE_FIRST_SFR */
  1291, 	/* KVX_REGFILE_LAST_SFR */
  112, 	/* KVX_REGFILE_DEC_SFR */
  1292, 	/* KVX_REGFILE_FIRST_X16R */
  1295, 	/* KVX_REGFILE_LAST_X16R */
  624, 	/* KVX_REGFILE_DEC_X16R */
  1296, 	/* KVX_REGFILE_FIRST_X2R */
  1327, 	/* KVX_REGFILE_LAST_X2R */
  628, 	/* KVX_REGFILE_DEC_X2R */
  1328, 	/* KVX_REGFILE_FIRST_X32R */
  1329, 	/* KVX_REGFILE_LAST_X32R */
  660, 	/* KVX_REGFILE_DEC_X32R */
  1330, 	/* KVX_REGFILE_FIRST_X4R */
  1345, 	/* KVX_REGFILE_LAST_X4R */
  662, 	/* KVX_REGFILE_DEC_X4R */
  1346, 	/* KVX_REGFILE_FIRST_X64R */
  1346, 	/* KVX_REGFILE_LAST_X64R */
  678, 	/* KVX_REGFILE_DEC_X64R */
  1347, 	/* KVX_REGFILE_FIRST_X8R */
  1354, 	/* KVX_REGFILE_LAST_X8R */
  679, 	/* KVX_REGFILE_DEC_X8R */
  1355, 	/* KVX_REGFILE_FIRST_XBR */
  1610, 	/* KVX_REGFILE_LAST_XBR */
  687, 	/* KVX_REGFILE_DEC_XBR */
  1611, 	/* KVX_REGFILE_FIRST_XCR */
  2122, 	/* KVX_REGFILE_LAST_XCR */
  815, 	/* KVX_REGFILE_DEC_XCR */
  2123, 	/* KVX_REGFILE_FIRST_XMR */
  2138, 	/* KVX_REGFILE_LAST_XMR */
  1071, 	/* KVX_REGFILE_DEC_XMR */
  2139, 	/* KVX_REGFILE_FIRST_XTR */
  2202, 	/* KVX_REGFILE_LAST_XTR */
  1087, 	/* KVX_REGFILE_DEC_XTR */
  2203, 	/* KVX_REGFILE_FIRST_XVR */
  2394, 	/* KVX_REGFILE_LAST_XVR */
  1119, 	/* KVX_REGFILE_DEC_XVR */
  2395, 	/* KVX_REGFILE_REGISTERS*/
  1183, 	/* KVX_REGFILE_DEC_REGISTERS*/
};

struct kvx_Register kvx_kv3_v1_registers[] = {
  { 0, "$r0"}, /* 0 */
  { 0, "$r0r1.lo"}, /* 1 */
  { 0, "$r0r1r2r3.x"}, /* 2 */
  { 1, "$r1"}, /* 3 */
  { 1, "$r0r1.hi"}, /* 4 */
  { 1, "$r0r1r2r3.y"}, /* 5 */
  { 2, "$r2"}, /* 6 */
  { 2, "$r2r3.lo"}, /* 7 */
  { 2, "$r0r1r2r3.z"}, /* 8 */
  { 3, "$r3"}, /* 9 */
  { 3, "$r2r3.hi"}, /* 10 */
  { 3, "$r0r1r2r3.t"}, /* 11 */
  { 4, "$r4"}, /* 12 */
  { 4, "$r4r5.lo"}, /* 13 */
  { 4, "$r4r5r6r7.x"}, /* 14 */
  { 5, "$r5"}, /* 15 */
  { 5, "$r4r5.hi"}, /* 16 */
  { 5, "$r4r5r6r7.y"}, /* 17 */
  { 6, "$r6"}, /* 18 */
  { 6, "$r6r7.lo"}, /* 19 */
  { 6, "$r4r5r6r7.z"}, /* 20 */
  { 7, "$r7"}, /* 21 */
  { 7, "$r6r7.hi"}, /* 22 */
  { 7, "$r4r5r6r7.t"}, /* 23 */
  { 8, "$r8"}, /* 24 */
  { 8, "$r8r9.lo"}, /* 25 */
  { 8, "$r8r9r10r11.x"}, /* 26 */
  { 9, "$r9"}, /* 27 */
  { 9, "$r8r9.hi"}, /* 28 */
  { 9, "$r8r9r10r11.y"}, /* 29 */
  { 10, "$r10"}, /* 30 */
  { 10, "$r10r11.lo"}, /* 31 */
  { 10, "$r8r9r10r11.z"}, /* 32 */
  { 11, "$r11"}, /* 33 */
  { 11, "$r10r11.hi"}, /* 34 */
  { 11, "$r8r9r10r11.t"}, /* 35 */
  { 12, "$r12"}, /* 36 */
  { 12, "$sp"}, /* 37 */
  { 13, "$r13"}, /* 38 */
  { 13, "$tp"}, /* 39 */
  { 14, "$r14"}, /* 40 */
  { 14, "$fp"}, /* 41 */
  { 15, "$r15"}, /* 42 */
  { 15, "$rp"}, /* 43 */
  { 16, "$r16"}, /* 44 */
  { 16, "$r16r17.lo"}, /* 45 */
  { 16, "$r16r17r18r19.x"}, /* 46 */
  { 17, "$r17"}, /* 47 */
  { 17, "$r16r17.hi"}, /* 48 */
  { 17, "$r16r17r18r19.y"}, /* 49 */
  { 18, "$r18"}, /* 50 */
  { 18, "$r18r19.lo"}, /* 51 */
  { 18, "$r16r17r18r19.z"}, /* 52 */
  { 19, "$r19"}, /* 53 */
  { 19, "$r18r19.hi"}, /* 54 */
  { 19, "$r16r17r18r19.t"}, /* 55 */
  { 20, "$r20"}, /* 56 */
  { 20, "$r20r21.lo"}, /* 57 */
  { 20, "$r20r21r22r23.x"}, /* 58 */
  { 21, "$r21"}, /* 59 */
  { 21, "$r20r21.hi"}, /* 60 */
  { 21, "$r20r21r22r23.y"}, /* 61 */
  { 22, "$r22"}, /* 62 */
  { 22, "$r22r23.lo"}, /* 63 */
  { 22, "$r20r21r22r23.z"}, /* 64 */
  { 23, "$r23"}, /* 65 */
  { 23, "$r22r23.hi"}, /* 66 */
  { 23, "$r20r21r22r23.t"}, /* 67 */
  { 24, "$r24"}, /* 68 */
  { 24, "$r24r25.lo"}, /* 69 */
  { 24, "$r24r25r26r27.x"}, /* 70 */
  { 25, "$r25"}, /* 71 */
  { 25, "$r24r25.hi"}, /* 72 */
  { 25, "$r24r25r26r27.y"}, /* 73 */
  { 26, "$r26"}, /* 74 */
  { 26, "$r26r27.lo"}, /* 75 */
  { 26, "$r24r25r26r27.z"}, /* 76 */
  { 27, "$r27"}, /* 77 */
  { 27, "$r26r27.hi"}, /* 78 */
  { 27, "$r24r25r26r27.t"}, /* 79 */
  { 28, "$r28"}, /* 80 */
  { 28, "$r28r29.lo"}, /* 81 */
  { 28, "$r28r29r30r31.x"}, /* 82 */
  { 29, "$r29"}, /* 83 */
  { 29, "$r28r29.hi"}, /* 84 */
  { 29, "$r28r29r30r31.y"}, /* 85 */
  { 30, "$r30"}, /* 86 */
  { 30, "$r30r31.lo"}, /* 87 */
  { 30, "$r28r29r30r31.z"}, /* 88 */
  { 31, "$r31"}, /* 89 */
  { 31, "$r30r31.hi"}, /* 90 */
  { 31, "$r28r29r30r31.t"}, /* 91 */
  { 32, "$r32"}, /* 92 */
  { 32, "$r32r33.lo"}, /* 93 */
  { 32, "$r32r33r34r35.x"}, /* 94 */
  { 33, "$r33"}, /* 95 */
  { 33, "$r32r33.hi"}, /* 96 */
  { 33, "$r32r33r34r35.y"}, /* 97 */
  { 34, "$r34"}, /* 98 */
  { 34, "$r34r35.lo"}, /* 99 */
  { 34, "$r32r33r34r35.z"}, /* 100 */
  { 35, "$r35"}, /* 101 */
  { 35, "$r34r35.hi"}, /* 102 */
  { 35, "$r32r33r34r35.t"}, /* 103 */
  { 36, "$r36"}, /* 104 */
  { 36, "$r36r37.lo"}, /* 105 */
  { 36, "$r36r37r38r39.x"}, /* 106 */
  { 37, "$r37"}, /* 107 */
  { 37, "$r36r37.hi"}, /* 108 */
  { 37, "$r36r37r38r39.y"}, /* 109 */
  { 38, "$r38"}, /* 110 */
  { 38, "$r38r39.lo"}, /* 111 */
  { 38, "$r36r37r38r39.z"}, /* 112 */
  { 39, "$r39"}, /* 113 */
  { 39, "$r38r39.hi"}, /* 114 */
  { 39, "$r36r37r38r39.t"}, /* 115 */
  { 40, "$r40"}, /* 116 */
  { 40, "$r40r41.lo"}, /* 117 */
  { 40, "$r40r41r42r43.x"}, /* 118 */
  { 41, "$r41"}, /* 119 */
  { 41, "$r40r41.hi"}, /* 120 */
  { 41, "$r40r41r42r43.y"}, /* 121 */
  { 42, "$r42"}, /* 122 */
  { 42, "$r42r43.lo"}, /* 123 */
  { 42, "$r40r41r42r43.z"}, /* 124 */
  { 43, "$r43"}, /* 125 */
  { 43, "$r42r43.hi"}, /* 126 */
  { 43, "$r40r41r42r43.t"}, /* 127 */
  { 44, "$r44"}, /* 128 */
  { 44, "$r44r45.lo"}, /* 129 */
  { 44, "$r44r45r46r47.x"}, /* 130 */
  { 45, "$r45"}, /* 131 */
  { 45, "$r44r45.hi"}, /* 132 */
  { 45, "$r44r45r46r47.y"}, /* 133 */
  { 46, "$r46"}, /* 134 */
  { 46, "$r46r47.lo"}, /* 135 */
  { 46, "$r44r45r46r47.z"}, /* 136 */
  { 47, "$r47"}, /* 137 */
  { 47, "$r46r47.hi"}, /* 138 */
  { 47, "$r44r45r46r47.t"}, /* 139 */
  { 48, "$r48"}, /* 140 */
  { 48, "$r48r49.lo"}, /* 141 */
  { 48, "$r48r49r50r51.x"}, /* 142 */
  { 49, "$r49"}, /* 143 */
  { 49, "$r48r49.hi"}, /* 144 */
  { 49, "$r48r49r50r51.y"}, /* 145 */
  { 50, "$r50"}, /* 146 */
  { 50, "$r50r51.lo"}, /* 147 */
  { 50, "$r48r49r50r51.z"}, /* 148 */
  { 51, "$r51"}, /* 149 */
  { 51, "$r50r51.hi"}, /* 150 */
  { 51, "$r48r49r50r51.t"}, /* 151 */
  { 52, "$r52"}, /* 152 */
  { 52, "$r52r53.lo"}, /* 153 */
  { 52, "$r52r53r54r55.x"}, /* 154 */
  { 53, "$r53"}, /* 155 */
  { 53, "$r52r53.hi"}, /* 156 */
  { 53, "$r52r53r54r55.y"}, /* 157 */
  { 54, "$r54"}, /* 158 */
  { 54, "$r54r55.lo"}, /* 159 */
  { 54, "$r52r53r54r55.z"}, /* 160 */
  { 55, "$r55"}, /* 161 */
  { 55, "$r54r55.hi"}, /* 162 */
  { 55, "$r52r53r54r55.t"}, /* 163 */
  { 56, "$r56"}, /* 164 */
  { 56, "$r56r57.lo"}, /* 165 */
  { 56, "$r56r57r58r59.x"}, /* 166 */
  { 57, "$r57"}, /* 167 */
  { 57, "$r56r57.hi"}, /* 168 */
  { 57, "$r56r57r58r59.y"}, /* 169 */
  { 58, "$r58"}, /* 170 */
  { 58, "$r58r59.lo"}, /* 171 */
  { 58, "$r56r57r58r59.z"}, /* 172 */
  { 59, "$r59"}, /* 173 */
  { 59, "$r58r59.hi"}, /* 174 */
  { 59, "$r56r57r58r59.t"}, /* 175 */
  { 60, "$r60"}, /* 176 */
  { 60, "$r60r61.lo"}, /* 177 */
  { 60, "$r60r61r62r63.x"}, /* 178 */
  { 61, "$r61"}, /* 179 */
  { 61, "$r60r61.hi"}, /* 180 */
  { 61, "$r60r61r62r63.y"}, /* 181 */
  { 62, "$r62"}, /* 182 */
  { 62, "$r62r63.lo"}, /* 183 */
  { 62, "$r60r61r62r63.z"}, /* 184 */
  { 63, "$r63"}, /* 185 */
  { 63, "$r62r63.hi"}, /* 186 */
  { 63, "$r60r61r62r63.t"}, /* 187 */
  { 0, "$r0r1"}, /* 188 */
  { 0, "$r0r1r2r3.lo"}, /* 189 */
  { 1, "$r2r3"}, /* 190 */
  { 1, "$r0r1r2r3.hi"}, /* 191 */
  { 2, "$r4r5"}, /* 192 */
  { 2, "$r4r5r6r7.lo"}, /* 193 */
  { 3, "$r6r7"}, /* 194 */
  { 3, "$r4r5r6r7.hi"}, /* 195 */
  { 4, "$r8r9"}, /* 196 */
  { 4, "$r8r9r10r11.lo"}, /* 197 */
  { 5, "$r10r11"}, /* 198 */
  { 5, "$r8r9r10r11.hi"}, /* 199 */
  { 6, "$r12r13"}, /* 200 */
  { 6, "$r12r13r14r15.lo"}, /* 201 */
  { 7, "$r14r15"}, /* 202 */
  { 7, "$r12r13r14r15.hi"}, /* 203 */
  { 8, "$r16r17"}, /* 204 */
  { 8, "$r16r17r18r19.lo"}, /* 205 */
  { 9, "$r18r19"}, /* 206 */
  { 9, "$r16r17r18r19.hi"}, /* 207 */
  { 10, "$r20r21"}, /* 208 */
  { 10, "$r20r21r22r23.lo"}, /* 209 */
  { 11, "$r22r23"}, /* 210 */
  { 11, "$r20r21r22r23.hi"}, /* 211 */
  { 12, "$r24r25"}, /* 212 */
  { 12, "$r24r25r26r27.lo"}, /* 213 */
  { 13, "$r26r27"}, /* 214 */
  { 13, "$r24r25r26r27.hi"}, /* 215 */
  { 14, "$r28r29"}, /* 216 */
  { 14, "$r28r29r30r31.lo"}, /* 217 */
  { 15, "$r30r31"}, /* 218 */
  { 15, "$r28r29r30r31.hi"}, /* 219 */
  { 16, "$r32r33"}, /* 220 */
  { 16, "$r32r33r34r35.lo"}, /* 221 */
  { 17, "$r34r35"}, /* 222 */
  { 17, "$r32r33r34r35.hi"}, /* 223 */
  { 18, "$r36r37"}, /* 224 */
  { 18, "$r36r37r38r39.lo"}, /* 225 */
  { 19, "$r38r39"}, /* 226 */
  { 19, "$r36r37r38r39.hi"}, /* 227 */
  { 20, "$r40r41"}, /* 228 */
  { 20, "$r40r41r42r43.lo"}, /* 229 */
  { 21, "$r42r43"}, /* 230 */
  { 21, "$r40r41r42r43.hi"}, /* 231 */
  { 22, "$r44r45"}, /* 232 */
  { 22, "$r44r45r46r47.lo"}, /* 233 */
  { 23, "$r46r47"}, /* 234 */
  { 23, "$r44r45r46r47.hi"}, /* 235 */
  { 24, "$r48r49"}, /* 236 */
  { 24, "$r48r49r50r51.lo"}, /* 237 */
  { 25, "$r50r51"}, /* 238 */
  { 25, "$r48r49r50r51.hi"}, /* 239 */
  { 26, "$r52r53"}, /* 240 */
  { 26, "$r52r53r54r55.lo"}, /* 241 */
  { 27, "$r54r55"}, /* 242 */
  { 27, "$r52r53r54r55.hi"}, /* 243 */
  { 28, "$r56r57"}, /* 244 */
  { 28, "$r56r57r58r59.lo"}, /* 245 */
  { 29, "$r58r59"}, /* 246 */
  { 29, "$r56r57r58r59.hi"}, /* 247 */
  { 30, "$r60r61"}, /* 248 */
  { 30, "$r60r61r62r63.lo"}, /* 249 */
  { 31, "$r62r63"}, /* 250 */
  { 31, "$r60r61r62r63.hi"}, /* 251 */
  { 0, "$r0r1r2r3"}, /* 252 */
  { 1, "$r4r5r6r7"}, /* 253 */
  { 2, "$r8r9r10r11"}, /* 254 */
  { 3, "$r12r13r14r15"}, /* 255 */
  { 4, "$r16r17r18r19"}, /* 256 */
  { 5, "$r20r21r22r23"}, /* 257 */
  { 6, "$r24r25r26r27"}, /* 258 */
  { 7, "$r28r29r30r31"}, /* 259 */
  { 8, "$r32r33r34r35"}, /* 260 */
  { 9, "$r36r37r38r39"}, /* 261 */
  { 10, "$r40r41r42r43"}, /* 262 */
  { 11, "$r44r45r46r47"}, /* 263 */
  { 12, "$r48r49r50r51"}, /* 264 */
  { 13, "$r52r53r54r55"}, /* 265 */
  { 14, "$r56r57r58r59"}, /* 266 */
  { 15, "$r60r61r62r63"}, /* 267 */
  { 0, "$pc"}, /* 268 */
  { 0, "$s0"}, /* 269 */
  { 1, "$ps"}, /* 270 */
  { 1, "$s1"}, /* 271 */
  { 2, "$pcr"}, /* 272 */
  { 2, "$s2"}, /* 273 */
  { 3, "$ra"}, /* 274 */
  { 3, "$s3"}, /* 275 */
  { 4, "$cs"}, /* 276 */
  { 4, "$s4"}, /* 277 */
  { 5, "$csit"}, /* 278 */
  { 5, "$s5"}, /* 279 */
  { 6, "$aespc"}, /* 280 */
  { 6, "$s6"}, /* 281 */
  { 7, "$ls"}, /* 282 */
  { 7, "$s7"}, /* 283 */
  { 8, "$le"}, /* 284 */
  { 8, "$s8"}, /* 285 */
  { 9, "$lc"}, /* 286 */
  { 9, "$s9"}, /* 287 */
  { 10, "$ipe"}, /* 288 */
  { 10, "$s10"}, /* 289 */
  { 11, "$men"}, /* 290 */
  { 11, "$s11"}, /* 291 */
  { 12, "$pmc"}, /* 292 */
  { 12, "$s12"}, /* 293 */
  { 13, "$pm0"}, /* 294 */
  { 13, "$s13"}, /* 295 */
  { 14, "$pm1"}, /* 296 */
  { 14, "$s14"}, /* 297 */
  { 15, "$pm2"}, /* 298 */
  { 15, "$s15"}, /* 299 */
  { 16, "$pm3"}, /* 300 */
  { 16, "$s16"}, /* 301 */
  { 17, "$pmsa"}, /* 302 */
  { 17, "$s17"}, /* 303 */
  { 18, "$tcr"}, /* 304 */
  { 18, "$s18"}, /* 305 */
  { 19, "$t0v"}, /* 306 */
  { 19, "$s19"}, /* 307 */
  { 20, "$t1v"}, /* 308 */
  { 20, "$s20"}, /* 309 */
  { 21, "$t0r"}, /* 310 */
  { 21, "$s21"}, /* 311 */
  { 22, "$t1r"}, /* 312 */
  { 22, "$s22"}, /* 313 */
  { 23, "$wdv"}, /* 314 */
  { 23, "$s23"}, /* 315 */
  { 24, "$wdr"}, /* 316 */
  { 24, "$s24"}, /* 317 */
  { 25, "$ile"}, /* 318 */
  { 25, "$s25"}, /* 319 */
  { 26, "$ill"}, /* 320 */
  { 26, "$s26"}, /* 321 */
  { 27, "$ilr"}, /* 322 */
  { 27, "$s27"}, /* 323 */
  { 28, "$mmc"}, /* 324 */
  { 28, "$s28"}, /* 325 */
  { 29, "$tel"}, /* 326 */
  { 29, "$s29"}, /* 327 */
  { 30, "$teh"}, /* 328 */
  { 30, "$s30"}, /* 329 */
  { 31, "$ixc"}, /* 330 */
  { 31, "$s31"}, /* 331 */
  { 32, "$syo"}, /* 332 */
  { 32, "$s32"}, /* 333 */
  { 33, "$hto"}, /* 334 */
  { 33, "$s33"}, /* 335 */
  { 34, "$ito"}, /* 336 */
  { 34, "$s34"}, /* 337 */
  { 35, "$do"}, /* 338 */
  { 35, "$s35"}, /* 339 */
  { 36, "$mo"}, /* 340 */
  { 36, "$s36"}, /* 341 */
  { 37, "$pso"}, /* 342 */
  { 37, "$s37"}, /* 343 */
  { 38, "$res38"}, /* 344 */
  { 38, "$s38"}, /* 345 */
  { 39, "$res39"}, /* 346 */
  { 39, "$s39"}, /* 347 */
  { 40, "$dc"}, /* 348 */
  { 40, "$s40"}, /* 349 */
  { 41, "$dba0"}, /* 350 */
  { 41, "$s41"}, /* 351 */
  { 42, "$dba1"}, /* 352 */
  { 42, "$s42"}, /* 353 */
  { 43, "$dwa0"}, /* 354 */
  { 43, "$s43"}, /* 355 */
  { 44, "$dwa1"}, /* 356 */
  { 44, "$s44"}, /* 357 */
  { 45, "$mes"}, /* 358 */
  { 45, "$s45"}, /* 359 */
  { 46, "$ws"}, /* 360 */
  { 46, "$s46"}, /* 361 */
  { 47, "$res47"}, /* 362 */
  { 47, "$s47"}, /* 363 */
  { 48, "$res48"}, /* 364 */
  { 48, "$s48"}, /* 365 */
  { 49, "$res49"}, /* 366 */
  { 49, "$s49"}, /* 367 */
  { 50, "$res50"}, /* 368 */
  { 50, "$s50"}, /* 369 */
  { 51, "$res51"}, /* 370 */
  { 51, "$s51"}, /* 371 */
  { 52, "$res52"}, /* 372 */
  { 52, "$s52"}, /* 373 */
  { 53, "$res53"}, /* 374 */
  { 53, "$s53"}, /* 375 */
  { 54, "$res54"}, /* 376 */
  { 54, "$s54"}, /* 377 */
  { 55, "$res55"}, /* 378 */
  { 55, "$s55"}, /* 379 */
  { 56, "$res56"}, /* 380 */
  { 56, "$s56"}, /* 381 */
  { 57, "$res57"}, /* 382 */
  { 57, "$s57"}, /* 383 */
  { 58, "$res58"}, /* 384 */
  { 58, "$s58"}, /* 385 */
  { 59, "$res59"}, /* 386 */
  { 59, "$s59"}, /* 387 */
  { 60, "$res60"}, /* 388 */
  { 60, "$s60"}, /* 389 */
  { 61, "$res61"}, /* 390 */
  { 61, "$s61"}, /* 391 */
  { 62, "$res62"}, /* 392 */
  { 62, "$s62"}, /* 393 */
  { 63, "$res63"}, /* 394 */
  { 63, "$s63"}, /* 395 */
  { 64, "$spc_pl0"}, /* 396 */
  { 64, "$s64"}, /* 397 */
  { 65, "$spc_pl1"}, /* 398 */
  { 65, "$s65"}, /* 399 */
  { 66, "$spc_pl2"}, /* 400 */
  { 66, "$s66"}, /* 401 */
  { 67, "$spc_pl3"}, /* 402 */
  { 67, "$s67"}, /* 403 */
  { 68, "$sps_pl0"}, /* 404 */
  { 68, "$s68"}, /* 405 */
  { 69, "$sps_pl1"}, /* 406 */
  { 69, "$s69"}, /* 407 */
  { 70, "$sps_pl2"}, /* 408 */
  { 70, "$s70"}, /* 409 */
  { 71, "$sps_pl3"}, /* 410 */
  { 71, "$s71"}, /* 411 */
  { 72, "$ea_pl0"}, /* 412 */
  { 72, "$s72"}, /* 413 */
  { 73, "$ea_pl1"}, /* 414 */
  { 73, "$s73"}, /* 415 */
  { 74, "$ea_pl2"}, /* 416 */
  { 74, "$s74"}, /* 417 */
  { 75, "$ea_pl3"}, /* 418 */
  { 75, "$s75"}, /* 419 */
  { 76, "$ev_pl0"}, /* 420 */
  { 76, "$s76"}, /* 421 */
  { 77, "$ev_pl1"}, /* 422 */
  { 77, "$s77"}, /* 423 */
  { 78, "$ev_pl2"}, /* 424 */
  { 78, "$s78"}, /* 425 */
  { 79, "$ev_pl3"}, /* 426 */
  { 79, "$s79"}, /* 427 */
  { 80, "$sr_pl0"}, /* 428 */
  { 80, "$s80"}, /* 429 */
  { 81, "$sr_pl1"}, /* 430 */
  { 81, "$s81"}, /* 431 */
  { 82, "$sr_pl2"}, /* 432 */
  { 82, "$s82"}, /* 433 */
  { 83, "$sr_pl3"}, /* 434 */
  { 83, "$s83"}, /* 435 */
  { 84, "$es_pl0"}, /* 436 */
  { 84, "$s84"}, /* 437 */
  { 85, "$es_pl1"}, /* 438 */
  { 85, "$s85"}, /* 439 */
  { 86, "$es_pl2"}, /* 440 */
  { 86, "$s86"}, /* 441 */
  { 87, "$es_pl3"}, /* 442 */
  { 87, "$s87"}, /* 443 */
  { 88, "$res88"}, /* 444 */
  { 88, "$s88"}, /* 445 */
  { 89, "$res89"}, /* 446 */
  { 89, "$s89"}, /* 447 */
  { 90, "$res90"}, /* 448 */
  { 90, "$s90"}, /* 449 */
  { 91, "$res91"}, /* 450 */
  { 91, "$s91"}, /* 451 */
  { 92, "$res92"}, /* 452 */
  { 92, "$s92"}, /* 453 */
  { 93, "$res93"}, /* 454 */
  { 93, "$s93"}, /* 455 */
  { 94, "$res94"}, /* 456 */
  { 94, "$s94"}, /* 457 */
  { 95, "$res95"}, /* 458 */
  { 95, "$s95"}, /* 459 */
  { 96, "$syow"}, /* 460 */
  { 96, "$s96"}, /* 461 */
  { 97, "$htow"}, /* 462 */
  { 97, "$s97"}, /* 463 */
  { 98, "$itow"}, /* 464 */
  { 98, "$s98"}, /* 465 */
  { 99, "$dow"}, /* 466 */
  { 99, "$s99"}, /* 467 */
  { 100, "$mow"}, /* 468 */
  { 100, "$s100"}, /* 469 */
  { 101, "$psow"}, /* 470 */
  { 101, "$s101"}, /* 471 */
  { 102, "$res102"}, /* 472 */
  { 102, "$s102"}, /* 473 */
  { 103, "$res103"}, /* 474 */
  { 103, "$s103"}, /* 475 */
  { 104, "$res104"}, /* 476 */
  { 104, "$s104"}, /* 477 */
  { 105, "$res105"}, /* 478 */
  { 105, "$s105"}, /* 479 */
  { 106, "$res106"}, /* 480 */
  { 106, "$s106"}, /* 481 */
  { 107, "$res107"}, /* 482 */
  { 107, "$s107"}, /* 483 */
  { 108, "$res108"}, /* 484 */
  { 108, "$s108"}, /* 485 */
  { 109, "$res109"}, /* 486 */
  { 109, "$s109"}, /* 487 */
  { 110, "$res110"}, /* 488 */
  { 110, "$s110"}, /* 489 */
  { 111, "$res111"}, /* 490 */
  { 111, "$s111"}, /* 491 */
  { 112, "$res112"}, /* 492 */
  { 112, "$s112"}, /* 493 */
  { 113, "$res113"}, /* 494 */
  { 113, "$s113"}, /* 495 */
  { 114, "$res114"}, /* 496 */
  { 114, "$s114"}, /* 497 */
  { 115, "$res115"}, /* 498 */
  { 115, "$s115"}, /* 499 */
  { 116, "$res116"}, /* 500 */
  { 116, "$s116"}, /* 501 */
  { 117, "$res117"}, /* 502 */
  { 117, "$s117"}, /* 503 */
  { 118, "$res118"}, /* 504 */
  { 118, "$s118"}, /* 505 */
  { 119, "$res119"}, /* 506 */
  { 119, "$s119"}, /* 507 */
  { 120, "$res120"}, /* 508 */
  { 120, "$s120"}, /* 509 */
  { 121, "$res121"}, /* 510 */
  { 121, "$s121"}, /* 511 */
  { 122, "$res122"}, /* 512 */
  { 122, "$s122"}, /* 513 */
  { 123, "$res123"}, /* 514 */
  { 123, "$s123"}, /* 515 */
  { 124, "$res124"}, /* 516 */
  { 124, "$s124"}, /* 517 */
  { 125, "$res125"}, /* 518 */
  { 125, "$s125"}, /* 519 */
  { 126, "$res126"}, /* 520 */
  { 126, "$s126"}, /* 521 */
  { 127, "$res127"}, /* 522 */
  { 127, "$s127"}, /* 523 */
  { 128, "$spc"}, /* 524 */
  { 128, "$s128"}, /* 525 */
  { 129, "$res129"}, /* 526 */
  { 129, "$s129"}, /* 527 */
  { 130, "$res130"}, /* 528 */
  { 130, "$s130"}, /* 529 */
  { 131, "$res131"}, /* 530 */
  { 131, "$s131"}, /* 531 */
  { 132, "$sps"}, /* 532 */
  { 132, "$s132"}, /* 533 */
  { 133, "$res133"}, /* 534 */
  { 133, "$s133"}, /* 535 */
  { 134, "$res134"}, /* 536 */
  { 134, "$s134"}, /* 537 */
  { 135, "$res135"}, /* 538 */
  { 135, "$s135"}, /* 539 */
  { 136, "$ea"}, /* 540 */
  { 136, "$s136"}, /* 541 */
  { 137, "$res137"}, /* 542 */
  { 137, "$s137"}, /* 543 */
  { 138, "$res138"}, /* 544 */
  { 138, "$s138"}, /* 545 */
  { 139, "$res139"}, /* 546 */
  { 139, "$s139"}, /* 547 */
  { 140, "$ev"}, /* 548 */
  { 140, "$s140"}, /* 549 */
  { 141, "$res141"}, /* 550 */
  { 141, "$s141"}, /* 551 */
  { 142, "$res142"}, /* 552 */
  { 142, "$s142"}, /* 553 */
  { 143, "$res143"}, /* 554 */
  { 143, "$s143"}, /* 555 */
  { 144, "$sr"}, /* 556 */
  { 144, "$s144"}, /* 557 */
  { 145, "$res145"}, /* 558 */
  { 145, "$s145"}, /* 559 */
  { 146, "$res146"}, /* 560 */
  { 146, "$s146"}, /* 561 */
  { 147, "$res147"}, /* 562 */
  { 147, "$s147"}, /* 563 */
  { 148, "$es"}, /* 564 */
  { 148, "$s148"}, /* 565 */
  { 149, "$res149"}, /* 566 */
  { 149, "$s149"}, /* 567 */
  { 150, "$res150"}, /* 568 */
  { 150, "$s150"}, /* 569 */
  { 151, "$res151"}, /* 570 */
  { 151, "$s151"}, /* 571 */
  { 152, "$res152"}, /* 572 */
  { 152, "$s152"}, /* 573 */
  { 153, "$res153"}, /* 574 */
  { 153, "$s153"}, /* 575 */
  { 154, "$res154"}, /* 576 */
  { 154, "$s154"}, /* 577 */
  { 155, "$res155"}, /* 578 */
  { 155, "$s155"}, /* 579 */
  { 156, "$res156"}, /* 580 */
  { 156, "$s156"}, /* 581 */
  { 157, "$res157"}, /* 582 */
  { 157, "$s157"}, /* 583 */
  { 158, "$res158"}, /* 584 */
  { 158, "$s158"}, /* 585 */
  { 159, "$res159"}, /* 586 */
  { 159, "$s159"}, /* 587 */
  { 160, "$res160"}, /* 588 */
  { 160, "$s160"}, /* 589 */
  { 161, "$res161"}, /* 590 */
  { 161, "$s161"}, /* 591 */
  { 162, "$res162"}, /* 592 */
  { 162, "$s162"}, /* 593 */
  { 163, "$res163"}, /* 594 */
  { 163, "$s163"}, /* 595 */
  { 164, "$res164"}, /* 596 */
  { 164, "$s164"}, /* 597 */
  { 165, "$res165"}, /* 598 */
  { 165, "$s165"}, /* 599 */
  { 166, "$res166"}, /* 600 */
  { 166, "$s166"}, /* 601 */
  { 167, "$res167"}, /* 602 */
  { 167, "$s167"}, /* 603 */
  { 168, "$res168"}, /* 604 */
  { 168, "$s168"}, /* 605 */
  { 169, "$res169"}, /* 606 */
  { 169, "$s169"}, /* 607 */
  { 170, "$res170"}, /* 608 */
  { 170, "$s170"}, /* 609 */
  { 171, "$res171"}, /* 610 */
  { 171, "$s171"}, /* 611 */
  { 172, "$res172"}, /* 612 */
  { 172, "$s172"}, /* 613 */
  { 173, "$res173"}, /* 614 */
  { 173, "$s173"}, /* 615 */
  { 174, "$res174"}, /* 616 */
  { 174, "$s174"}, /* 617 */
  { 175, "$res175"}, /* 618 */
  { 175, "$s175"}, /* 619 */
  { 176, "$res176"}, /* 620 */
  { 176, "$s176"}, /* 621 */
  { 177, "$res177"}, /* 622 */
  { 177, "$s177"}, /* 623 */
  { 178, "$res178"}, /* 624 */
  { 178, "$s178"}, /* 625 */
  { 179, "$res179"}, /* 626 */
  { 179, "$s179"}, /* 627 */
  { 180, "$res180"}, /* 628 */
  { 180, "$s180"}, /* 629 */
  { 181, "$res181"}, /* 630 */
  { 181, "$s181"}, /* 631 */
  { 182, "$res182"}, /* 632 */
  { 182, "$s182"}, /* 633 */
  { 183, "$res183"}, /* 634 */
  { 183, "$s183"}, /* 635 */
  { 184, "$res184"}, /* 636 */
  { 184, "$s184"}, /* 637 */
  { 185, "$res185"}, /* 638 */
  { 185, "$s185"}, /* 639 */
  { 186, "$res186"}, /* 640 */
  { 186, "$s186"}, /* 641 */
  { 187, "$res187"}, /* 642 */
  { 187, "$s187"}, /* 643 */
  { 188, "$res188"}, /* 644 */
  { 188, "$s188"}, /* 645 */
  { 189, "$res189"}, /* 646 */
  { 189, "$s189"}, /* 647 */
  { 190, "$res190"}, /* 648 */
  { 190, "$s190"}, /* 649 */
  { 191, "$res191"}, /* 650 */
  { 191, "$s191"}, /* 651 */
  { 192, "$res192"}, /* 652 */
  { 192, "$s192"}, /* 653 */
  { 193, "$res193"}, /* 654 */
  { 193, "$s193"}, /* 655 */
  { 194, "$res194"}, /* 656 */
  { 194, "$s194"}, /* 657 */
  { 195, "$res195"}, /* 658 */
  { 195, "$s195"}, /* 659 */
  { 196, "$res196"}, /* 660 */
  { 196, "$s196"}, /* 661 */
  { 197, "$res197"}, /* 662 */
  { 197, "$s197"}, /* 663 */
  { 198, "$res198"}, /* 664 */
  { 198, "$s198"}, /* 665 */
  { 199, "$res199"}, /* 666 */
  { 199, "$s199"}, /* 667 */
  { 200, "$res200"}, /* 668 */
  { 200, "$s200"}, /* 669 */
  { 201, "$res201"}, /* 670 */
  { 201, "$s201"}, /* 671 */
  { 202, "$res202"}, /* 672 */
  { 202, "$s202"}, /* 673 */
  { 203, "$res203"}, /* 674 */
  { 203, "$s203"}, /* 675 */
  { 204, "$res204"}, /* 676 */
  { 204, "$s204"}, /* 677 */
  { 205, "$res205"}, /* 678 */
  { 205, "$s205"}, /* 679 */
  { 206, "$res206"}, /* 680 */
  { 206, "$s206"}, /* 681 */
  { 207, "$res207"}, /* 682 */
  { 207, "$s207"}, /* 683 */
  { 208, "$res208"}, /* 684 */
  { 208, "$s208"}, /* 685 */
  { 209, "$res209"}, /* 686 */
  { 209, "$s209"}, /* 687 */
  { 210, "$res210"}, /* 688 */
  { 210, "$s210"}, /* 689 */
  { 211, "$res211"}, /* 690 */
  { 211, "$s211"}, /* 691 */
  { 212, "$res212"}, /* 692 */
  { 212, "$s212"}, /* 693 */
  { 213, "$res213"}, /* 694 */
  { 213, "$s213"}, /* 695 */
  { 214, "$res214"}, /* 696 */
  { 214, "$s214"}, /* 697 */
  { 215, "$res215"}, /* 698 */
  { 215, "$s215"}, /* 699 */
  { 216, "$res216"}, /* 700 */
  { 216, "$s216"}, /* 701 */
  { 217, "$res217"}, /* 702 */
  { 217, "$s217"}, /* 703 */
  { 218, "$res218"}, /* 704 */
  { 218, "$s218"}, /* 705 */
  { 219, "$res219"}, /* 706 */
  { 219, "$s219"}, /* 707 */
  { 220, "$res220"}, /* 708 */
  { 220, "$s220"}, /* 709 */
  { 221, "$res221"}, /* 710 */
  { 221, "$s221"}, /* 711 */
  { 222, "$res222"}, /* 712 */
  { 222, "$s222"}, /* 713 */
  { 223, "$res223"}, /* 714 */
  { 223, "$s223"}, /* 715 */
  { 224, "$res224"}, /* 716 */
  { 224, "$s224"}, /* 717 */
  { 225, "$res225"}, /* 718 */
  { 225, "$s225"}, /* 719 */
  { 226, "$res226"}, /* 720 */
  { 226, "$s226"}, /* 721 */
  { 227, "$res227"}, /* 722 */
  { 227, "$s227"}, /* 723 */
  { 228, "$res228"}, /* 724 */
  { 228, "$s228"}, /* 725 */
  { 229, "$res229"}, /* 726 */
  { 229, "$s229"}, /* 727 */
  { 230, "$res230"}, /* 728 */
  { 230, "$s230"}, /* 729 */
  { 231, "$res231"}, /* 730 */
  { 231, "$s231"}, /* 731 */
  { 232, "$res232"}, /* 732 */
  { 232, "$s232"}, /* 733 */
  { 233, "$res233"}, /* 734 */
  { 233, "$s233"}, /* 735 */
  { 234, "$res234"}, /* 736 */
  { 234, "$s234"}, /* 737 */
  { 235, "$res235"}, /* 738 */
  { 235, "$s235"}, /* 739 */
  { 236, "$res236"}, /* 740 */
  { 236, "$s236"}, /* 741 */
  { 237, "$res237"}, /* 742 */
  { 237, "$s237"}, /* 743 */
  { 238, "$res238"}, /* 744 */
  { 238, "$s238"}, /* 745 */
  { 239, "$res239"}, /* 746 */
  { 239, "$s239"}, /* 747 */
  { 240, "$res240"}, /* 748 */
  { 240, "$s240"}, /* 749 */
  { 241, "$res241"}, /* 750 */
  { 241, "$s241"}, /* 751 */
  { 242, "$res242"}, /* 752 */
  { 242, "$s242"}, /* 753 */
  { 243, "$res243"}, /* 754 */
  { 243, "$s243"}, /* 755 */
  { 244, "$res244"}, /* 756 */
  { 244, "$s244"}, /* 757 */
  { 245, "$res245"}, /* 758 */
  { 245, "$s245"}, /* 759 */
  { 246, "$res246"}, /* 760 */
  { 246, "$s246"}, /* 761 */
  { 247, "$res247"}, /* 762 */
  { 247, "$s247"}, /* 763 */
  { 248, "$res248"}, /* 764 */
  { 248, "$s248"}, /* 765 */
  { 249, "$res249"}, /* 766 */
  { 249, "$s249"}, /* 767 */
  { 250, "$res250"}, /* 768 */
  { 250, "$s250"}, /* 769 */
  { 251, "$res251"}, /* 770 */
  { 251, "$s251"}, /* 771 */
  { 252, "$res252"}, /* 772 */
  { 252, "$s252"}, /* 773 */
  { 253, "$res253"}, /* 774 */
  { 253, "$s253"}, /* 775 */
  { 254, "$res254"}, /* 776 */
  { 254, "$s254"}, /* 777 */
  { 255, "$res255"}, /* 778 */
  { 255, "$s255"}, /* 779 */
  { 256, "$vsfr0"}, /* 780 */
  { 256, "$s256"}, /* 781 */
  { 257, "$vsfr1"}, /* 782 */
  { 257, "$s257"}, /* 783 */
  { 258, "$vsfr2"}, /* 784 */
  { 258, "$s258"}, /* 785 */
  { 259, "$vsfr3"}, /* 786 */
  { 259, "$s259"}, /* 787 */
  { 260, "$vsfr4"}, /* 788 */
  { 260, "$s260"}, /* 789 */
  { 261, "$vsfr5"}, /* 790 */
  { 261, "$s261"}, /* 791 */
  { 262, "$vsfr6"}, /* 792 */
  { 262, "$s262"}, /* 793 */
  { 263, "$vsfr7"}, /* 794 */
  { 263, "$s263"}, /* 795 */
  { 264, "$vsfr8"}, /* 796 */
  { 264, "$s264"}, /* 797 */
  { 265, "$vsfr9"}, /* 798 */
  { 265, "$s265"}, /* 799 */
  { 266, "$vsfr10"}, /* 800 */
  { 266, "$s266"}, /* 801 */
  { 267, "$vsfr11"}, /* 802 */
  { 267, "$s267"}, /* 803 */
  { 268, "$vsfr12"}, /* 804 */
  { 268, "$s268"}, /* 805 */
  { 269, "$vsfr13"}, /* 806 */
  { 269, "$s269"}, /* 807 */
  { 270, "$vsfr14"}, /* 808 */
  { 270, "$s270"}, /* 809 */
  { 271, "$vsfr15"}, /* 810 */
  { 271, "$s271"}, /* 811 */
  { 272, "$vsfr16"}, /* 812 */
  { 272, "$s272"}, /* 813 */
  { 273, "$vsfr17"}, /* 814 */
  { 273, "$s273"}, /* 815 */
  { 274, "$vsfr18"}, /* 816 */
  { 274, "$s274"}, /* 817 */
  { 275, "$vsfr19"}, /* 818 */
  { 275, "$s275"}, /* 819 */
  { 276, "$vsfr20"}, /* 820 */
  { 276, "$s276"}, /* 821 */
  { 277, "$vsfr21"}, /* 822 */
  { 277, "$s277"}, /* 823 */
  { 278, "$vsfr22"}, /* 824 */
  { 278, "$s278"}, /* 825 */
  { 279, "$vsfr23"}, /* 826 */
  { 279, "$s279"}, /* 827 */
  { 280, "$vsfr24"}, /* 828 */
  { 280, "$s280"}, /* 829 */
  { 281, "$vsfr25"}, /* 830 */
  { 281, "$s281"}, /* 831 */
  { 282, "$vsfr26"}, /* 832 */
  { 282, "$s282"}, /* 833 */
  { 283, "$vsfr27"}, /* 834 */
  { 283, "$s283"}, /* 835 */
  { 284, "$vsfr28"}, /* 836 */
  { 284, "$s284"}, /* 837 */
  { 285, "$vsfr29"}, /* 838 */
  { 285, "$s285"}, /* 839 */
  { 286, "$vsfr30"}, /* 840 */
  { 286, "$s286"}, /* 841 */
  { 287, "$vsfr31"}, /* 842 */
  { 287, "$s287"}, /* 843 */
  { 288, "$vsfr32"}, /* 844 */
  { 288, "$s288"}, /* 845 */
  { 289, "$vsfr33"}, /* 846 */
  { 289, "$s289"}, /* 847 */
  { 290, "$vsfr34"}, /* 848 */
  { 290, "$s290"}, /* 849 */
  { 291, "$vsfr35"}, /* 850 */
  { 291, "$s291"}, /* 851 */
  { 292, "$vsfr36"}, /* 852 */
  { 292, "$s292"}, /* 853 */
  { 293, "$vsfr37"}, /* 854 */
  { 293, "$s293"}, /* 855 */
  { 294, "$vsfr38"}, /* 856 */
  { 294, "$s294"}, /* 857 */
  { 295, "$vsfr39"}, /* 858 */
  { 295, "$s295"}, /* 859 */
  { 296, "$vsfr40"}, /* 860 */
  { 296, "$s296"}, /* 861 */
  { 297, "$vsfr41"}, /* 862 */
  { 297, "$s297"}, /* 863 */
  { 298, "$vsfr42"}, /* 864 */
  { 298, "$s298"}, /* 865 */
  { 299, "$vsfr43"}, /* 866 */
  { 299, "$s299"}, /* 867 */
  { 300, "$vsfr44"}, /* 868 */
  { 300, "$s300"}, /* 869 */
  { 301, "$vsfr45"}, /* 870 */
  { 301, "$s301"}, /* 871 */
  { 302, "$vsfr46"}, /* 872 */
  { 302, "$s302"}, /* 873 */
  { 303, "$vsfr47"}, /* 874 */
  { 303, "$s303"}, /* 875 */
  { 304, "$vsfr48"}, /* 876 */
  { 304, "$s304"}, /* 877 */
  { 305, "$vsfr49"}, /* 878 */
  { 305, "$s305"}, /* 879 */
  { 306, "$vsfr50"}, /* 880 */
  { 306, "$s306"}, /* 881 */
  { 307, "$vsfr51"}, /* 882 */
  { 307, "$s307"}, /* 883 */
  { 308, "$vsfr52"}, /* 884 */
  { 308, "$s308"}, /* 885 */
  { 309, "$vsfr53"}, /* 886 */
  { 309, "$s309"}, /* 887 */
  { 310, "$vsfr54"}, /* 888 */
  { 310, "$s310"}, /* 889 */
  { 311, "$vsfr55"}, /* 890 */
  { 311, "$s311"}, /* 891 */
  { 312, "$vsfr56"}, /* 892 */
  { 312, "$s312"}, /* 893 */
  { 313, "$vsfr57"}, /* 894 */
  { 313, "$s313"}, /* 895 */
  { 314, "$vsfr58"}, /* 896 */
  { 314, "$s314"}, /* 897 */
  { 315, "$vsfr59"}, /* 898 */
  { 315, "$s315"}, /* 899 */
  { 316, "$vsfr60"}, /* 900 */
  { 316, "$s316"}, /* 901 */
  { 317, "$vsfr61"}, /* 902 */
  { 317, "$s317"}, /* 903 */
  { 318, "$vsfr62"}, /* 904 */
  { 318, "$s318"}, /* 905 */
  { 319, "$vsfr63"}, /* 906 */
  { 319, "$s319"}, /* 907 */
  { 320, "$vsfr64"}, /* 908 */
  { 320, "$s320"}, /* 909 */
  { 321, "$vsfr65"}, /* 910 */
  { 321, "$s321"}, /* 911 */
  { 322, "$vsfr66"}, /* 912 */
  { 322, "$s322"}, /* 913 */
  { 323, "$vsfr67"}, /* 914 */
  { 323, "$s323"}, /* 915 */
  { 324, "$vsfr68"}, /* 916 */
  { 324, "$s324"}, /* 917 */
  { 325, "$vsfr69"}, /* 918 */
  { 325, "$s325"}, /* 919 */
  { 326, "$vsfr70"}, /* 920 */
  { 326, "$s326"}, /* 921 */
  { 327, "$vsfr71"}, /* 922 */
  { 327, "$s327"}, /* 923 */
  { 328, "$vsfr72"}, /* 924 */
  { 328, "$s328"}, /* 925 */
  { 329, "$vsfr73"}, /* 926 */
  { 329, "$s329"}, /* 927 */
  { 330, "$vsfr74"}, /* 928 */
  { 330, "$s330"}, /* 929 */
  { 331, "$vsfr75"}, /* 930 */
  { 331, "$s331"}, /* 931 */
  { 332, "$vsfr76"}, /* 932 */
  { 332, "$s332"}, /* 933 */
  { 333, "$vsfr77"}, /* 934 */
  { 333, "$s333"}, /* 935 */
  { 334, "$vsfr78"}, /* 936 */
  { 334, "$s334"}, /* 937 */
  { 335, "$vsfr79"}, /* 938 */
  { 335, "$s335"}, /* 939 */
  { 336, "$vsfr80"}, /* 940 */
  { 336, "$s336"}, /* 941 */
  { 337, "$vsfr81"}, /* 942 */
  { 337, "$s337"}, /* 943 */
  { 338, "$vsfr82"}, /* 944 */
  { 338, "$s338"}, /* 945 */
  { 339, "$vsfr83"}, /* 946 */
  { 339, "$s339"}, /* 947 */
  { 340, "$vsfr84"}, /* 948 */
  { 340, "$s340"}, /* 949 */
  { 341, "$vsfr85"}, /* 950 */
  { 341, "$s341"}, /* 951 */
  { 342, "$vsfr86"}, /* 952 */
  { 342, "$s342"}, /* 953 */
  { 343, "$vsfr87"}, /* 954 */
  { 343, "$s343"}, /* 955 */
  { 344, "$vsfr88"}, /* 956 */
  { 344, "$s344"}, /* 957 */
  { 345, "$vsfr89"}, /* 958 */
  { 345, "$s345"}, /* 959 */
  { 346, "$vsfr90"}, /* 960 */
  { 346, "$s346"}, /* 961 */
  { 347, "$vsfr91"}, /* 962 */
  { 347, "$s347"}, /* 963 */
  { 348, "$vsfr92"}, /* 964 */
  { 348, "$s348"}, /* 965 */
  { 349, "$vsfr93"}, /* 966 */
  { 349, "$s349"}, /* 967 */
  { 350, "$vsfr94"}, /* 968 */
  { 350, "$s350"}, /* 969 */
  { 351, "$vsfr95"}, /* 970 */
  { 351, "$s351"}, /* 971 */
  { 352, "$vsfr96"}, /* 972 */
  { 352, "$s352"}, /* 973 */
  { 353, "$vsfr97"}, /* 974 */
  { 353, "$s353"}, /* 975 */
  { 354, "$vsfr98"}, /* 976 */
  { 354, "$s354"}, /* 977 */
  { 355, "$vsfr99"}, /* 978 */
  { 355, "$s355"}, /* 979 */
  { 356, "$vsfr100"}, /* 980 */
  { 356, "$s356"}, /* 981 */
  { 357, "$vsfr101"}, /* 982 */
  { 357, "$s357"}, /* 983 */
  { 358, "$vsfr102"}, /* 984 */
  { 358, "$s358"}, /* 985 */
  { 359, "$vsfr103"}, /* 986 */
  { 359, "$s359"}, /* 987 */
  { 360, "$vsfr104"}, /* 988 */
  { 360, "$s360"}, /* 989 */
  { 361, "$vsfr105"}, /* 990 */
  { 361, "$s361"}, /* 991 */
  { 362, "$vsfr106"}, /* 992 */
  { 362, "$s362"}, /* 993 */
  { 363, "$vsfr107"}, /* 994 */
  { 363, "$s363"}, /* 995 */
  { 364, "$vsfr108"}, /* 996 */
  { 364, "$s364"}, /* 997 */
  { 365, "$vsfr109"}, /* 998 */
  { 365, "$s365"}, /* 999 */
  { 366, "$vsfr110"}, /* 1000 */
  { 366, "$s366"}, /* 1001 */
  { 367, "$vsfr111"}, /* 1002 */
  { 367, "$s367"}, /* 1003 */
  { 368, "$vsfr112"}, /* 1004 */
  { 368, "$s368"}, /* 1005 */
  { 369, "$vsfr113"}, /* 1006 */
  { 369, "$s369"}, /* 1007 */
  { 370, "$vsfr114"}, /* 1008 */
  { 370, "$s370"}, /* 1009 */
  { 371, "$vsfr115"}, /* 1010 */
  { 371, "$s371"}, /* 1011 */
  { 372, "$vsfr116"}, /* 1012 */
  { 372, "$s372"}, /* 1013 */
  { 373, "$vsfr117"}, /* 1014 */
  { 373, "$s373"}, /* 1015 */
  { 374, "$vsfr118"}, /* 1016 */
  { 374, "$s374"}, /* 1017 */
  { 375, "$vsfr119"}, /* 1018 */
  { 375, "$s375"}, /* 1019 */
  { 376, "$vsfr120"}, /* 1020 */
  { 376, "$s376"}, /* 1021 */
  { 377, "$vsfr121"}, /* 1022 */
  { 377, "$s377"}, /* 1023 */
  { 378, "$vsfr122"}, /* 1024 */
  { 378, "$s378"}, /* 1025 */
  { 379, "$vsfr123"}, /* 1026 */
  { 379, "$s379"}, /* 1027 */
  { 380, "$vsfr124"}, /* 1028 */
  { 380, "$s380"}, /* 1029 */
  { 381, "$vsfr125"}, /* 1030 */
  { 381, "$s381"}, /* 1031 */
  { 382, "$vsfr126"}, /* 1032 */
  { 382, "$s382"}, /* 1033 */
  { 383, "$vsfr127"}, /* 1034 */
  { 383, "$s383"}, /* 1035 */
  { 384, "$vsfr128"}, /* 1036 */
  { 384, "$s384"}, /* 1037 */
  { 385, "$vsfr129"}, /* 1038 */
  { 385, "$s385"}, /* 1039 */
  { 386, "$vsfr130"}, /* 1040 */
  { 386, "$s386"}, /* 1041 */
  { 387, "$vsfr131"}, /* 1042 */
  { 387, "$s387"}, /* 1043 */
  { 388, "$vsfr132"}, /* 1044 */
  { 388, "$s388"}, /* 1045 */
  { 389, "$vsfr133"}, /* 1046 */
  { 389, "$s389"}, /* 1047 */
  { 390, "$vsfr134"}, /* 1048 */
  { 390, "$s390"}, /* 1049 */
  { 391, "$vsfr135"}, /* 1050 */
  { 391, "$s391"}, /* 1051 */
  { 392, "$vsfr136"}, /* 1052 */
  { 392, "$s392"}, /* 1053 */
  { 393, "$vsfr137"}, /* 1054 */
  { 393, "$s393"}, /* 1055 */
  { 394, "$vsfr138"}, /* 1056 */
  { 394, "$s394"}, /* 1057 */
  { 395, "$vsfr139"}, /* 1058 */
  { 395, "$s395"}, /* 1059 */
  { 396, "$vsfr140"}, /* 1060 */
  { 396, "$s396"}, /* 1061 */
  { 397, "$vsfr141"}, /* 1062 */
  { 397, "$s397"}, /* 1063 */
  { 398, "$vsfr142"}, /* 1064 */
  { 398, "$s398"}, /* 1065 */
  { 399, "$vsfr143"}, /* 1066 */
  { 399, "$s399"}, /* 1067 */
  { 400, "$vsfr144"}, /* 1068 */
  { 400, "$s400"}, /* 1069 */
  { 401, "$vsfr145"}, /* 1070 */
  { 401, "$s401"}, /* 1071 */
  { 402, "$vsfr146"}, /* 1072 */
  { 402, "$s402"}, /* 1073 */
  { 403, "$vsfr147"}, /* 1074 */
  { 403, "$s403"}, /* 1075 */
  { 404, "$vsfr148"}, /* 1076 */
  { 404, "$s404"}, /* 1077 */
  { 405, "$vsfr149"}, /* 1078 */
  { 405, "$s405"}, /* 1079 */
  { 406, "$vsfr150"}, /* 1080 */
  { 406, "$s406"}, /* 1081 */
  { 407, "$vsfr151"}, /* 1082 */
  { 407, "$s407"}, /* 1083 */
  { 408, "$vsfr152"}, /* 1084 */
  { 408, "$s408"}, /* 1085 */
  { 409, "$vsfr153"}, /* 1086 */
  { 409, "$s409"}, /* 1087 */
  { 410, "$vsfr154"}, /* 1088 */
  { 410, "$s410"}, /* 1089 */
  { 411, "$vsfr155"}, /* 1090 */
  { 411, "$s411"}, /* 1091 */
  { 412, "$vsfr156"}, /* 1092 */
  { 412, "$s412"}, /* 1093 */
  { 413, "$vsfr157"}, /* 1094 */
  { 413, "$s413"}, /* 1095 */
  { 414, "$vsfr158"}, /* 1096 */
  { 414, "$s414"}, /* 1097 */
  { 415, "$vsfr159"}, /* 1098 */
  { 415, "$s415"}, /* 1099 */
  { 416, "$vsfr160"}, /* 1100 */
  { 416, "$s416"}, /* 1101 */
  { 417, "$vsfr161"}, /* 1102 */
  { 417, "$s417"}, /* 1103 */
  { 418, "$vsfr162"}, /* 1104 */
  { 418, "$s418"}, /* 1105 */
  { 419, "$vsfr163"}, /* 1106 */
  { 419, "$s419"}, /* 1107 */
  { 420, "$vsfr164"}, /* 1108 */
  { 420, "$s420"}, /* 1109 */
  { 421, "$vsfr165"}, /* 1110 */
  { 421, "$s421"}, /* 1111 */
  { 422, "$vsfr166"}, /* 1112 */
  { 422, "$s422"}, /* 1113 */
  { 423, "$vsfr167"}, /* 1114 */
  { 423, "$s423"}, /* 1115 */
  { 424, "$vsfr168"}, /* 1116 */
  { 424, "$s424"}, /* 1117 */
  { 425, "$vsfr169"}, /* 1118 */
  { 425, "$s425"}, /* 1119 */
  { 426, "$vsfr170"}, /* 1120 */
  { 426, "$s426"}, /* 1121 */
  { 427, "$vsfr171"}, /* 1122 */
  { 427, "$s427"}, /* 1123 */
  { 428, "$vsfr172"}, /* 1124 */
  { 428, "$s428"}, /* 1125 */
  { 429, "$vsfr173"}, /* 1126 */
  { 429, "$s429"}, /* 1127 */
  { 430, "$vsfr174"}, /* 1128 */
  { 430, "$s430"}, /* 1129 */
  { 431, "$vsfr175"}, /* 1130 */
  { 431, "$s431"}, /* 1131 */
  { 432, "$vsfr176"}, /* 1132 */
  { 432, "$s432"}, /* 1133 */
  { 433, "$vsfr177"}, /* 1134 */
  { 433, "$s433"}, /* 1135 */
  { 434, "$vsfr178"}, /* 1136 */
  { 434, "$s434"}, /* 1137 */
  { 435, "$vsfr179"}, /* 1138 */
  { 435, "$s435"}, /* 1139 */
  { 436, "$vsfr180"}, /* 1140 */
  { 436, "$s436"}, /* 1141 */
  { 437, "$vsfr181"}, /* 1142 */
  { 437, "$s437"}, /* 1143 */
  { 438, "$vsfr182"}, /* 1144 */
  { 438, "$s438"}, /* 1145 */
  { 439, "$vsfr183"}, /* 1146 */
  { 439, "$s439"}, /* 1147 */
  { 440, "$vsfr184"}, /* 1148 */
  { 440, "$s440"}, /* 1149 */
  { 441, "$vsfr185"}, /* 1150 */
  { 441, "$s441"}, /* 1151 */
  { 442, "$vsfr186"}, /* 1152 */
  { 442, "$s442"}, /* 1153 */
  { 443, "$vsfr187"}, /* 1154 */
  { 443, "$s443"}, /* 1155 */
  { 444, "$vsfr188"}, /* 1156 */
  { 444, "$s444"}, /* 1157 */
  { 445, "$vsfr189"}, /* 1158 */
  { 445, "$s445"}, /* 1159 */
  { 446, "$vsfr190"}, /* 1160 */
  { 446, "$s446"}, /* 1161 */
  { 447, "$vsfr191"}, /* 1162 */
  { 447, "$s447"}, /* 1163 */
  { 448, "$vsfr192"}, /* 1164 */
  { 448, "$s448"}, /* 1165 */
  { 449, "$vsfr193"}, /* 1166 */
  { 449, "$s449"}, /* 1167 */
  { 450, "$vsfr194"}, /* 1168 */
  { 450, "$s450"}, /* 1169 */
  { 451, "$vsfr195"}, /* 1170 */
  { 451, "$s451"}, /* 1171 */
  { 452, "$vsfr196"}, /* 1172 */
  { 452, "$s452"}, /* 1173 */
  { 453, "$vsfr197"}, /* 1174 */
  { 453, "$s453"}, /* 1175 */
  { 454, "$vsfr198"}, /* 1176 */
  { 454, "$s454"}, /* 1177 */
  { 455, "$vsfr199"}, /* 1178 */
  { 455, "$s455"}, /* 1179 */
  { 456, "$vsfr200"}, /* 1180 */
  { 456, "$s456"}, /* 1181 */
  { 457, "$vsfr201"}, /* 1182 */
  { 457, "$s457"}, /* 1183 */
  { 458, "$vsfr202"}, /* 1184 */
  { 458, "$s458"}, /* 1185 */
  { 459, "$vsfr203"}, /* 1186 */
  { 459, "$s459"}, /* 1187 */
  { 460, "$vsfr204"}, /* 1188 */
  { 460, "$s460"}, /* 1189 */
  { 461, "$vsfr205"}, /* 1190 */
  { 461, "$s461"}, /* 1191 */
  { 462, "$vsfr206"}, /* 1192 */
  { 462, "$s462"}, /* 1193 */
  { 463, "$vsfr207"}, /* 1194 */
  { 463, "$s463"}, /* 1195 */
  { 464, "$vsfr208"}, /* 1196 */
  { 464, "$s464"}, /* 1197 */
  { 465, "$vsfr209"}, /* 1198 */
  { 465, "$s465"}, /* 1199 */
  { 466, "$vsfr210"}, /* 1200 */
  { 466, "$s466"}, /* 1201 */
  { 467, "$vsfr211"}, /* 1202 */
  { 467, "$s467"}, /* 1203 */
  { 468, "$vsfr212"}, /* 1204 */
  { 468, "$s468"}, /* 1205 */
  { 469, "$vsfr213"}, /* 1206 */
  { 469, "$s469"}, /* 1207 */
  { 470, "$vsfr214"}, /* 1208 */
  { 470, "$s470"}, /* 1209 */
  { 471, "$vsfr215"}, /* 1210 */
  { 471, "$s471"}, /* 1211 */
  { 472, "$vsfr216"}, /* 1212 */
  { 472, "$s472"}, /* 1213 */
  { 473, "$vsfr217"}, /* 1214 */
  { 473, "$s473"}, /* 1215 */
  { 474, "$vsfr218"}, /* 1216 */
  { 474, "$s474"}, /* 1217 */
  { 475, "$vsfr219"}, /* 1218 */
  { 475, "$s475"}, /* 1219 */
  { 476, "$vsfr220"}, /* 1220 */
  { 476, "$s476"}, /* 1221 */
  { 477, "$vsfr221"}, /* 1222 */
  { 477, "$s477"}, /* 1223 */
  { 478, "$vsfr222"}, /* 1224 */
  { 478, "$s478"}, /* 1225 */
  { 479, "$vsfr223"}, /* 1226 */
  { 479, "$s479"}, /* 1227 */
  { 480, "$vsfr224"}, /* 1228 */
  { 480, "$s480"}, /* 1229 */
  { 481, "$vsfr225"}, /* 1230 */
  { 481, "$s481"}, /* 1231 */
  { 482, "$vsfr226"}, /* 1232 */
  { 482, "$s482"}, /* 1233 */
  { 483, "$vsfr227"}, /* 1234 */
  { 483, "$s483"}, /* 1235 */
  { 484, "$vsfr228"}, /* 1236 */
  { 484, "$s484"}, /* 1237 */
  { 485, "$vsfr229"}, /* 1238 */
  { 485, "$s485"}, /* 1239 */
  { 486, "$vsfr230"}, /* 1240 */
  { 486, "$s486"}, /* 1241 */
  { 487, "$vsfr231"}, /* 1242 */
  { 487, "$s487"}, /* 1243 */
  { 488, "$vsfr232"}, /* 1244 */
  { 488, "$s488"}, /* 1245 */
  { 489, "$vsfr233"}, /* 1246 */
  { 489, "$s489"}, /* 1247 */
  { 490, "$vsfr234"}, /* 1248 */
  { 490, "$s490"}, /* 1249 */
  { 491, "$vsfr235"}, /* 1250 */
  { 491, "$s491"}, /* 1251 */
  { 492, "$vsfr236"}, /* 1252 */
  { 492, "$s492"}, /* 1253 */
  { 493, "$vsfr237"}, /* 1254 */
  { 493, "$s493"}, /* 1255 */
  { 494, "$vsfr238"}, /* 1256 */
  { 494, "$s494"}, /* 1257 */
  { 495, "$vsfr239"}, /* 1258 */
  { 495, "$s495"}, /* 1259 */
  { 496, "$vsfr240"}, /* 1260 */
  { 496, "$s496"}, /* 1261 */
  { 497, "$vsfr241"}, /* 1262 */
  { 497, "$s497"}, /* 1263 */
  { 498, "$vsfr242"}, /* 1264 */
  { 498, "$s498"}, /* 1265 */
  { 499, "$vsfr243"}, /* 1266 */
  { 499, "$s499"}, /* 1267 */
  { 500, "$vsfr244"}, /* 1268 */
  { 500, "$s500"}, /* 1269 */
  { 501, "$vsfr245"}, /* 1270 */
  { 501, "$s501"}, /* 1271 */
  { 502, "$vsfr246"}, /* 1272 */
  { 502, "$s502"}, /* 1273 */
  { 503, "$vsfr247"}, /* 1274 */
  { 503, "$s503"}, /* 1275 */
  { 504, "$vsfr248"}, /* 1276 */
  { 504, "$s504"}, /* 1277 */
  { 505, "$vsfr249"}, /* 1278 */
  { 505, "$s505"}, /* 1279 */
  { 506, "$vsfr250"}, /* 1280 */
  { 506, "$s506"}, /* 1281 */
  { 507, "$vsfr251"}, /* 1282 */
  { 507, "$s507"}, /* 1283 */
  { 508, "$vsfr252"}, /* 1284 */
  { 508, "$s508"}, /* 1285 */
  { 509, "$vsfr253"}, /* 1286 */
  { 509, "$s509"}, /* 1287 */
  { 510, "$vsfr254"}, /* 1288 */
  { 510, "$s510"}, /* 1289 */
  { 511, "$vsfr255"}, /* 1290 */
  { 511, "$s511"}, /* 1291 */
  { 0, "$a0..a15"}, /* 1292 */
  { 1, "$a16..a31"}, /* 1293 */
  { 2, "$a32..a47"}, /* 1294 */
  { 3, "$a48..a63"}, /* 1295 */
  { 0, "$a0..a1"}, /* 1296 */
  { 1, "$a2..a3"}, /* 1297 */
  { 2, "$a4..a5"}, /* 1298 */
  { 3, "$a6..a7"}, /* 1299 */
  { 4, "$a8..a9"}, /* 1300 */
  { 5, "$a10..a11"}, /* 1301 */
  { 6, "$a12..a13"}, /* 1302 */
  { 7, "$a14..a15"}, /* 1303 */
  { 8, "$a16..a17"}, /* 1304 */
  { 9, "$a18..a19"}, /* 1305 */
  { 10, "$a20..a21"}, /* 1306 */
  { 11, "$a22..a23"}, /* 1307 */
  { 12, "$a24..a25"}, /* 1308 */
  { 13, "$a26..a27"}, /* 1309 */
  { 14, "$a28..a29"}, /* 1310 */
  { 15, "$a30..a31"}, /* 1311 */
  { 16, "$a32..a33"}, /* 1312 */
  { 17, "$a34..a35"}, /* 1313 */
  { 18, "$a36..a37"}, /* 1314 */
  { 19, "$a38..a39"}, /* 1315 */
  { 20, "$a40..a41"}, /* 1316 */
  { 21, "$a42..a43"}, /* 1317 */
  { 22, "$a44..a45"}, /* 1318 */
  { 23, "$a46..a47"}, /* 1319 */
  { 24, "$a48..a49"}, /* 1320 */
  { 25, "$a50..a51"}, /* 1321 */
  { 26, "$a52..a53"}, /* 1322 */
  { 27, "$a54..a55"}, /* 1323 */
  { 28, "$a56..a57"}, /* 1324 */
  { 29, "$a58..a59"}, /* 1325 */
  { 30, "$a60..a61"}, /* 1326 */
  { 31, "$a62..a63"}, /* 1327 */
  { 0, "$a0..a31"}, /* 1328 */
  { 1, "$a32..a63"}, /* 1329 */
  { 0, "$a0..a3"}, /* 1330 */
  { 1, "$a4..a7"}, /* 1331 */
  { 2, "$a8..a11"}, /* 1332 */
  { 3, "$a12..a15"}, /* 1333 */
  { 4, "$a16..a19"}, /* 1334 */
  { 5, "$a20..a23"}, /* 1335 */
  { 6, "$a24..a27"}, /* 1336 */
  { 7, "$a28..a31"}, /* 1337 */
  { 8, "$a32..a35"}, /* 1338 */
  { 9, "$a36..a39"}, /* 1339 */
  { 10, "$a40..a43"}, /* 1340 */
  { 11, "$a44..a47"}, /* 1341 */
  { 12, "$a48..a51"}, /* 1342 */
  { 13, "$a52..a55"}, /* 1343 */
  { 14, "$a56..a59"}, /* 1344 */
  { 15, "$a60..a63"}, /* 1345 */
  { 0, "$a0..a63"}, /* 1346 */
  { 0, "$a0..a7"}, /* 1347 */
  { 1, "$a8..a15"}, /* 1348 */
  { 2, "$a16..a23"}, /* 1349 */
  { 3, "$a24..a31"}, /* 1350 */
  { 4, "$a32..a39"}, /* 1351 */
  { 5, "$a40..a47"}, /* 1352 */
  { 6, "$a48..a55"}, /* 1353 */
  { 7, "$a56..a63"}, /* 1354 */
  { 0, "$a0_lo"}, /* 1355 */
  { 0, "$a0.lo"}, /* 1356 */
  { 1, "$a0_hi"}, /* 1357 */
  { 1, "$a0.hi"}, /* 1358 */
  { 2, "$a1_lo"}, /* 1359 */
  { 2, "$a1.lo"}, /* 1360 */
  { 3, "$a1_hi"}, /* 1361 */
  { 3, "$a1.hi"}, /* 1362 */
  { 4, "$a2_lo"}, /* 1363 */
  { 4, "$a2.lo"}, /* 1364 */
  { 5, "$a2_hi"}, /* 1365 */
  { 5, "$a2.hi"}, /* 1366 */
  { 6, "$a3_lo"}, /* 1367 */
  { 6, "$a3.lo"}, /* 1368 */
  { 7, "$a3_hi"}, /* 1369 */
  { 7, "$a3.hi"}, /* 1370 */
  { 8, "$a4_lo"}, /* 1371 */
  { 8, "$a4.lo"}, /* 1372 */
  { 9, "$a4_hi"}, /* 1373 */
  { 9, "$a4.hi"}, /* 1374 */
  { 10, "$a5_lo"}, /* 1375 */
  { 10, "$a5.lo"}, /* 1376 */
  { 11, "$a5_hi"}, /* 1377 */
  { 11, "$a5.hi"}, /* 1378 */
  { 12, "$a6_lo"}, /* 1379 */
  { 12, "$a6.lo"}, /* 1380 */
  { 13, "$a6_hi"}, /* 1381 */
  { 13, "$a6.hi"}, /* 1382 */
  { 14, "$a7_lo"}, /* 1383 */
  { 14, "$a7.lo"}, /* 1384 */
  { 15, "$a7_hi"}, /* 1385 */
  { 15, "$a7.hi"}, /* 1386 */
  { 16, "$a8_lo"}, /* 1387 */
  { 16, "$a8.lo"}, /* 1388 */
  { 17, "$a8_hi"}, /* 1389 */
  { 17, "$a8.hi"}, /* 1390 */
  { 18, "$a9_lo"}, /* 1391 */
  { 18, "$a9.lo"}, /* 1392 */
  { 19, "$a9_hi"}, /* 1393 */
  { 19, "$a9.hi"}, /* 1394 */
  { 20, "$a10_lo"}, /* 1395 */
  { 20, "$a10.lo"}, /* 1396 */
  { 21, "$a10_hi"}, /* 1397 */
  { 21, "$a10.hi"}, /* 1398 */
  { 22, "$a11_lo"}, /* 1399 */
  { 22, "$a11.lo"}, /* 1400 */
  { 23, "$a11_hi"}, /* 1401 */
  { 23, "$a11.hi"}, /* 1402 */
  { 24, "$a12_lo"}, /* 1403 */
  { 24, "$a12.lo"}, /* 1404 */
  { 25, "$a12_hi"}, /* 1405 */
  { 25, "$a12.hi"}, /* 1406 */
  { 26, "$a13_lo"}, /* 1407 */
  { 26, "$a13.lo"}, /* 1408 */
  { 27, "$a13_hi"}, /* 1409 */
  { 27, "$a13.hi"}, /* 1410 */
  { 28, "$a14_lo"}, /* 1411 */
  { 28, "$a14.lo"}, /* 1412 */
  { 29, "$a14_hi"}, /* 1413 */
  { 29, "$a14.hi"}, /* 1414 */
  { 30, "$a15_lo"}, /* 1415 */
  { 30, "$a15.lo"}, /* 1416 */
  { 31, "$a15_hi"}, /* 1417 */
  { 31, "$a15.hi"}, /* 1418 */
  { 32, "$a16_lo"}, /* 1419 */
  { 32, "$a16.lo"}, /* 1420 */
  { 33, "$a16_hi"}, /* 1421 */
  { 33, "$a16.hi"}, /* 1422 */
  { 34, "$a17_lo"}, /* 1423 */
  { 34, "$a17.lo"}, /* 1424 */
  { 35, "$a17_hi"}, /* 1425 */
  { 35, "$a17.hi"}, /* 1426 */
  { 36, "$a18_lo"}, /* 1427 */
  { 36, "$a18.lo"}, /* 1428 */
  { 37, "$a18_hi"}, /* 1429 */
  { 37, "$a18.hi"}, /* 1430 */
  { 38, "$a19_lo"}, /* 1431 */
  { 38, "$a19.lo"}, /* 1432 */
  { 39, "$a19_hi"}, /* 1433 */
  { 39, "$a19.hi"}, /* 1434 */
  { 40, "$a20_lo"}, /* 1435 */
  { 40, "$a20.lo"}, /* 1436 */
  { 41, "$a20_hi"}, /* 1437 */
  { 41, "$a20.hi"}, /* 1438 */
  { 42, "$a21_lo"}, /* 1439 */
  { 42, "$a21.lo"}, /* 1440 */
  { 43, "$a21_hi"}, /* 1441 */
  { 43, "$a21.hi"}, /* 1442 */
  { 44, "$a22_lo"}, /* 1443 */
  { 44, "$a22.lo"}, /* 1444 */
  { 45, "$a22_hi"}, /* 1445 */
  { 45, "$a22.hi"}, /* 1446 */
  { 46, "$a23_lo"}, /* 1447 */
  { 46, "$a23.lo"}, /* 1448 */
  { 47, "$a23_hi"}, /* 1449 */
  { 47, "$a23.hi"}, /* 1450 */
  { 48, "$a24_lo"}, /* 1451 */
  { 48, "$a24.lo"}, /* 1452 */
  { 49, "$a24_hi"}, /* 1453 */
  { 49, "$a24.hi"}, /* 1454 */
  { 50, "$a25_lo"}, /* 1455 */
  { 50, "$a25.lo"}, /* 1456 */
  { 51, "$a25_hi"}, /* 1457 */
  { 51, "$a25.hi"}, /* 1458 */
  { 52, "$a26_lo"}, /* 1459 */
  { 52, "$a26.lo"}, /* 1460 */
  { 53, "$a26_hi"}, /* 1461 */
  { 53, "$a26.hi"}, /* 1462 */
  { 54, "$a27_lo"}, /* 1463 */
  { 54, "$a27.lo"}, /* 1464 */
  { 55, "$a27_hi"}, /* 1465 */
  { 55, "$a27.hi"}, /* 1466 */
  { 56, "$a28_lo"}, /* 1467 */
  { 56, "$a28.lo"}, /* 1468 */
  { 57, "$a28_hi"}, /* 1469 */
  { 57, "$a28.hi"}, /* 1470 */
  { 58, "$a29_lo"}, /* 1471 */
  { 58, "$a29.lo"}, /* 1472 */
  { 59, "$a29_hi"}, /* 1473 */
  { 59, "$a29.hi"}, /* 1474 */
  { 60, "$a30_lo"}, /* 1475 */
  { 60, "$a30.lo"}, /* 1476 */
  { 61, "$a30_hi"}, /* 1477 */
  { 61, "$a30.hi"}, /* 1478 */
  { 62, "$a31_lo"}, /* 1479 */
  { 62, "$a31.lo"}, /* 1480 */
  { 63, "$a31_hi"}, /* 1481 */
  { 63, "$a31.hi"}, /* 1482 */
  { 64, "$a32_lo"}, /* 1483 */
  { 64, "$a32.lo"}, /* 1484 */
  { 65, "$a32_hi"}, /* 1485 */
  { 65, "$a32.hi"}, /* 1486 */
  { 66, "$a33_lo"}, /* 1487 */
  { 66, "$a33.lo"}, /* 1488 */
  { 67, "$a33_hi"}, /* 1489 */
  { 67, "$a33.hi"}, /* 1490 */
  { 68, "$a34_lo"}, /* 1491 */
  { 68, "$a34.lo"}, /* 1492 */
  { 69, "$a34_hi"}, /* 1493 */
  { 69, "$a34.hi"}, /* 1494 */
  { 70, "$a35_lo"}, /* 1495 */
  { 70, "$a35.lo"}, /* 1496 */
  { 71, "$a35_hi"}, /* 1497 */
  { 71, "$a35.hi"}, /* 1498 */
  { 72, "$a36_lo"}, /* 1499 */
  { 72, "$a36.lo"}, /* 1500 */
  { 73, "$a36_hi"}, /* 1501 */
  { 73, "$a36.hi"}, /* 1502 */
  { 74, "$a37_lo"}, /* 1503 */
  { 74, "$a37.lo"}, /* 1504 */
  { 75, "$a37_hi"}, /* 1505 */
  { 75, "$a37.hi"}, /* 1506 */
  { 76, "$a38_lo"}, /* 1507 */
  { 76, "$a38.lo"}, /* 1508 */
  { 77, "$a38_hi"}, /* 1509 */
  { 77, "$a38.hi"}, /* 1510 */
  { 78, "$a39_lo"}, /* 1511 */
  { 78, "$a39.lo"}, /* 1512 */
  { 79, "$a39_hi"}, /* 1513 */
  { 79, "$a39.hi"}, /* 1514 */
  { 80, "$a40_lo"}, /* 1515 */
  { 80, "$a40.lo"}, /* 1516 */
  { 81, "$a40_hi"}, /* 1517 */
  { 81, "$a40.hi"}, /* 1518 */
  { 82, "$a41_lo"}, /* 1519 */
  { 82, "$a41.lo"}, /* 1520 */
  { 83, "$a41_hi"}, /* 1521 */
  { 83, "$a41.hi"}, /* 1522 */
  { 84, "$a42_lo"}, /* 1523 */
  { 84, "$a42.lo"}, /* 1524 */
  { 85, "$a42_hi"}, /* 1525 */
  { 85, "$a42.hi"}, /* 1526 */
  { 86, "$a43_lo"}, /* 1527 */
  { 86, "$a43.lo"}, /* 1528 */
  { 87, "$a43_hi"}, /* 1529 */
  { 87, "$a43.hi"}, /* 1530 */
  { 88, "$a44_lo"}, /* 1531 */
  { 88, "$a44.lo"}, /* 1532 */
  { 89, "$a44_hi"}, /* 1533 */
  { 89, "$a44.hi"}, /* 1534 */
  { 90, "$a45_lo"}, /* 1535 */
  { 90, "$a45.lo"}, /* 1536 */
  { 91, "$a45_hi"}, /* 1537 */
  { 91, "$a45.hi"}, /* 1538 */
  { 92, "$a46_lo"}, /* 1539 */
  { 92, "$a46.lo"}, /* 1540 */
  { 93, "$a46_hi"}, /* 1541 */
  { 93, "$a46.hi"}, /* 1542 */
  { 94, "$a47_lo"}, /* 1543 */
  { 94, "$a47.lo"}, /* 1544 */
  { 95, "$a47_hi"}, /* 1545 */
  { 95, "$a47.hi"}, /* 1546 */
  { 96, "$a48_lo"}, /* 1547 */
  { 96, "$a48.lo"}, /* 1548 */
  { 97, "$a48_hi"}, /* 1549 */
  { 97, "$a48.hi"}, /* 1550 */
  { 98, "$a49_lo"}, /* 1551 */
  { 98, "$a49.lo"}, /* 1552 */
  { 99, "$a49_hi"}, /* 1553 */
  { 99, "$a49.hi"}, /* 1554 */
  { 100, "$a50_lo"}, /* 1555 */
  { 100, "$a50.lo"}, /* 1556 */
  { 101, "$a50_hi"}, /* 1557 */
  { 101, "$a50.hi"}, /* 1558 */
  { 102, "$a51_lo"}, /* 1559 */
  { 102, "$a51.lo"}, /* 1560 */
  { 103, "$a51_hi"}, /* 1561 */
  { 103, "$a51.hi"}, /* 1562 */
  { 104, "$a52_lo"}, /* 1563 */
  { 104, "$a52.lo"}, /* 1564 */
  { 105, "$a52_hi"}, /* 1565 */
  { 105, "$a52.hi"}, /* 1566 */
  { 106, "$a53_lo"}, /* 1567 */
  { 106, "$a53.lo"}, /* 1568 */
  { 107, "$a53_hi"}, /* 1569 */
  { 107, "$a53.hi"}, /* 1570 */
  { 108, "$a54_lo"}, /* 1571 */
  { 108, "$a54.lo"}, /* 1572 */
  { 109, "$a54_hi"}, /* 1573 */
  { 109, "$a54.hi"}, /* 1574 */
  { 110, "$a55_lo"}, /* 1575 */
  { 110, "$a55.lo"}, /* 1576 */
  { 111, "$a55_hi"}, /* 1577 */
  { 111, "$a55.hi"}, /* 1578 */
  { 112, "$a56_lo"}, /* 1579 */
  { 112, "$a56.lo"}, /* 1580 */
  { 113, "$a56_hi"}, /* 1581 */
  { 113, "$a56.hi"}, /* 1582 */
  { 114, "$a57_lo"}, /* 1583 */
  { 114, "$a57.lo"}, /* 1584 */
  { 115, "$a57_hi"}, /* 1585 */
  { 115, "$a57.hi"}, /* 1586 */
  { 116, "$a58_lo"}, /* 1587 */
  { 116, "$a58.lo"}, /* 1588 */
  { 117, "$a58_hi"}, /* 1589 */
  { 117, "$a58.hi"}, /* 1590 */
  { 118, "$a59_lo"}, /* 1591 */
  { 118, "$a59.lo"}, /* 1592 */
  { 119, "$a59_hi"}, /* 1593 */
  { 119, "$a59.hi"}, /* 1594 */
  { 120, "$a60_lo"}, /* 1595 */
  { 120, "$a60.lo"}, /* 1596 */
  { 121, "$a60_hi"}, /* 1597 */
  { 121, "$a60.hi"}, /* 1598 */
  { 122, "$a61_lo"}, /* 1599 */
  { 122, "$a61.lo"}, /* 1600 */
  { 123, "$a61_hi"}, /* 1601 */
  { 123, "$a61.hi"}, /* 1602 */
  { 124, "$a62_lo"}, /* 1603 */
  { 124, "$a62.lo"}, /* 1604 */
  { 125, "$a62_hi"}, /* 1605 */
  { 125, "$a62.hi"}, /* 1606 */
  { 126, "$a63_lo"}, /* 1607 */
  { 126, "$a63.lo"}, /* 1608 */
  { 127, "$a63_hi"}, /* 1609 */
  { 127, "$a63.hi"}, /* 1610 */
  { 0, "$a0_x"}, /* 1611 */
  { 0, "$a0.x"}, /* 1612 */
  { 1, "$a0_y"}, /* 1613 */
  { 1, "$a0.y"}, /* 1614 */
  { 2, "$a0_z"}, /* 1615 */
  { 2, "$a0.z"}, /* 1616 */
  { 3, "$a0_t"}, /* 1617 */
  { 3, "$a0.t"}, /* 1618 */
  { 4, "$a1_x"}, /* 1619 */
  { 4, "$a1.x"}, /* 1620 */
  { 5, "$a1_y"}, /* 1621 */
  { 5, "$a1.y"}, /* 1622 */
  { 6, "$a1_z"}, /* 1623 */
  { 6, "$a1.z"}, /* 1624 */
  { 7, "$a1_t"}, /* 1625 */
  { 7, "$a1.t"}, /* 1626 */
  { 8, "$a2_x"}, /* 1627 */
  { 8, "$a2.x"}, /* 1628 */
  { 9, "$a2_y"}, /* 1629 */
  { 9, "$a2.y"}, /* 1630 */
  { 10, "$a2_z"}, /* 1631 */
  { 10, "$a2.z"}, /* 1632 */
  { 11, "$a2_t"}, /* 1633 */
  { 11, "$a2.t"}, /* 1634 */
  { 12, "$a3_x"}, /* 1635 */
  { 12, "$a3.x"}, /* 1636 */
  { 13, "$a3_y"}, /* 1637 */
  { 13, "$a3.y"}, /* 1638 */
  { 14, "$a3_z"}, /* 1639 */
  { 14, "$a3.z"}, /* 1640 */
  { 15, "$a3_t"}, /* 1641 */
  { 15, "$a3.t"}, /* 1642 */
  { 16, "$a4_x"}, /* 1643 */
  { 16, "$a4.x"}, /* 1644 */
  { 17, "$a4_y"}, /* 1645 */
  { 17, "$a4.y"}, /* 1646 */
  { 18, "$a4_z"}, /* 1647 */
  { 18, "$a4.z"}, /* 1648 */
  { 19, "$a4_t"}, /* 1649 */
  { 19, "$a4.t"}, /* 1650 */
  { 20, "$a5_x"}, /* 1651 */
  { 20, "$a5.x"}, /* 1652 */
  { 21, "$a5_y"}, /* 1653 */
  { 21, "$a5.y"}, /* 1654 */
  { 22, "$a5_z"}, /* 1655 */
  { 22, "$a5.z"}, /* 1656 */
  { 23, "$a5_t"}, /* 1657 */
  { 23, "$a5.t"}, /* 1658 */
  { 24, "$a6_x"}, /* 1659 */
  { 24, "$a6.x"}, /* 1660 */
  { 25, "$a6_y"}, /* 1661 */
  { 25, "$a6.y"}, /* 1662 */
  { 26, "$a6_z"}, /* 1663 */
  { 26, "$a6.z"}, /* 1664 */
  { 27, "$a6_t"}, /* 1665 */
  { 27, "$a6.t"}, /* 1666 */
  { 28, "$a7_x"}, /* 1667 */
  { 28, "$a7.x"}, /* 1668 */
  { 29, "$a7_y"}, /* 1669 */
  { 29, "$a7.y"}, /* 1670 */
  { 30, "$a7_z"}, /* 1671 */
  { 30, "$a7.z"}, /* 1672 */
  { 31, "$a7_t"}, /* 1673 */
  { 31, "$a7.t"}, /* 1674 */
  { 32, "$a8_x"}, /* 1675 */
  { 32, "$a8.x"}, /* 1676 */
  { 33, "$a8_y"}, /* 1677 */
  { 33, "$a8.y"}, /* 1678 */
  { 34, "$a8_z"}, /* 1679 */
  { 34, "$a8.z"}, /* 1680 */
  { 35, "$a8_t"}, /* 1681 */
  { 35, "$a8.t"}, /* 1682 */
  { 36, "$a9_x"}, /* 1683 */
  { 36, "$a9.x"}, /* 1684 */
  { 37, "$a9_y"}, /* 1685 */
  { 37, "$a9.y"}, /* 1686 */
  { 38, "$a9_z"}, /* 1687 */
  { 38, "$a9.z"}, /* 1688 */
  { 39, "$a9_t"}, /* 1689 */
  { 39, "$a9.t"}, /* 1690 */
  { 40, "$a10_x"}, /* 1691 */
  { 40, "$a10.x"}, /* 1692 */
  { 41, "$a10_y"}, /* 1693 */
  { 41, "$a10.y"}, /* 1694 */
  { 42, "$a10_z"}, /* 1695 */
  { 42, "$a10.z"}, /* 1696 */
  { 43, "$a10_t"}, /* 1697 */
  { 43, "$a10.t"}, /* 1698 */
  { 44, "$a11_x"}, /* 1699 */
  { 44, "$a11.x"}, /* 1700 */
  { 45, "$a11_y"}, /* 1701 */
  { 45, "$a11.y"}, /* 1702 */
  { 46, "$a11_z"}, /* 1703 */
  { 46, "$a11.z"}, /* 1704 */
  { 47, "$a11_t"}, /* 1705 */
  { 47, "$a11.t"}, /* 1706 */
  { 48, "$a12_x"}, /* 1707 */
  { 48, "$a12.x"}, /* 1708 */
  { 49, "$a12_y"}, /* 1709 */
  { 49, "$a12.y"}, /* 1710 */
  { 50, "$a12_z"}, /* 1711 */
  { 50, "$a12.z"}, /* 1712 */
  { 51, "$a12_t"}, /* 1713 */
  { 51, "$a12.t"}, /* 1714 */
  { 52, "$a13_x"}, /* 1715 */
  { 52, "$a13.x"}, /* 1716 */
  { 53, "$a13_y"}, /* 1717 */
  { 53, "$a13.y"}, /* 1718 */
  { 54, "$a13_z"}, /* 1719 */
  { 54, "$a13.z"}, /* 1720 */
  { 55, "$a13_t"}, /* 1721 */
  { 55, "$a13.t"}, /* 1722 */
  { 56, "$a14_x"}, /* 1723 */
  { 56, "$a14.x"}, /* 1724 */
  { 57, "$a14_y"}, /* 1725 */
  { 57, "$a14.y"}, /* 1726 */
  { 58, "$a14_z"}, /* 1727 */
  { 58, "$a14.z"}, /* 1728 */
  { 59, "$a14_t"}, /* 1729 */
  { 59, "$a14.t"}, /* 1730 */
  { 60, "$a15_x"}, /* 1731 */
  { 60, "$a15.x"}, /* 1732 */
  { 61, "$a15_y"}, /* 1733 */
  { 61, "$a15.y"}, /* 1734 */
  { 62, "$a15_z"}, /* 1735 */
  { 62, "$a15.z"}, /* 1736 */
  { 63, "$a15_t"}, /* 1737 */
  { 63, "$a15.t"}, /* 1738 */
  { 64, "$a16_x"}, /* 1739 */
  { 64, "$a16.x"}, /* 1740 */
  { 65, "$a16_y"}, /* 1741 */
  { 65, "$a16.y"}, /* 1742 */
  { 66, "$a16_z"}, /* 1743 */
  { 66, "$a16.z"}, /* 1744 */
  { 67, "$a16_t"}, /* 1745 */
  { 67, "$a16.t"}, /* 1746 */
  { 68, "$a17_x"}, /* 1747 */
  { 68, "$a17.x"}, /* 1748 */
  { 69, "$a17_y"}, /* 1749 */
  { 69, "$a17.y"}, /* 1750 */
  { 70, "$a17_z"}, /* 1751 */
  { 70, "$a17.z"}, /* 1752 */
  { 71, "$a17_t"}, /* 1753 */
  { 71, "$a17.t"}, /* 1754 */
  { 72, "$a18_x"}, /* 1755 */
  { 72, "$a18.x"}, /* 1756 */
  { 73, "$a18_y"}, /* 1757 */
  { 73, "$a18.y"}, /* 1758 */
  { 74, "$a18_z"}, /* 1759 */
  { 74, "$a18.z"}, /* 1760 */
  { 75, "$a18_t"}, /* 1761 */
  { 75, "$a18.t"}, /* 1762 */
  { 76, "$a19_x"}, /* 1763 */
  { 76, "$a19.x"}, /* 1764 */
  { 77, "$a19_y"}, /* 1765 */
  { 77, "$a19.y"}, /* 1766 */
  { 78, "$a19_z"}, /* 1767 */
  { 78, "$a19.z"}, /* 1768 */
  { 79, "$a19_t"}, /* 1769 */
  { 79, "$a19.t"}, /* 1770 */
  { 80, "$a20_x"}, /* 1771 */
  { 80, "$a20.x"}, /* 1772 */
  { 81, "$a20_y"}, /* 1773 */
  { 81, "$a20.y"}, /* 1774 */
  { 82, "$a20_z"}, /* 1775 */
  { 82, "$a20.z"}, /* 1776 */
  { 83, "$a20_t"}, /* 1777 */
  { 83, "$a20.t"}, /* 1778 */
  { 84, "$a21_x"}, /* 1779 */
  { 84, "$a21.x"}, /* 1780 */
  { 85, "$a21_y"}, /* 1781 */
  { 85, "$a21.y"}, /* 1782 */
  { 86, "$a21_z"}, /* 1783 */
  { 86, "$a21.z"}, /* 1784 */
  { 87, "$a21_t"}, /* 1785 */
  { 87, "$a21.t"}, /* 1786 */
  { 88, "$a22_x"}, /* 1787 */
  { 88, "$a22.x"}, /* 1788 */
  { 89, "$a22_y"}, /* 1789 */
  { 89, "$a22.y"}, /* 1790 */
  { 90, "$a22_z"}, /* 1791 */
  { 90, "$a22.z"}, /* 1792 */
  { 91, "$a22_t"}, /* 1793 */
  { 91, "$a22.t"}, /* 1794 */
  { 92, "$a23_x"}, /* 1795 */
  { 92, "$a23.x"}, /* 1796 */
  { 93, "$a23_y"}, /* 1797 */
  { 93, "$a23.y"}, /* 1798 */
  { 94, "$a23_z"}, /* 1799 */
  { 94, "$a23.z"}, /* 1800 */
  { 95, "$a23_t"}, /* 1801 */
  { 95, "$a23.t"}, /* 1802 */
  { 96, "$a24_x"}, /* 1803 */
  { 96, "$a24.x"}, /* 1804 */
  { 97, "$a24_y"}, /* 1805 */
  { 97, "$a24.y"}, /* 1806 */
  { 98, "$a24_z"}, /* 1807 */
  { 98, "$a24.z"}, /* 1808 */
  { 99, "$a24_t"}, /* 1809 */
  { 99, "$a24.t"}, /* 1810 */
  { 100, "$a25_x"}, /* 1811 */
  { 100, "$a25.x"}, /* 1812 */
  { 101, "$a25_y"}, /* 1813 */
  { 101, "$a25.y"}, /* 1814 */
  { 102, "$a25_z"}, /* 1815 */
  { 102, "$a25.z"}, /* 1816 */
  { 103, "$a25_t"}, /* 1817 */
  { 103, "$a25.t"}, /* 1818 */
  { 104, "$a26_x"}, /* 1819 */
  { 104, "$a26.x"}, /* 1820 */
  { 105, "$a26_y"}, /* 1821 */
  { 105, "$a26.y"}, /* 1822 */
  { 106, "$a26_z"}, /* 1823 */
  { 106, "$a26.z"}, /* 1824 */
  { 107, "$a26_t"}, /* 1825 */
  { 107, "$a26.t"}, /* 1826 */
  { 108, "$a27_x"}, /* 1827 */
  { 108, "$a27.x"}, /* 1828 */
  { 109, "$a27_y"}, /* 1829 */
  { 109, "$a27.y"}, /* 1830 */
  { 110, "$a27_z"}, /* 1831 */
  { 110, "$a27.z"}, /* 1832 */
  { 111, "$a27_t"}, /* 1833 */
  { 111, "$a27.t"}, /* 1834 */
  { 112, "$a28_x"}, /* 1835 */
  { 112, "$a28.x"}, /* 1836 */
  { 113, "$a28_y"}, /* 1837 */
  { 113, "$a28.y"}, /* 1838 */
  { 114, "$a28_z"}, /* 1839 */
  { 114, "$a28.z"}, /* 1840 */
  { 115, "$a28_t"}, /* 1841 */
  { 115, "$a28.t"}, /* 1842 */
  { 116, "$a29_x"}, /* 1843 */
  { 116, "$a29.x"}, /* 1844 */
  { 117, "$a29_y"}, /* 1845 */
  { 117, "$a29.y"}, /* 1846 */
  { 118, "$a29_z"}, /* 1847 */
  { 118, "$a29.z"}, /* 1848 */
  { 119, "$a29_t"}, /* 1849 */
  { 119, "$a29.t"}, /* 1850 */
  { 120, "$a30_x"}, /* 1851 */
  { 120, "$a30.x"}, /* 1852 */
  { 121, "$a30_y"}, /* 1853 */
  { 121, "$a30.y"}, /* 1854 */
  { 122, "$a30_z"}, /* 1855 */
  { 122, "$a30.z"}, /* 1856 */
  { 123, "$a30_t"}, /* 1857 */
  { 123, "$a30.t"}, /* 1858 */
  { 124, "$a31_x"}, /* 1859 */
  { 124, "$a31.x"}, /* 1860 */
  { 125, "$a31_y"}, /* 1861 */
  { 125, "$a31.y"}, /* 1862 */
  { 126, "$a31_z"}, /* 1863 */
  { 126, "$a31.z"}, /* 1864 */
  { 127, "$a31_t"}, /* 1865 */
  { 127, "$a31.t"}, /* 1866 */
  { 128, "$a32_x"}, /* 1867 */
  { 128, "$a32.x"}, /* 1868 */
  { 129, "$a32_y"}, /* 1869 */
  { 129, "$a32.y"}, /* 1870 */
  { 130, "$a32_z"}, /* 1871 */
  { 130, "$a32.z"}, /* 1872 */
  { 131, "$a32_t"}, /* 1873 */
  { 131, "$a32.t"}, /* 1874 */
  { 132, "$a33_x"}, /* 1875 */
  { 132, "$a33.x"}, /* 1876 */
  { 133, "$a33_y"}, /* 1877 */
  { 133, "$a33.y"}, /* 1878 */
  { 134, "$a33_z"}, /* 1879 */
  { 134, "$a33.z"}, /* 1880 */
  { 135, "$a33_t"}, /* 1881 */
  { 135, "$a33.t"}, /* 1882 */
  { 136, "$a34_x"}, /* 1883 */
  { 136, "$a34.x"}, /* 1884 */
  { 137, "$a34_y"}, /* 1885 */
  { 137, "$a34.y"}, /* 1886 */
  { 138, "$a34_z"}, /* 1887 */
  { 138, "$a34.z"}, /* 1888 */
  { 139, "$a34_t"}, /* 1889 */
  { 139, "$a34.t"}, /* 1890 */
  { 140, "$a35_x"}, /* 1891 */
  { 140, "$a35.x"}, /* 1892 */
  { 141, "$a35_y"}, /* 1893 */
  { 141, "$a35.y"}, /* 1894 */
  { 142, "$a35_z"}, /* 1895 */
  { 142, "$a35.z"}, /* 1896 */
  { 143, "$a35_t"}, /* 1897 */
  { 143, "$a35.t"}, /* 1898 */
  { 144, "$a36_x"}, /* 1899 */
  { 144, "$a36.x"}, /* 1900 */
  { 145, "$a36_y"}, /* 1901 */
  { 145, "$a36.y"}, /* 1902 */
  { 146, "$a36_z"}, /* 1903 */
  { 146, "$a36.z"}, /* 1904 */
  { 147, "$a36_t"}, /* 1905 */
  { 147, "$a36.t"}, /* 1906 */
  { 148, "$a37_x"}, /* 1907 */
  { 148, "$a37.x"}, /* 1908 */
  { 149, "$a37_y"}, /* 1909 */
  { 149, "$a37.y"}, /* 1910 */
  { 150, "$a37_z"}, /* 1911 */
  { 150, "$a37.z"}, /* 1912 */
  { 151, "$a37_t"}, /* 1913 */
  { 151, "$a37.t"}, /* 1914 */
  { 152, "$a38_x"}, /* 1915 */
  { 152, "$a38.x"}, /* 1916 */
  { 153, "$a38_y"}, /* 1917 */
  { 153, "$a38.y"}, /* 1918 */
  { 154, "$a38_z"}, /* 1919 */
  { 154, "$a38.z"}, /* 1920 */
  { 155, "$a38_t"}, /* 1921 */
  { 155, "$a38.t"}, /* 1922 */
  { 156, "$a39_x"}, /* 1923 */
  { 156, "$a39.x"}, /* 1924 */
  { 157, "$a39_y"}, /* 1925 */
  { 157, "$a39.y"}, /* 1926 */
  { 158, "$a39_z"}, /* 1927 */
  { 158, "$a39.z"}, /* 1928 */
  { 159, "$a39_t"}, /* 1929 */
  { 159, "$a39.t"}, /* 1930 */
  { 160, "$a40_x"}, /* 1931 */
  { 160, "$a40.x"}, /* 1932 */
  { 161, "$a40_y"}, /* 1933 */
  { 161, "$a40.y"}, /* 1934 */
  { 162, "$a40_z"}, /* 1935 */
  { 162, "$a40.z"}, /* 1936 */
  { 163, "$a40_t"}, /* 1937 */
  { 163, "$a40.t"}, /* 1938 */
  { 164, "$a41_x"}, /* 1939 */
  { 164, "$a41.x"}, /* 1940 */
  { 165, "$a41_y"}, /* 1941 */
  { 165, "$a41.y"}, /* 1942 */
  { 166, "$a41_z"}, /* 1943 */
  { 166, "$a41.z"}, /* 1944 */
  { 167, "$a41_t"}, /* 1945 */
  { 167, "$a41.t"}, /* 1946 */
  { 168, "$a42_x"}, /* 1947 */
  { 168, "$a42.x"}, /* 1948 */
  { 169, "$a42_y"}, /* 1949 */
  { 169, "$a42.y"}, /* 1950 */
  { 170, "$a42_z"}, /* 1951 */
  { 170, "$a42.z"}, /* 1952 */
  { 171, "$a42_t"}, /* 1953 */
  { 171, "$a42.t"}, /* 1954 */
  { 172, "$a43_x"}, /* 1955 */
  { 172, "$a43.x"}, /* 1956 */
  { 173, "$a43_y"}, /* 1957 */
  { 173, "$a43.y"}, /* 1958 */
  { 174, "$a43_z"}, /* 1959 */
  { 174, "$a43.z"}, /* 1960 */
  { 175, "$a43_t"}, /* 1961 */
  { 175, "$a43.t"}, /* 1962 */
  { 176, "$a44_x"}, /* 1963 */
  { 176, "$a44.x"}, /* 1964 */
  { 177, "$a44_y"}, /* 1965 */
  { 177, "$a44.y"}, /* 1966 */
  { 178, "$a44_z"}, /* 1967 */
  { 178, "$a44.z"}, /* 1968 */
  { 179, "$a44_t"}, /* 1969 */
  { 179, "$a44.t"}, /* 1970 */
  { 180, "$a45_x"}, /* 1971 */
  { 180, "$a45.x"}, /* 1972 */
  { 181, "$a45_y"}, /* 1973 */
  { 181, "$a45.y"}, /* 1974 */
  { 182, "$a45_z"}, /* 1975 */
  { 182, "$a45.z"}, /* 1976 */
  { 183, "$a45_t"}, /* 1977 */
  { 183, "$a45.t"}, /* 1978 */
  { 184, "$a46_x"}, /* 1979 */
  { 184, "$a46.x"}, /* 1980 */
  { 185, "$a46_y"}, /* 1981 */
  { 185, "$a46.y"}, /* 1982 */
  { 186, "$a46_z"}, /* 1983 */
  { 186, "$a46.z"}, /* 1984 */
  { 187, "$a46_t"}, /* 1985 */
  { 187, "$a46.t"}, /* 1986 */
  { 188, "$a47_x"}, /* 1987 */
  { 188, "$a47.x"}, /* 1988 */
  { 189, "$a47_y"}, /* 1989 */
  { 189, "$a47.y"}, /* 1990 */
  { 190, "$a47_z"}, /* 1991 */
  { 190, "$a47.z"}, /* 1992 */
  { 191, "$a47_t"}, /* 1993 */
  { 191, "$a47.t"}, /* 1994 */
  { 192, "$a48_x"}, /* 1995 */
  { 192, "$a48.x"}, /* 1996 */
  { 193, "$a48_y"}, /* 1997 */
  { 193, "$a48.y"}, /* 1998 */
  { 194, "$a48_z"}, /* 1999 */
  { 194, "$a48.z"}, /* 2000 */
  { 195, "$a48_t"}, /* 2001 */
  { 195, "$a48.t"}, /* 2002 */
  { 196, "$a49_x"}, /* 2003 */
  { 196, "$a49.x"}, /* 2004 */
  { 197, "$a49_y"}, /* 2005 */
  { 197, "$a49.y"}, /* 2006 */
  { 198, "$a49_z"}, /* 2007 */
  { 198, "$a49.z"}, /* 2008 */
  { 199, "$a49_t"}, /* 2009 */
  { 199, "$a49.t"}, /* 2010 */
  { 200, "$a50_x"}, /* 2011 */
  { 200, "$a50.x"}, /* 2012 */
  { 201, "$a50_y"}, /* 2013 */
  { 201, "$a50.y"}, /* 2014 */
  { 202, "$a50_z"}, /* 2015 */
  { 202, "$a50.z"}, /* 2016 */
  { 203, "$a50_t"}, /* 2017 */
  { 203, "$a50.t"}, /* 2018 */
  { 204, "$a51_x"}, /* 2019 */
  { 204, "$a51.x"}, /* 2020 */
  { 205, "$a51_y"}, /* 2021 */
  { 205, "$a51.y"}, /* 2022 */
  { 206, "$a51_z"}, /* 2023 */
  { 206, "$a51.z"}, /* 2024 */
  { 207, "$a51_t"}, /* 2025 */
  { 207, "$a51.t"}, /* 2026 */
  { 208, "$a52_x"}, /* 2027 */
  { 208, "$a52.x"}, /* 2028 */
  { 209, "$a52_y"}, /* 2029 */
  { 209, "$a52.y"}, /* 2030 */
  { 210, "$a52_z"}, /* 2031 */
  { 210, "$a52.z"}, /* 2032 */
  { 211, "$a52_t"}, /* 2033 */
  { 211, "$a52.t"}, /* 2034 */
  { 212, "$a53_x"}, /* 2035 */
  { 212, "$a53.x"}, /* 2036 */
  { 213, "$a53_y"}, /* 2037 */
  { 213, "$a53.y"}, /* 2038 */
  { 214, "$a53_z"}, /* 2039 */
  { 214, "$a53.z"}, /* 2040 */
  { 215, "$a53_t"}, /* 2041 */
  { 215, "$a53.t"}, /* 2042 */
  { 216, "$a54_x"}, /* 2043 */
  { 216, "$a54.x"}, /* 2044 */
  { 217, "$a54_y"}, /* 2045 */
  { 217, "$a54.y"}, /* 2046 */
  { 218, "$a54_z"}, /* 2047 */
  { 218, "$a54.z"}, /* 2048 */
  { 219, "$a54_t"}, /* 2049 */
  { 219, "$a54.t"}, /* 2050 */
  { 220, "$a55_x"}, /* 2051 */
  { 220, "$a55.x"}, /* 2052 */
  { 221, "$a55_y"}, /* 2053 */
  { 221, "$a55.y"}, /* 2054 */
  { 222, "$a55_z"}, /* 2055 */
  { 222, "$a55.z"}, /* 2056 */
  { 223, "$a55_t"}, /* 2057 */
  { 223, "$a55.t"}, /* 2058 */
  { 224, "$a56_x"}, /* 2059 */
  { 224, "$a56.x"}, /* 2060 */
  { 225, "$a56_y"}, /* 2061 */
  { 225, "$a56.y"}, /* 2062 */
  { 226, "$a56_z"}, /* 2063 */
  { 226, "$a56.z"}, /* 2064 */
  { 227, "$a56_t"}, /* 2065 */
  { 227, "$a56.t"}, /* 2066 */
  { 228, "$a57_x"}, /* 2067 */
  { 228, "$a57.x"}, /* 2068 */
  { 229, "$a57_y"}, /* 2069 */
  { 229, "$a57.y"}, /* 2070 */
  { 230, "$a57_z"}, /* 2071 */
  { 230, "$a57.z"}, /* 2072 */
  { 231, "$a57_t"}, /* 2073 */
  { 231, "$a57.t"}, /* 2074 */
  { 232, "$a58_x"}, /* 2075 */
  { 232, "$a58.x"}, /* 2076 */
  { 233, "$a58_y"}, /* 2077 */
  { 233, "$a58.y"}, /* 2078 */
  { 234, "$a58_z"}, /* 2079 */
  { 234, "$a58.z"}, /* 2080 */
  { 235, "$a58_t"}, /* 2081 */
  { 235, "$a58.t"}, /* 2082 */
  { 236, "$a59_x"}, /* 2083 */
  { 236, "$a59.x"}, /* 2084 */
  { 237, "$a59_y"}, /* 2085 */
  { 237, "$a59.y"}, /* 2086 */
  { 238, "$a59_z"}, /* 2087 */
  { 238, "$a59.z"}, /* 2088 */
  { 239, "$a59_t"}, /* 2089 */
  { 239, "$a59.t"}, /* 2090 */
  { 240, "$a60_x"}, /* 2091 */
  { 240, "$a60.x"}, /* 2092 */
  { 241, "$a60_y"}, /* 2093 */
  { 241, "$a60.y"}, /* 2094 */
  { 242, "$a60_z"}, /* 2095 */
  { 242, "$a60.z"}, /* 2096 */
  { 243, "$a60_t"}, /* 2097 */
  { 243, "$a60.t"}, /* 2098 */
  { 244, "$a61_x"}, /* 2099 */
  { 244, "$a61.x"}, /* 2100 */
  { 245, "$a61_y"}, /* 2101 */
  { 245, "$a61.y"}, /* 2102 */
  { 246, "$a61_z"}, /* 2103 */
  { 246, "$a61.z"}, /* 2104 */
  { 247, "$a61_t"}, /* 2105 */
  { 247, "$a61.t"}, /* 2106 */
  { 248, "$a62_x"}, /* 2107 */
  { 248, "$a62.x"}, /* 2108 */
  { 249, "$a62_y"}, /* 2109 */
  { 249, "$a62.y"}, /* 2110 */
  { 250, "$a62_z"}, /* 2111 */
  { 250, "$a62.z"}, /* 2112 */
  { 251, "$a62_t"}, /* 2113 */
  { 251, "$a62.t"}, /* 2114 */
  { 252, "$a63_x"}, /* 2115 */
  { 252, "$a63.x"}, /* 2116 */
  { 253, "$a63_y"}, /* 2117 */
  { 253, "$a63.y"}, /* 2118 */
  { 254, "$a63_z"}, /* 2119 */
  { 254, "$a63.z"}, /* 2120 */
  { 255, "$a63_t"}, /* 2121 */
  { 255, "$a63.t"}, /* 2122 */
  { 0, "$a0a1a2a3"}, /* 2123 */
  { 1, "$a4a5a6a7"}, /* 2124 */
  { 2, "$a8a9a10a11"}, /* 2125 */
  { 3, "$a12a13a14a15"}, /* 2126 */
  { 4, "$a16a17a18a19"}, /* 2127 */
  { 5, "$a20a21a22a23"}, /* 2128 */
  { 6, "$a24a25a26a27"}, /* 2129 */
  { 7, "$a28a29a30a31"}, /* 2130 */
  { 8, "$a32a33a34a35"}, /* 2131 */
  { 9, "$a36a37a38a39"}, /* 2132 */
  { 10, "$a40a41a42a43"}, /* 2133 */
  { 11, "$a44a45a46a47"}, /* 2134 */
  { 12, "$a48a49a50a51"}, /* 2135 */
  { 13, "$a52a53a54a55"}, /* 2136 */
  { 14, "$a56a57a58a59"}, /* 2137 */
  { 15, "$a60a61a62a63"}, /* 2138 */
  { 0, "$a0a1"}, /* 2139 */
  { 0, "$a0a1a2a3.lo"}, /* 2140 */
  { 1, "$a2a3"}, /* 2141 */
  { 1, "$a0a1a2a3.hi"}, /* 2142 */
  { 2, "$a4a5"}, /* 2143 */
  { 2, "$a4a5a6a7.lo"}, /* 2144 */
  { 3, "$a6a7"}, /* 2145 */
  { 3, "$a4a5a6a7.hi"}, /* 2146 */
  { 4, "$a8a9"}, /* 2147 */
  { 4, "$a8a9a10a11.lo"}, /* 2148 */
  { 5, "$a10a11"}, /* 2149 */
  { 5, "$a8a9a10a11.hi"}, /* 2150 */
  { 6, "$a12a13"}, /* 2151 */
  { 6, "$a12a13a14a15.lo"}, /* 2152 */
  { 7, "$a14a15"}, /* 2153 */
  { 7, "$a12a13a14a15.hi"}, /* 2154 */
  { 8, "$a16a17"}, /* 2155 */
  { 8, "$a16a17a18a19.lo"}, /* 2156 */
  { 9, "$a18a19"}, /* 2157 */
  { 9, "$a16a17a18a19.hi"}, /* 2158 */
  { 10, "$a20a21"}, /* 2159 */
  { 10, "$a20a21a22a23.lo"}, /* 2160 */
  { 11, "$a22a23"}, /* 2161 */
  { 11, "$a20a21a22a23.hi"}, /* 2162 */
  { 12, "$a24a25"}, /* 2163 */
  { 12, "$a24a25a26a27.lo"}, /* 2164 */
  { 13, "$a26a27"}, /* 2165 */
  { 13, "$a24a25a26a27.hi"}, /* 2166 */
  { 14, "$a28a29"}, /* 2167 */
  { 14, "$a28a29a30a31.lo"}, /* 2168 */
  { 15, "$a30a31"}, /* 2169 */
  { 15, "$a28a29a30a31.hi"}, /* 2170 */
  { 16, "$a32a33"}, /* 2171 */
  { 16, "$a32a33a34a35.lo"}, /* 2172 */
  { 17, "$a34a35"}, /* 2173 */
  { 17, "$a32a33a34a35.hi"}, /* 2174 */
  { 18, "$a36a37"}, /* 2175 */
  { 18, "$a36a37a38a39.lo"}, /* 2176 */
  { 19, "$a38a39"}, /* 2177 */
  { 19, "$a36a37a38a39.hi"}, /* 2178 */
  { 20, "$a40a41"}, /* 2179 */
  { 20, "$a40a41a42a43.lo"}, /* 2180 */
  { 21, "$a42a43"}, /* 2181 */
  { 21, "$a40a41a42a43.hi"}, /* 2182 */
  { 22, "$a44a45"}, /* 2183 */
  { 22, "$a44a45a46a47.lo"}, /* 2184 */
  { 23, "$a46a47"}, /* 2185 */
  { 23, "$a44a45a46a47.hi"}, /* 2186 */
  { 24, "$a48a49"}, /* 2187 */
  { 24, "$a48a49a50a51.lo"}, /* 2188 */
  { 25, "$a50a51"}, /* 2189 */
  { 25, "$a48a49a50a51.hi"}, /* 2190 */
  { 26, "$a52a53"}, /* 2191 */
  { 26, "$a52a53a54a55.lo"}, /* 2192 */
  { 27, "$a54a55"}, /* 2193 */
  { 27, "$a52a53a54a55.hi"}, /* 2194 */
  { 28, "$a56a57"}, /* 2195 */
  { 28, "$a56a57a58a59.lo"}, /* 2196 */
  { 29, "$a58a59"}, /* 2197 */
  { 29, "$a56a57a58a59.hi"}, /* 2198 */
  { 30, "$a60a61"}, /* 2199 */
  { 30, "$a60a61a62a63.lo"}, /* 2200 */
  { 31, "$a62a63"}, /* 2201 */
  { 31, "$a60a61a62a63.hi"}, /* 2202 */
  { 0, "$a0"}, /* 2203 */
  { 0, "$a0a1.lo"}, /* 2204 */
  { 0, "$a0a1a2a3.x"}, /* 2205 */
  { 1, "$a1"}, /* 2206 */
  { 1, "$a0a1.hi"}, /* 2207 */
  { 1, "$a0a1a2a3.y"}, /* 2208 */
  { 2, "$a2"}, /* 2209 */
  { 2, "$a2a3.lo"}, /* 2210 */
  { 2, "$a0a1a2a3.z"}, /* 2211 */
  { 3, "$a3"}, /* 2212 */
  { 3, "$a2a3.hi"}, /* 2213 */
  { 3, "$a0a1a2a3.t"}, /* 2214 */
  { 4, "$a4"}, /* 2215 */
  { 4, "$a4a5.lo"}, /* 2216 */
  { 4, "$a4a5a6a7.x"}, /* 2217 */
  { 5, "$a5"}, /* 2218 */
  { 5, "$a4a5.hi"}, /* 2219 */
  { 5, "$a4a5a6a7.y"}, /* 2220 */
  { 6, "$a6"}, /* 2221 */
  { 6, "$a6a7.lo"}, /* 2222 */
  { 6, "$a4a5a6a7.z"}, /* 2223 */
  { 7, "$a7"}, /* 2224 */
  { 7, "$a6a7.hi"}, /* 2225 */
  { 7, "$a4a5a6a7.t"}, /* 2226 */
  { 8, "$a8"}, /* 2227 */
  { 8, "$a8a9.lo"}, /* 2228 */
  { 8, "$a8a9a10a11.x"}, /* 2229 */
  { 9, "$a9"}, /* 2230 */
  { 9, "$a8a9.hi"}, /* 2231 */
  { 9, "$a8a9a10a11.y"}, /* 2232 */
  { 10, "$a10"}, /* 2233 */
  { 10, "$a10a11.lo"}, /* 2234 */
  { 10, "$a8a9a10a11.z"}, /* 2235 */
  { 11, "$a11"}, /* 2236 */
  { 11, "$a10a11.hi"}, /* 2237 */
  { 11, "$a8a9a10a11.t"}, /* 2238 */
  { 12, "$a12"}, /* 2239 */
  { 12, "$a12a13.lo"}, /* 2240 */
  { 12, "$a12a13a14a15.x"}, /* 2241 */
  { 13, "$a13"}, /* 2242 */
  { 13, "$a12a13.hi"}, /* 2243 */
  { 13, "$a12a13a14a15.y"}, /* 2244 */
  { 14, "$a14"}, /* 2245 */
  { 14, "$a14a15.lo"}, /* 2246 */
  { 14, "$a12a13a14a15.z"}, /* 2247 */
  { 15, "$a15"}, /* 2248 */
  { 15, "$a14a15.hi"}, /* 2249 */
  { 15, "$a12a13a14a15.t"}, /* 2250 */
  { 16, "$a16"}, /* 2251 */
  { 16, "$a16a17.lo"}, /* 2252 */
  { 16, "$a16a17a18a19.x"}, /* 2253 */
  { 17, "$a17"}, /* 2254 */
  { 17, "$a16a17.hi"}, /* 2255 */
  { 17, "$a16a17a18a19.y"}, /* 2256 */
  { 18, "$a18"}, /* 2257 */
  { 18, "$a18a19.lo"}, /* 2258 */
  { 18, "$a16a17a18a19.z"}, /* 2259 */
  { 19, "$a19"}, /* 2260 */
  { 19, "$a18a19.hi"}, /* 2261 */
  { 19, "$a16a17a18a19.t"}, /* 2262 */
  { 20, "$a20"}, /* 2263 */
  { 20, "$a20a21.lo"}, /* 2264 */
  { 20, "$a20a21a22a23.x"}, /* 2265 */
  { 21, "$a21"}, /* 2266 */
  { 21, "$a20a21.hi"}, /* 2267 */
  { 21, "$a20a21a22a23.y"}, /* 2268 */
  { 22, "$a22"}, /* 2269 */
  { 22, "$a22a23.lo"}, /* 2270 */
  { 22, "$a20a21a22a23.z"}, /* 2271 */
  { 23, "$a23"}, /* 2272 */
  { 23, "$a22a23.hi"}, /* 2273 */
  { 23, "$a20a21a22a23.t"}, /* 2274 */
  { 24, "$a24"}, /* 2275 */
  { 24, "$a24a25.lo"}, /* 2276 */
  { 24, "$a24a25a26a27.x"}, /* 2277 */
  { 25, "$a25"}, /* 2278 */
  { 25, "$a24a25.hi"}, /* 2279 */
  { 25, "$a24a25a26a27.y"}, /* 2280 */
  { 26, "$a26"}, /* 2281 */
  { 26, "$a26a27.lo"}, /* 2282 */
  { 26, "$a24a25a26a27.z"}, /* 2283 */
  { 27, "$a27"}, /* 2284 */
  { 27, "$a26a27.hi"}, /* 2285 */
  { 27, "$a24a25a26a27.t"}, /* 2286 */
  { 28, "$a28"}, /* 2287 */
  { 28, "$a28a29.lo"}, /* 2288 */
  { 28, "$a28a29a30a31.x"}, /* 2289 */
  { 29, "$a29"}, /* 2290 */
  { 29, "$a28a29.hi"}, /* 2291 */
  { 29, "$a28a29a30a31.y"}, /* 2292 */
  { 30, "$a30"}, /* 2293 */
  { 30, "$a30a31.lo"}, /* 2294 */
  { 30, "$a28a29a30a31.z"}, /* 2295 */
  { 31, "$a31"}, /* 2296 */
  { 31, "$a30a31.hi"}, /* 2297 */
  { 31, "$a28a29a30a31.t"}, /* 2298 */
  { 32, "$a32"}, /* 2299 */
  { 32, "$a32a33.lo"}, /* 2300 */
  { 32, "$a32a33a34a35.x"}, /* 2301 */
  { 33, "$a33"}, /* 2302 */
  { 33, "$a32a33.hi"}, /* 2303 */
  { 33, "$a32a33a34a35.y"}, /* 2304 */
  { 34, "$a34"}, /* 2305 */
  { 34, "$a34a35.lo"}, /* 2306 */
  { 34, "$a32a33a34a35.z"}, /* 2307 */
  { 35, "$a35"}, /* 2308 */
  { 35, "$a34a35.hi"}, /* 2309 */
  { 35, "$a32a33a34a35.t"}, /* 2310 */
  { 36, "$a36"}, /* 2311 */
  { 36, "$a36a37.lo"}, /* 2312 */
  { 36, "$a36a37a38a39.x"}, /* 2313 */
  { 37, "$a37"}, /* 2314 */
  { 37, "$a36a37.hi"}, /* 2315 */
  { 37, "$a36a37a38a39.y"}, /* 2316 */
  { 38, "$a38"}, /* 2317 */
  { 38, "$a38a39.lo"}, /* 2318 */
  { 38, "$a36a37a38a39.z"}, /* 2319 */
  { 39, "$a39"}, /* 2320 */
  { 39, "$a38a39.hi"}, /* 2321 */
  { 39, "$a36a37a38a39.t"}, /* 2322 */
  { 40, "$a40"}, /* 2323 */
  { 40, "$a40a41.lo"}, /* 2324 */
  { 40, "$a40a41a42a43.x"}, /* 2325 */
  { 41, "$a41"}, /* 2326 */
  { 41, "$a40a41.hi"}, /* 2327 */
  { 41, "$a40a41a42a43.y"}, /* 2328 */
  { 42, "$a42"}, /* 2329 */
  { 42, "$a42a43.lo"}, /* 2330 */
  { 42, "$a40a41a42a43.z"}, /* 2331 */
  { 43, "$a43"}, /* 2332 */
  { 43, "$a42a43.hi"}, /* 2333 */
  { 43, "$a40a41a42a43.t"}, /* 2334 */
  { 44, "$a44"}, /* 2335 */
  { 44, "$a44a45.lo"}, /* 2336 */
  { 44, "$a44a45a46a47.x"}, /* 2337 */
  { 45, "$a45"}, /* 2338 */
  { 45, "$a44a45.hi"}, /* 2339 */
  { 45, "$a44a45a46a47.y"}, /* 2340 */
  { 46, "$a46"}, /* 2341 */
  { 46, "$a46a47.lo"}, /* 2342 */
  { 46, "$a44a45a46a47.z"}, /* 2343 */
  { 47, "$a47"}, /* 2344 */
  { 47, "$a46a47.hi"}, /* 2345 */
  { 47, "$a44a45a46a47.t"}, /* 2346 */
  { 48, "$a48"}, /* 2347 */
  { 48, "$a48a49.lo"}, /* 2348 */
  { 48, "$a48a49a50a51.x"}, /* 2349 */
  { 49, "$a49"}, /* 2350 */
  { 49, "$a48a49.hi"}, /* 2351 */
  { 49, "$a48a49a50a51.y"}, /* 2352 */
  { 50, "$a50"}, /* 2353 */
  { 50, "$a50a51.lo"}, /* 2354 */
  { 50, "$a48a49a50a51.z"}, /* 2355 */
  { 51, "$a51"}, /* 2356 */
  { 51, "$a50a51.hi"}, /* 2357 */
  { 51, "$a48a49a50a51.t"}, /* 2358 */
  { 52, "$a52"}, /* 2359 */
  { 52, "$a52a53.lo"}, /* 2360 */
  { 52, "$a52a53a54a55.x"}, /* 2361 */
  { 53, "$a53"}, /* 2362 */
  { 53, "$a52a53.hi"}, /* 2363 */
  { 53, "$a52a53a54a55.y"}, /* 2364 */
  { 54, "$a54"}, /* 2365 */
  { 54, "$a54a55.lo"}, /* 2366 */
  { 54, "$a52a53a54a55.z"}, /* 2367 */
  { 55, "$a55"}, /* 2368 */
  { 55, "$a54a55.hi"}, /* 2369 */
  { 55, "$a52a53a54a55.t"}, /* 2370 */
  { 56, "$a56"}, /* 2371 */
  { 56, "$a56a57.lo"}, /* 2372 */
  { 56, "$a56a57a58a59.x"}, /* 2373 */
  { 57, "$a57"}, /* 2374 */
  { 57, "$a56a57.hi"}, /* 2375 */
  { 57, "$a56a57a58a59.y"}, /* 2376 */
  { 58, "$a58"}, /* 2377 */
  { 58, "$a58a59.lo"}, /* 2378 */
  { 58, "$a56a57a58a59.z"}, /* 2379 */
  { 59, "$a59"}, /* 2380 */
  { 59, "$a58a59.hi"}, /* 2381 */
  { 59, "$a56a57a58a59.t"}, /* 2382 */
  { 60, "$a60"}, /* 2383 */
  { 60, "$a60a61.lo"}, /* 2384 */
  { 60, "$a60a61a62a63.x"}, /* 2385 */
  { 61, "$a61"}, /* 2386 */
  { 61, "$a60a61.hi"}, /* 2387 */
  { 61, "$a60a61a62a63.y"}, /* 2388 */
  { 62, "$a62"}, /* 2389 */
  { 62, "$a62a63.lo"}, /* 2390 */
  { 62, "$a60a61a62a63.z"}, /* 2391 */
  { 63, "$a63"}, /* 2392 */
  { 63, "$a62a63.hi"}, /* 2393 */
  { 63, "$a60a61a62a63.t"}, /* 2394 */
};

int kvx_kv3_v1_dec_registers[] = {
  0, /* 0 $r0 */
  3, /* 1 $r1 */
  6, /* 2 $r2 */
  9, /* 3 $r3 */
  12, /* 4 $r4 */
  15, /* 5 $r5 */
  18, /* 6 $r6 */
  21, /* 7 $r7 */
  24, /* 8 $r8 */
  27, /* 9 $r9 */
  30, /* 10 $r10 */
  33, /* 11 $r11 */
  36, /* 12 $r12 */
  38, /* 13 $r13 */
  40, /* 14 $r14 */
  42, /* 15 $r15 */
  44, /* 16 $r16 */
  47, /* 17 $r17 */
  50, /* 18 $r18 */
  53, /* 19 $r19 */
  56, /* 20 $r20 */
  59, /* 21 $r21 */
  62, /* 22 $r22 */
  65, /* 23 $r23 */
  68, /* 24 $r24 */
  71, /* 25 $r25 */
  74, /* 26 $r26 */
  77, /* 27 $r27 */
  80, /* 28 $r28 */
  83, /* 29 $r29 */
  86, /* 30 $r30 */
  89, /* 31 $r31 */
  92, /* 32 $r32 */
  95, /* 33 $r33 */
  98, /* 34 $r34 */
  101, /* 35 $r35 */
  104, /* 36 $r36 */
  107, /* 37 $r37 */
  110, /* 38 $r38 */
  113, /* 39 $r39 */
  116, /* 40 $r40 */
  119, /* 41 $r41 */
  122, /* 42 $r42 */
  125, /* 43 $r43 */
  128, /* 44 $r44 */
  131, /* 45 $r45 */
  134, /* 46 $r46 */
  137, /* 47 $r47 */
  140, /* 48 $r48 */
  143, /* 49 $r49 */
  146, /* 50 $r50 */
  149, /* 51 $r51 */
  152, /* 52 $r52 */
  155, /* 53 $r53 */
  158, /* 54 $r54 */
  161, /* 55 $r55 */
  164, /* 56 $r56 */
  167, /* 57 $r57 */
  170, /* 58 $r58 */
  173, /* 59 $r59 */
  176, /* 60 $r60 */
  179, /* 61 $r61 */
  182, /* 62 $r62 */
  185, /* 63 $r63 */
  188, /* 64 $r0r1 */
  190, /* 65 $r2r3 */
  192, /* 66 $r4r5 */
  194, /* 67 $r6r7 */
  196, /* 68 $r8r9 */
  198, /* 69 $r10r11 */
  200, /* 70 $r12r13 */
  202, /* 71 $r14r15 */
  204, /* 72 $r16r17 */
  206, /* 73 $r18r19 */
  208, /* 74 $r20r21 */
  210, /* 75 $r22r23 */
  212, /* 76 $r24r25 */
  214, /* 77 $r26r27 */
  216, /* 78 $r28r29 */
  218, /* 79 $r30r31 */
  220, /* 80 $r32r33 */
  222, /* 81 $r34r35 */
  224, /* 82 $r36r37 */
  226, /* 83 $r38r39 */
  228, /* 84 $r40r41 */
  230, /* 85 $r42r43 */
  232, /* 86 $r44r45 */
  234, /* 87 $r46r47 */
  236, /* 88 $r48r49 */
  238, /* 89 $r50r51 */
  240, /* 90 $r52r53 */
  242, /* 91 $r54r55 */
  244, /* 92 $r56r57 */
  246, /* 93 $r58r59 */
  248, /* 94 $r60r61 */
  250, /* 95 $r62r63 */
  252, /* 96 $r0r1r2r3 */
  253, /* 97 $r4r5r6r7 */
  254, /* 98 $r8r9r10r11 */
  255, /* 99 $r12r13r14r15 */
  256, /* 100 $r16r17r18r19 */
  257, /* 101 $r20r21r22r23 */
  258, /* 102 $r24r25r26r27 */
  259, /* 103 $r28r29r30r31 */
  260, /* 104 $r32r33r34r35 */
  261, /* 105 $r36r37r38r39 */
  262, /* 106 $r40r41r42r43 */
  263, /* 107 $r44r45r46r47 */
  264, /* 108 $r48r49r50r51 */
  265, /* 109 $r52r53r54r55 */
  266, /* 110 $r56r57r58r59 */
  267, /* 111 $r60r61r62r63 */
  268, /* 112 $pc */
  270, /* 113 $ps */
  272, /* 114 $pcr */
  274, /* 115 $ra */
  276, /* 116 $cs */
  278, /* 117 $csit */
  280, /* 118 $aespc */
  282, /* 119 $ls */
  284, /* 120 $le */
  286, /* 121 $lc */
  288, /* 122 $ipe */
  290, /* 123 $men */
  292, /* 124 $pmc */
  294, /* 125 $pm0 */
  296, /* 126 $pm1 */
  298, /* 127 $pm2 */
  300, /* 128 $pm3 */
  302, /* 129 $pmsa */
  304, /* 130 $tcr */
  306, /* 131 $t0v */
  308, /* 132 $t1v */
  310, /* 133 $t0r */
  312, /* 134 $t1r */
  314, /* 135 $wdv */
  316, /* 136 $wdr */
  318, /* 137 $ile */
  320, /* 138 $ill */
  322, /* 139 $ilr */
  324, /* 140 $mmc */
  326, /* 141 $tel */
  328, /* 142 $teh */
  330, /* 143 $ixc */
  332, /* 144 $syo */
  334, /* 145 $hto */
  336, /* 146 $ito */
  338, /* 147 $do */
  340, /* 148 $mo */
  342, /* 149 $pso */
  344, /* 150 $res38 */
  346, /* 151 $res39 */
  348, /* 152 $dc */
  350, /* 153 $dba0 */
  352, /* 154 $dba1 */
  354, /* 155 $dwa0 */
  356, /* 156 $dwa1 */
  358, /* 157 $mes */
  360, /* 158 $ws */
  362, /* 159 $res47 */
  364, /* 160 $res48 */
  366, /* 161 $res49 */
  368, /* 162 $res50 */
  370, /* 163 $res51 */
  372, /* 164 $res52 */
  374, /* 165 $res53 */
  376, /* 166 $res54 */
  378, /* 167 $res55 */
  380, /* 168 $res56 */
  382, /* 169 $res57 */
  384, /* 170 $res58 */
  386, /* 171 $res59 */
  388, /* 172 $res60 */
  390, /* 173 $res61 */
  392, /* 174 $res62 */
  394, /* 175 $res63 */
  396, /* 176 $spc_pl0 */
  398, /* 177 $spc_pl1 */
  400, /* 178 $spc_pl2 */
  402, /* 179 $spc_pl3 */
  404, /* 180 $sps_pl0 */
  406, /* 181 $sps_pl1 */
  408, /* 182 $sps_pl2 */
  410, /* 183 $sps_pl3 */
  412, /* 184 $ea_pl0 */
  414, /* 185 $ea_pl1 */
  416, /* 186 $ea_pl2 */
  418, /* 187 $ea_pl3 */
  420, /* 188 $ev_pl0 */
  422, /* 189 $ev_pl1 */
  424, /* 190 $ev_pl2 */
  426, /* 191 $ev_pl3 */
  428, /* 192 $sr_pl0 */
  430, /* 193 $sr_pl1 */
  432, /* 194 $sr_pl2 */
  434, /* 195 $sr_pl3 */
  436, /* 196 $es_pl0 */
  438, /* 197 $es_pl1 */
  440, /* 198 $es_pl2 */
  442, /* 199 $es_pl3 */
  444, /* 200 $res88 */
  446, /* 201 $res89 */
  448, /* 202 $res90 */
  450, /* 203 $res91 */
  452, /* 204 $res92 */
  454, /* 205 $res93 */
  456, /* 206 $res94 */
  458, /* 207 $res95 */
  460, /* 208 $syow */
  462, /* 209 $htow */
  464, /* 210 $itow */
  466, /* 211 $dow */
  468, /* 212 $mow */
  470, /* 213 $psow */
  472, /* 214 $res102 */
  474, /* 215 $res103 */
  476, /* 216 $res104 */
  478, /* 217 $res105 */
  480, /* 218 $res106 */
  482, /* 219 $res107 */
  484, /* 220 $res108 */
  486, /* 221 $res109 */
  488, /* 222 $res110 */
  490, /* 223 $res111 */
  492, /* 224 $res112 */
  494, /* 225 $res113 */
  496, /* 226 $res114 */
  498, /* 227 $res115 */
  500, /* 228 $res116 */
  502, /* 229 $res117 */
  504, /* 230 $res118 */
  506, /* 231 $res119 */
  508, /* 232 $res120 */
  510, /* 233 $res121 */
  512, /* 234 $res122 */
  514, /* 235 $res123 */
  516, /* 236 $res124 */
  518, /* 237 $res125 */
  520, /* 238 $res126 */
  522, /* 239 $res127 */
  524, /* 240 $spc */
  526, /* 241 $res129 */
  528, /* 242 $res130 */
  530, /* 243 $res131 */
  532, /* 244 $sps */
  534, /* 245 $res133 */
  536, /* 246 $res134 */
  538, /* 247 $res135 */
  540, /* 248 $ea */
  542, /* 249 $res137 */
  544, /* 250 $res138 */
  546, /* 251 $res139 */
  548, /* 252 $ev */
  550, /* 253 $res141 */
  552, /* 254 $res142 */
  554, /* 255 $res143 */
  556, /* 256 $sr */
  558, /* 257 $res145 */
  560, /* 258 $res146 */
  562, /* 259 $res147 */
  564, /* 260 $es */
  566, /* 261 $res149 */
  568, /* 262 $res150 */
  570, /* 263 $res151 */
  572, /* 264 $res152 */
  574, /* 265 $res153 */
  576, /* 266 $res154 */
  578, /* 267 $res155 */
  580, /* 268 $res156 */
  582, /* 269 $res157 */
  584, /* 270 $res158 */
  586, /* 271 $res159 */
  588, /* 272 $res160 */
  590, /* 273 $res161 */
  592, /* 274 $res162 */
  594, /* 275 $res163 */
  596, /* 276 $res164 */
  598, /* 277 $res165 */
  600, /* 278 $res166 */
  602, /* 279 $res167 */
  604, /* 280 $res168 */
  606, /* 281 $res169 */
  608, /* 282 $res170 */
  610, /* 283 $res171 */
  612, /* 284 $res172 */
  614, /* 285 $res173 */
  616, /* 286 $res174 */
  618, /* 287 $res175 */
  620, /* 288 $res176 */
  622, /* 289 $res177 */
  624, /* 290 $res178 */
  626, /* 291 $res179 */
  628, /* 292 $res180 */
  630, /* 293 $res181 */
  632, /* 294 $res182 */
  634, /* 295 $res183 */
  636, /* 296 $res184 */
  638, /* 297 $res185 */
  640, /* 298 $res186 */
  642, /* 299 $res187 */
  644, /* 300 $res188 */
  646, /* 301 $res189 */
  648, /* 302 $res190 */
  650, /* 303 $res191 */
  652, /* 304 $res192 */
  654, /* 305 $res193 */
  656, /* 306 $res194 */
  658, /* 307 $res195 */
  660, /* 308 $res196 */
  662, /* 309 $res197 */
  664, /* 310 $res198 */
  666, /* 311 $res199 */
  668, /* 312 $res200 */
  670, /* 313 $res201 */
  672, /* 314 $res202 */
  674, /* 315 $res203 */
  676, /* 316 $res204 */
  678, /* 317 $res205 */
  680, /* 318 $res206 */
  682, /* 319 $res207 */
  684, /* 320 $res208 */
  686, /* 321 $res209 */
  688, /* 322 $res210 */
  690, /* 323 $res211 */
  692, /* 324 $res212 */
  694, /* 325 $res213 */
  696, /* 326 $res214 */
  698, /* 327 $res215 */
  700, /* 328 $res216 */
  702, /* 329 $res217 */
  704, /* 330 $res218 */
  706, /* 331 $res219 */
  708, /* 332 $res220 */
  710, /* 333 $res221 */
  712, /* 334 $res222 */
  714, /* 335 $res223 */
  716, /* 336 $res224 */
  718, /* 337 $res225 */
  720, /* 338 $res226 */
  722, /* 339 $res227 */
  724, /* 340 $res228 */
  726, /* 341 $res229 */
  728, /* 342 $res230 */
  730, /* 343 $res231 */
  732, /* 344 $res232 */
  734, /* 345 $res233 */
  736, /* 346 $res234 */
  738, /* 347 $res235 */
  740, /* 348 $res236 */
  742, /* 349 $res237 */
  744, /* 350 $res238 */
  746, /* 351 $res239 */
  748, /* 352 $res240 */
  750, /* 353 $res241 */
  752, /* 354 $res242 */
  754, /* 355 $res243 */
  756, /* 356 $res244 */
  758, /* 357 $res245 */
  760, /* 358 $res246 */
  762, /* 359 $res247 */
  764, /* 360 $res248 */
  766, /* 361 $res249 */
  768, /* 362 $res250 */
  770, /* 363 $res251 */
  772, /* 364 $res252 */
  774, /* 365 $res253 */
  776, /* 366 $res254 */
  778, /* 367 $res255 */
  780, /* 368 $vsfr0 */
  782, /* 369 $vsfr1 */
  784, /* 370 $vsfr2 */
  786, /* 371 $vsfr3 */
  788, /* 372 $vsfr4 */
  790, /* 373 $vsfr5 */
  792, /* 374 $vsfr6 */
  794, /* 375 $vsfr7 */
  796, /* 376 $vsfr8 */
  798, /* 377 $vsfr9 */
  800, /* 378 $vsfr10 */
  802, /* 379 $vsfr11 */
  804, /* 380 $vsfr12 */
  806, /* 381 $vsfr13 */
  808, /* 382 $vsfr14 */
  810, /* 383 $vsfr15 */
  812, /* 384 $vsfr16 */
  814, /* 385 $vsfr17 */
  816, /* 386 $vsfr18 */
  818, /* 387 $vsfr19 */
  820, /* 388 $vsfr20 */
  822, /* 389 $vsfr21 */
  824, /* 390 $vsfr22 */
  826, /* 391 $vsfr23 */
  828, /* 392 $vsfr24 */
  830, /* 393 $vsfr25 */
  832, /* 394 $vsfr26 */
  834, /* 395 $vsfr27 */
  836, /* 396 $vsfr28 */
  838, /* 397 $vsfr29 */
  840, /* 398 $vsfr30 */
  842, /* 399 $vsfr31 */
  844, /* 400 $vsfr32 */
  846, /* 401 $vsfr33 */
  848, /* 402 $vsfr34 */
  850, /* 403 $vsfr35 */
  852, /* 404 $vsfr36 */
  854, /* 405 $vsfr37 */
  856, /* 406 $vsfr38 */
  858, /* 407 $vsfr39 */
  860, /* 408 $vsfr40 */
  862, /* 409 $vsfr41 */
  864, /* 410 $vsfr42 */
  866, /* 411 $vsfr43 */
  868, /* 412 $vsfr44 */
  870, /* 413 $vsfr45 */
  872, /* 414 $vsfr46 */
  874, /* 415 $vsfr47 */
  876, /* 416 $vsfr48 */
  878, /* 417 $vsfr49 */
  880, /* 418 $vsfr50 */
  882, /* 419 $vsfr51 */
  884, /* 420 $vsfr52 */
  886, /* 421 $vsfr53 */
  888, /* 422 $vsfr54 */
  890, /* 423 $vsfr55 */
  892, /* 424 $vsfr56 */
  894, /* 425 $vsfr57 */
  896, /* 426 $vsfr58 */
  898, /* 427 $vsfr59 */
  900, /* 428 $vsfr60 */
  902, /* 429 $vsfr61 */
  904, /* 430 $vsfr62 */
  906, /* 431 $vsfr63 */
  908, /* 432 $vsfr64 */
  910, /* 433 $vsfr65 */
  912, /* 434 $vsfr66 */
  914, /* 435 $vsfr67 */
  916, /* 436 $vsfr68 */
  918, /* 437 $vsfr69 */
  920, /* 438 $vsfr70 */
  922, /* 439 $vsfr71 */
  924, /* 440 $vsfr72 */
  926, /* 441 $vsfr73 */
  928, /* 442 $vsfr74 */
  930, /* 443 $vsfr75 */
  932, /* 444 $vsfr76 */
  934, /* 445 $vsfr77 */
  936, /* 446 $vsfr78 */
  938, /* 447 $vsfr79 */
  940, /* 448 $vsfr80 */
  942, /* 449 $vsfr81 */
  944, /* 450 $vsfr82 */
  946, /* 451 $vsfr83 */
  948, /* 452 $vsfr84 */
  950, /* 453 $vsfr85 */
  952, /* 454 $vsfr86 */
  954, /* 455 $vsfr87 */
  956, /* 456 $vsfr88 */
  958, /* 457 $vsfr89 */
  960, /* 458 $vsfr90 */
  962, /* 459 $vsfr91 */
  964, /* 460 $vsfr92 */
  966, /* 461 $vsfr93 */
  968, /* 462 $vsfr94 */
  970, /* 463 $vsfr95 */
  972, /* 464 $vsfr96 */
  974, /* 465 $vsfr97 */
  976, /* 466 $vsfr98 */
  978, /* 467 $vsfr99 */
  980, /* 468 $vsfr100 */
  982, /* 469 $vsfr101 */
  984, /* 470 $vsfr102 */
  986, /* 471 $vsfr103 */
  988, /* 472 $vsfr104 */
  990, /* 473 $vsfr105 */
  992, /* 474 $vsfr106 */
  994, /* 475 $vsfr107 */
  996, /* 476 $vsfr108 */
  998, /* 477 $vsfr109 */
  1000, /* 478 $vsfr110 */
  1002, /* 479 $vsfr111 */
  1004, /* 480 $vsfr112 */
  1006, /* 481 $vsfr113 */
  1008, /* 482 $vsfr114 */
  1010, /* 483 $vsfr115 */
  1012, /* 484 $vsfr116 */
  1014, /* 485 $vsfr117 */
  1016, /* 486 $vsfr118 */
  1018, /* 487 $vsfr119 */
  1020, /* 488 $vsfr120 */
  1022, /* 489 $vsfr121 */
  1024, /* 490 $vsfr122 */
  1026, /* 491 $vsfr123 */
  1028, /* 492 $vsfr124 */
  1030, /* 493 $vsfr125 */
  1032, /* 494 $vsfr126 */
  1034, /* 495 $vsfr127 */
  1036, /* 496 $vsfr128 */
  1038, /* 497 $vsfr129 */
  1040, /* 498 $vsfr130 */
  1042, /* 499 $vsfr131 */
  1044, /* 500 $vsfr132 */
  1046, /* 501 $vsfr133 */
  1048, /* 502 $vsfr134 */
  1050, /* 503 $vsfr135 */
  1052, /* 504 $vsfr136 */
  1054, /* 505 $vsfr137 */
  1056, /* 506 $vsfr138 */
  1058, /* 507 $vsfr139 */
  1060, /* 508 $vsfr140 */
  1062, /* 509 $vsfr141 */
  1064, /* 510 $vsfr142 */
  1066, /* 511 $vsfr143 */
  1068, /* 512 $vsfr144 */
  1070, /* 513 $vsfr145 */
  1072, /* 514 $vsfr146 */
  1074, /* 515 $vsfr147 */
  1076, /* 516 $vsfr148 */
  1078, /* 517 $vsfr149 */
  1080, /* 518 $vsfr150 */
  1082, /* 519 $vsfr151 */
  1084, /* 520 $vsfr152 */
  1086, /* 521 $vsfr153 */
  1088, /* 522 $vsfr154 */
  1090, /* 523 $vsfr155 */
  1092, /* 524 $vsfr156 */
  1094, /* 525 $vsfr157 */
  1096, /* 526 $vsfr158 */
  1098, /* 527 $vsfr159 */
  1100, /* 528 $vsfr160 */
  1102, /* 529 $vsfr161 */
  1104, /* 530 $vsfr162 */
  1106, /* 531 $vsfr163 */
  1108, /* 532 $vsfr164 */
  1110, /* 533 $vsfr165 */
  1112, /* 534 $vsfr166 */
  1114, /* 535 $vsfr167 */
  1116, /* 536 $vsfr168 */
  1118, /* 537 $vsfr169 */
  1120, /* 538 $vsfr170 */
  1122, /* 539 $vsfr171 */
  1124, /* 540 $vsfr172 */
  1126, /* 541 $vsfr173 */
  1128, /* 542 $vsfr174 */
  1130, /* 543 $vsfr175 */
  1132, /* 544 $vsfr176 */
  1134, /* 545 $vsfr177 */
  1136, /* 546 $vsfr178 */
  1138, /* 547 $vsfr179 */
  1140, /* 548 $vsfr180 */
  1142, /* 549 $vsfr181 */
  1144, /* 550 $vsfr182 */
  1146, /* 551 $vsfr183 */
  1148, /* 552 $vsfr184 */
  1150, /* 553 $vsfr185 */
  1152, /* 554 $vsfr186 */
  1154, /* 555 $vsfr187 */
  1156, /* 556 $vsfr188 */
  1158, /* 557 $vsfr189 */
  1160, /* 558 $vsfr190 */
  1162, /* 559 $vsfr191 */
  1164, /* 560 $vsfr192 */
  1166, /* 561 $vsfr193 */
  1168, /* 562 $vsfr194 */
  1170, /* 563 $vsfr195 */
  1172, /* 564 $vsfr196 */
  1174, /* 565 $vsfr197 */
  1176, /* 566 $vsfr198 */
  1178, /* 567 $vsfr199 */
  1180, /* 568 $vsfr200 */
  1182, /* 569 $vsfr201 */
  1184, /* 570 $vsfr202 */
  1186, /* 571 $vsfr203 */
  1188, /* 572 $vsfr204 */
  1190, /* 573 $vsfr205 */
  1192, /* 574 $vsfr206 */
  1194, /* 575 $vsfr207 */
  1196, /* 576 $vsfr208 */
  1198, /* 577 $vsfr209 */
  1200, /* 578 $vsfr210 */
  1202, /* 579 $vsfr211 */
  1204, /* 580 $vsfr212 */
  1206, /* 581 $vsfr213 */
  1208, /* 582 $vsfr214 */
  1210, /* 583 $vsfr215 */
  1212, /* 584 $vsfr216 */
  1214, /* 585 $vsfr217 */
  1216, /* 586 $vsfr218 */
  1218, /* 587 $vsfr219 */
  1220, /* 588 $vsfr220 */
  1222, /* 589 $vsfr221 */
  1224, /* 590 $vsfr222 */
  1226, /* 591 $vsfr223 */
  1228, /* 592 $vsfr224 */
  1230, /* 593 $vsfr225 */
  1232, /* 594 $vsfr226 */
  1234, /* 595 $vsfr227 */
  1236, /* 596 $vsfr228 */
  1238, /* 597 $vsfr229 */
  1240, /* 598 $vsfr230 */
  1242, /* 599 $vsfr231 */
  1244, /* 600 $vsfr232 */
  1246, /* 601 $vsfr233 */
  1248, /* 602 $vsfr234 */
  1250, /* 603 $vsfr235 */
  1252, /* 604 $vsfr236 */
  1254, /* 605 $vsfr237 */
  1256, /* 606 $vsfr238 */
  1258, /* 607 $vsfr239 */
  1260, /* 608 $vsfr240 */
  1262, /* 609 $vsfr241 */
  1264, /* 610 $vsfr242 */
  1266, /* 611 $vsfr243 */
  1268, /* 612 $vsfr244 */
  1270, /* 613 $vsfr245 */
  1272, /* 614 $vsfr246 */
  1274, /* 615 $vsfr247 */
  1276, /* 616 $vsfr248 */
  1278, /* 617 $vsfr249 */
  1280, /* 618 $vsfr250 */
  1282, /* 619 $vsfr251 */
  1284, /* 620 $vsfr252 */
  1286, /* 621 $vsfr253 */
  1288, /* 622 $vsfr254 */
  1290, /* 623 $vsfr255 */
  1292, /* 624 $a0..a15 */
  1293, /* 625 $a16..a31 */
  1294, /* 626 $a32..a47 */
  1295, /* 627 $a48..a63 */
  1296, /* 628 $a0..a1 */
  1297, /* 629 $a2..a3 */
  1298, /* 630 $a4..a5 */
  1299, /* 631 $a6..a7 */
  1300, /* 632 $a8..a9 */
  1301, /* 633 $a10..a11 */
  1302, /* 634 $a12..a13 */
  1303, /* 635 $a14..a15 */
  1304, /* 636 $a16..a17 */
  1305, /* 637 $a18..a19 */
  1306, /* 638 $a20..a21 */
  1307, /* 639 $a22..a23 */
  1308, /* 640 $a24..a25 */
  1309, /* 641 $a26..a27 */
  1310, /* 642 $a28..a29 */
  1311, /* 643 $a30..a31 */
  1312, /* 644 $a32..a33 */
  1313, /* 645 $a34..a35 */
  1314, /* 646 $a36..a37 */
  1315, /* 647 $a38..a39 */
  1316, /* 648 $a40..a41 */
  1317, /* 649 $a42..a43 */
  1318, /* 650 $a44..a45 */
  1319, /* 651 $a46..a47 */
  1320, /* 652 $a48..a49 */
  1321, /* 653 $a50..a51 */
  1322, /* 654 $a52..a53 */
  1323, /* 655 $a54..a55 */
  1324, /* 656 $a56..a57 */
  1325, /* 657 $a58..a59 */
  1326, /* 658 $a60..a61 */
  1327, /* 659 $a62..a63 */
  1328, /* 660 $a0..a31 */
  1329, /* 661 $a32..a63 */
  1330, /* 662 $a0..a3 */
  1331, /* 663 $a4..a7 */
  1332, /* 664 $a8..a11 */
  1333, /* 665 $a12..a15 */
  1334, /* 666 $a16..a19 */
  1335, /* 667 $a20..a23 */
  1336, /* 668 $a24..a27 */
  1337, /* 669 $a28..a31 */
  1338, /* 670 $a32..a35 */
  1339, /* 671 $a36..a39 */
  1340, /* 672 $a40..a43 */
  1341, /* 673 $a44..a47 */
  1342, /* 674 $a48..a51 */
  1343, /* 675 $a52..a55 */
  1344, /* 676 $a56..a59 */
  1345, /* 677 $a60..a63 */
  1346, /* 678 $a0..a63 */
  1347, /* 679 $a0..a7 */
  1348, /* 680 $a8..a15 */
  1349, /* 681 $a16..a23 */
  1350, /* 682 $a24..a31 */
  1351, /* 683 $a32..a39 */
  1352, /* 684 $a40..a47 */
  1353, /* 685 $a48..a55 */
  1354, /* 686 $a56..a63 */
  1355, /* 687 $a0_lo */
  1357, /* 688 $a0_hi */
  1359, /* 689 $a1_lo */
  1361, /* 690 $a1_hi */
  1363, /* 691 $a2_lo */
  1365, /* 692 $a2_hi */
  1367, /* 693 $a3_lo */
  1369, /* 694 $a3_hi */
  1371, /* 695 $a4_lo */
  1373, /* 696 $a4_hi */
  1375, /* 697 $a5_lo */
  1377, /* 698 $a5_hi */
  1379, /* 699 $a6_lo */
  1381, /* 700 $a6_hi */
  1383, /* 701 $a7_lo */
  1385, /* 702 $a7_hi */
  1387, /* 703 $a8_lo */
  1389, /* 704 $a8_hi */
  1391, /* 705 $a9_lo */
  1393, /* 706 $a9_hi */
  1395, /* 707 $a10_lo */
  1397, /* 708 $a10_hi */
  1399, /* 709 $a11_lo */
  1401, /* 710 $a11_hi */
  1403, /* 711 $a12_lo */
  1405, /* 712 $a12_hi */
  1407, /* 713 $a13_lo */
  1409, /* 714 $a13_hi */
  1411, /* 715 $a14_lo */
  1413, /* 716 $a14_hi */
  1415, /* 717 $a15_lo */
  1417, /* 718 $a15_hi */
  1419, /* 719 $a16_lo */
  1421, /* 720 $a16_hi */
  1423, /* 721 $a17_lo */
  1425, /* 722 $a17_hi */
  1427, /* 723 $a18_lo */
  1429, /* 724 $a18_hi */
  1431, /* 725 $a19_lo */
  1433, /* 726 $a19_hi */
  1435, /* 727 $a20_lo */
  1437, /* 728 $a20_hi */
  1439, /* 729 $a21_lo */
  1441, /* 730 $a21_hi */
  1443, /* 731 $a22_lo */
  1445, /* 732 $a22_hi */
  1447, /* 733 $a23_lo */
  1449, /* 734 $a23_hi */
  1451, /* 735 $a24_lo */
  1453, /* 736 $a24_hi */
  1455, /* 737 $a25_lo */
  1457, /* 738 $a25_hi */
  1459, /* 739 $a26_lo */
  1461, /* 740 $a26_hi */
  1463, /* 741 $a27_lo */
  1465, /* 742 $a27_hi */
  1467, /* 743 $a28_lo */
  1469, /* 744 $a28_hi */
  1471, /* 745 $a29_lo */
  1473, /* 746 $a29_hi */
  1475, /* 747 $a30_lo */
  1477, /* 748 $a30_hi */
  1479, /* 749 $a31_lo */
  1481, /* 750 $a31_hi */
  1483, /* 751 $a32_lo */
  1485, /* 752 $a32_hi */
  1487, /* 753 $a33_lo */
  1489, /* 754 $a33_hi */
  1491, /* 755 $a34_lo */
  1493, /* 756 $a34_hi */
  1495, /* 757 $a35_lo */
  1497, /* 758 $a35_hi */
  1499, /* 759 $a36_lo */
  1501, /* 760 $a36_hi */
  1503, /* 761 $a37_lo */
  1505, /* 762 $a37_hi */
  1507, /* 763 $a38_lo */
  1509, /* 764 $a38_hi */
  1511, /* 765 $a39_lo */
  1513, /* 766 $a39_hi */
  1515, /* 767 $a40_lo */
  1517, /* 768 $a40_hi */
  1519, /* 769 $a41_lo */
  1521, /* 770 $a41_hi */
  1523, /* 771 $a42_lo */
  1525, /* 772 $a42_hi */
  1527, /* 773 $a43_lo */
  1529, /* 774 $a43_hi */
  1531, /* 775 $a44_lo */
  1533, /* 776 $a44_hi */
  1535, /* 777 $a45_lo */
  1537, /* 778 $a45_hi */
  1539, /* 779 $a46_lo */
  1541, /* 780 $a46_hi */
  1543, /* 781 $a47_lo */
  1545, /* 782 $a47_hi */
  1547, /* 783 $a48_lo */
  1549, /* 784 $a48_hi */
  1551, /* 785 $a49_lo */
  1553, /* 786 $a49_hi */
  1555, /* 787 $a50_lo */
  1557, /* 788 $a50_hi */
  1559, /* 789 $a51_lo */
  1561, /* 790 $a51_hi */
  1563, /* 791 $a52_lo */
  1565, /* 792 $a52_hi */
  1567, /* 793 $a53_lo */
  1569, /* 794 $a53_hi */
  1571, /* 795 $a54_lo */
  1573, /* 796 $a54_hi */
  1575, /* 797 $a55_lo */
  1577, /* 798 $a55_hi */
  1579, /* 799 $a56_lo */
  1581, /* 800 $a56_hi */
  1583, /* 801 $a57_lo */
  1585, /* 802 $a57_hi */
  1587, /* 803 $a58_lo */
  1589, /* 804 $a58_hi */
  1591, /* 805 $a59_lo */
  1593, /* 806 $a59_hi */
  1595, /* 807 $a60_lo */
  1597, /* 808 $a60_hi */
  1599, /* 809 $a61_lo */
  1601, /* 810 $a61_hi */
  1603, /* 811 $a62_lo */
  1605, /* 812 $a62_hi */
  1607, /* 813 $a63_lo */
  1609, /* 814 $a63_hi */
  1611, /* 815 $a0_x */
  1613, /* 816 $a0_y */
  1615, /* 817 $a0_z */
  1617, /* 818 $a0_t */
  1619, /* 819 $a1_x */
  1621, /* 820 $a1_y */
  1623, /* 821 $a1_z */
  1625, /* 822 $a1_t */
  1627, /* 823 $a2_x */
  1629, /* 824 $a2_y */
  1631, /* 825 $a2_z */
  1633, /* 826 $a2_t */
  1635, /* 827 $a3_x */
  1637, /* 828 $a3_y */
  1639, /* 829 $a3_z */
  1641, /* 830 $a3_t */
  1643, /* 831 $a4_x */
  1645, /* 832 $a4_y */
  1647, /* 833 $a4_z */
  1649, /* 834 $a4_t */
  1651, /* 835 $a5_x */
  1653, /* 836 $a5_y */
  1655, /* 837 $a5_z */
  1657, /* 838 $a5_t */
  1659, /* 839 $a6_x */
  1661, /* 840 $a6_y */
  1663, /* 841 $a6_z */
  1665, /* 842 $a6_t */
  1667, /* 843 $a7_x */
  1669, /* 844 $a7_y */
  1671, /* 845 $a7_z */
  1673, /* 846 $a7_t */
  1675, /* 847 $a8_x */
  1677, /* 848 $a8_y */
  1679, /* 849 $a8_z */
  1681, /* 850 $a8_t */
  1683, /* 851 $a9_x */
  1685, /* 852 $a9_y */
  1687, /* 853 $a9_z */
  1689, /* 854 $a9_t */
  1691, /* 855 $a10_x */
  1693, /* 856 $a10_y */
  1695, /* 857 $a10_z */
  1697, /* 858 $a10_t */
  1699, /* 859 $a11_x */
  1701, /* 860 $a11_y */
  1703, /* 861 $a11_z */
  1705, /* 862 $a11_t */
  1707, /* 863 $a12_x */
  1709, /* 864 $a12_y */
  1711, /* 865 $a12_z */
  1713, /* 866 $a12_t */
  1715, /* 867 $a13_x */
  1717, /* 868 $a13_y */
  1719, /* 869 $a13_z */
  1721, /* 870 $a13_t */
  1723, /* 871 $a14_x */
  1725, /* 872 $a14_y */
  1727, /* 873 $a14_z */
  1729, /* 874 $a14_t */
  1731, /* 875 $a15_x */
  1733, /* 876 $a15_y */
  1735, /* 877 $a15_z */
  1737, /* 878 $a15_t */
  1739, /* 879 $a16_x */
  1741, /* 880 $a16_y */
  1743, /* 881 $a16_z */
  1745, /* 882 $a16_t */
  1747, /* 883 $a17_x */
  1749, /* 884 $a17_y */
  1751, /* 885 $a17_z */
  1753, /* 886 $a17_t */
  1755, /* 887 $a18_x */
  1757, /* 888 $a18_y */
  1759, /* 889 $a18_z */
  1761, /* 890 $a18_t */
  1763, /* 891 $a19_x */
  1765, /* 892 $a19_y */
  1767, /* 893 $a19_z */
  1769, /* 894 $a19_t */
  1771, /* 895 $a20_x */
  1773, /* 896 $a20_y */
  1775, /* 897 $a20_z */
  1777, /* 898 $a20_t */
  1779, /* 899 $a21_x */
  1781, /* 900 $a21_y */
  1783, /* 901 $a21_z */
  1785, /* 902 $a21_t */
  1787, /* 903 $a22_x */
  1789, /* 904 $a22_y */
  1791, /* 905 $a22_z */
  1793, /* 906 $a22_t */
  1795, /* 907 $a23_x */
  1797, /* 908 $a23_y */
  1799, /* 909 $a23_z */
  1801, /* 910 $a23_t */
  1803, /* 911 $a24_x */
  1805, /* 912 $a24_y */
  1807, /* 913 $a24_z */
  1809, /* 914 $a24_t */
  1811, /* 915 $a25_x */
  1813, /* 916 $a25_y */
  1815, /* 917 $a25_z */
  1817, /* 918 $a25_t */
  1819, /* 919 $a26_x */
  1821, /* 920 $a26_y */
  1823, /* 921 $a26_z */
  1825, /* 922 $a26_t */
  1827, /* 923 $a27_x */
  1829, /* 924 $a27_y */
  1831, /* 925 $a27_z */
  1833, /* 926 $a27_t */
  1835, /* 927 $a28_x */
  1837, /* 928 $a28_y */
  1839, /* 929 $a28_z */
  1841, /* 930 $a28_t */
  1843, /* 931 $a29_x */
  1845, /* 932 $a29_y */
  1847, /* 933 $a29_z */
  1849, /* 934 $a29_t */
  1851, /* 935 $a30_x */
  1853, /* 936 $a30_y */
  1855, /* 937 $a30_z */
  1857, /* 938 $a30_t */
  1859, /* 939 $a31_x */
  1861, /* 940 $a31_y */
  1863, /* 941 $a31_z */
  1865, /* 942 $a31_t */
  1867, /* 943 $a32_x */
  1869, /* 944 $a32_y */
  1871, /* 945 $a32_z */
  1873, /* 946 $a32_t */
  1875, /* 947 $a33_x */
  1877, /* 948 $a33_y */
  1879, /* 949 $a33_z */
  1881, /* 950 $a33_t */
  1883, /* 951 $a34_x */
  1885, /* 952 $a34_y */
  1887, /* 953 $a34_z */
  1889, /* 954 $a34_t */
  1891, /* 955 $a35_x */
  1893, /* 956 $a35_y */
  1895, /* 957 $a35_z */
  1897, /* 958 $a35_t */
  1899, /* 959 $a36_x */
  1901, /* 960 $a36_y */
  1903, /* 961 $a36_z */
  1905, /* 962 $a36_t */
  1907, /* 963 $a37_x */
  1909, /* 964 $a37_y */
  1911, /* 965 $a37_z */
  1913, /* 966 $a37_t */
  1915, /* 967 $a38_x */
  1917, /* 968 $a38_y */
  1919, /* 969 $a38_z */
  1921, /* 970 $a38_t */
  1923, /* 971 $a39_x */
  1925, /* 972 $a39_y */
  1927, /* 973 $a39_z */
  1929, /* 974 $a39_t */
  1931, /* 975 $a40_x */
  1933, /* 976 $a40_y */
  1935, /* 977 $a40_z */
  1937, /* 978 $a40_t */
  1939, /* 979 $a41_x */
  1941, /* 980 $a41_y */
  1943, /* 981 $a41_z */
  1945, /* 982 $a41_t */
  1947, /* 983 $a42_x */
  1949, /* 984 $a42_y */
  1951, /* 985 $a42_z */
  1953, /* 986 $a42_t */
  1955, /* 987 $a43_x */
  1957, /* 988 $a43_y */
  1959, /* 989 $a43_z */
  1961, /* 990 $a43_t */
  1963, /* 991 $a44_x */
  1965, /* 992 $a44_y */
  1967, /* 993 $a44_z */
  1969, /* 994 $a44_t */
  1971, /* 995 $a45_x */
  1973, /* 996 $a45_y */
  1975, /* 997 $a45_z */
  1977, /* 998 $a45_t */
  1979, /* 999 $a46_x */
  1981, /* 1000 $a46_y */
  1983, /* 1001 $a46_z */
  1985, /* 1002 $a46_t */
  1987, /* 1003 $a47_x */
  1989, /* 1004 $a47_y */
  1991, /* 1005 $a47_z */
  1993, /* 1006 $a47_t */
  1995, /* 1007 $a48_x */
  1997, /* 1008 $a48_y */
  1999, /* 1009 $a48_z */
  2001, /* 1010 $a48_t */
  2003, /* 1011 $a49_x */
  2005, /* 1012 $a49_y */
  2007, /* 1013 $a49_z */
  2009, /* 1014 $a49_t */
  2011, /* 1015 $a50_x */
  2013, /* 1016 $a50_y */
  2015, /* 1017 $a50_z */
  2017, /* 1018 $a50_t */
  2019, /* 1019 $a51_x */
  2021, /* 1020 $a51_y */
  2023, /* 1021 $a51_z */
  2025, /* 1022 $a51_t */
  2027, /* 1023 $a52_x */
  2029, /* 1024 $a52_y */
  2031, /* 1025 $a52_z */
  2033, /* 1026 $a52_t */
  2035, /* 1027 $a53_x */
  2037, /* 1028 $a53_y */
  2039, /* 1029 $a53_z */
  2041, /* 1030 $a53_t */
  2043, /* 1031 $a54_x */
  2045, /* 1032 $a54_y */
  2047, /* 1033 $a54_z */
  2049, /* 1034 $a54_t */
  2051, /* 1035 $a55_x */
  2053, /* 1036 $a55_y */
  2055, /* 1037 $a55_z */
  2057, /* 1038 $a55_t */
  2059, /* 1039 $a56_x */
  2061, /* 1040 $a56_y */
  2063, /* 1041 $a56_z */
  2065, /* 1042 $a56_t */
  2067, /* 1043 $a57_x */
  2069, /* 1044 $a57_y */
  2071, /* 1045 $a57_z */
  2073, /* 1046 $a57_t */
  2075, /* 1047 $a58_x */
  2077, /* 1048 $a58_y */
  2079, /* 1049 $a58_z */
  2081, /* 1050 $a58_t */
  2083, /* 1051 $a59_x */
  2085, /* 1052 $a59_y */
  2087, /* 1053 $a59_z */
  2089, /* 1054 $a59_t */
  2091, /* 1055 $a60_x */
  2093, /* 1056 $a60_y */
  2095, /* 1057 $a60_z */
  2097, /* 1058 $a60_t */
  2099, /* 1059 $a61_x */
  2101, /* 1060 $a61_y */
  2103, /* 1061 $a61_z */
  2105, /* 1062 $a61_t */
  2107, /* 1063 $a62_x */
  2109, /* 1064 $a62_y */
  2111, /* 1065 $a62_z */
  2113, /* 1066 $a62_t */
  2115, /* 1067 $a63_x */
  2117, /* 1068 $a63_y */
  2119, /* 1069 $a63_z */
  2121, /* 1070 $a63_t */
  2123, /* 1071 $a0a1a2a3 */
  2124, /* 1072 $a4a5a6a7 */
  2125, /* 1073 $a8a9a10a11 */
  2126, /* 1074 $a12a13a14a15 */
  2127, /* 1075 $a16a17a18a19 */
  2128, /* 1076 $a20a21a22a23 */
  2129, /* 1077 $a24a25a26a27 */
  2130, /* 1078 $a28a29a30a31 */
  2131, /* 1079 $a32a33a34a35 */
  2132, /* 1080 $a36a37a38a39 */
  2133, /* 1081 $a40a41a42a43 */
  2134, /* 1082 $a44a45a46a47 */
  2135, /* 1083 $a48a49a50a51 */
  2136, /* 1084 $a52a53a54a55 */
  2137, /* 1085 $a56a57a58a59 */
  2138, /* 1086 $a60a61a62a63 */
  2139, /* 1087 $a0a1 */
  2141, /* 1088 $a2a3 */
  2143, /* 1089 $a4a5 */
  2145, /* 1090 $a6a7 */
  2147, /* 1091 $a8a9 */
  2149, /* 1092 $a10a11 */
  2151, /* 1093 $a12a13 */
  2153, /* 1094 $a14a15 */
  2155, /* 1095 $a16a17 */
  2157, /* 1096 $a18a19 */
  2159, /* 1097 $a20a21 */
  2161, /* 1098 $a22a23 */
  2163, /* 1099 $a24a25 */
  2165, /* 1100 $a26a27 */
  2167, /* 1101 $a28a29 */
  2169, /* 1102 $a30a31 */
  2171, /* 1103 $a32a33 */
  2173, /* 1104 $a34a35 */
  2175, /* 1105 $a36a37 */
  2177, /* 1106 $a38a39 */
  2179, /* 1107 $a40a41 */
  2181, /* 1108 $a42a43 */
  2183, /* 1109 $a44a45 */
  2185, /* 1110 $a46a47 */
  2187, /* 1111 $a48a49 */
  2189, /* 1112 $a50a51 */
  2191, /* 1113 $a52a53 */
  2193, /* 1114 $a54a55 */
  2195, /* 1115 $a56a57 */
  2197, /* 1116 $a58a59 */
  2199, /* 1117 $a60a61 */
  2201, /* 1118 $a62a63 */
  2203, /* 1119 $a0 */
  2206, /* 1120 $a1 */
  2209, /* 1121 $a2 */
  2212, /* 1122 $a3 */
  2215, /* 1123 $a4 */
  2218, /* 1124 $a5 */
  2221, /* 1125 $a6 */
  2224, /* 1126 $a7 */
  2227, /* 1127 $a8 */
  2230, /* 1128 $a9 */
  2233, /* 1129 $a10 */
  2236, /* 1130 $a11 */
  2239, /* 1131 $a12 */
  2242, /* 1132 $a13 */
  2245, /* 1133 $a14 */
  2248, /* 1134 $a15 */
  2251, /* 1135 $a16 */
  2254, /* 1136 $a17 */
  2257, /* 1137 $a18 */
  2260, /* 1138 $a19 */
  2263, /* 1139 $a20 */
  2266, /* 1140 $a21 */
  2269, /* 1141 $a22 */
  2272, /* 1142 $a23 */
  2275, /* 1143 $a24 */
  2278, /* 1144 $a25 */
  2281, /* 1145 $a26 */
  2284, /* 1146 $a27 */
  2287, /* 1147 $a28 */
  2290, /* 1148 $a29 */
  2293, /* 1149 $a30 */
  2296, /* 1150 $a31 */
  2299, /* 1151 $a32 */
  2302, /* 1152 $a33 */
  2305, /* 1153 $a34 */
  2308, /* 1154 $a35 */
  2311, /* 1155 $a36 */
  2314, /* 1156 $a37 */
  2317, /* 1157 $a38 */
  2320, /* 1158 $a39 */
  2323, /* 1159 $a40 */
  2326, /* 1160 $a41 */
  2329, /* 1161 $a42 */
  2332, /* 1162 $a43 */
  2335, /* 1163 $a44 */
  2338, /* 1164 $a45 */
  2341, /* 1165 $a46 */
  2344, /* 1166 $a47 */
  2347, /* 1167 $a48 */
  2350, /* 1168 $a49 */
  2353, /* 1169 $a50 */
  2356, /* 1170 $a51 */
  2359, /* 1171 $a52 */
  2362, /* 1172 $a53 */
  2365, /* 1173 $a54 */
  2368, /* 1174 $a55 */
  2371, /* 1175 $a56 */
  2374, /* 1176 $a57 */
  2377, /* 1177 $a58 */
  2380, /* 1178 $a59 */
  2383, /* 1179 $a60 */
  2386, /* 1180 $a61 */
  2389, /* 1181 $a62 */
  2392, /* 1182 $a63 */
};

const char *mod_kv3_v1_exunum[] = {
  "alu0",
  "alu1",
  "mau",
  "lsu",
  NULL,
};

const char *mod_kv3_v1_scalarcond[] = {
  ".dnez",
  ".deqz",
  ".dltz",
  ".dgez",
  ".dlez",
  ".dgtz",
  ".odd",
  ".even",
  ".wnez",
  ".weqz",
  ".wltz",
  ".wgez",
  ".wlez",
  ".wgtz",
  NULL,
};

const char *mod_kv3_v1_simplecond[] = {
  ".nez",
  ".eqz",
  ".ltz",
  ".gez",
  ".lez",
  ".gtz",
  ".odd",
  ".even",
  NULL,
};

const char *mod_kv3_v1_comparison[] = {
  ".ne",
  ".eq",
  ".lt",
  ".ge",
  ".le",
  ".gt",
  ".ltu",
  ".geu",
  ".leu",
  ".gtu",
  ".all",
  ".nall",
  ".any",
  ".none",
  NULL,
};

const char *mod_kv3_v1_floatcomp[] = {
  ".one",
  ".ueq",
  ".oeq",
  ".une",
  ".olt",
  ".uge",
  ".oge",
  ".ult",
  NULL,
};

const char *mod_kv3_v1_rounding[] = {
  ".rn",
  ".ru",
  ".rd",
  ".rz",
  ".rna",
  ".rnz",
  ".ro",
  ".",
  NULL,
};

const char *mod_kv3_v1_silent[] = {
  ".",
  ".s",
  NULL,
};

const char *mod_kv3_v1_roundint[] = {
  ".rn",
  ".ru",
  ".rd",
  ".rz",
  ".rhu",
  NULL,
};

const char *mod_kv3_v1_saturate[] = {
  ".sat",
  ".satu",
  NULL,
};

const char *mod_kv3_v1_rectify[] = {
  ".",
  ".relu",
  NULL,
};

const char *mod_kv3_v1_variant[] = {
  ".",
  ".s",
  ".u",
  ".us",
  NULL,
};

const char *mod_kv3_v1_speculate[] = {
  ".u",
  ".us",
  NULL,
};

const char *mod_kv3_v1_column[] = {
  ".c0",
  ".c1",
  ".c2",
  ".c3",
  NULL,
};

const char *mod_kv3_v1_doscale[] = {
  ".",
  ".xs",
  NULL,
};

const char *mod_kv3_v1_qindex[] = {
  ".q0",
  ".q1",
  ".q2",
  ".q3",
  NULL,
};

const char *mod_kv3_v1_splat32[] = {
  ".",
  ".@",
  NULL,
};

const char **kvx_kv3_v1_modifiers[] = {
  mod_kv3_v1_column,
  mod_kv3_v1_comparison,
  mod_kv3_v1_doscale,
  mod_kv3_v1_exunum,
  mod_kv3_v1_floatcomp,
  mod_kv3_v1_qindex,
  mod_kv3_v1_rectify,
  mod_kv3_v1_rounding,
  mod_kv3_v1_roundint,
  mod_kv3_v1_saturate,
  mod_kv3_v1_scalarcond,
  mod_kv3_v1_silent,
  mod_kv3_v1_simplecond,
  mod_kv3_v1_speculate,
  mod_kv3_v1_splat32,
  mod_kv3_v1_variant
};

struct pseudo_func kvx_kv3_v1_pseudo_func[] = {
  // reloc pseudo functions:
  {
    .name = "signed32",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 32,
      .reloc_type = S32_LO5_UP27,
      .reloc_lo5 = BFD_RELOC_KVX_S32_LO5,
      .reloc_up27 = BFD_RELOC_KVX_S32_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_signed32_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_GOTOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_GOTOFF_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotoff_signed37_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 32,
      .reloc_type = S32,
      .single = BFD_RELOC_KVX_32_GOTOFF,
      .kreloc = & kv3_v1_gotoff_32_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_GOT_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_GOT_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_got_signed37_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 32,
      .reloc_type = S32,
      .single = BFD_RELOC_KVX_32_GOT,
      .kreloc = & kv3_v1_got_32_reloc,
    }
  },
  {
    .name = "tlsgd",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_GD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_GD_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsgd_signed37_reloc,
    }
  },
  {
    .name = "tlsgd",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_GD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_GD_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_GD_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsgd_signed43_reloc,
    }
  },
  {
    .name = "tlsle",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_LE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_LE_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsle_signed37_reloc,
    }
  },
  {
    .name = "tlsle",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_LE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_LE_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_LE_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsle_signed43_reloc,
    }
  },
  {
    .name = "tlsld",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_LD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_LD_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsld_signed37_reloc,
    }
  },
  {
    .name = "tlsld",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_LD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_LD_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_LD_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsld_signed43_reloc,
    }
  },
  {
    .name = "dtpoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_DTPOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_DTPOFF_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_dtpoff_signed37_reloc,
    }
  },
  {
    .name = "dtpoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_DTPOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_DTPOFF_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_DTPOFF_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_dtpoff_signed43_reloc,
    }
  },
  {
    .name = "tlsie",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_IE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_IE_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsie_signed37_reloc,
    }
  },
  {
    .name = "tlsie",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_IE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_IE_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_IE_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsie_signed43_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_GOTOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_GOTOFF_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_GOTOFF_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotoff_signed43_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .reloc_type = S64,
      .single = BFD_RELOC_KVX_64_GOTOFF,
      .kreloc = & kv3_v1_gotoff_64_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_GOT_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_GOT_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_GOT_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_got_signed43_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .reloc_type = S64,
      .single = BFD_RELOC_KVX_64_GOT,
      .kreloc = & kv3_v1_got_64_reloc,
    }
  },
  {
    .name = "gotaddr",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 37,
      .has_no_arg = 1,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_GOTADDR_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_GOTADDR_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotaddr_signed37_reloc,
    }
  },
  {
    .name = "gotaddr",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 43,
      .has_no_arg = 1,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_GOTADDR_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_GOTADDR_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_GOTADDR_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotaddr_signed43_reloc,
    }
  },
  {
    .name = "gotaddr",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .has_no_arg = 1,
      .reloc_type = S64_LO10_UP27_EX27,
      .reloc_lo10 = BFD_RELOC_KVX_S64_GOTADDR_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S64_GOTADDR_UP27,
      .reloc_ex = BFD_RELOC_KVX_S64_GOTADDR_EX27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotaddr_signed64_reloc,
    }
  },
  // pcrel()
  {
    // use pcrel16 to force the use of 16bits. This would normally not
    // be selected as symbol would not fit.
    .name = "pcrel16",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 16,
      .single = BFD_RELOC_KVX_S16_PCREL,
      .reloc_type = S16,
      .kreloc = & kv3_v1_pcrel_signed16_reloc,
    }
  },
  {
    .name = "pcrel",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_PCREL_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_PCREL_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_pcrel_signed37_reloc,
    }
  },
  {
    .name = "pcrel",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_PCREL_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_PCREL_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_PCREL_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_pcrel_signed43_reloc,
    }
  },
  {
    .name = "pcrel",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .reloc_type = S64_LO10_UP27_EX27,
      .reloc_lo10 = BFD_RELOC_KVX_S64_PCREL_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S64_PCREL_UP27,
      .reloc_ex = BFD_RELOC_KVX_S64_PCREL_EX27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_pcrel_signed64_reloc,
    }
  },
};

struct kvx_reloc kv3_v1_rel16_reloc __attribute__((unused)) = {
  .bitsize = 16,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_16 }
};
struct kvx_reloc kv3_v1_rel32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_32 }
};
struct kvx_reloc kv3_v1_rel64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_64 }
};
struct kvx_reloc kv3_v1_pcrel_signed16_reloc __attribute__((unused)) = {
  .bitsize = 16,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_S16_PCREL }
};
struct kvx_reloc kv3_v1_pcrel17_reloc __attribute__((unused)) = {
  .bitsize = 17,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_PCREL17 }
};
struct kvx_reloc kv3_v1_pcrel27_reloc __attribute__((unused)) = {
  .bitsize = 27,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_PCREL27 }
};
struct kvx_reloc kv3_v1_pcrel32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_32_PCREL }
};
struct kvx_reloc kv3_v1_pcrel_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_PC,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_PCREL_UP27, R_KVX_S37_PCREL_LO10 }
};
struct kvx_reloc kv3_v1_pcrel_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_PCREL_EX6, R_KVX_S43_PCREL_UP27, R_KVX_S43_PCREL_LO10 }
};
struct kvx_reloc kv3_v1_pcrel_signed64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S64_PCREL_EX27, R_KVX_S64_PCREL_UP27, R_KVX_S64_PCREL_LO10 }
};
struct kvx_reloc kv3_v1_pcrel64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_PCREL }
};
struct kvx_reloc kv3_v1_signed16_reloc __attribute__((unused)) = {
  .bitsize = 16,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_S16 }
};
struct kvx_reloc kv3_v1_signed32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 2,
  .relocs = { R_KVX_S32_UP27, R_KVX_S32_LO5 }
};
struct kvx_reloc kv3_v1_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_ABS,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_UP27, R_KVX_S37_LO10 }
};
struct kvx_reloc kv3_v1_gotoff_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_GOTOFF_UP27, R_KVX_S37_GOTOFF_LO10 }
};
struct kvx_reloc kv3_v1_gotoff_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_GOTOFF_EX6, R_KVX_S43_GOTOFF_UP27, R_KVX_S43_GOTOFF_LO10 }
};
struct kvx_reloc kv3_v1_gotoff_32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_32_GOTOFF }
};
struct kvx_reloc kv3_v1_gotoff_64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_GOTOFF }
};
struct kvx_reloc kv3_v1_got_32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_32_GOT }
};
struct kvx_reloc kv3_v1_got_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_GOT_UP27, R_KVX_S37_GOT_LO10 }
};
struct kvx_reloc kv3_v1_got_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_GOT_EX6, R_KVX_S43_GOT_UP27, R_KVX_S43_GOT_LO10 }
};
struct kvx_reloc kv3_v1_got_64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_GOT }
};
struct kvx_reloc kv3_v1_glob_dat_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_GLOB_DAT }
};
struct kvx_reloc kv3_v1_copy_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_COPY }
};
struct kvx_reloc kv3_v1_jump_slot_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_JMP_SLOT }
};
struct kvx_reloc kv3_v1_relative_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_BASE,
  .reloc_nb = 1,
  .relocs = { R_KVX_RELATIVE }
};
struct kvx_reloc kv3_v1_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_ABS,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_EX6, R_KVX_S43_UP27, R_KVX_S43_LO10 }
};
struct kvx_reloc kv3_v1_signed64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 3,
  .relocs = { R_KVX_S64_EX27, R_KVX_S64_UP27, R_KVX_S64_LO10 }
};
struct kvx_reloc kv3_v1_gotaddr_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_PC,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_GOTADDR_UP27, R_KVX_S37_GOTADDR_LO10 }
};
struct kvx_reloc kv3_v1_gotaddr_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_GOTADDR_EX6, R_KVX_S43_GOTADDR_UP27, R_KVX_S43_GOTADDR_LO10 }
};
struct kvx_reloc kv3_v1_gotaddr_signed64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S64_GOTADDR_EX27, R_KVX_S64_GOTADDR_UP27, R_KVX_S64_GOTADDR_LO10 }
};
struct kvx_reloc kv3_v1_dtpmod64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_DTPMOD }
};
struct kvx_reloc kv3_v1_dtpoff64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_DTPOFF }
};
struct kvx_reloc kv3_v1_dtpoff_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_ABS,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_DTPOFF_UP27, R_KVX_S37_TLS_DTPOFF_LO10 }
};
struct kvx_reloc kv3_v1_dtpoff_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_ABS,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_DTPOFF_EX6, R_KVX_S43_TLS_DTPOFF_UP27, R_KVX_S43_TLS_DTPOFF_LO10 }
};
struct kvx_reloc kv3_v1_tlsgd_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_GD_UP27, R_KVX_S37_TLS_GD_LO10 }
};
struct kvx_reloc kv3_v1_tlsgd_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_GD_EX6, R_KVX_S43_TLS_GD_UP27, R_KVX_S43_TLS_GD_LO10 }
};
struct kvx_reloc kv3_v1_tlsld_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_LD_UP27, R_KVX_S37_TLS_LD_LO10 }
};
struct kvx_reloc kv3_v1_tlsld_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_LD_EX6, R_KVX_S43_TLS_LD_UP27, R_KVX_S43_TLS_LD_LO10 }
};
struct kvx_reloc kv3_v1_tpoff64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_TP,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_TPOFF }
};
struct kvx_reloc kv3_v1_tlsie_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_IE_UP27, R_KVX_S37_TLS_IE_LO10 }
};
struct kvx_reloc kv3_v1_tlsie_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_IE_EX6, R_KVX_S43_TLS_IE_UP27, R_KVX_S43_TLS_IE_LO10 }
};
struct kvx_reloc kv3_v1_tlsle_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_TP,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_LE_UP27, R_KVX_S37_TLS_LE_LO10 }
};
struct kvx_reloc kv3_v1_tlsle_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_TP,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_LE_EX6, R_KVX_S43_TLS_LE_UP27, R_KVX_S43_TLS_LE_LO10 }
};
struct kvx_reloc kv3_v1_rel8_reloc __attribute__((unused)) = {
  .bitsize = 8,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_8 }
};

static struct kvx_reloc *kv3_v1_branchcond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_branchcond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_branchcond_opnd",
  .type = Modifier_kv3_v1_scalarcond,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_branchcond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 23 },  }
};

static struct kvx_reloc *kv3_v1_byteshift_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_byteshift_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_byteshift_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_byteshift_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_comparison_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_comparison_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_comparison_opnd",
  .type = Modifier_kv3_v1_comparison,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_comparison_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_doscale_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_doscale_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_doscale_opnd",
  .type = Modifier_kv3_v1_doscale,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_doscale_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_extend27_offset27_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_extend27_offset27_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_extend27_offset27_opnd",
  .type = Immediate_kv3_v1_signed54,
  .width = 54,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_extend27_offset27_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 27, 27, 64 }, { 27, 0, 32 },  }
};

static struct kvx_reloc *kv3_v1_extend27_upper27_lower10_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed64_reloc,
  &kv3_v1_signed64_reloc,
  &kv3_v1_gotaddr_signed64_reloc,
  0
};
static struct kvx_operand kv3_v1_extend27_upper27_lower10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_extend27_upper27_lower10_opnd",
  .type = Immediate_kv3_v1_wrapped64,
  .width = 64,
  .shift = 0,
  .bias = 0,
  .flags = kvxWRAPPED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 3,
  .relocs = kv3_v1_extend27_upper27_lower10_opnd_relocs,
  .bitfields = 3,
  .bfield = { { 27, 37, 64 }, { 27, 10, 32 }, { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_extend6_upper27_lower10_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed43_reloc,
  &kv3_v1_gotoff_signed43_reloc,
  &kv3_v1_got_signed43_reloc,
  &kv3_v1_signed43_reloc,
  &kv3_v1_gotaddr_signed43_reloc,
  &kv3_v1_dtpoff_signed43_reloc,
  &kv3_v1_tlsgd_signed43_reloc,
  &kv3_v1_tlsld_signed43_reloc,
  &kv3_v1_tlsie_signed43_reloc,
  &kv3_v1_tlsle_signed43_reloc,
  0
};
static struct kvx_operand kv3_v1_extend6_upper27_lower10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_extend6_upper27_lower10_opnd",
  .type = Immediate_kv3_v1_signed43,
  .width = 43,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 10,
  .relocs = kv3_v1_extend6_upper27_lower10_opnd_relocs,
  .bitfields = 3,
  .bfield = { { 6, 37, 0 }, { 27, 10, 32 }, { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_floatcomp_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_floatcomp_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_floatcomp_opnd",
  .type = Modifier_kv3_v1_floatcomp,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_floatcomp_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_lsucond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_lsucond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_lsucond_opnd",
  .type = Modifier_kv3_v1_scalarcond,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_lsucond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_offset27_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_offset27_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_offset27_opnd",
  .type = Immediate_kv3_v1_signed27,
  .width = 27,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_offset27_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 27, 0, 32 },  }
};

static struct kvx_reloc *kv3_v1_pcrel17_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel17_reloc,
  0
};
static struct kvx_operand kv3_v1_pcrel17_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_pcrel17_opnd",
  .type = Immediate_kv3_v1_pcrel17,
  .width = 17,
  .shift = 2,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 1,
  .relocs = kv3_v1_pcrel17_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 17, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_pcrel27_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel27_reloc,
  0
};
static struct kvx_operand kv3_v1_pcrel27_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_pcrel27_opnd",
  .type = Immediate_kv3_v1_pcrel27,
  .width = 27,
  .shift = 2,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 1,
  .relocs = kv3_v1_pcrel27_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 27, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_qindex_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_qindex_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_qindex_opnd",
  .type = Modifier_kv3_v1_qindex,
  .width = 2,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_qindex_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 2, 0, 18 },  }
};

static struct kvx_reloc *kv3_v1_rectify_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_rectify_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_rectify_opnd",
  .type = Modifier_kv3_v1_rectify,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_rectify_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 7 },  }
};

static int kv3_v1_registera_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registera_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registera_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registera_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registera_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registera_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registera_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registera0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera0_opnd",
  .type = RegClass_kv3_v1_blockReg0M4,
  .width = 5,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registera1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registera1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera1_opnd",
  .type = RegClass_kv3_v1_blockReg1M4,
  .width = 5,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registera2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registera2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera2_opnd",
  .type = RegClass_kv3_v1_blockReg2M4,
  .width = 5,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registera3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registera3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera3_opnd",
  .type = RegClass_kv3_v1_blockReg3M4,
  .width = 5,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerae_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerae_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerae_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerae_opnd",
  .type = RegClass_kv3_v1_blockRegE,
  .width = 6,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registerae_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerae_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerao_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerao_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerao_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerao_opnd",
  .type = RegClass_kv3_v1_blockRegO,
  .width = 6,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registerao_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerao_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerap_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerap_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerap_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerap_opnd",
  .type = RegClass_kv3_v1_tileReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerap_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerap_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerap_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerap_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerap_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerap_0_opnd",
  .type = RegClass_kv3_v1_tileReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerap_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerap_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerap_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerap_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerap_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerap_1_opnd",
  .type = RegClass_kv3_v1_tileReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerap_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerap_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registeraq_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registeraq_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_opnd",
  .type = RegClass_kv3_v1_matrixReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registeraq_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registeraq_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_0_opnd",
  .type = RegClass_kv3_v1_matrixReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registeraq_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_1_opnd",
  .type = RegClass_kv3_v1_matrixReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registeraq_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_2_opnd",
  .type = RegClass_kv3_v1_matrixReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registeraq_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_3_opnd",
  .type = RegClass_kv3_v1_matrixReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerat_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerat_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerat_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerat_opnd",
  .type = RegClass_kv3_v1_coproReg3M4,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerat_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerat_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerax_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerax_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerax_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerax_opnd",
  .type = RegClass_kv3_v1_coproReg0M4,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerax_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerax_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registeray_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registeray_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeray_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeray_opnd",
  .type = RegClass_kv3_v1_coproReg1M4,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registeray_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeray_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registeraz_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registeraz_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraz_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraz_opnd",
  .type = RegClass_kv3_v1_coproReg2M4,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registeraz_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraz_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerb_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerb_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerb_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerb_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerb_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerb_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerb_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerbe_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerbe_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbe_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbe_opnd",
  .type = RegClass_kv3_v1_vectorRegE,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbe_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbe_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbo_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerbo_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbo_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbo_opnd",
  .type = RegClass_kv3_v1_vectorRegO,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbo_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbo_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbp_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerbp_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbp_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbp_opnd",
  .type = RegClass_kv3_v1_tileReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerbp_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbp_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbp_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerbp_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbp_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbp_0_opnd",
  .type = RegClass_kv3_v1_tileReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbp_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbp_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbp_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerbp_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbp_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbp_1_opnd",
  .type = RegClass_kv3_v1_tileReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbp_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbp_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbq_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerbq_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_opnd",
  .type = RegClass_kv3_v1_matrixReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registerbq_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerbq_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_0_opnd",
  .type = RegClass_kv3_v1_matrixReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerbq_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_1_opnd",
  .type = RegClass_kv3_v1_matrixReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerbq_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_2_opnd",
  .type = RegClass_kv3_v1_matrixReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerbq_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_3_opnd",
  .type = RegClass_kv3_v1_matrixReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerc_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerc_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerc_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerc_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerc_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerc_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerc_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerce_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerce_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerce_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerce_opnd",
  .type = RegClass_kv3_v1_vectorRegE,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerce_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerce_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registerco_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerco_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerco_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerco_opnd",
  .type = RegClass_kv3_v1_vectorRegO,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerco_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerco_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registerd_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerd_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerd_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerd_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerd_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerd_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerd_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registere_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registere_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registere_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registere_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registere_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registere_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registere_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerm_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerm_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerm_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerm_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerm_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerm_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerm_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerm_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerm_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerm_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerm_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerm_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerm_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerm_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerm_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerm_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerm_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerm_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registern_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registern_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_opnd",
  .type = RegClass_kv3_v1_quadReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registern_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registern_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_0_opnd",
  .type = RegClass_kv3_v1_quadReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registern_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_1_opnd",
  .type = RegClass_kv3_v1_quadReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registern_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_2_opnd",
  .type = RegClass_kv3_v1_quadReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registern_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_3_opnd",
  .type = RegClass_kv3_v1_quadReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registero_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registero_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registero_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registero_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registero_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registero_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registero_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registero_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registero_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registero_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registero_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registero_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registero_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registero_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registero_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registero_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registero_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registero_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registerp_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerp_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerp_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerp_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerp_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerp_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 1 },  }
};

static int kv3_v1_registerp_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerp_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerp_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerp_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerp_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerp_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 1 },  }
};

static int kv3_v1_registerp_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerp_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerp_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerp_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerp_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerp_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 1 },  }
};

static int kv3_v1_registerr_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerr_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_opnd",
  .type = RegClass_kv3_v1_quadReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registerr_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerr_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_0_opnd",
  .type = RegClass_kv3_v1_quadReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerr_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_1_opnd",
  .type = RegClass_kv3_v1_quadReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerr_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_2_opnd",
  .type = RegClass_kv3_v1_quadReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerr_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_3_opnd",
  .type = RegClass_kv3_v1_quadReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registert_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registert_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registert_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registert_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registert_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registert_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registeru_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registeru_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeru_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeru_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registeru_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeru_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registeru_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registeru_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeru_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeru_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeru_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeru_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registeru_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registeru_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeru_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeru_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeru_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeru_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerv_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerv_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_opnd",
  .type = RegClass_kv3_v1_quadReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registerv_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerv_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_0_opnd",
  .type = RegClass_kv3_v1_quadReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerv_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_1_opnd",
  .type = RegClass_kv3_v1_quadReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerv_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_2_opnd",
  .type = RegClass_kv3_v1_quadReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerv_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_3_opnd",
  .type = RegClass_kv3_v1_quadReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerw_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerw_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerw_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerw_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerw_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerw_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registery_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registery_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registery_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registery_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registery_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registery_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerz_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerz_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerz_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerz_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerz_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerz_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_rounding_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_rounding_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_rounding_opnd",
  .type = Modifier_kv3_v1_rounding,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_rounding_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_rounding2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_rounding2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_rounding2_opnd",
  .type = Modifier_kv3_v1_rounding,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_rounding2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 8 },  }
};

static struct kvx_reloc *kv3_v1_roundint_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_roundint_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_roundint_opnd",
  .type = Modifier_kv3_v1_roundint,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_roundint_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 8 },  }
};

static struct kvx_reloc *kv3_v1_saturate_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_saturate_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_saturate_opnd",
  .type = Modifier_kv3_v1_saturate,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_saturate_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 7 },  }
};

static struct kvx_reloc *kv3_v1_scalarcond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_scalarcond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_scalarcond_opnd",
  .type = Modifier_kv3_v1_scalarcond,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_scalarcond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_signed10_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_signed10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_signed10_opnd",
  .type = Immediate_kv3_v1_signed10,
  .width = 10,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_signed10_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_signed16_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed16_reloc,
  &kv3_v1_signed16_reloc,
  0
};
static struct kvx_operand kv3_v1_signed16_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_signed16_opnd",
  .type = Immediate_kv3_v1_signed16,
  .width = 16,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 2,
  .relocs = kv3_v1_signed16_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 16, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_silent_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_silent_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_silent_opnd",
  .type = Modifier_kv3_v1_silent,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_silent_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 15 },  }
};

static struct kvx_reloc *kv3_v1_silent2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_silent2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_silent2_opnd",
  .type = Modifier_kv3_v1_silent,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_silent2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 11 },  }
};

static struct kvx_reloc *kv3_v1_simdcond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_simdcond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_simdcond_opnd",
  .type = Modifier_kv3_v1_simplecond,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_simdcond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_speculate_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_speculate_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_speculate_opnd",
  .type = Modifier_kv3_v1_speculate,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_speculate_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_splat32_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_splat32_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_splat32_opnd",
  .type = Modifier_kv3_v1_splat32,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_splat32_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 11 },  }
};

static struct kvx_reloc *kv3_v1_startbit_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_startbit_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_startbit_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_startbit_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_stopbit2_stopbit4_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_stopbit2_stopbit4_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_stopbit2_stopbit4_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_stopbit2_stopbit4_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 2, 4, 24 }, { 4, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_sysnumber_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_sysnumber_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_sysnumber_opnd",
  .type = Immediate_kv3_v1_sysnumber,
  .width = 12,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_sysnumber_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 12, 0, 0 },  }
};

static int kv3_v1_systemalone_opnd_regs[] = {
      0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_systemalone_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemalone_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemalone_opnd",
  .type = RegClass_kv3_v1_aloneReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemalone_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemalone_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemra_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_systemra_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemra_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemra_opnd",
  .type = RegClass_kv3_v1_onlyraReg,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemra_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemra_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systems2_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systems2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systems2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systems2_opnd",
  .type = RegClass_kv3_v1_onlygetReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systems2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systems2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systems3_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systems3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systems3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systems3_opnd",
  .type = RegClass_kv3_v1_systemReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systems3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systems3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systems4_opnd_regs[] = {
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systems4_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systems4_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systems4_opnd",
  .type = RegClass_kv3_v1_onlyswapReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systems4_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systems4_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemt2_opnd_regs[] = {
      0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_systemt2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemt2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemt2_opnd",
  .type = RegClass_kv3_v1_onlyfxReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemt2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemt2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemt3_opnd_regs[] = {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systemt3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemt3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemt3_opnd",
  .type = RegClass_kv3_v1_onlysetReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemt3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemt3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemt4_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systemt4_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemt4_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemt4_opnd",
  .type = RegClass_kv3_v1_systemReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemt4_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemt4_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_unsigned6_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_unsigned6_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_unsigned6_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_unsigned6_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_upper27_lower10_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed37_reloc,
  &kv3_v1_signed37_reloc,
  &kv3_v1_gotoff_signed37_reloc,
  &kv3_v1_got_signed37_reloc,
  &kv3_v1_gotaddr_signed37_reloc,
  &kv3_v1_dtpoff_signed37_reloc,
  &kv3_v1_tlsgd_signed37_reloc,
  &kv3_v1_tlsld_signed37_reloc,
  &kv3_v1_tlsie_signed37_reloc,
  &kv3_v1_tlsle_signed37_reloc,
  0
};
static struct kvx_operand kv3_v1_upper27_lower10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_upper27_lower10_opnd",
  .type = Immediate_kv3_v1_signed37,
  .width = 37,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 10,
  .relocs = kv3_v1_upper27_lower10_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 27, 10, 32 }, { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_upper27_lower5_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_signed32_reloc,
  0
};
static struct kvx_operand kv3_v1_upper27_lower5_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_upper27_lower5_opnd",
  .type = Immediate_kv3_v1_wrapped32,
  .width = 32,
  .shift = 0,
  .bias = 0,
  .flags = kvxWRAPPED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 1,
  .relocs = kv3_v1_upper27_lower5_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 27, 5, 32 }, { 5, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_variant_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_variant_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_variant_opnd",
  .type = Modifier_kv3_v1_variant,
  .width = 2,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_variant_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 2, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_xrounding_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_xrounding_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_xrounding_opnd",
  .type = Modifier_kv3_v1_rounding,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_xrounding_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 8 },  }
};



const char *kvx_kv3_v1_resource_names[kvx_kv3_v1_RESOURCE_MAX] = {
  "ISSUE",
  "TINY",
  "LITE",
  "FULL",
  "LSU",
  "MAU",
  "BCU",
  "TCA",
  "AUXR",
  "AUXW",
  "CRRP",
  "CRWL",
  "CRWH",
  "NOP"
};

const int kvx_kv3_v1_resources[kvx_kv3_v1_RESOURCE_MAX] = { 8,4,2,1,1,1,1,1,1,1,1,1,1,4};



#define kvx_kv3_v1_RESERVATION_TABLE_LINES 1
const int kvx_kv3_v1_reservation_table_lines = kvx_kv3_v1_RESERVATION_TABLE_LINES;

static const int Reservation_kv3_v1_ALL_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  8 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_FULL_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  1 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_FULL_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  1 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_FULL_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  1 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_CRWH_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  1 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_CRWL_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  1 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_NOP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  1 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_TINY_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_TINY_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_TINY_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  1 /* cyc.0 Resource-kv3_v1-CRWL */,
  1 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_TINY_AUXW_CRRP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  2 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  4 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_AUXW_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_AUXW_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_AUXW_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXW_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXW_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXW_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_CRRP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_CRRP_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_CRRP_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_AUXR_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_AUXR_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_AUXR_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_TCA_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  1 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

const int *kvx_kv3_v1_reservation_table_table[] ={
  Reservation_kv3_v1_ALL_table,
  Reservation_kv3_v1_ALU_NOP_table,
  Reservation_kv3_v1_ALU_TINY_table,
  Reservation_kv3_v1_ALU_TINY_X_table,
  Reservation_kv3_v1_ALU_TINY_Y_table,
  Reservation_kv3_v1_ALU_LITE_table,
  Reservation_kv3_v1_ALU_LITE_X_table,
  Reservation_kv3_v1_ALU_LITE_Y_table,
  Reservation_kv3_v1_ALU_LITE_CRWL_table,
  Reservation_kv3_v1_ALU_LITE_CRWH_table,
  Reservation_kv3_v1_ALU_FULL_table,
  Reservation_kv3_v1_ALU_FULL_X_table,
  Reservation_kv3_v1_ALU_FULL_Y_table,
  Reservation_kv3_v1_BCU_table,
  Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH_table,
  Reservation_kv3_v1_BCU_TINY_AUXW_CRRP_table,
  Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP_table,
  Reservation_kv3_v1_TCA_table,
  Reservation_kv3_v1_LSU_table,
  Reservation_kv3_v1_LSU_X_table,
  Reservation_kv3_v1_LSU_Y_table,
  Reservation_kv3_v1_LSU_CRRP_table,
  Reservation_kv3_v1_LSU_CRRP_X_table,
  Reservation_kv3_v1_LSU_CRRP_Y_table,
  Reservation_kv3_v1_LSU_AUXR_table,
  Reservation_kv3_v1_LSU_AUXR_X_table,
  Reservation_kv3_v1_LSU_AUXR_Y_table,
  Reservation_kv3_v1_LSU_AUXW_table,
  Reservation_kv3_v1_LSU_AUXW_X_table,
  Reservation_kv3_v1_LSU_AUXW_Y_table,
  Reservation_kv3_v1_LSU_AUXR_AUXW_table,
  Reservation_kv3_v1_LSU_AUXR_AUXW_X_table,
  Reservation_kv3_v1_LSU_AUXR_AUXW_Y_table,
  Reservation_kv3_v1_MAU_table,
  Reservation_kv3_v1_MAU_X_table,
  Reservation_kv3_v1_MAU_Y_table,
  Reservation_kv3_v1_MAU_AUXR_table,
  Reservation_kv3_v1_MAU_AUXR_X_table,
  Reservation_kv3_v1_MAU_AUXR_Y_table
};

const struct kvx_core_info kvx_kv3_v1_core_info = { kvx_kv3_v1_optab, "kv3-1", kvx_kv3_v1_resources, ELF_KVX_CORE_KV3_1, kvx_kv3_v1_pseudo_func, 26, (int **) kvx_kv3_v1_reservation_table_table, kvx_kv3_v1_RESERVATION_TABLE_LINES, kvx_kv3_v1_RESOURCE_MAX, (char **) kvx_kv3_v1_resource_names };

struct kvxopc kvx_kv3_v1_optab[] = {
  { /* A_Opcode-kv3_v1-ABSD_registerW_registerZ_simple */
    .as_op = "absd",
    .codewords = {
      {
        .opcode = 0x64000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ABSHQ_registerW_registerZ_double */
    .as_op = "abshq",
    .codewords = {
      {
        .opcode = 0xf4013000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ABSWP_registerW_registerZ_double */
    .as_op = "abswp",
    .codewords = {
      {
        .opcode = 0xf4012000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ABSW_registerW_registerZ_simple */
    .as_op = "absw",
    .codewords = {
      {
        .opcode = 0x74000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-COPYD_registerW_registerZ_simple */
    .as_op = "copyd",
    .codewords = {
      {
        .opcode = 0x6a000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-COPYW_registerW_registerZ_simple */
    .as_op = "copyw",
    .codewords = {
      {
        .opcode = 0x7a000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGD_registerW_registerZ_simple */
    .as_op = "negd",
    .codewords = {
      {
        .opcode = 0x65000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGHQ_registerW_registerZ_double */
    .as_op = "neghq",
    .codewords = {
      {
        .opcode = 0xf5013000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGWP_registerW_registerZ_double */
    .as_op = "negwp",
    .codewords = {
      {
        .opcode = 0xf5012000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGW_registerW_registerZ_simple */
    .as_op = "negw",
    .codewords = {
      {
        .opcode = 0x75000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NOTD_registerW_registerZ_simple */
    .as_op = "notd",
    .codewords = {
      {
        .opcode = 0x6c00ffc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NOTW_registerW_registerZ_simple */
    .as_op = "notw",
    .codewords = {
      {
        .opcode = 0x7c00ffc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SATDH_registerW_registerZ_simple */
    .as_op = "satdh",
    .codewords = {
      {
        .opcode = 0x7e022400,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SATDW_registerW_registerZ_simple */
    .as_op = "satdw",
    .codewords = {
      {
        .opcode = 0x7e022800,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SXBD_registerW_registerZ_simple */
    .as_op = "sxbd",
    .codewords = {
      {
        .opcode = 0x68037000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SXHD_registerW_registerZ_simple */
    .as_op = "sxhd",
    .codewords = {
      {
        .opcode = 0x6803f000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SXWD_registerW_registerZ_simple */
    .as_op = "sxwd",
    .codewords = {
      {
        .opcode = 0x6903f000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XCOPYO_registerA_registerBe_simple */
    .as_op = "xcopyo",
    .codewords = {
      {
        .opcode = 0x01000f80,
        .mask = 0x7f001fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbe_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XCOPYO_registerA_registerBo_simple */
    .as_op = "xcopyo",
    .codewords = {
      {
        .opcode = 0x01001f80,
        .mask = 0x7f001fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbo_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XMOVEFO_registerN_registerBe_simple */
    .as_op = "xmovefo",
    .codewords = {
      {
        .opcode = 0x00081f80,
        .mask = 0x7f0c1fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbe_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XMOVEFO_registerN_registerBo_simple */
    .as_op = "xmovefo",
    .codewords = {
      {
        .opcode = 0x000c1f80,
        .mask = 0x7f0c1fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbo_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ZXBD_registerW_registerZ_simple */
    .as_op = "zxbd",
    .codewords = {
      {
        .opcode = 0x78003fc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ZXHD_registerW_registerZ_simple */
    .as_op = "zxhd",
    .codewords = {
      {
        .opcode = 0x6403f000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ZXWD_registerW_registerZ_simple */
    .as_op = "zxwd",
    .codewords = {
      {
        .opcode = 0x7800ffc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_registerY_simple */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0x74010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_s010_simple */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0x64000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_s037_double */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0xe4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_w032_double */
    .as_op = "abdd.@",
    .codewords = {
      {
        .opcode = 0xf4010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_w064_triple */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0xe4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDHQ_registerW_registerZ_registerY_simple */
    .as_op = "abdhq",
    .codewords = {
      {
        .opcode = 0x74013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "abdhq",
    .codewords = {
      {
        .opcode = 0xf4013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDWP_registerW_registerZ_registerY_simple */
    .as_op = "abdwp",
    .codewords = {
      {
        .opcode = 0x74012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDWP_splat32_registerW_registerZ_w032_double */
    .as_op = "abdwp",
    .codewords = {
      {
        .opcode = 0xf4012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDW_registerW_registerZ_registerY_simple */
    .as_op = "abdw",
    .codewords = {
      {
        .opcode = 0x74011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDW_registerW_registerZ_s010_simple */
    .as_op = "abdw",
    .codewords = {
      {
        .opcode = 0x74000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDW_registerW_registerZ_s037_double */
    .as_op = "abdw",
    .codewords = {
      {
        .opcode = 0xf4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_doscale_registerY_registerZ_registerU_simple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0x3f03e000,
        .mask = 0x7f07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_lsucond_registerY_registerZ_registerU_simple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0x3f030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_lsucond_registerY_s027_registerZ_registerU_double */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_lsucond_registerY_s054_registerZ_registerU_triple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_s010_registerZ_registerU_simple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0x3f010000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_s037_registerZ_registerU_double */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_w064_registerZ_registerU_triple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_doscale_registerY_registerZ_registerU_simple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0x3e03e000,
        .mask = 0x7f07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_lsucond_registerY_registerZ_registerU_simple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0x3e030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_lsucond_registerY_s027_registerZ_registerU_double */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_lsucond_registerY_s054_registerZ_registerU_triple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_s010_registerZ_registerU_simple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0x3e010000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_s037_registerZ_registerU_double */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_w064_registerZ_registerU_triple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ADDCD.I_registerW_registerZ_registerY_simple */
    .as_op = "addcd.i",
    .codewords = {
      {
        .opcode = 0x7e01d000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDCD.I_registerW_registerZ_w032_double */
    .as_op = "addcd.i",
    .codewords = {
      {
        .opcode = 0xfe01d000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDCD_registerW_registerZ_registerY_simple */
    .as_op = "addcd",
    .codewords = {
      {
        .opcode = 0x7e01c000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDCD_registerW_registerZ_w032_double */
    .as_op = "addcd",
    .codewords = {
      {
        .opcode = 0xfe01c000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_registerY_simple */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0x71010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_s010_simple */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0x61000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_s037_double */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0xe1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_w032_double */
    .as_op = "addd.@",
    .codewords = {
      {
        .opcode = 0xf1010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_w064_triple */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0xe1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHCP.C_registerW_registerZ_registerY_simple */
    .as_op = "addhcp.c",
    .codewords = {
      {
        .opcode = 0x7c013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHCP.C_splat32_registerW_registerZ_w032_double */
    .as_op = "addhcp.c",
    .codewords = {
      {
        .opcode = 0xfc013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHQ_registerW_registerZ_registerY_simple */
    .as_op = "addhq",
    .codewords = {
      {
        .opcode = 0x71013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "addhq",
    .codewords = {
      {
        .opcode = 0xf1013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_registerY_simple */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0x7e01a000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_s010_simple */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0x6e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_s037_double */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0xee010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_w064_triple */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0xee010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSHQ_registerW_registerZ_registerY_simple */
    .as_op = "addshq",
    .codewords = {
      {
        .opcode = 0x7e01f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "addshq",
    .codewords = {
      {
        .opcode = 0xfe01f000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSWP_registerW_registerZ_registerY_simple */
    .as_op = "addswp",
    .codewords = {
      {
        .opcode = 0x7e01e000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSWP_splat32_registerW_registerZ_w032_double */
    .as_op = "addswp",
    .codewords = {
      {
        .opcode = 0xfe01e000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSW_registerW_registerZ_registerY_simple */
    .as_op = "addsw",
    .codewords = {
      {
        .opcode = 0x7e01b000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSW_registerW_registerZ_w032_double */
    .as_op = "addsw",
    .codewords = {
      {
        .opcode = 0xfe01b000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDUWD_registerW_registerZ_registerY_simple */
    .as_op = "adduwd",
    .codewords = {
      {
        .opcode = 0x7a014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDUWD_splat32_registerW_registerZ_w032_double */
    .as_op = "adduwd",
    .codewords = {
      {
        .opcode = 0xfa014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWC.C_registerW_registerZ_registerY_simple */
    .as_op = "addwc.c",
    .codewords = {
      {
        .opcode = 0x7c012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWC.C_splat32_registerW_registerZ_w032_double */
    .as_op = "addwc.c",
    .codewords = {
      {
        .opcode = 0xfc012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWD_registerW_registerZ_registerY_simple */
    .as_op = "addwd",
    .codewords = {
      {
        .opcode = 0x78014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWD_splat32_registerW_registerZ_w032_double */
    .as_op = "addwd",
    .codewords = {
      {
        .opcode = 0xf8014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWP_registerW_registerZ_registerY_simple */
    .as_op = "addwp",
    .codewords = {
      {
        .opcode = 0x71012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWP_splat32_registerW_registerZ_w032_double */
    .as_op = "addwp",
    .codewords = {
      {
        .opcode = 0xf1012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDW_registerW_registerZ_registerY_simple */
    .as_op = "addw",
    .codewords = {
      {
        .opcode = 0x71011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDW_registerW_registerZ_s010_simple */
    .as_op = "addw",
    .codewords = {
      {
        .opcode = 0x71000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDW_registerW_registerZ_s037_double */
    .as_op = "addw",
    .codewords = {
      {
        .opcode = 0xf1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16D_registerW_registerZ_registerY_simple */
    .as_op = "addx16d",
    .codewords = {
      {
        .opcode = 0x76014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16D_splat32_registerW_registerZ_w032_double */
    .as_op = "addx16d",
    .codewords = {
      {
        .opcode = 0xf6014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx16hq",
    .codewords = {
      {
        .opcode = 0x76017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "addx16hq",
    .codewords = {
      {
        .opcode = 0xf6017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx16uwd",
    .codewords = {
      {
        .opcode = 0x7e018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16UWD_registerW_registerZ_w032_double */
    .as_op = "addx16uwd",
    .codewords = {
      {
        .opcode = 0xfe018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WD_registerW_registerZ_registerY_simple */
    .as_op = "addx16wd",
    .codewords = {
      {
        .opcode = 0x76018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WD_registerW_registerZ_w032_double */
    .as_op = "addx16wd",
    .codewords = {
      {
        .opcode = 0xf6018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WP_registerW_registerZ_registerY_simple */
    .as_op = "addx16wp",
    .codewords = {
      {
        .opcode = 0x76016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WP_splat32_registerW_registerZ_w032_double */
    .as_op = "addx16wp",
    .codewords = {
      {
        .opcode = 0xf6016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16W_registerW_registerZ_registerY_simple */
    .as_op = "addx16w",
    .codewords = {
      {
        .opcode = 0x76015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16W_registerW_registerZ_w032_double */
    .as_op = "addx16w",
    .codewords = {
      {
        .opcode = 0xf6015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2D_registerW_registerZ_registerY_simple */
    .as_op = "addx2d",
    .codewords = {
      {
        .opcode = 0x70014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2D_splat32_registerW_registerZ_w032_double */
    .as_op = "addx2d",
    .codewords = {
      {
        .opcode = 0xf0014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx2hq",
    .codewords = {
      {
        .opcode = 0x70017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "addx2hq",
    .codewords = {
      {
        .opcode = 0xf0017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx2uwd",
    .codewords = {
      {
        .opcode = 0x78018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2UWD_registerW_registerZ_w032_double */
    .as_op = "addx2uwd",
    .codewords = {
      {
        .opcode = 0xf8018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WD_registerW_registerZ_registerY_simple */
    .as_op = "addx2wd",
    .codewords = {
      {
        .opcode = 0x70018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WD_registerW_registerZ_w032_double */
    .as_op = "addx2wd",
    .codewords = {
      {
        .opcode = 0xf0018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WP_registerW_registerZ_registerY_simple */
    .as_op = "addx2wp",
    .codewords = {
      {
        .opcode = 0x70016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WP_splat32_registerW_registerZ_w032_double */
    .as_op = "addx2wp",
    .codewords = {
      {
        .opcode = 0xf0016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2W_registerW_registerZ_registerY_simple */
    .as_op = "addx2w",
    .codewords = {
      {
        .opcode = 0x70015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2W_registerW_registerZ_w032_double */
    .as_op = "addx2w",
    .codewords = {
      {
        .opcode = 0xf0015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4D_registerW_registerZ_registerY_simple */
    .as_op = "addx4d",
    .codewords = {
      {
        .opcode = 0x72014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4D_splat32_registerW_registerZ_w032_double */
    .as_op = "addx4d",
    .codewords = {
      {
        .opcode = 0xf2014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx4hq",
    .codewords = {
      {
        .opcode = 0x72017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "addx4hq",
    .codewords = {
      {
        .opcode = 0xf2017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx4uwd",
    .codewords = {
      {
        .opcode = 0x7a018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4UWD_registerW_registerZ_w032_double */
    .as_op = "addx4uwd",
    .codewords = {
      {
        .opcode = 0xfa018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WD_registerW_registerZ_registerY_simple */
    .as_op = "addx4wd",
    .codewords = {
      {
        .opcode = 0x72018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WD_registerW_registerZ_w032_double */
    .as_op = "addx4wd",
    .codewords = {
      {
        .opcode = 0xf2018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WP_registerW_registerZ_registerY_simple */
    .as_op = "addx4wp",
    .codewords = {
      {
        .opcode = 0x72016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WP_splat32_registerW_registerZ_w032_double */
    .as_op = "addx4wp",
    .codewords = {
      {
        .opcode = 0xf2016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4W_registerW_registerZ_registerY_simple */
    .as_op = "addx4w",
    .codewords = {
      {
        .opcode = 0x72015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4W_registerW_registerZ_w032_double */
    .as_op = "addx4w",
    .codewords = {
      {
        .opcode = 0xf2015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8D_registerW_registerZ_registerY_simple */
    .as_op = "addx8d",
    .codewords = {
      {
        .opcode = 0x74014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8D_splat32_registerW_registerZ_w032_double */
    .as_op = "addx8d",
    .codewords = {
      {
        .opcode = 0xf4014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx8hq",
    .codewords = {
      {
        .opcode = 0x74017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "addx8hq",
    .codewords = {
      {
        .opcode = 0xf4017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx8uwd",
    .codewords = {
      {
        .opcode = 0x7c018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8UWD_registerW_registerZ_w032_double */
    .as_op = "addx8uwd",
    .codewords = {
      {
        .opcode = 0xfc018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WD_registerW_registerZ_registerY_simple */
    .as_op = "addx8wd",
    .codewords = {
      {
        .opcode = 0x74018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WD_registerW_registerZ_w032_double */
    .as_op = "addx8wd",
    .codewords = {
      {
        .opcode = 0xf4018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WP_registerW_registerZ_registerY_simple */
    .as_op = "addx8wp",
    .codewords = {
      {
        .opcode = 0x74016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WP_splat32_registerW_registerZ_w032_double */
    .as_op = "addx8wp",
    .codewords = {
      {
        .opcode = 0xf4016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8W_registerW_registerZ_registerY_simple */
    .as_op = "addx8w",
    .codewords = {
      {
        .opcode = 0x74015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8W_registerW_registerZ_w032_double */
    .as_op = "addx8w",
    .codewords = {
      {
        .opcode = 0xf4015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ALADDD_doscale_registerY_registerZ_registerT_simple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0x2f03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0x2f030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_s010_registerZ_registerT_simple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0x2f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_s037_registerZ_registerT_double */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_w064_registerZ_registerT_triple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_doscale_registerY_registerZ_registerT_simple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0x2e03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0x2e030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_s010_registerZ_registerT_simple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0x2e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_s037_registerZ_registerT_double */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_w064_registerZ_registerT_triple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALCLRD_doscale_registerW_registerY_registerZ_simple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0x2b03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0x2b030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_registerW_s010_registerZ_simple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0x2b010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_registerW_s037_registerZ_double */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_registerW_w064_registerZ_triple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_doscale_registerW_registerY_registerZ_simple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0x2a03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0x2a030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_registerW_s010_registerZ_simple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0x2a010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_registerW_s037_registerZ_double */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_registerW_w064_registerZ_triple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBe_registerCo_registerZ_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x00081040,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBe_registerCo_u006_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x00081000,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBo_registerCe_registerZ_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x000c1040,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBo_registerCe_u006_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x000c1000,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBe_registerCo_registerZ_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01000040,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBe_registerCo_u006_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01000000,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBo_registerCe_registerZ_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01001040,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBo_registerCe_u006_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01001000,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_registerY_simple */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0x78010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_s010_simple */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0x68000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_s037_double */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0xe8000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_w032_double */
    .as_op = "andd.@",
    .codewords = {
      {
        .opcode = 0xf8010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_w064_triple */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0xe8000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_registerY_simple */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0x7e010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_s010_simple */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0x6e000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_s037_double */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0xee000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_w032_double */
    .as_op = "andnd.@",
    .codewords = {
      {
        .opcode = 0xfe010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_w064_triple */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0xee000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDNW_registerW_registerZ_registerY_simple */
    .as_op = "andnw",
    .codewords = {
      {
        .opcode = 0x7e011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDNW_registerW_registerZ_s010_simple */
    .as_op = "andnw",
    .codewords = {
      {
        .opcode = 0x7e000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDNW_registerW_registerZ_s037_double */
    .as_op = "andnw",
    .codewords = {
      {
        .opcode = 0xfe000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDW_registerW_registerZ_registerY_simple */
    .as_op = "andw",
    .codewords = {
      {
        .opcode = 0x78011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDW_registerW_registerZ_s010_simple */
    .as_op = "andw",
    .codewords = {
      {
        .opcode = 0x78000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDW_registerW_registerZ_s037_double */
    .as_op = "andw",
    .codewords = {
      {
        .opcode = 0xf8000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGHQ_registerW_registerZ_registerY_simple */
    .as_op = "avghq",
    .codewords = {
      {
        .opcode = 0x78017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "avghq",
    .codewords = {
      {
        .opcode = 0xf8017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRHQ_registerW_registerZ_registerY_simple */
    .as_op = "avgrhq",
    .codewords = {
      {
        .opcode = 0x7a017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "avgrhq",
    .codewords = {
      {
        .opcode = 0xfa017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUHQ_registerW_registerZ_registerY_simple */
    .as_op = "avgruhq",
    .codewords = {
      {
        .opcode = 0x7b017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "avgruhq",
    .codewords = {
      {
        .opcode = 0xfb017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUWP_registerW_registerZ_registerY_simple */
    .as_op = "avgruwp",
    .codewords = {
      {
        .opcode = 0x7b016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUWP_splat32_registerW_registerZ_w032_double */
    .as_op = "avgruwp",
    .codewords = {
      {
        .opcode = 0xfb016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUW_registerW_registerZ_registerY_simple */
    .as_op = "avgruw",
    .codewords = {
      {
        .opcode = 0x7b015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUW_registerW_registerZ_w032_double */
    .as_op = "avgruw",
    .codewords = {
      {
        .opcode = 0xfb015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRWP_registerW_registerZ_registerY_simple */
    .as_op = "avgrwp",
    .codewords = {
      {
        .opcode = 0x7a016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRWP_splat32_registerW_registerZ_w032_double */
    .as_op = "avgrwp",
    .codewords = {
      {
        .opcode = 0xfa016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRW_registerW_registerZ_registerY_simple */
    .as_op = "avgrw",
    .codewords = {
      {
        .opcode = 0x7a015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRW_registerW_registerZ_w032_double */
    .as_op = "avgrw",
    .codewords = {
      {
        .opcode = 0xfa015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUHQ_registerW_registerZ_registerY_simple */
    .as_op = "avguhq",
    .codewords = {
      {
        .opcode = 0x79017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "avguhq",
    .codewords = {
      {
        .opcode = 0xf9017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUWP_registerW_registerZ_registerY_simple */
    .as_op = "avguwp",
    .codewords = {
      {
        .opcode = 0x79016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUWP_splat32_registerW_registerZ_w032_double */
    .as_op = "avguwp",
    .codewords = {
      {
        .opcode = 0xf9016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUW_registerW_registerZ_registerY_simple */
    .as_op = "avguw",
    .codewords = {
      {
        .opcode = 0x79015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUW_registerW_registerZ_w032_double */
    .as_op = "avguw",
    .codewords = {
      {
        .opcode = 0xf9015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGWP_registerW_registerZ_registerY_simple */
    .as_op = "avgwp",
    .codewords = {
      {
        .opcode = 0x78016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGWP_splat32_registerW_registerZ_w032_double */
    .as_op = "avgwp",
    .codewords = {
      {
        .opcode = 0xf8016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGW_registerW_registerZ_registerY_simple */
    .as_op = "avgw",
    .codewords = {
      {
        .opcode = 0x78015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGW_registerW_registerZ_w032_double */
    .as_op = "avgw",
    .codewords = {
      {
        .opcode = 0xf8015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AWAIT_simple */
    .as_op = "await",
    .codewords = {
      {
        .opcode = 0x0fa00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-BARRIER_simple */
    .as_op = "barrier",
    .codewords = {
      {
        .opcode = 0x0fac0000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-CALL_s027_simple */
    .as_op = "call",
    .codewords = {
      {
        .opcode = 0x18000000,
        .mask = 0x78000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_pcrel27_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-CBSD_registerW_registerZ_simple */
    .as_op = "cbsd",
    .codewords = {
      {
        .opcode = 0x72022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CBSWP_registerW_registerZ_simple */
    .as_op = "cbswp",
    .codewords = {
      {
        .opcode = 0x72024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CBSW_registerW_registerZ_simple */
    .as_op = "cbsw",
    .codewords = {
      {
        .opcode = 0x72023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CB_branchcond_registerZ_s017_simple */
    .as_op = "cb",
    .codewords = {
      {
        .opcode = 0x08000000,
        .mask = 0x78000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_branchcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_pcrel17_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s",
  },
  { /* Opcode-kv3_v1-CLRF_registerW_registerZ_u006_u006_simple */
    .as_op = "clrf",
    .codewords = {
      {
        .opcode = 0x6c030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-CLSD_registerW_registerZ_simple */
    .as_op = "clsd",
    .codewords = {
      {
        .opcode = 0x71022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLSWP_registerW_registerZ_simple */
    .as_op = "clswp",
    .codewords = {
      {
        .opcode = 0x71024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLSW_registerW_registerZ_simple */
    .as_op = "clsw",
    .codewords = {
      {
        .opcode = 0x71023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLZD_registerW_registerZ_simple */
    .as_op = "clzd",
    .codewords = {
      {
        .opcode = 0x70022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLZWP_registerW_registerZ_simple */
    .as_op = "clzwp",
    .codewords = {
      {
        .opcode = 0x70024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLZW_registerW_registerZ_simple */
    .as_op = "clzw",
    .codewords = {
      {
        .opcode = 0x70023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_registerY_simple */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0x70020000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_s010_simple */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0x60020000,
        .mask = 0x70030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_s037_double */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0xe0020000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_w064_triple */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0xe0020000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVEHQ_simdcond_registerZ_registerW_registerY_simple */
    .as_op = "cmovehq",
    .codewords = {
      {
        .opcode = 0x78021000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_simdcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVEWP_simdcond_registerZ_registerW_registerY_simple */
    .as_op = "cmovewp",
    .codewords = {
      {
        .opcode = 0x70021000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_simdcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_registerY_simple */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0x5b041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_s010_simple */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0x4b040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_s037_double */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0xcb040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_w064_triple */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0xcb040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULGHXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulghxdt",
    .codewords = {
      {
        .opcode = 0x5f041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULGLXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulglxdt",
    .codewords = {
      {
        .opcode = 0x5d041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULGMXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulgmxdt",
    .codewords = {
      {
        .opcode = 0x5e041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulxdt",
    .codewords = {
      {
        .opcode = 0x5c041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0x7001a000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_s010_simple */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0x60010000,
        .mask = 0x70030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_s037_double */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0xe0010000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_w064_triple */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0xe0010000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNHQ_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compnhq",
    .codewords = {
      {
        .opcode = 0x7001f000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNHQ_comparison_splat32_registerW_registerZ_w032_double */
    .as_op = "compnhq",
    .codewords = {
      {
        .opcode = 0xf001f000,
        .mask = 0xf003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNWP_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compnwp",
    .codewords = {
      {
        .opcode = 0x7001e000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNWP_comparison_splat32_registerW_registerZ_w032_double */
    .as_op = "compnwp",
    .codewords = {
      {
        .opcode = 0xf001e000,
        .mask = 0xf003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPUWD_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compuwd",
    .codewords = {
      {
        .opcode = 0x7001d000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPUWD_comparison_registerW_registerZ_w032_double */
    .as_op = "compuwd",
    .codewords = {
      {
        .opcode = 0xf001d000,
        .mask = 0xf003f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPWD_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compwd",
    .codewords = {
      {
        .opcode = 0x7001c000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPWD_comparison_registerW_registerZ_w032_double */
    .as_op = "compwd",
    .codewords = {
      {
        .opcode = 0xf001c000,
        .mask = 0xf003f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPW_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compw",
    .codewords = {
      {
        .opcode = 0x7001b000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPW_comparison_registerW_registerZ_w032_double */
    .as_op = "compw",
    .codewords = {
      {
        .opcode = 0xf001b000,
        .mask = 0xf003f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CONVDHV0_roundint_saturate_registerAE_registerBq_simple */
    .as_op = "convdhv0",
    .codewords = {
      {
        .opcode = 0x05000000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerae_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVDHV1_roundint_saturate_registerAO_registerBq_simple */
    .as_op = "convdhv1",
    .codewords = {
      {
        .opcode = 0x05001000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerao_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV0_roundint_saturate_registerAx_registerBq_simple */
    .as_op = "convwbv0",
    .codewords = {
      {
        .opcode = 0x06000000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerax_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV1_roundint_saturate_registerAy_registerBq_simple */
    .as_op = "convwbv1",
    .codewords = {
      {
        .opcode = 0x06001000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registeray_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV2_roundint_saturate_registerAz_registerBq_simple */
    .as_op = "convwbv2",
    .codewords = {
      {
        .opcode = 0x06002000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registeraz_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV3_roundint_saturate_registerAt_registerBq_simple */
    .as_op = "convwbv3",
    .codewords = {
      {
        .opcode = 0x06003000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerat_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-COPYO_registerN_registerR_simple */
    .as_op = "copyo",
    .codewords = {
      {
        .opcode = 0x3e050000,
        .mask = 0x7f0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerr_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-COPYQ_registerM_registerZ_registerY_simple */
    .as_op = "copyq",
    .codewords = {
      {
        .opcode = 0x5f00f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELLW_registerW_registerZ_registerY_simple */
    .as_op = "crcbellw",
    .codewords = {
      {
        .opcode = 0x59002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELLW_registerW_registerZ_w032_double */
    .as_op = "crcbellw",
    .codewords = {
      {
        .opcode = 0xd9002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELMW_registerW_registerZ_registerY_simple */
    .as_op = "crcbelmw",
    .codewords = {
      {
        .opcode = 0x58002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELMW_registerW_registerZ_w032_double */
    .as_op = "crcbelmw",
    .codewords = {
      {
        .opcode = 0xd8002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELLW_registerW_registerZ_registerY_simple */
    .as_op = "crclellw",
    .codewords = {
      {
        .opcode = 0x5b002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELLW_registerW_registerZ_w032_double */
    .as_op = "crclellw",
    .codewords = {
      {
        .opcode = 0xdb002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELMW_registerW_registerZ_registerY_simple */
    .as_op = "crclelmw",
    .codewords = {
      {
        .opcode = 0x5a002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELMW_registerW_registerZ_w032_double */
    .as_op = "crclelmw",
    .codewords = {
      {
        .opcode = 0xda002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CTZD_registerW_registerZ_simple */
    .as_op = "ctzd",
    .codewords = {
      {
        .opcode = 0x73022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CTZWP_registerW_registerZ_simple */
    .as_op = "ctzwp",
    .codewords = {
      {
        .opcode = 0x73024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CTZW_registerW_registerZ_simple */
    .as_op = "ctzw",
    .codewords = {
      {
        .opcode = 0x73023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-D1INVAL_simple */
    .as_op = "d1inval",
    .codewords = {
      {
        .opcode = 0x3f8d0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-DINVALL_lsucond_registerY_registerZ_simple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0x3c1e0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_lsucond_registerY_s027_registerZ_double */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_lsucond_registerY_s054_registerZ_triple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_registerY_registerZ_simple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0x3c1ee000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_s010_registerZ_simple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0x3c1c0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_s037_registerZ_double */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_w064_registerZ_triple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DOT2SUWDP_registerM_registerP_registerO_simple */
    .as_op = "dot2suwdp",
    .codewords = {
      {
        .opcode = 0x52002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_registerY_simple */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0x5e002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_s010_simple */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0x4e000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_s037_double */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0xce000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_w064_triple */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0xce000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWDP_registerM_registerP_registerO_simple */
    .as_op = "dot2uwdp",
    .codewords = {
      {
        .opcode = 0x51002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_registerY_simple */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0x5d002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_s010_simple */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0x4d000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_s037_double */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0xcd000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_w064_triple */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0xcd000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WDP_registerM_registerP_registerO_simple */
    .as_op = "dot2wdp",
    .codewords = {
      {
        .opcode = 0x50002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_registerY_simple */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0x5c002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_s010_simple */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0x4c000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_s037_double */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0xcc000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_w064_triple */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0xcc000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WZP_registerM_registerP_registerO_simple */
    .as_op = "dot2wzp",
    .codewords = {
      {
        .opcode = 0x53002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_registerY_simple */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0x5f002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_s010_simple */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0x4f000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_s037_double */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0xcf000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_w064_triple */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0xcf000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DTOUCHL_lsucond_registerY_registerZ_simple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0x3c0e0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_lsucond_registerY_s027_registerZ_double */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_lsucond_registerY_s054_registerZ_triple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_registerY_registerZ_simple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0x3c0ee000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_s010_registerZ_simple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0x3c0c0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_s037_registerZ_double */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_w064_registerZ_triple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_lsucond_registerY_registerZ_simple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0x280f0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_lsucond_registerY_s027_registerZ_double */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80f0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_lsucond_registerY_s054_registerZ_triple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80f0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_registerY_registerZ_simple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0x280fe000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_s010_registerZ_simple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0x280d0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_s037_registerZ_double */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80d0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_w064_registerZ_triple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80d0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-ERROP_simple */
    .as_op = "errop",
    .codewords = {
      {
        .opcode = 0x00000000,
        .mask = 0x7fffffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-EXTFS_registerW_registerZ_u006_u006_simple */
    .as_op = "extfs",
    .codewords = {
      {
        .opcode = 0x68030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-EXTFZ_registerW_registerZ_u006_u006_simple */
    .as_op = "extfz",
    .codewords = {
      {
        .opcode = 0x64030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FABSD_registerW_registerZ_simple */
    .as_op = "fabsd",
    .codewords = {
      {
        .opcode = 0x71032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FABSHQ_registerW_registerZ_simple */
    .as_op = "fabshq",
    .codewords = {
      {
        .opcode = 0x77032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FABSWP_registerW_registerZ_simple */
    .as_op = "fabswp",
    .codewords = {
      {
        .opcode = 0x75032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FABSW_registerW_registerZ_simple */
    .as_op = "fabsw",
    .codewords = {
      {
        .opcode = 0x73032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FADDDC.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fadddc.c",
    .codewords = {
      {
        .opcode = 0x5d030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDDP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fadddp",
    .codewords = {
      {
        .opcode = 0x5c030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_registerW_registerZ_s010_simple */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0x40020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_registerW_registerZ_s037_double */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0xc0020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_registerW_registerZ_w064_triple */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0xc0020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0x50020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_registerW_registerZ_s010_simple */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0x42020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_registerW_registerZ_s037_double */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0xc2020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_registerW_registerZ_w064_triple */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0xc2020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0x52020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_registerW_registerZ_s010_simple */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0x43020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_registerW_registerZ_s037_double */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0xc3020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_registerW_registerZ_w064_triple */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0xc3020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0x53020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWCP.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "faddwcp.c",
    .codewords = {
      {
        .opcode = 0x59070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_registerW_registerZ_s010_simple */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0x41020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_registerW_registerZ_s037_double */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0xc1020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_registerW_registerZ_w064_triple */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0xc1020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0x51020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWQ_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "faddwq",
    .codewords = {
      {
        .opcode = 0x58070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_registerW_registerZ_s010_simple */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0x4c020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_registerW_registerZ_s037_double */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0xcc020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_registerW_registerZ_w064_triple */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0xcc020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0x5c020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCDIVD_silent2_registerW_registerP_simple */
    .as_op = "fcdivd",
    .codewords = {
      {
        .opcode = 0x71035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FCDIVWP_silent2_registerW_registerP_simple */
    .as_op = "fcdivwp",
    .codewords = {
      {
        .opcode = 0x75035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FCDIVW_silent2_registerW_registerP_simple */
    .as_op = "fcdivw",
    .codewords = {
      {
        .opcode = 0x73035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FCOMPD_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompd",
    .codewords = {
      {
        .opcode = 0x78030000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPD_floatcomp_registerW_registerZ_w032_double */
    .as_op = "fcompd",
    .codewords = {
      {
        .opcode = 0xf8030000,
        .mask = 0xf803f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNHQ_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompnhq",
    .codewords = {
      {
        .opcode = 0x78031000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNHQ_floatcomp_splat32_registerW_registerZ_w032_double */
    .as_op = "fcompnhq",
    .codewords = {
      {
        .opcode = 0xf8031000,
        .mask = 0xf803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNWP_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompnwp",
    .codewords = {
      {
        .opcode = 0x70031000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNWP_floatcomp_splat32_registerW_registerZ_w032_double */
    .as_op = "fcompnwp",
    .codewords = {
      {
        .opcode = 0xf0031000,
        .mask = 0xf803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPW_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompw",
    .codewords = {
      {
        .opcode = 0x70030000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPW_floatcomp_registerW_registerZ_w032_double */
    .as_op = "fcompw",
    .codewords = {
      {
        .opcode = 0xf0030000,
        .mask = 0xf803f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WDP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fdot2wdp",
    .codewords = {
      {
        .opcode = 0x5c070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_registerW_registerZ_s010_simple */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0x4d010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_registerW_registerZ_s037_double */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0xcd010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_registerW_registerZ_w064_triple */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0xcd010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0x5d010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WZP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fdot2wzp",
    .codewords = {
      {
        .opcode = 0x5d070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_registerW_registerZ_s010_simple */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0x4c010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_registerW_registerZ_s037_double */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0xcc010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_registerW_registerZ_w064_triple */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0xcc010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0x5c010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FENCE_simple */
    .as_op = "fence",
    .codewords = {
      {
        .opcode = 0x3fcd0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-FFMAD_registerW_registerZ_s010_simple */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0x40010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAD_registerW_registerZ_s037_double */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0xc0010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAD_registerW_registerZ_w064_triple */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0xc0010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0x50010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_registerW_registerZ_s010_simple */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0x43010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_registerW_registerZ_s037_double */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0xc3010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_registerW_registerZ_w064_triple */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0xc3010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0x53010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_registerM_registerZ_s010_simple */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0x41030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_registerM_registerZ_s037_double */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0xc1030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_registerM_registerZ_w064_triple */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0xc1030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0x51030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_registerW_registerZ_s010_simple */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0x48020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_registerW_registerZ_s037_double */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0xc8020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_registerW_registerZ_w064_triple */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0xc8020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0x58020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_registerM_registerZ_s010_simple */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0x40030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_registerM_registerZ_s037_double */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0xc0030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_registerM_registerZ_w064_triple */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0xc0030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0x50030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_registerW_registerZ_s010_simple */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0x41010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_registerW_registerZ_s037_double */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0xc1010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_registerW_registerZ_w064_triple */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0xc1010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0x51010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_registerW_registerZ_s010_simple */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0x42010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_registerW_registerZ_s037_double */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0xc2010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_registerW_registerZ_w064_triple */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0xc2010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0x52010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_registerW_registerZ_s010_simple */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0x49020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_registerW_registerZ_s037_double */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0xc9020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_registerW_registerZ_w064_triple */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0xc9020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0x59020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_registerW_registerZ_s010_simple */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0x44010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_registerW_registerZ_s037_double */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0xc4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_registerW_registerZ_w064_triple */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0xc4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0x54010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_registerW_registerZ_s010_simple */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0x47010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_registerW_registerZ_s037_double */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0xc7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_registerW_registerZ_w064_triple */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0xc7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0x57010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_registerM_registerZ_s010_simple */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0x43030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_registerM_registerZ_s037_double */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0xc3030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_registerM_registerZ_w064_triple */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0xc3030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0x53030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_registerW_registerZ_s010_simple */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0x4a020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_registerW_registerZ_s037_double */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0xca020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_registerW_registerZ_w064_triple */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0xca020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0x5a020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_registerM_registerZ_s010_simple */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0x42030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_registerM_registerZ_s037_double */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0xc2030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_registerM_registerZ_w064_triple */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0xc2030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0x52030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_registerW_registerZ_s010_simple */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0x45010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_registerW_registerZ_s037_double */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0xc5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_registerW_registerZ_w064_triple */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0xc5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0x55010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_registerW_registerZ_s010_simple */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0x46010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_registerW_registerZ_s037_double */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0xc6010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_registerW_registerZ_w064_triple */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0xc6010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0x56010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_registerW_registerZ_s010_simple */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0x4b020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_registerW_registerZ_s037_double */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0xcb020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_registerW_registerZ_w064_triple */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0xcb020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0x5b020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedd",
    .codewords = {
      {
        .opcode = 0x46030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDUD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedud",
    .codewords = {
      {
        .opcode = 0x47030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDUWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixeduwp",
    .codewords = {
      {
        .opcode = 0x4f030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDUW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixeduw",
    .codewords = {
      {
        .opcode = 0x4b030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedwp",
    .codewords = {
      {
        .opcode = 0x4e030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedw",
    .codewords = {
      {
        .opcode = 0x4a030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatd",
    .codewords = {
      {
        .opcode = 0x44030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATUD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatud",
    .codewords = {
      {
        .opcode = 0x45030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATUWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatuwp",
    .codewords = {
      {
        .opcode = 0x4d030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATUW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatuw",
    .codewords = {
      {
        .opcode = 0x49030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatwp",
    .codewords = {
      {
        .opcode = 0x4c030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatw",
    .codewords = {
      {
        .opcode = 0x48030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXD_registerW_registerZ_registerY_simple */
    .as_op = "fmaxd",
    .codewords = {
      {
        .opcode = 0x71038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXHQ_registerW_registerZ_registerY_simple */
    .as_op = "fmaxhq",
    .codewords = {
      {
        .opcode = 0x77038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXWP_registerW_registerZ_registerY_simple */
    .as_op = "fmaxwp",
    .codewords = {
      {
        .opcode = 0x75038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXW_registerW_registerZ_registerY_simple */
    .as_op = "fmaxw",
    .codewords = {
      {
        .opcode = 0x73038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMIND_registerW_registerZ_registerY_simple */
    .as_op = "fmind",
    .codewords = {
      {
        .opcode = 0x70038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMINHQ_registerW_registerZ_registerY_simple */
    .as_op = "fminhq",
    .codewords = {
      {
        .opcode = 0x76038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMINWP_registerW_registerZ_registerY_simple */
    .as_op = "fminwp",
    .codewords = {
      {
        .opcode = 0x74038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMINW_registerW_registerZ_registerY_simple */
    .as_op = "fminw",
    .codewords = {
      {
        .opcode = 0x72038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMM212W_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmm212w",
    .codewords = {
      {
        .opcode = 0x54070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA212W_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmma212w",
    .codewords = {
      {
        .opcode = 0x54030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW0_registerA0_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw0",
    .codewords = {
      {
        .opcode = 0x03000000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera0_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW1_registerA1_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw1",
    .codewords = {
      {
        .opcode = 0x03001000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera1_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW2_registerA2_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw2",
    .codewords = {
      {
        .opcode = 0x03040000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera2_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW3_registerA3_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw3",
    .codewords = {
      {
        .opcode = 0x03041000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera3_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMS212W_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmms212w",
    .codewords = {
      {
        .opcode = 0x56030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_registerW_registerZ_s010_simple */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0x48010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_registerW_registerZ_s037_double */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0xc8010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_registerW_registerZ_w064_triple */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0xc8010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0x58010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_registerW_registerZ_s010_simple */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0x4b010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_registerW_registerZ_s037_double */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0xcb010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_registerW_registerZ_w064_triple */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0xcb010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0x5b010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_registerM_registerZ_s010_simple */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0x41070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_registerM_registerZ_s037_double */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0xc1070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_registerM_registerZ_w064_triple */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0xc1070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0x51070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_registerW_registerZ_s010_simple */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0x4f020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_registerW_registerZ_s037_double */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0xcf020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_registerW_registerZ_w064_triple */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0xcf020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0x5f020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_registerW_registerZ_s010_simple */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0x4f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_registerW_registerZ_s037_double */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0xcf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_registerW_registerZ_w064_triple */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0xcf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0x5f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_registerW_registerZ_s010_simple */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0x4e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_registerW_registerZ_s037_double */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0xce010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_registerW_registerZ_w064_triple */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0xce010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0x5e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_registerM_registerZ_s010_simple */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0x43070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_registerM_registerZ_s037_double */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0xc3070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_registerM_registerZ_w064_triple */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0xc3070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0x53070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_registerM_registerZ_s010_simple */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0x42070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_registerM_registerZ_s037_double */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0xc2070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_registerM_registerZ_w064_triple */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0xc2070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0x52070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_registerM_registerZ_s010_simple */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0x40070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_registerM_registerZ_s037_double */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0xc0070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_registerM_registerZ_w064_triple */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0xc0070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0x50070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_registerW_registerZ_s010_simple */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0x49010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_registerW_registerZ_s037_double */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0xc9010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_registerW_registerZ_w064_triple */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0xc9010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0x59010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_registerW_registerZ_s010_simple */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0x4a010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_registerW_registerZ_s037_double */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0xca010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_registerW_registerZ_w064_triple */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0xca010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0x5a010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWQ_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fmulwq",
    .codewords = {
      {
        .opcode = 0x5e070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_registerW_registerZ_s010_simple */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0x4e020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_registerW_registerZ_s037_double */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0xce020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_registerW_registerZ_w064_triple */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0xce020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0x5e020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FNARROW44WH_xrounding_silent2_registerA_registerBp_simple */
    .as_op = "fnarrow44wh",
    .codewords = {
      {
        .opcode = 0x07000040,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_xrounding_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWDWP_rounding2_silent2_registerW_registerP_simple */
    .as_op = "fnarrowdwp",
    .codewords = {
      {
        .opcode = 0x7c036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWDW_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "fnarrowdw",
    .codewords = {
      {
        .opcode = 0x78036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWWHQ_rounding2_silent2_registerW_registerP_simple */
    .as_op = "fnarrowwhq",
    .codewords = {
      {
        .opcode = 0x7e036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWWH_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "fnarrowwh",
    .codewords = {
      {
        .opcode = 0x7a036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGD_registerW_registerZ_simple */
    .as_op = "fnegd",
    .codewords = {
      {
        .opcode = 0x70032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGHQ_registerW_registerZ_simple */
    .as_op = "fneghq",
    .codewords = {
      {
        .opcode = 0x76032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGWP_registerW_registerZ_simple */
    .as_op = "fnegwp",
    .codewords = {
      {
        .opcode = 0x74032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGW_registerW_registerZ_simple */
    .as_op = "fnegw",
    .codewords = {
      {
        .opcode = 0x72032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FRECW_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "frecw",
    .codewords = {
      {
        .opcode = 0x72036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FRSRW_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "frsrw",
    .codewords = {
      {
        .opcode = 0x73036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSBFDC.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfdc.c",
    .codewords = {
      {
        .opcode = 0x5f030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFDP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfdp",
    .codewords = {
      {
        .opcode = 0x5e030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_registerW_registerZ_s010_simple */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0x44020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_registerW_registerZ_s037_double */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0xc4020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_registerW_registerZ_w064_triple */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0xc4020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0x54020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_registerW_registerZ_s010_simple */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0x46020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_registerW_registerZ_s037_double */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0xc6020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_registerW_registerZ_w064_triple */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0xc6020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0x56020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_registerW_registerZ_s010_simple */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0x47020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_registerW_registerZ_s037_double */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0xc7020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_registerW_registerZ_w064_triple */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0xc7020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0x57020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWCP.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfwcp.c",
    .codewords = {
      {
        .opcode = 0x5b070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_registerW_registerZ_s010_simple */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0x45020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_registerW_registerZ_s037_double */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0xc5020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_registerW_registerZ_w064_triple */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0xc5020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0x55020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWQ_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfwq",
    .codewords = {
      {
        .opcode = 0x5a070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_registerW_registerZ_s010_simple */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0x4d020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_registerW_registerZ_s037_double */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0xcd020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_registerW_registerZ_w064_triple */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0xcd020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0x5d020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSCALEWV_xrounding_silent2_rectify_registerA_registerB_simple */
    .as_op = "fscalewv",
    .codewords = {
      {
        .opcode = 0x07000000,
        .mask = 0x7f000040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_xrounding_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_rectify_opnd,
      &kv3_v1_registera_opnd,
      &kv3_v1_registerb_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSDIVD_silent2_registerW_registerP_simple */
    .as_op = "fsdivd",
    .codewords = {
      {
        .opcode = 0x70035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSDIVWP_silent2_registerW_registerP_simple */
    .as_op = "fsdivwp",
    .codewords = {
      {
        .opcode = 0x74035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSDIVW_silent2_registerW_registerP_simple */
    .as_op = "fsdivw",
    .codewords = {
      {
        .opcode = 0x72035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRECD_silent2_registerW_registerZ_simple */
    .as_op = "fsrecd",
    .codewords = {
      {
        .opcode = 0x70034000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRECWP_silent2_registerW_registerZ_simple */
    .as_op = "fsrecwp",
    .codewords = {
      {
        .opcode = 0x74034000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRECW_silent2_registerW_registerZ_simple */
    .as_op = "fsrecw",
    .codewords = {
      {
        .opcode = 0x72034000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRSRD_registerW_registerZ_simple */
    .as_op = "fsrsrd",
    .codewords = {
      {
        .opcode = 0x78032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FSRSRWP_registerW_registerZ_simple */
    .as_op = "fsrsrwp",
    .codewords = {
      {
        .opcode = 0x7c032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FSRSRW_registerW_registerZ_simple */
    .as_op = "fsrsrw",
    .codewords = {
      {
        .opcode = 0x7a032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENLHWP_silent2_registerW_registerZ_simple */
    .as_op = "fwidenlhwp",
    .codewords = {
      {
        .opcode = 0x7c033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENLHW_silent2_registerW_registerZ_simple */
    .as_op = "fwidenlhw",
    .codewords = {
      {
        .opcode = 0x7a033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENLWD_silent2_registerW_registerZ_simple */
    .as_op = "fwidenlwd",
    .codewords = {
      {
        .opcode = 0x78033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENMHWP_silent2_registerW_registerZ_simple */
    .as_op = "fwidenmhwp",
    .codewords = {
      {
        .opcode = 0x7d033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENMHW_silent2_registerW_registerZ_simple */
    .as_op = "fwidenmhw",
    .codewords = {
      {
        .opcode = 0x7b033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENMWD_silent2_registerW_registerZ_simple */
    .as_op = "fwidenmwd",
    .codewords = {
      {
        .opcode = 0x79033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-GET_registerZ_systemS2_simple */
    .as_op = "get",
    .codewords = {
      {
        .opcode = 0x0fc40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems2_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-GET_registerZ_systemS3_simple */
    .as_op = "get",
    .codewords = {
      {
        .opcode = 0x0fc40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems3_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-GOTO_s027_simple */
    .as_op = "goto",
    .codewords = {
      {
        .opcode = 0x10000000,
        .mask = 0x78000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_pcrel27_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-I1INVALS_lsucond_registerY_registerZ_simple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0x3c5e0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_lsucond_registerY_s027_registerZ_double */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_lsucond_registerY_s054_registerZ_triple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_registerY_registerZ_simple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0x3c5ee000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_s010_registerZ_simple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0x3c5c0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_s037_registerZ_double */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_w064_registerZ_triple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVAL_simple */
    .as_op = "i1inval",
    .codewords = {
      {
        .opcode = 0x3f9d0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-ICALL_registerZ_simple */
    .as_op = "icall",
    .codewords = {
      {
        .opcode = 0x0fdc0000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-IGET_registerZ_simple */
    .as_op = "iget",
    .codewords = {
      {
        .opcode = 0x0fcc0000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-IGOTO_registerZ_simple */
    .as_op = "igoto",
    .codewords = {
      {
        .opcode = 0x0fd80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-INSF_registerW_registerZ_u006_u006_simple */
    .as_op = "insf",
    .codewords = {
      {
        .opcode = 0x60030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-LANDD_registerW_registerZ_registerY_simple */
    .as_op = "landd",
    .codewords = {
      {
        .opcode = 0x7c014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDD_splat32_registerW_registerZ_w032_double */
    .as_op = "landd",
    .codewords = {
      {
        .opcode = 0xfc014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDHQ_registerW_registerZ_registerY_simple */
    .as_op = "landhq",
    .codewords = {
      {
        .opcode = 0x7c017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "landhq",
    .codewords = {
      {
        .opcode = 0xfc017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDWP_registerW_registerZ_registerY_simple */
    .as_op = "landwp",
    .codewords = {
      {
        .opcode = 0x7c016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDWP_splat32_registerW_registerZ_w032_double */
    .as_op = "landwp",
    .codewords = {
      {
        .opcode = 0xfc016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDW_registerW_registerZ_registerY_simple */
    .as_op = "landw",
    .codewords = {
      {
        .opcode = 0x7c015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDW_registerW_registerZ_w032_double */
    .as_op = "landw",
    .codewords = {
      {
        .opcode = 0xfc015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LBS_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0x2402e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0x24020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_registerW_s010_registerZ_simple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0x24000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_registerW_s037_registerZ_double */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_registerW_w064_registerZ_triple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0x2002e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0x20020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_registerW_s010_registerZ_simple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0x20000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_registerW_s037_registerZ_double */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_registerW_w064_registerZ_triple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0x3802e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0x38020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_registerW_s010_registerZ_simple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0x38000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_registerW_s037_registerZ_double */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_registerW_w064_registerZ_triple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0x2c02e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0x2c020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_registerW_s010_registerZ_simple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0x2c000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_registerW_s037_registerZ_double */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_registerW_w064_registerZ_triple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0x2802e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0x28020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_registerW_s010_registerZ_simple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0x28000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_registerW_s037_registerZ_double */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_registerW_w064_registerZ_triple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LNANDD_registerW_registerZ_registerY_simple */
    .as_op = "lnandd",
    .codewords = {
      {
        .opcode = 0x7d014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDD_splat32_registerW_registerZ_w032_double */
    .as_op = "lnandd",
    .codewords = {
      {
        .opcode = 0xfd014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDHQ_registerW_registerZ_registerY_simple */
    .as_op = "lnandhq",
    .codewords = {
      {
        .opcode = 0x7d017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "lnandhq",
    .codewords = {
      {
        .opcode = 0xfd017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDWP_registerW_registerZ_registerY_simple */
    .as_op = "lnandwp",
    .codewords = {
      {
        .opcode = 0x7d016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDWP_splat32_registerW_registerZ_w032_double */
    .as_op = "lnandwp",
    .codewords = {
      {
        .opcode = 0xfd016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDW_registerW_registerZ_registerY_simple */
    .as_op = "lnandw",
    .codewords = {
      {
        .opcode = 0x7d015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDW_registerW_registerZ_w032_double */
    .as_op = "lnandw",
    .codewords = {
      {
        .opcode = 0xfd015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORD_registerW_registerZ_registerY_simple */
    .as_op = "lnord",
    .codewords = {
      {
        .opcode = 0x7f014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORD_splat32_registerW_registerZ_w032_double */
    .as_op = "lnord",
    .codewords = {
      {
        .opcode = 0xff014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORHQ_registerW_registerZ_registerY_simple */
    .as_op = "lnorhq",
    .codewords = {
      {
        .opcode = 0x7f017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "lnorhq",
    .codewords = {
      {
        .opcode = 0xff017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORWP_registerW_registerZ_registerY_simple */
    .as_op = "lnorwp",
    .codewords = {
      {
        .opcode = 0x7f016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORWP_splat32_registerW_registerZ_w032_double */
    .as_op = "lnorwp",
    .codewords = {
      {
        .opcode = 0xff016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORW_registerW_registerZ_registerY_simple */
    .as_op = "lnorw",
    .codewords = {
      {
        .opcode = 0x7f015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNORW_registerW_registerZ_w032_double */
    .as_op = "lnorw",
    .codewords = {
      {
        .opcode = 0xff015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LOOPDO_registerZ_s017_simple */
    .as_op = "loopdo",
    .codewords = {
      {
        .opcode = 0x0f000000,
        .mask = 0x7f800000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_pcrel17_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s, %s",
  },
  { /* Opcode-kv3_v1-LORD_registerW_registerZ_registerY_simple */
    .as_op = "lord",
    .codewords = {
      {
        .opcode = 0x7e014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORD_splat32_registerW_registerZ_w032_double */
    .as_op = "lord",
    .codewords = {
      {
        .opcode = 0xfe014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORHQ_registerW_registerZ_registerY_simple */
    .as_op = "lorhq",
    .codewords = {
      {
        .opcode = 0x7e017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "lorhq",
    .codewords = {
      {
        .opcode = 0xfe017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORWP_registerW_registerZ_registerY_simple */
    .as_op = "lorwp",
    .codewords = {
      {
        .opcode = 0x7e016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORWP_splat32_registerW_registerZ_w032_double */
    .as_op = "lorwp",
    .codewords = {
      {
        .opcode = 0xfe016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORW_registerW_registerZ_registerY_simple */
    .as_op = "lorw",
    .codewords = {
      {
        .opcode = 0x7e015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LORW_registerW_registerZ_w032_double */
    .as_op = "lorw",
    .codewords = {
      {
        .opcode = 0xfe015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LO_variant_doscale_registerN_registerY_registerZ_simple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0x3c06e000,
        .mask = 0x7c0fe000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_lsucond_registerY_registerN_registerZ_simple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0x3c060000,
        .mask = 0x7c0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_lsucond_registerY_registerN_s027_registerZ_double */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc060000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_lsucond_registerY_registerN_s054_registerZ_triple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc060000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_registerN_s010_registerZ_simple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0x3c040000,
        .mask = 0x7c0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_registerN_s037_registerZ_double */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc040000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_registerN_w064_registerZ_triple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc040000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_doscale_registerM_registerY_registerZ_simple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0x3c02e000,
        .mask = 0x7c07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_lsucond_registerY_registerM_registerZ_simple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0x3c020000,
        .mask = 0x7c070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_lsucond_registerY_registerM_s027_registerZ_double */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc020000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_lsucond_registerY_registerM_s054_registerZ_triple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc020000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_registerM_s010_registerZ_simple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0x3c000000,
        .mask = 0x7c070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_registerM_s037_registerZ_double */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc000000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_registerM_w064_registerZ_triple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc000000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0x3402e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0x34020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_registerW_s010_registerZ_simple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0x34000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_registerW_s037_registerZ_double */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_registerW_w064_registerZ_triple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0x3002e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0x30020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_registerW_s010_registerZ_simple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0x30000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_registerW_s037_registerZ_double */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_registerW_w064_registerZ_triple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_registerY_simple */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0x58001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_s010_simple */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0x48000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_s037_double */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0xc8000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_w064_triple */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0xc8000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_registerY_simple */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0x50000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_s010_simple */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0x40000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_s037_double */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0xc0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_w064_triple */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0xc0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_registerY_simple */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0x52000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_s010_simple */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0x42000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_s037_double */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0xc2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_w064_triple */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0xc2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHWQ_registerM_registerZ_registerY_simple */
    .as_op = "maddhwq",
    .codewords = {
      {
        .opcode = 0x50004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_registerY_simple */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0x5a001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_s010_simple */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0x4a000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_s037_double */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0xca000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_w064_triple */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0xca000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "maddsuhwq",
    .codewords = {
      {
        .opcode = 0x52004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUWDP_registerM_registerZ_registerY_simple */
    .as_op = "maddsuwdp",
    .codewords = {
      {
        .opcode = 0x5a000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUWD_registerW_registerZ_registerY_simple */
    .as_op = "maddsuwd",
    .codewords = {
      {
        .opcode = 0x52003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUWD_registerW_registerZ_w032_double */
    .as_op = "maddsuwd",
    .codewords = {
      {
        .opcode = 0xd2003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_registerY_simple */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0x59001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_s010_simple */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0x49000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_s037_double */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0xc9000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_w064_triple */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0xc9000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "madduhwq",
    .codewords = {
      {
        .opcode = 0x51004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUWDP_registerM_registerZ_registerY_simple */
    .as_op = "madduwdp",
    .codewords = {
      {
        .opcode = 0x59000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUWD_registerW_registerZ_registerY_simple */
    .as_op = "madduwd",
    .codewords = {
      {
        .opcode = 0x51003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUWD_registerW_registerZ_w032_double */
    .as_op = "madduwd",
    .codewords = {
      {
        .opcode = 0xd1003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_registerY_simple */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0x5b001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_s010_simple */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0x4b000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_s037_double */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0xcb000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_w064_triple */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0xcb000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWDP_registerM_registerZ_registerY_simple */
    .as_op = "maddwdp",
    .codewords = {
      {
        .opcode = 0x58000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWD_registerW_registerZ_registerY_simple */
    .as_op = "maddwd",
    .codewords = {
      {
        .opcode = 0x50003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWD_registerW_registerZ_w032_double */
    .as_op = "maddwd",
    .codewords = {
      {
        .opcode = 0xd0003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_registerY_simple */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0x51000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_s010_simple */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0x41000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_s037_double */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0xc1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_w064_triple */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0xc1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDW_registerW_registerZ_registerY_simple */
    .as_op = "maddw",
    .codewords = {
      {
        .opcode = 0x53003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDW_registerW_registerZ_w032_double */
    .as_op = "maddw",
    .codewords = {
      {
        .opcode = 0xd3003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAKE_registerW_s016_simple */
    .as_op = "make",
    .codewords = {
      {
        .opcode = 0x60000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed16_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-MAKE_registerW_s043_double */
    .as_op = "make",
    .codewords = {
      {
        .opcode = 0xe0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend6_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-MAKE_registerW_w064_triple */
    .as_op = "make",
    .codewords = {
      {
        .opcode = 0xe0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_registerY_simple */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0x73010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_s010_simple */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0x63000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_s037_double */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0xe3000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_w032_double */
    .as_op = "maxd.@",
    .codewords = {
      {
        .opcode = 0xf3010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_w064_triple */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0xe3000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXHQ_registerW_registerZ_registerY_simple */
    .as_op = "maxhq",
    .codewords = {
      {
        .opcode = 0x73013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "maxhq",
    .codewords = {
      {
        .opcode = 0xf3013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_registerY_simple */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0x77010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_s010_simple */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0x67000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_s037_double */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0xe7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_w032_double */
    .as_op = "maxud.@",
    .codewords = {
      {
        .opcode = 0xf7010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_w064_triple */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0xe7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUHQ_registerW_registerZ_registerY_simple */
    .as_op = "maxuhq",
    .codewords = {
      {
        .opcode = 0x77013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "maxuhq",
    .codewords = {
      {
        .opcode = 0xf7013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUWP_registerW_registerZ_registerY_simple */
    .as_op = "maxuwp",
    .codewords = {
      {
        .opcode = 0x77012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUWP_splat32_registerW_registerZ_w032_double */
    .as_op = "maxuwp",
    .codewords = {
      {
        .opcode = 0xf7012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUW_registerW_registerZ_registerY_simple */
    .as_op = "maxuw",
    .codewords = {
      {
        .opcode = 0x77011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUW_registerW_registerZ_s010_simple */
    .as_op = "maxuw",
    .codewords = {
      {
        .opcode = 0x77000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUW_registerW_registerZ_s037_double */
    .as_op = "maxuw",
    .codewords = {
      {
        .opcode = 0xf7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXWP_registerW_registerZ_registerY_simple */
    .as_op = "maxwp",
    .codewords = {
      {
        .opcode = 0x73012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXWP_splat32_registerW_registerZ_w032_double */
    .as_op = "maxwp",
    .codewords = {
      {
        .opcode = 0xf3012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXW_registerW_registerZ_registerY_simple */
    .as_op = "maxw",
    .codewords = {
      {
        .opcode = 0x73011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXW_registerW_registerZ_s010_simple */
    .as_op = "maxw",
    .codewords = {
      {
        .opcode = 0x73000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXW_registerW_registerZ_s037_double */
    .as_op = "maxw",
    .codewords = {
      {
        .opcode = 0xf3000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_registerY_simple */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0x72010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_s010_simple */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0x62000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_s037_double */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0xe2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_w032_double */
    .as_op = "mind.@",
    .codewords = {
      {
        .opcode = 0xf2010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_w064_triple */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0xe2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINHQ_registerW_registerZ_registerY_simple */
    .as_op = "minhq",
    .codewords = {
      {
        .opcode = 0x72013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "minhq",
    .codewords = {
      {
        .opcode = 0xf2013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_registerY_simple */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0x76010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_s010_simple */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0x66000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_s037_double */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0xe6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_w032_double */
    .as_op = "minud.@",
    .codewords = {
      {
        .opcode = 0xf6010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_w064_triple */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0xe6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUHQ_registerW_registerZ_registerY_simple */
    .as_op = "minuhq",
    .codewords = {
      {
        .opcode = 0x76013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "minuhq",
    .codewords = {
      {
        .opcode = 0xf6013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUWP_registerW_registerZ_registerY_simple */
    .as_op = "minuwp",
    .codewords = {
      {
        .opcode = 0x76012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUWP_splat32_registerW_registerZ_w032_double */
    .as_op = "minuwp",
    .codewords = {
      {
        .opcode = 0xf6012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUW_registerW_registerZ_registerY_simple */
    .as_op = "minuw",
    .codewords = {
      {
        .opcode = 0x76011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUW_registerW_registerZ_s010_simple */
    .as_op = "minuw",
    .codewords = {
      {
        .opcode = 0x76000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUW_registerW_registerZ_s037_double */
    .as_op = "minuw",
    .codewords = {
      {
        .opcode = 0xf6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINWP_registerW_registerZ_registerY_simple */
    .as_op = "minwp",
    .codewords = {
      {
        .opcode = 0x72012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINWP_splat32_registerW_registerZ_w032_double */
    .as_op = "minwp",
    .codewords = {
      {
        .opcode = 0xf2012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINW_registerW_registerZ_registerY_simple */
    .as_op = "minw",
    .codewords = {
      {
        .opcode = 0x72011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINW_registerW_registerZ_s010_simple */
    .as_op = "minw",
    .codewords = {
      {
        .opcode = 0x72000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINW_registerW_registerZ_s037_double */
    .as_op = "minw",
    .codewords = {
      {
        .opcode = 0xf2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MM212W_registerM_registerZ_registerY_simple */
    .as_op = "mm212w",
    .codewords = {
      {
        .opcode = 0x53001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MMA212W_registerM_registerZ_registerY_simple */
    .as_op = "mma212w",
    .codewords = {
      {
        .opcode = 0x5b000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444HBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444hbd0",
    .codewords = {
      {
        .opcode = 0x04000000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444HBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444hbd1",
    .codewords = {
      {
        .opcode = 0x04040000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444HD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444hd",
    .codewords = {
      {
        .opcode = 0x04080000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444SUHBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444suhbd0",
    .codewords = {
      {
        .opcode = 0x04002000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444SUHBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444suhbd1",
    .codewords = {
      {
        .opcode = 0x04042000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444SUHD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444suhd",
    .codewords = {
      {
        .opcode = 0x04082000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444UHBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444uhbd0",
    .codewords = {
      {
        .opcode = 0x04001000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444UHBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444uhbd1",
    .codewords = {
      {
        .opcode = 0x04041000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444UHD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444uhd",
    .codewords = {
      {
        .opcode = 0x04081000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444USHBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444ushbd0",
    .codewords = {
      {
        .opcode = 0x04003000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444USHBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444ushbd1",
    .codewords = {
      {
        .opcode = 0x04043000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444USHD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444ushd",
    .codewords = {
      {
        .opcode = 0x04083000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMS212W_registerM_registerZ_registerY_simple */
    .as_op = "mms212w",
    .codewords = {
      {
        .opcode = 0x5f000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MOVETQ_registerAE_registerZ_registerY_simple */
    .as_op = "movetq",
    .codewords = {
      {
        .opcode = 0x7f02e000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_CRWL,
    .format = {
      &kv3_v1_registerae_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MOVETQ_registerAO_registerZ_registerY_simple */
    .as_op = "movetq",
    .codewords = {
      {
        .opcode = 0x7f02f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_CRWH,
    .format = {
      &kv3_v1_registerao_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfdt",
    .codewords = {
      {
        .opcode = 0x5c001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFD_registerW_registerZ_registerY_simple */
    .as_op = "msbfd",
    .codewords = {
      {
        .opcode = 0x54000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFHQ_registerW_registerZ_registerY_simple */
    .as_op = "msbfhq",
    .codewords = {
      {
        .opcode = 0x56000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFHWQ_registerM_registerZ_registerY_simple */
    .as_op = "msbfhwq",
    .codewords = {
      {
        .opcode = 0x54004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfsudt",
    .codewords = {
      {
        .opcode = 0x5e001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "msbfsuhwq",
    .codewords = {
      {
        .opcode = 0x56004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUWDP_registerM_registerZ_registerY_simple */
    .as_op = "msbfsuwdp",
    .codewords = {
      {
        .opcode = 0x5e000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUWD_registerW_registerZ_registerY_simple */
    .as_op = "msbfsuwd",
    .codewords = {
      {
        .opcode = 0x56003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUWD_registerW_registerZ_w032_double */
    .as_op = "msbfsuwd",
    .codewords = {
      {
        .opcode = 0xd6003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfudt",
    .codewords = {
      {
        .opcode = 0x5d001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "msbfuhwq",
    .codewords = {
      {
        .opcode = 0x55004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUWDP_registerM_registerZ_registerY_simple */
    .as_op = "msbfuwdp",
    .codewords = {
      {
        .opcode = 0x5d000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUWD_registerW_registerZ_registerY_simple */
    .as_op = "msbfuwd",
    .codewords = {
      {
        .opcode = 0x55003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUWD_registerW_registerZ_w032_double */
    .as_op = "msbfuwd",
    .codewords = {
      {
        .opcode = 0xd5003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUZDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfuzdt",
    .codewords = {
      {
        .opcode = 0x5f001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWDP_registerM_registerZ_registerY_simple */
    .as_op = "msbfwdp",
    .codewords = {
      {
        .opcode = 0x5c000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWD_registerW_registerZ_registerY_simple */
    .as_op = "msbfwd",
    .codewords = {
      {
        .opcode = 0x54003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWD_registerW_registerZ_w032_double */
    .as_op = "msbfwd",
    .codewords = {
      {
        .opcode = 0xd4003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWP_registerW_registerZ_registerY_simple */
    .as_op = "msbfwp",
    .codewords = {
      {
        .opcode = 0x55000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFW_registerW_registerZ_registerY_simple */
    .as_op = "msbfw",
    .codewords = {
      {
        .opcode = 0x57003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFW_registerW_registerZ_w032_double */
    .as_op = "msbfw",
    .codewords = {
      {
        .opcode = 0xd7003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_registerY_simple */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0x58041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_s010_simple */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0x48040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_s037_double */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0xc8040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_w064_triple */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0xc8040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_registerY_simple */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0x54001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_s010_simple */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0x44000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_s037_double */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0xc4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_w064_triple */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0xc4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_registerY_simple */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0x56001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_s010_simple */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0x46000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_s037_double */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0xc6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_w064_triple */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0xc6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHWQ_registerM_registerZ_registerY_simple */
    .as_op = "mulhwq",
    .codewords = {
      {
        .opcode = 0x58004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_registerY_simple */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0x5a041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_s010_simple */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0x4a040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_s037_double */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0xca040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_w064_triple */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0xca040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "mulsuhwq",
    .codewords = {
      {
        .opcode = 0x5a004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUWDP_registerM_registerZ_registerY_simple */
    .as_op = "mulsuwdp",
    .codewords = {
      {
        .opcode = 0x52001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUWD_registerW_registerZ_registerY_simple */
    .as_op = "mulsuwd",
    .codewords = {
      {
        .opcode = 0x5a003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUWD_registerW_registerZ_w032_double */
    .as_op = "mulsuwd",
    .codewords = {
      {
        .opcode = 0xda003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_registerY_simple */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0x59041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_s010_simple */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0x49040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_s037_double */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0xc9040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_w064_triple */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0xc9040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "muluhwq",
    .codewords = {
      {
        .opcode = 0x59004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUWDP_registerM_registerZ_registerY_simple */
    .as_op = "muluwdp",
    .codewords = {
      {
        .opcode = 0x51001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUWD_registerW_registerZ_registerY_simple */
    .as_op = "muluwd",
    .codewords = {
      {
        .opcode = 0x59003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUWD_registerW_registerZ_w032_double */
    .as_op = "muluwd",
    .codewords = {
      {
        .opcode = 0xd9003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC.C_registerW_registerZ_registerY_simple */
    .as_op = "mulwc.c",
    .codewords = {
      {
        .opcode = 0x55002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_registerY_simple */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0x57001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_s010_simple */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0x47000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_s037_double */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0xc7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_w064_triple */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0xc7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDC.C_registerM_registerZ_registerY_simple */
    .as_op = "mulwdc.c",
    .codewords = {
      {
        .opcode = 0x57002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDC_registerM_registerZ_registerY_simple */
    .as_op = "mulwdc",
    .codewords = {
      {
        .opcode = 0x56002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDP_registerM_registerZ_registerY_simple */
    .as_op = "mulwdp",
    .codewords = {
      {
        .opcode = 0x50001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWD_registerW_registerZ_registerY_simple */
    .as_op = "mulwd",
    .codewords = {
      {
        .opcode = 0x58003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWD_registerW_registerZ_w032_double */
    .as_op = "mulwd",
    .codewords = {
      {
        .opcode = 0xd8003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_registerY_simple */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0x55001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_s010_simple */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0x45000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_s037_double */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0xc5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_w064_triple */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0xc5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWQ_registerM_registerP_registerO_simple */
    .as_op = "mulwq",
    .codewords = {
      {
        .opcode = 0x54002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULW_registerW_registerZ_registerY_simple */
    .as_op = "mulw",
    .codewords = {
      {
        .opcode = 0x5b003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULW_registerW_registerZ_w032_double */
    .as_op = "mulw",
    .codewords = {
      {
        .opcode = 0xdb003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_registerY_simple */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0x79010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_s010_simple */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0x69000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_s037_double */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0xe9000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_w032_double */
    .as_op = "nandd.@",
    .codewords = {
      {
        .opcode = 0xf9010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_w064_triple */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0xe9000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDW_registerW_registerZ_registerY_simple */
    .as_op = "nandw",
    .codewords = {
      {
        .opcode = 0x79011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDW_registerW_registerZ_s010_simple */
    .as_op = "nandw",
    .codewords = {
      {
        .opcode = 0x79000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDW_registerW_registerZ_s037_double */
    .as_op = "nandw",
    .codewords = {
      {
        .opcode = 0xf9000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NOP_simple */
    .as_op = "nop",
    .codewords = {
      {
        .opcode = 0x7f03f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_NOP, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_NOP,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-NORD_registerW_registerZ_registerY_simple */
    .as_op = "nord",
    .codewords = {
      {
        .opcode = 0x7b010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORD_registerW_registerZ_s010_simple */
    .as_op = "nord",
    .codewords = {
      {
        .opcode = 0x6b000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORD_registerW_registerZ_s037_double */
    .as_op = "nord",
    .codewords = {
      {
        .opcode = 0xeb000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORD_registerW_registerZ_w032_double */
    .as_op = "nord.@",
    .codewords = {
      {
        .opcode = 0xfb010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORD_registerW_registerZ_w064_triple */
    .as_op = "nord",
    .codewords = {
      {
        .opcode = 0xeb000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORW_registerW_registerZ_registerY_simple */
    .as_op = "norw",
    .codewords = {
      {
        .opcode = 0x7b011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORW_registerW_registerZ_s010_simple */
    .as_op = "norw",
    .codewords = {
      {
        .opcode = 0x7b000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NORW_registerW_registerZ_s037_double */
    .as_op = "norw",
    .codewords = {
      {
        .opcode = 0xfb000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORD_registerW_registerZ_registerY_simple */
    .as_op = "nxord",
    .codewords = {
      {
        .opcode = 0x7d010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORD_registerW_registerZ_s010_simple */
    .as_op = "nxord",
    .codewords = {
      {
        .opcode = 0x6d000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORD_registerW_registerZ_s037_double */
    .as_op = "nxord",
    .codewords = {
      {
        .opcode = 0xed000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORD_registerW_registerZ_w032_double */
    .as_op = "nxord.@",
    .codewords = {
      {
        .opcode = 0xfd010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORD_registerW_registerZ_w064_triple */
    .as_op = "nxord",
    .codewords = {
      {
        .opcode = 0xed000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORW_registerW_registerZ_registerY_simple */
    .as_op = "nxorw",
    .codewords = {
      {
        .opcode = 0x7d011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORW_registerW_registerZ_s010_simple */
    .as_op = "nxorw",
    .codewords = {
      {
        .opcode = 0x7d000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NXORW_registerW_registerZ_s037_double */
    .as_op = "nxorw",
    .codewords = {
      {
        .opcode = 0xfd000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORD_registerW_registerZ_registerY_simple */
    .as_op = "ord",
    .codewords = {
      {
        .opcode = 0x7a010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORD_registerW_registerZ_s010_simple */
    .as_op = "ord",
    .codewords = {
      {
        .opcode = 0x6a000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORD_registerW_registerZ_s037_double */
    .as_op = "ord",
    .codewords = {
      {
        .opcode = 0xea000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORD_registerW_registerZ_w032_double */
    .as_op = "ord.@",
    .codewords = {
      {
        .opcode = 0xfa010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORD_registerW_registerZ_w064_triple */
    .as_op = "ord",
    .codewords = {
      {
        .opcode = 0xea000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORND_registerW_registerZ_registerY_simple */
    .as_op = "ornd",
    .codewords = {
      {
        .opcode = 0x7f010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORND_registerW_registerZ_s010_simple */
    .as_op = "ornd",
    .codewords = {
      {
        .opcode = 0x6f000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORND_registerW_registerZ_s037_double */
    .as_op = "ornd",
    .codewords = {
      {
        .opcode = 0xef000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORND_registerW_registerZ_w032_double */
    .as_op = "ornd.@",
    .codewords = {
      {
        .opcode = 0xff010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORND_registerW_registerZ_w064_triple */
    .as_op = "ornd",
    .codewords = {
      {
        .opcode = 0xef000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORNW_registerW_registerZ_registerY_simple */
    .as_op = "ornw",
    .codewords = {
      {
        .opcode = 0x7f011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORNW_registerW_registerZ_s010_simple */
    .as_op = "ornw",
    .codewords = {
      {
        .opcode = 0x7f000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORNW_registerW_registerZ_s037_double */
    .as_op = "ornw",
    .codewords = {
      {
        .opcode = 0xff000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORW_registerW_registerZ_registerY_simple */
    .as_op = "orw",
    .codewords = {
      {
        .opcode = 0x7a011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORW_registerW_registerZ_s010_simple */
    .as_op = "orw",
    .codewords = {
      {
        .opcode = 0x7a000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ORW_registerW_registerZ_s037_double */
    .as_op = "orw",
    .codewords = {
      {
        .opcode = 0xfa000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-PCREL_registerW_s016_simple */
    .as_op = "pcrel",
    .codewords = {
      {
        .opcode = 0x70000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed16_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-PCREL_registerW_s043_double */
    .as_op = "pcrel",
    .codewords = {
      {
        .opcode = 0xf0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend6_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-PCREL_registerW_w064_triple */
    .as_op = "pcrel",
    .codewords = {
      {
        .opcode = 0xf0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-RET_simple */
    .as_op = "ret",
    .codewords = {
      {
        .opcode = 0x0fd00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-RFE_simple */
    .as_op = "rfe",
    .codewords = {
      {
        .opcode = 0x0fd40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-ROLWPS_registerW_registerZ_registerY_simple */
    .as_op = "rolwps",
    .codewords = {
      {
        .opcode = 0x7e028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ROLWPS_registerW_registerZ_u006_simple */
    .as_op = "rolwps",
    .codewords = {
      {
        .opcode = 0x7e024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ROLW_registerW_registerZ_registerY_simple */
    .as_op = "rolw",
    .codewords = {
      {
        .opcode = 0x7e027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ROLW_registerW_registerZ_u006_simple */
    .as_op = "rolw",
    .codewords = {
      {
        .opcode = 0x7e023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORWPS_registerW_registerZ_registerY_simple */
    .as_op = "rorwps",
    .codewords = {
      {
        .opcode = 0x7f028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORWPS_registerW_registerZ_u006_simple */
    .as_op = "rorwps",
    .codewords = {
      {
        .opcode = 0x7f024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORW_registerW_registerZ_registerY_simple */
    .as_op = "rorw",
    .codewords = {
      {
        .opcode = 0x7f027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORW_registerW_registerZ_u006_simple */
    .as_op = "rorw",
    .codewords = {
      {
        .opcode = 0x7f023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RSWAP_registerZ_systemAlone_simple */
    .as_op = "rswap",
    .codewords = {
      {
        .opcode = 0x0fc80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systemalone_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-RSWAP_registerZ_systemS3_simple */
    .as_op = "rswap",
    .codewords = {
      {
        .opcode = 0x0fc80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems3_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-RSWAP_registerZ_systemS4_simple */
    .as_op = "rswap",
    .codewords = {
      {
        .opcode = 0x0fc80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems4_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SATD_registerW_registerZ_registerY_simple */
    .as_op = "satd",
    .codewords = {
      {
        .opcode = 0x7e026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SATD_registerW_registerZ_u006_simple */
    .as_op = "satd",
    .codewords = {
      {
        .opcode = 0x7e022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD.I_registerW_registerZ_registerY_simple */
    .as_op = "sbfcd.i",
    .codewords = {
      {
        .opcode = 0x7f01d000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD.I_registerW_registerZ_w032_double */
    .as_op = "sbfcd.i",
    .codewords = {
      {
        .opcode = 0xff01d000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD_registerW_registerZ_registerY_simple */
    .as_op = "sbfcd",
    .codewords = {
      {
        .opcode = 0x7f01c000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD_registerW_registerZ_w032_double */
    .as_op = "sbfcd",
    .codewords = {
      {
        .opcode = 0xff01c000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_registerY_simple */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0x75010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_s010_simple */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0x65000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_s037_double */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0xe5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_w032_double */
    .as_op = "sbfd.@",
    .codewords = {
      {
        .opcode = 0xf5010800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_w064_triple */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0xe5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHCP.C_registerW_registerZ_registerY_simple */
    .as_op = "sbfhcp.c",
    .codewords = {
      {
        .opcode = 0x7d013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHCP.C_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfhcp.c",
    .codewords = {
      {
        .opcode = 0xfd013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfhq",
    .codewords = {
      {
        .opcode = 0x75013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfhq",
    .codewords = {
      {
        .opcode = 0xf5013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_registerY_simple */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0x7f01a000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_s010_simple */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0x6f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_s037_double */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0xef010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_w064_triple */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0xef010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSHQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfshq",
    .codewords = {
      {
        .opcode = 0x7f01f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSHQ_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfshq",
    .codewords = {
      {
        .opcode = 0xff01f000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSWP_registerW_registerZ_registerY_simple */
    .as_op = "sbfswp",
    .codewords = {
      {
        .opcode = 0x7f01e000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSWP_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfswp",
    .codewords = {
      {
        .opcode = 0xff01e000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSW_registerW_registerZ_registerY_simple */
    .as_op = "sbfsw",
    .codewords = {
      {
        .opcode = 0x7f01b000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSW_registerW_registerZ_w032_double */
    .as_op = "sbfsw",
    .codewords = {
      {
        .opcode = 0xff01b000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFUWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfuwd",
    .codewords = {
      {
        .opcode = 0x7b014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFUWD_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfuwd",
    .codewords = {
      {
        .opcode = 0xfb014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWC.C_registerW_registerZ_registerY_simple */
    .as_op = "sbfwc.c",
    .codewords = {
      {
        .opcode = 0x7d012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWC.C_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfwc.c",
    .codewords = {
      {
        .opcode = 0xfd012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfwd",
    .codewords = {
      {
        .opcode = 0x79014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWD_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfwd",
    .codewords = {
      {
        .opcode = 0xf9014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWP_registerW_registerZ_registerY_simple */
    .as_op = "sbfwp",
    .codewords = {
      {
        .opcode = 0x75012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWP_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfwp",
    .codewords = {
      {
        .opcode = 0xf5012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFW_registerW_registerZ_registerY_simple */
    .as_op = "sbfw",
    .codewords = {
      {
        .opcode = 0x75011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFW_registerW_registerZ_s010_simple */
    .as_op = "sbfw",
    .codewords = {
      {
        .opcode = 0x75000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFW_registerW_registerZ_s037_double */
    .as_op = "sbfw",
    .codewords = {
      {
        .opcode = 0xf5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16d",
    .codewords = {
      {
        .opcode = 0x77014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16D_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx16d",
    .codewords = {
      {
        .opcode = 0xf7014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16hq",
    .codewords = {
      {
        .opcode = 0x77017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx16hq",
    .codewords = {
      {
        .opcode = 0xf7017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16uwd",
    .codewords = {
      {
        .opcode = 0x7f018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx16uwd",
    .codewords = {
      {
        .opcode = 0xff018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16wd",
    .codewords = {
      {
        .opcode = 0x77018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WD_registerW_registerZ_w032_double */
    .as_op = "sbfx16wd",
    .codewords = {
      {
        .opcode = 0xf7018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16wp",
    .codewords = {
      {
        .opcode = 0x77016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WP_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx16wp",
    .codewords = {
      {
        .opcode = 0xf7016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16w",
    .codewords = {
      {
        .opcode = 0x77015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16W_registerW_registerZ_w032_double */
    .as_op = "sbfx16w",
    .codewords = {
      {
        .opcode = 0xf7015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2d",
    .codewords = {
      {
        .opcode = 0x71014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2D_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx2d",
    .codewords = {
      {
        .opcode = 0xf1014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2hq",
    .codewords = {
      {
        .opcode = 0x71017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx2hq",
    .codewords = {
      {
        .opcode = 0xf1017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2uwd",
    .codewords = {
      {
        .opcode = 0x79018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx2uwd",
    .codewords = {
      {
        .opcode = 0xf9018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2wd",
    .codewords = {
      {
        .opcode = 0x71018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WD_registerW_registerZ_w032_double */
    .as_op = "sbfx2wd",
    .codewords = {
      {
        .opcode = 0xf1018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2wp",
    .codewords = {
      {
        .opcode = 0x71016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WP_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx2wp",
    .codewords = {
      {
        .opcode = 0xf1016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2w",
    .codewords = {
      {
        .opcode = 0x71015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2W_registerW_registerZ_w032_double */
    .as_op = "sbfx2w",
    .codewords = {
      {
        .opcode = 0xf1015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4d",
    .codewords = {
      {
        .opcode = 0x73014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4D_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx4d",
    .codewords = {
      {
        .opcode = 0xf3014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4hq",
    .codewords = {
      {
        .opcode = 0x73017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx4hq",
    .codewords = {
      {
        .opcode = 0xf3017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4uwd",
    .codewords = {
      {
        .opcode = 0x7b018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx4uwd",
    .codewords = {
      {
        .opcode = 0xfb018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4wd",
    .codewords = {
      {
        .opcode = 0x73018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WD_registerW_registerZ_w032_double */
    .as_op = "sbfx4wd",
    .codewords = {
      {
        .opcode = 0xf3018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4wp",
    .codewords = {
      {
        .opcode = 0x73016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WP_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx4wp",
    .codewords = {
      {
        .opcode = 0xf3016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4w",
    .codewords = {
      {
        .opcode = 0x73015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4W_registerW_registerZ_w032_double */
    .as_op = "sbfx4w",
    .codewords = {
      {
        .opcode = 0xf3015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8d",
    .codewords = {
      {
        .opcode = 0x75014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8D_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx8d",
    .codewords = {
      {
        .opcode = 0xf5014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8hq",
    .codewords = {
      {
        .opcode = 0x75017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8HQ_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx8hq",
    .codewords = {
      {
        .opcode = 0xf5017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8uwd",
    .codewords = {
      {
        .opcode = 0x7d018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx8uwd",
    .codewords = {
      {
        .opcode = 0xfd018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8wd",
    .codewords = {
      {
        .opcode = 0x75018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WD_registerW_registerZ_w032_double */
    .as_op = "sbfx8wd",
    .codewords = {
      {
        .opcode = 0xf5018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8wp",
    .codewords = {
      {
        .opcode = 0x75016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WP_splat32_registerW_registerZ_w032_double */
    .as_op = "sbfx8wp",
    .codewords = {
      {
        .opcode = 0xf5016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_splat32_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8w",
    .codewords = {
      {
        .opcode = 0x75015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8W_registerW_registerZ_w032_double */
    .as_op = "sbfx8w",
    .codewords = {
      {
        .opcode = 0xf5015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_registerY_simple */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0x7e020000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_s010_simple */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0x6e020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_s037_double */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0xee020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_w032_double */
    .as_op = "sbmm8.@",
    .codewords = {
      {
        .opcode = 0xfe020800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_w064_triple */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0xee020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_registerY_simple */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0x7f020000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_s010_simple */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0x6f020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_s037_double */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0xef020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_w032_double */
    .as_op = "sbmmt8.@",
    .codewords = {
      {
        .opcode = 0xff020800,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_w064_triple */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0xef020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SB_doscale_registerY_registerZ_registerT_simple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0x2403e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0x24030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_s010_registerZ_registerT_simple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0x24010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_s037_registerZ_registerT_double */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_w064_registerZ_registerT_triple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SCALL_registerZ_simple */
    .as_op = "scall",
    .codewords = {
      {
        .opcode = 0x0fe40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-SCALL_u012_simple */
    .as_op = "scall",
    .codewords = {
      {
        .opcode = 0x0fe00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_sysnumber_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-SD_doscale_registerY_registerZ_registerT_simple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0x2703e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0x27030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_s010_registerZ_registerT_simple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0x27010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_s037_registerZ_registerT_double */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_w064_registerZ_registerT_triple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SET_systemAlone_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_systemalone_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SET_systemRA_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_systemra_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SET_systemT3_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_systemt3_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SET_systemT4_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_systemt4_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SH_doscale_registerY_registerZ_registerT_simple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0x2503e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0x25030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_s010_registerZ_registerT_simple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0x25010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_s037_registerZ_registerT_double */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_w064_registerZ_registerT_triple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SLEEP_simple */
    .as_op = "sleep",
    .codewords = {
      {
        .opcode = 0x0fa40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-SLLD_registerW_registerZ_registerY_simple */
    .as_op = "slld",
    .codewords = {
      {
        .opcode = 0x79026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLD_registerW_registerZ_u006_simple */
    .as_op = "slld",
    .codewords = {
      {
        .opcode = 0x79022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLHQS_registerW_registerZ_registerY_simple */
    .as_op = "sllhqs",
    .codewords = {
      {
        .opcode = 0x79029000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLHQS_registerW_registerZ_u006_simple */
    .as_op = "sllhqs",
    .codewords = {
      {
        .opcode = 0x79025000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLWPS_registerW_registerZ_registerY_simple */
    .as_op = "sllwps",
    .codewords = {
      {
        .opcode = 0x79028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLWPS_registerW_registerZ_u006_simple */
    .as_op = "sllwps",
    .codewords = {
      {
        .opcode = 0x79024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLW_registerW_registerZ_registerY_simple */
    .as_op = "sllw",
    .codewords = {
      {
        .opcode = 0x79027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLW_registerW_registerZ_u006_simple */
    .as_op = "sllw",
    .codewords = {
      {
        .opcode = 0x79023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSD_registerW_registerZ_registerY_simple */
    .as_op = "slsd",
    .codewords = {
      {
        .opcode = 0x7c026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSD_registerW_registerZ_u006_simple */
    .as_op = "slsd",
    .codewords = {
      {
        .opcode = 0x7c022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSHQS_registerW_registerZ_registerY_simple */
    .as_op = "slshqs",
    .codewords = {
      {
        .opcode = 0x7c029000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSHQS_registerW_registerZ_u006_simple */
    .as_op = "slshqs",
    .codewords = {
      {
        .opcode = 0x7c025000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSWPS_registerW_registerZ_registerY_simple */
    .as_op = "slswps",
    .codewords = {
      {
        .opcode = 0x7c028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSWPS_registerW_registerZ_u006_simple */
    .as_op = "slswps",
    .codewords = {
      {
        .opcode = 0x7c024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSW_registerW_registerZ_registerY_simple */
    .as_op = "slsw",
    .codewords = {
      {
        .opcode = 0x7c027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSW_registerW_registerZ_u006_simple */
    .as_op = "slsw",
    .codewords = {
      {
        .opcode = 0x7c023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SO_doscale_registerY_registerZ_registerV_simple */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0x2807e000,
        .mask = 0x7f0fe000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SO_lsucond_registerY_registerZ_registerV_simple */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0x28070000,
        .mask = 0x7f0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SO_lsucond_registerY_s027_registerZ_registerV_double */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0xa8070000,
        .mask = 0xff0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SO_lsucond_registerY_s054_registerZ_registerV_triple */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0xa8070000,
        .mask = 0xff0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SO_s010_registerZ_registerV_simple */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0x28050000,
        .mask = 0x7f0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SO_s037_registerZ_registerV_double */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0xa8050000,
        .mask = 0xff0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SO_w064_registerZ_registerV_triple */
    .as_op = "so",
    .codewords = {
      {
        .opcode = 0xa8050000,
        .mask = 0xff0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerv_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_doscale_registerY_registerZ_registerU_simple */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0x2803e000,
        .mask = 0x7f07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_lsucond_registerY_registerZ_registerU_simple */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0x28030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_lsucond_registerY_s027_registerZ_registerU_double */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0xa8030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_lsucond_registerY_s054_registerZ_registerU_triple */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0xa8030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_s010_registerZ_registerU_simple */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0x28010000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_s037_registerZ_registerU_double */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0xa8010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SQ_w064_registerZ_registerU_triple */
    .as_op = "sq",
    .codewords = {
      {
        .opcode = 0xa8010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SRAD_registerW_registerZ_registerY_simple */
    .as_op = "srad",
    .codewords = {
      {
        .opcode = 0x7a026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAD_registerW_registerZ_u006_simple */
    .as_op = "srad",
    .codewords = {
      {
        .opcode = 0x7a022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAHQS_registerW_registerZ_registerY_simple */
    .as_op = "srahqs",
    .codewords = {
      {
        .opcode = 0x7a029000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAHQS_registerW_registerZ_u006_simple */
    .as_op = "srahqs",
    .codewords = {
      {
        .opcode = 0x7a025000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAWPS_registerW_registerZ_registerY_simple */
    .as_op = "srawps",
    .codewords = {
      {
        .opcode = 0x7a028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAWPS_registerW_registerZ_u006_simple */
    .as_op = "srawps",
    .codewords = {
      {
        .opcode = 0x7a024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAW_registerW_registerZ_registerY_simple */
    .as_op = "sraw",
    .codewords = {
      {
        .opcode = 0x7a027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRAW_registerW_registerZ_u006_simple */
    .as_op = "sraw",
    .codewords = {
      {
        .opcode = 0x7a023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRLD_registerW_registerZ_registerY_simple */
    .as_op = "srld",
    .codewords = {
      {
        .opcode = 0x7b026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRLD_registerW_registerZ_u006_simple */
    .as_op = "srld",
    .codewords = {
      {
        .opcode = 0x7b022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRLHQS_registerW_registerZ_registerY_simple */
    .as_op = "srlhqs",
    .codewords = {
      {
        .opcode = 0x7b029000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRLHQS_registerW_registerZ_u006_simple */
    .as_op = "srlhqs",
    .codewords = {
      {
        .opcode = 0x7b025000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRLWPS_registerW_registerZ_registerY_simple */
    .as_op = "srlwps",
    .codewords = {
      {
        .opcode = 0x7b028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SRLWPS_registerW_registerZ_u006_simple */
    .as_op = "srlwps",
    .codewords = {
      {
        .