// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;

namespace NuGet.VisualStudio.Internal.Contracts
{
    public class PackageVulnerabilityMetadataContextInfo
    {
        public PackageVulnerabilityMetadataContextInfo(Uri advisoryUrl, int severity)
        {
            AdvisoryUrl = advisoryUrl;
            Severity = severity;
        }

        public Uri AdvisoryUrl { get; }
        public int Severity { get; }

        public override bool Equals(object obj)
        {
            var other = obj as PackageVulnerabilityMetadataContextInfo;

            return other != null && AdvisoryUrl.Equals(other.AdvisoryUrl) && Severity == other.Severity;
        }

        public override int GetHashCode()
        {
            return AdvisoryUrl.GetHashCode();
        }
    }
}
