#!/usr/bin/awk -f
# vim:ts=4:et
#
# (c) Robert Luberda, 2004
#
# Originally based on the part of /usr/bin/i2myspell
# by Lszl Nmeth from the libmyspell-dev package
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the BSD License (see http://www.opensource.org)
#

function deldups(s) {
    n = length(s)
    j = 1
    for( i = 1 ; i <= n ; i++ ) {
        a[j] = substr(s, i, 1)
        if (! have[ a[j] ]) {
            have[ a[j]] = 1;
            j++
        }
    }

    s =""
    for( i = 1 ; i < j ; i++ ) {
        s = s a[i];
        have[ a[i] ] = 0
    }
    return s
}

BEGIN {
    FS="/"
    OFS=""
}

{
    if (word == $1) {
        flags = flags $2
    } else {
        if (flags != "") {
            flags = "/" deldups(flags)
        }
        if (word != "") {  
            print word  flags
        }
        word = $1
        flags = $2
    }
}

END {
    if (flags != "") {
        flags = "/" deldups(flags)
    }
    if (word != "") {  
        print word flags
    }
}
