; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s

@ok = internal constant [4 x i8] c"%d\0A\00"
@no = internal constant [4 x i8] c"no\0A\00"

define i1 @test1(i32 %v1, i32 %v2) nounwind {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    jno .LBB0_1
; CHECK-NEXT:  # %bb.2: # %overflow
; CHECK-NEXT:    pushl $no
; CHECK-NEXT:    calll printf@PLT
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retl
; CHECK-NEXT:  .LBB0_1: # %normal
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    pushl $ok
; CHECK-NEXT:    calll printf@PLT
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retl
entry:
  %t = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %overflow, label %normal

normal:
  %t1 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @ok, i32 0, i32 0), i32 %sum ) nounwind
  ret i1 true

overflow:
  %t2 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @no, i32 0, i32 0) ) nounwind
  ret i1 false
}

define i1 @test2(i32 %v1, i32 %v2) nounwind {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    jno .LBB1_2
; CHECK-NEXT:  # %bb.1: # %overflow
; CHECK-NEXT:    pushl $no
; CHECK-NEXT:    calll printf@PLT
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retl
; CHECK-NEXT:  .LBB1_2: # %normal
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    pushl $ok
; CHECK-NEXT:    calll printf@PLT
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retl
entry:
  %t = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %overflow, label %normal

overflow:
  %t2 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @no, i32 0, i32 0) ) nounwind
  ret i1 false

normal:
  %t1 = tail call i32 (i8*, ...) @printf( i8* getelementptr ([4 x i8], [4 x i8]* @ok, i32 0, i32 0), i32 %sum ) nounwind
  ret i1 true
}

declare i32 @printf(i8*, ...) nounwind
declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32)

define i32 @test3(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    addl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    addl %eax, %eax
; CHECK-NEXT:    retl
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 %tmp0, i32 2)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}

define i32 @test4(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: test4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    addl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull $4, %eax, %eax
; CHECK-NEXT:    retl
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 %tmp0, i32 4)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}

declare { i63, i1 } @llvm.smul.with.overflow.i63(i63, i63) nounwind readnone

; Was returning false, should return true (not constant folded yet though).
; PR13991
define i1 @test5() nounwind {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retl
entry:
  %res = call { i63, i1 } @llvm.smul.with.overflow.i63(i63 4, i63 4611686018427387903)
  %sum = extractvalue { i63, i1 } %res, 0
  %overflow = extractvalue { i63, i1 } %res, 1
  ret i1 %overflow
}



declare { i129, i1 } @llvm.smul.with.overflow.i129(i129, i129)

define { i129, i1 } @smul_ovf(i129 %x, i129 %y) nounwind {
; CHECK-LABEL: smul_ovf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    pushl %edi
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    subl $164, %esp
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    andl $1, %eax
; CHECK-NEXT:    negl %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; CHECK-NEXT:    andl $1, %ebp
; CHECK-NEXT:    negl %ebp
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edx, %ebx
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    movl %eax, %esi
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %edx, %ecx
; CHECK-NEXT:    adcl $0, %ebx
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl %eax, %ecx
; CHECK-NEXT:    movl %ecx, %edi
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %edx, %ebx
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    addl %eax, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %cl, %eax
; CHECK-NEXT:    adcl %edx, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %ebx, %esi
; CHECK-NEXT:    adcl %eax, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    movl %ebp, %ebx
; CHECK-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movl %eax, %edi
; CHECK-NEXT:    movl %eax, %ebp
; CHECK-NEXT:    addl %edx, %ebp
; CHECK-NEXT:    adcl $0, %ecx
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl %eax, %ebp
; CHECK-NEXT:    adcl %edx, %ecx
; CHECK-NEXT:    setb %bl
; CHECK-NEXT:    addl %eax, %ecx
; CHECK-NEXT:    movzbl %bl, %eax
; CHECK-NEXT:    adcl %edx, %eax
; CHECK-NEXT:    addl %edi, %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl %ecx, %ebx
; CHECK-NEXT:    adcl $0, %ebx
; CHECK-NEXT:    movl %eax, %esi
; CHECK-NEXT:    movl %eax, %edx
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    setb %al
; CHECK-NEXT:    addl %edi, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %ebp, %esi
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    adcl %ecx, %eax
; CHECK-NEXT:    movl %eax, (%esp) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    addl %ecx, %ebx
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-NEXT:    mull %edi
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    addl %ebx, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %esi, %ecx
; CHECK-NEXT:    setb %bl
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    mull %edi
; CHECK-NEXT:    addl %ecx, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %bl, %eax
; CHECK-NEXT:    adcl %eax, %edx
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, %ebp
; CHECK-NEXT:    addl %ecx, %ebp
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; CHECK-NEXT:    mull %ebx
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    addl %ebp, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %esi, %edi
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %ebx
; CHECK-NEXT:    movl %eax, %esi
; CHECK-NEXT:    addl %edi, %esi
; CHECK-NEXT:    movzbl %cl, %eax
; CHECK-NEXT:    adcl %eax, %edx
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; CHECK-NEXT:    mull %ebx
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %ebx
; CHECK-NEXT:    movl %edx, %ebp
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    addl %edi, %ebx
; CHECK-NEXT:    adcl $0, %ebp
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-NEXT:    mull %edi
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    addl %ebx, %eax
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    adcl %ebp, %ecx
; CHECK-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %edi
; CHECK-NEXT:    movl %edx, %ebp
; CHECK-NEXT:    movl %eax, %edi
; CHECK-NEXT:    addl %ecx, %edi
; CHECK-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; CHECK-NEXT:    adcl %eax, %ebp
; CHECK-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    adcl $0, %ebp
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %esi
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    addl %ecx, %ebx
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    mull %ecx
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    addl %ebx, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %esi, %ecx
; CHECK-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    addl %ecx, %ebx
; CHECK-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; CHECK-NEXT:    adcl %eax, %edx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; CHECK-NEXT:    addl %edi, %ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    adcl %ebp, %esi
; CHECK-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; CHECK-NEXT:    adcl %eax, %ebx
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl $0, (%esp) # 4-byte Folded Spill
; CHECK-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; CHECK-NEXT:    mull %ecx
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %ecx
; CHECK-NEXT:    movl %eax, %ebp
; CHECK-NEXT:    addl %esi, %ebp
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    addl %ebx, %ebp
; CHECK-NEXT:    adcl %esi, %edi
; CHECK-NEXT:    setb %bl
; CHECK-NEXT:    addl %eax, %edi
; CHECK-NEXT:    movzbl %bl, %eax
; CHECK-NEXT:    adcl %edx, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %ecx
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %ecx
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    addl %eax, %ecx
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    addl %ebx, %ecx
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %eax, %edx
; CHECK-NEXT:    setb %bl
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %bl, %eax
; CHECK-NEXT:    adcl %esi, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    addl %edx, %esi
; CHECK-NEXT:    movl %ebp, %ebx
; CHECK-NEXT:    adcl %eax, %ebx
; CHECK-NEXT:    movl %edi, %ecx
; CHECK-NEXT:    adcl $0, %ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    adcl $0, %eax
; CHECK-NEXT:    addl %ecx, %esi
; CHECK-NEXT:    adcl %edx, %eax
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    movl %esi, %edx
; CHECK-NEXT:    adcl %ebp, %eax
; CHECK-NEXT:    movl %eax, %esi
; CHECK-NEXT:    movzbl %cl, %ecx
; CHECK-NEXT:    adcl %edi, %ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    addl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    adcl $0, %ecx
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    adcl $0, %eax
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl (%esp), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ecx, (%esp) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    mull {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    addl %edx, %ebx
; CHECK-NEXT:    movl %edx, %ebp
; CHECK-NEXT:    adcl $0, %ebp
; CHECK-NEXT:    addl %eax, %ebx
; CHECK-NEXT:    movl %ebx, %esi
; CHECK-NEXT:    adcl %edx, %ebp
; CHECK-NEXT:    setb %ch
; CHECK-NEXT:    addl %eax, %ebp
; CHECK-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %ch, %ecx
; CHECK-NEXT:    adcl %edx, %ecx
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %eax, %edi
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %ebp, %ebx
; CHECK-NEXT:    movl %esi, %edx
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %ecx, %esi
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    adcl $0, %eax
; CHECK-NEXT:    movl %ecx, %ebp
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %ecx
; CHECK-NEXT:    addl %edi, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %edx, %esi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    movl %edi, %ebx
; CHECK-NEXT:    adcl $0, %ebx
; CHECK-NEXT:    movl %ebp, %edx
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    addl %eax, %ebx
; CHECK-NEXT:    adcl %ecx, %edx
; CHECK-NEXT:    setb %al
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; CHECK-NEXT:    addl %ecx, %ebx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; CHECK-NEXT:    adcl %ebp, %edx
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    adcl %edi, %eax
; CHECK-NEXT:    movl %eax, %edi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    adcl $0, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl (%esp), %eax # 4-byte Reload
; CHECK-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; CHECK-NEXT:    adcl %eax, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; CHECK-NEXT:    mull %ebp
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %ebp
; CHECK-NEXT:    movl %ebp, %edi
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %esi, %ebx
; CHECK-NEXT:    movl %edx, %ebp
; CHECK-NEXT:    adcl $0, %ebp
; CHECK-NEXT:    addl %ecx, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %esi, %ebp
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    addl %eax, %ebp
; CHECK-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %cl, %eax
; CHECK-NEXT:    adcl %edx, %eax
; CHECK-NEXT:    movl %eax, (%esp) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %edi
; CHECK-NEXT:    movl %edx, %esi
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    mull %edi
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    movl %esi, %edx
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %esi, %ecx
; CHECK-NEXT:    movl %edi, %esi
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    addl %ebx, %ecx
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl %edx, %esi
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    addl %eax, %esi
; CHECK-NEXT:    movzbl %cl, %edx
; CHECK-NEXT:    adcl %edi, %edx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; CHECK-NEXT:    addl %esi, %ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    adcl %edx, %eax
; CHECK-NEXT:    movl %ebp, %edi
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    movl (%esp), %ebx # 4-byte Reload
; CHECK-NEXT:    movl %ebx, %ebp
; CHECK-NEXT:    adcl $0, %ebp
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    adcl $0, %edx
; CHECK-NEXT:    addl %edi, %esi
; CHECK-NEXT:    adcl %ebp, %edx
; CHECK-NEXT:    setb %al
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    addl %edi, %esi
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %ebx
; CHECK-NEXT:    movl %ebx, (%esp) # 4-byte Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull %edx, %eax
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull %edx, %eax
; CHECK-NEXT:    addl %ecx, %eax
; CHECK-NEXT:    movl %eax, %ecx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull %edx, %eax
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, %ebp
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    imull %edx, %eax
; CHECK-NEXT:    addl %ebp, %eax
; CHECK-NEXT:    movl %edi, %ebp
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    adcl %ecx, %eax
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, %edi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    imull %edx
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    addl %eax, %eax
; CHECK-NEXT:    adcl %edx, %ecx
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl %eax, %ebp
; CHECK-NEXT:    adcl %ecx, %edi
; CHECK-NEXT:    addl %esi, %ebx
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl (%esp), %edi # 4-byte Folded Reload
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, %esi
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %edx, %edi
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %edx, %esi
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    movl %ecx, %ebp
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl %eax, %esi
; CHECK-NEXT:    movl %esi, (%esp) # 4-byte Spill
; CHECK-NEXT:    adcl %edx, %edi
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    addl %eax, %edi
; CHECK-NEXT:    movzbl %cl, %ecx
; CHECK-NEXT:    adcl %edx, %ecx
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    addl %edi, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    adcl %ecx, %eax
; CHECK-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %edi
; CHECK-NEXT:    adcl $0, %ecx
; CHECK-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl %ebp, %esi
; CHECK-NEXT:    movl %ebp, %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movl %eax, %ebp
; CHECK-NEXT:    movl %eax, %ebx
; CHECK-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    addl %edx, %ebp
; CHECK-NEXT:    adcl $0, %ecx
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    mull {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl %eax, %ebp
; CHECK-NEXT:    adcl %edx, %ecx
; CHECK-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; CHECK-NEXT:    addl %eax, %ecx
; CHECK-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; CHECK-NEXT:    adcl %edx, %esi
; CHECK-NEXT:    movl %ebx, %edx
; CHECK-NEXT:    addl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    adcl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; CHECK-NEXT:    movl %ecx, %ebx
; CHECK-NEXT:    adcl $0, %ebx
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    adcl $0, %eax
; CHECK-NEXT:    addl %edi, %ebx
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; CHECK-NEXT:    addl %edx, %ebx
; CHECK-NEXT:    adcl %ebp, %eax
; CHECK-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 1-byte Folded Reload
; CHECK-NEXT:    adcl %ecx, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl $0, %esi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-NEXT:    imull %ecx, %edi
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; CHECK-NEXT:    movl %edi, %ebp
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-NEXT:    imull %ecx, %edi
; CHECK-NEXT:    addl %ebp, %edi
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; CHECK-NEXT:    imull %ecx, %ebp
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    imull {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    addl %ebp, %ecx
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl %edi, %ecx
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    addl %ebx, %ebp
; CHECK-NEXT:    movl %ebp, %ebx
; CHECK-NEXT:    adcl %eax, %edi
; CHECK-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl %esi, %ecx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; CHECK-NEXT:    movl (%esp), %eax # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; CHECK-NEXT:    movl %eax, (%esp) # 4-byte Spill
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    movl %ebp, %ebx
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; CHECK-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; CHECK-NEXT:    sarl $31, %eax
; CHECK-NEXT:    xorl %eax, %ebx
; CHECK-NEXT:    xorl %eax, %edx
; CHECK-NEXT:    orl %ebx, %edx
; CHECK-NEXT:    xorl %eax, %ebp
; CHECK-NEXT:    orl %edx, %ebp
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; CHECK-NEXT:    xorl %eax, %ebx
; CHECK-NEXT:    xorl %eax, %ecx
; CHECK-NEXT:    orl %ebx, %ecx
; CHECK-NEXT:    xorl %eax, %esi
; CHECK-NEXT:    orl %ecx, %esi
; CHECK-NEXT:    xorl %eax, %edi
; CHECK-NEXT:    xorl (%esp), %eax # 4-byte Folded Reload
; CHECK-NEXT:    orl %esi, %eax
; CHECK-NEXT:    orl %ebp, %eax
; CHECK-NEXT:    orl %edi, %eax
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; CHECK-NEXT:    movl %edi, %ecx
; CHECK-NEXT:    andl $1, %ecx
; CHECK-NEXT:    movl %ecx, %edx
; CHECK-NEXT:    negl %edx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; CHECK-NEXT:    xorl %edx, %ebx
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; CHECK-NEXT:    xorl %edx, %esi
; CHECK-NEXT:    orl %ebx, %esi
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; CHECK-NEXT:    xorl %edx, %ebx
; CHECK-NEXT:    orl %esi, %ebx
; CHECK-NEXT:    xorl %edi, %edx
; CHECK-NEXT:    orl %ebx, %edx
; CHECK-NEXT:    orl %eax, %edx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, 4(%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, (%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, 8(%eax)
; CHECK-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; CHECK-NEXT:    movl %edx, 12(%eax)
; CHECK-NEXT:    movb %cl, 16(%eax)
; CHECK-NEXT:    setne 20(%eax)
; CHECK-NEXT:    addl $164, %esp
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    popl %edi
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    retl $4
  %r = tail call { i129, i1 } @llvm.smul.with.overflow.i129(i129 %x, i129 %y)
  ret { i129, i1 } %r
}
