; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

;
; 32-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f32  (float)
declare   i8 @llvm.fptosi.sat.i8.f32  (float)
declare  i13 @llvm.fptosi.sat.i13.f32 (float)
declare  i16 @llvm.fptosi.sat.i16.f32 (float)
declare  i19 @llvm.fptosi.sat.i19.f32 (float)
declare  i32 @llvm.fptosi.sat.i32.f32 (float)
declare  i50 @llvm.fptosi.sat.i50.f32 (float)
declare  i64 @llvm.fptosi.sat.i64.f32 (float)
declare i100 @llvm.fptosi.sat.i100.f32(float)
declare i128 @llvm.fptosi.sat.i128.f32(float)

define i1 @test_signed_i1_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i1_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    csel w8, w8, wzr, lt
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    csinv w8, w8, wzr, ge
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
    %x = call i1 @llvm.fptosi.sat.i1.f32(float %f)
    ret i1 %x
}

define i8 @test_signed_i8_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i8_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    mov w8, #127
; CHECK-NEXT:    cmp w9, #127
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-128
; CHECK-NEXT:    cmn w8, #128
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i8 @llvm.fptosi.sat.i8.f32(float %f)
    ret i8 %x
}

define i13 @test_signed_i13_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i13_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    mov w8, #4095
; CHECK-NEXT:    cmp w9, #4095
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-4096
; CHECK-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i13 @llvm.fptosi.sat.i13.f32(float %f)
    ret i13 %x
}

define i16 @test_signed_i16_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i16_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov w9, #32767
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-32768
; CHECK-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i16 @llvm.fptosi.sat.i16.f32(float %f)
    ret i16 %x
}

define i19 @test_signed_i19_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i19_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov w9, #262143
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-262144
; CHECK-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i19 @llvm.fptosi.sat.i19.f32(float %f)
    ret i19 %x
}

define i32 @test_signed_i32_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i32_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f32(float %f)
    ret i32 %x
}

define i50 @test_signed_i50_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i50_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x8, s0
; CHECK-NEXT:    mov x9, #562949953421311
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    csel x8, x8, x9, lt
; CHECK-NEXT:    mov x9, #-562949953421312
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    csel x0, x8, x9, gt
; CHECK-NEXT:    ret
    %x = call i50 @llvm.fptosi.sat.i50.f32(float %f)
    ret i50 %x
}

define i64 @test_signed_i64_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i64_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, s0
; CHECK-NEXT:    ret
    %x = call i64 @llvm.fptosi.sat.i64.f32(float %f)
    ret i64 %x
}

define i100 @test_signed_i100_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i100_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    fmov s8, s0
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    movi v0.2s, #241, lsl #24
; CHECK-NEXT:    mov w8, #1895825407
; CHECK-NEXT:    mov x10, #34359738367
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov x8, #-34359738368
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    csel x8, x8, x1, lt
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    csel x8, x10, x8, gt
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    csel x0, xzr, x9, vs
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
    %x = call i100 @llvm.fptosi.sat.i100.f32(float %f)
    ret i100 %x
}

define i128 @test_signed_i128_f32(float %f) nounwind {
; CHECK-LABEL: test_signed_i128_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    fmov s8, s0
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    movi v0.2s, #255, lsl #24
; CHECK-NEXT:    mov w8, #2130706431
; CHECK-NEXT:    mov x10, #9223372036854775807
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov x8, #-9223372036854775808
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    csel x8, x8, x1, lt
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    csel x8, x10, x8, gt
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    csel x0, xzr, x9, vs
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
    %x = call i128 @llvm.fptosi.sat.i128.f32(float %f)
    ret i128 %x
}

;
; 64-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f64  (double)
declare   i8 @llvm.fptosi.sat.i8.f64  (double)
declare  i13 @llvm.fptosi.sat.i13.f64 (double)
declare  i16 @llvm.fptosi.sat.i16.f64 (double)
declare  i19 @llvm.fptosi.sat.i19.f64 (double)
declare  i32 @llvm.fptosi.sat.i32.f64 (double)
declare  i50 @llvm.fptosi.sat.i50.f64 (double)
declare  i64 @llvm.fptosi.sat.i64.f64 (double)
declare i100 @llvm.fptosi.sat.i100.f64(double)
declare i128 @llvm.fptosi.sat.i128.f64(double)

define i1 @test_signed_i1_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i1_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    csel w8, w8, wzr, lt
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    csinv w8, w8, wzr, ge
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
    %x = call i1 @llvm.fptosi.sat.i1.f64(double %f)
    ret i1 %x
}

define i8 @test_signed_i8_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i8_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, d0
; CHECK-NEXT:    mov w8, #127
; CHECK-NEXT:    cmp w9, #127
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-128
; CHECK-NEXT:    cmn w8, #128
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i8 @llvm.fptosi.sat.i8.f64(double %f)
    ret i8 %x
}

define i13 @test_signed_i13_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i13_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w9, d0
; CHECK-NEXT:    mov w8, #4095
; CHECK-NEXT:    cmp w9, #4095
; CHECK-NEXT:    csel w8, w9, w8, lt
; CHECK-NEXT:    mov w9, #-4096
; CHECK-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i13 @llvm.fptosi.sat.i13.f64(double %f)
    ret i13 %x
}

define i16 @test_signed_i16_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i16_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov w9, #32767
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-32768
; CHECK-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i16 @llvm.fptosi.sat.i16.f64(double %f)
    ret i16 %x
}

define i19 @test_signed_i19_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i19_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov w9, #262143
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    csel w8, w8, w9, lt
; CHECK-NEXT:    mov w9, #-262144
; CHECK-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-NEXT:    csel w0, w8, w9, gt
; CHECK-NEXT:    ret
    %x = call i19 @llvm.fptosi.sat.i19.f64(double %f)
    ret i19 %x
}

define i32 @test_signed_i32_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i32_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0
; CHECK-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f64(double %f)
    ret i32 %x
}

define i50 @test_signed_i50_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i50_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x8, d0
; CHECK-NEXT:    mov x9, #562949953421311
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    csel x8, x8, x9, lt
; CHECK-NEXT:    mov x9, #-562949953421312
; CHECK-NEXT:    cmp x8, x9
; CHECK-NEXT:    csel x0, x8, x9, gt
; CHECK-NEXT:    ret
    %x = call i50 @llvm.fptosi.sat.i50.f64(double %f)
    ret i50 %x
}

define i64 @test_signed_i64_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i64_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x0, d0
; CHECK-NEXT:    ret
    %x = call i64 @llvm.fptosi.sat.i64.f64(double %f)
    ret i64 %x
}

define i100 @test_signed_i100_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i100_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    fmov d8, d0
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    mov x8, #-4170333254945079296
; CHECK-NEXT:    mov x10, #34359738367
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    mov x8, #5053038781909696511
; CHECK-NEXT:    fcmp d8, d0
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    mov x8, #-34359738368
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    csel x8, x8, x1, lt
; CHECK-NEXT:    fcmp d8, d0
; CHECK-NEXT:    csel x8, x10, x8, gt
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    fcmp d8, d8
; CHECK-NEXT:    csel x0, xzr, x9, vs
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
    %x = call i100 @llvm.fptosi.sat.i100.f64(double %f)
    ret i100 %x
}

define i128 @test_signed_i128_f64(double %f) nounwind {
; CHECK-LABEL: test_signed_i128_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    fmov d8, d0
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    mov x8, #-4044232465378705408
; CHECK-NEXT:    mov x10, #9223372036854775807
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    mov x8, #5179139571476070399
; CHECK-NEXT:    fcmp d8, d0
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    mov x8, #-9223372036854775808
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    csel x8, x8, x1, lt
; CHECK-NEXT:    fcmp d8, d0
; CHECK-NEXT:    csel x8, x10, x8, gt
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    fcmp d8, d8
; CHECK-NEXT:    csel x0, xzr, x9, vs
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
    %x = call i128 @llvm.fptosi.sat.i128.f64(double %f)
    ret i128 %x
}

;
; 16-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f16  (half)
declare   i8 @llvm.fptosi.sat.i8.f16  (half)
declare  i13 @llvm.fptosi.sat.i13.f16 (half)
declare  i16 @llvm.fptosi.sat.i16.f16 (half)
declare  i19 @llvm.fptosi.sat.i19.f16 (half)
declare  i32 @llvm.fptosi.sat.i32.f16 (half)
declare  i50 @llvm.fptosi.sat.i50.f16 (half)
declare  i64 @llvm.fptosi.sat.i64.f16 (half)
declare i100 @llvm.fptosi.sat.i100.f16(half)
declare i128 @llvm.fptosi.sat.i128.f16(half)

define i1 @test_signed_i1_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i1_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs w8, s0
; CHECK-CVT-NEXT:    cmp w8, #0
; CHECK-CVT-NEXT:    csel w8, w8, wzr, lt
; CHECK-CVT-NEXT:    cmp w8, #0
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, ge
; CHECK-CVT-NEXT:    and w0, w8, #0x1
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i1_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w8, h0
; CHECK-FP16-NEXT:    cmp w8, #0
; CHECK-FP16-NEXT:    csel w8, w8, wzr, lt
; CHECK-FP16-NEXT:    cmp w8, #0
; CHECK-FP16-NEXT:    csinv w8, w8, wzr, ge
; CHECK-FP16-NEXT:    and w0, w8, #0x1
; CHECK-FP16-NEXT:    ret
    %x = call i1 @llvm.fptosi.sat.i1.f16(half %f)
    ret i1 %x
}

define i8 @test_signed_i8_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i8_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov w8, #127
; CHECK-CVT-NEXT:    fcvtzs w9, s0
; CHECK-CVT-NEXT:    cmp w9, #127
; CHECK-CVT-NEXT:    csel w8, w9, w8, lt
; CHECK-CVT-NEXT:    mov w9, #-128
; CHECK-CVT-NEXT:    cmn w8, #128
; CHECK-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i8_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w9, h0
; CHECK-FP16-NEXT:    mov w8, #127
; CHECK-FP16-NEXT:    cmp w9, #127
; CHECK-FP16-NEXT:    csel w8, w9, w8, lt
; CHECK-FP16-NEXT:    mov w9, #-128
; CHECK-FP16-NEXT:    cmn w8, #128
; CHECK-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-FP16-NEXT:    ret
    %x = call i8 @llvm.fptosi.sat.i8.f16(half %f)
    ret i8 %x
}

define i13 @test_signed_i13_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i13_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov w8, #4095
; CHECK-CVT-NEXT:    fcvtzs w9, s0
; CHECK-CVT-NEXT:    cmp w9, #4095
; CHECK-CVT-NEXT:    csel w8, w9, w8, lt
; CHECK-CVT-NEXT:    mov w9, #-4096
; CHECK-CVT-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i13_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w9, h0
; CHECK-FP16-NEXT:    mov w8, #4095
; CHECK-FP16-NEXT:    cmp w9, #4095
; CHECK-FP16-NEXT:    csel w8, w9, w8, lt
; CHECK-FP16-NEXT:    mov w9, #-4096
; CHECK-FP16-NEXT:    cmn w8, #1, lsl #12 // =4096
; CHECK-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-FP16-NEXT:    ret
    %x = call i13 @llvm.fptosi.sat.i13.f16(half %f)
    ret i13 %x
}

define i16 @test_signed_i16_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i16_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov w9, #32767
; CHECK-CVT-NEXT:    fcvtzs w8, s0
; CHECK-CVT-NEXT:    cmp w8, w9
; CHECK-CVT-NEXT:    csel w8, w8, w9, lt
; CHECK-CVT-NEXT:    mov w9, #-32768
; CHECK-CVT-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i16_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w8, h0
; CHECK-FP16-NEXT:    mov w9, #32767
; CHECK-FP16-NEXT:    cmp w8, w9
; CHECK-FP16-NEXT:    csel w8, w8, w9, lt
; CHECK-FP16-NEXT:    mov w9, #-32768
; CHECK-FP16-NEXT:    cmn w8, #8, lsl #12 // =32768
; CHECK-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-FP16-NEXT:    ret
    %x = call i16 @llvm.fptosi.sat.i16.f16(half %f)
    ret i16 %x
}

define i19 @test_signed_i19_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i19_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov w9, #262143
; CHECK-CVT-NEXT:    fcvtzs w8, s0
; CHECK-CVT-NEXT:    cmp w8, w9
; CHECK-CVT-NEXT:    csel w8, w8, w9, lt
; CHECK-CVT-NEXT:    mov w9, #-262144
; CHECK-CVT-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-CVT-NEXT:    csel w0, w8, w9, gt
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i19_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w8, h0
; CHECK-FP16-NEXT:    mov w9, #262143
; CHECK-FP16-NEXT:    cmp w8, w9
; CHECK-FP16-NEXT:    csel w8, w8, w9, lt
; CHECK-FP16-NEXT:    mov w9, #-262144
; CHECK-FP16-NEXT:    cmn w8, #64, lsl #12 // =262144
; CHECK-FP16-NEXT:    csel w0, w8, w9, gt
; CHECK-FP16-NEXT:    ret
    %x = call i19 @llvm.fptosi.sat.i19.f16(half %f)
    ret i19 %x
}

define i32 @test_signed_i32_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i32_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i32_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w0, h0
; CHECK-FP16-NEXT:    ret
    %x = call i32 @llvm.fptosi.sat.i32.f16(half %f)
    ret i32 %x
}

define i50 @test_signed_i50_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i50_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov x9, #562949953421311
; CHECK-CVT-NEXT:    fcvtzs x8, s0
; CHECK-CVT-NEXT:    cmp x8, x9
; CHECK-CVT-NEXT:    csel x8, x8, x9, lt
; CHECK-CVT-NEXT:    mov x9, #-562949953421312
; CHECK-CVT-NEXT:    cmp x8, x9
; CHECK-CVT-NEXT:    csel x0, x8, x9, gt
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i50_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x8, h0
; CHECK-FP16-NEXT:    mov x9, #562949953421311
; CHECK-FP16-NEXT:    cmp x8, x9
; CHECK-FP16-NEXT:    csel x8, x8, x9, lt
; CHECK-FP16-NEXT:    mov x9, #-562949953421312
; CHECK-FP16-NEXT:    cmp x8, x9
; CHECK-FP16-NEXT:    csel x0, x8, x9, gt
; CHECK-FP16-NEXT:    ret
    %x = call i50 @llvm.fptosi.sat.i50.f16(half %f)
    ret i50 %x
}

define i64 @test_signed_i64_f16(half %f) nounwind {
; CHECK-CVT-LABEL: test_signed_i64_f16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_signed_i64_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x0, h0
; CHECK-FP16-NEXT:    ret
    %x = call i64 @llvm.fptosi.sat.i64.f16(half %f)
    ret i64 %x
}

define i100 @test_signed_i100_f16(half %f) nounwind {
; CHECK-LABEL: test_signed_i100_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    fmov s0, s8
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    movi v0.2s, #241, lsl #24
; CHECK-NEXT:    mov w8, #1895825407
; CHECK-NEXT:    mov x10, #34359738367
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov x8, #-34359738368
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    csel x8, x8, x1, lt
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    csel x8, x10, x8, gt
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    csel x0, xzr, x9, vs
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
    %x = call i100 @llvm.fptosi.sat.i100.f16(half %f)
    ret i100 %x
}

define i128 @test_signed_i128_f16(half %f) nounwind {
; CHECK-LABEL: test_signed_i128_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    str x30, [sp, #8] // 8-byte Folded Spill
; CHECK-NEXT:    fmov s0, s8
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    movi v0.2s, #255, lsl #24
; CHECK-NEXT:    mov w8, #2130706431
; CHECK-NEXT:    mov x10, #9223372036854775807
; CHECK-NEXT:    ldr x30, [sp, #8] // 8-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov x8, #-9223372036854775808
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    csel x8, x8, x1, lt
; CHECK-NEXT:    fcmp s8, s0
; CHECK-NEXT:    csel x8, x10, x8, gt
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    csel x0, xzr, x9, vs
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
    %x = call i128 @llvm.fptosi.sat.i128.f16(half %f)
    ret i128 %x
}
