; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple armeb-eabi -mattr v7,neon -float-abi soft %s -o - | FileCheck %s -check-prefix SOFT
; RUN: llc -mtriple armeb-eabi -mattr v7,neon -float-abi hard %s -o - | FileCheck %s -check-prefix HARD

declare i64 @test_i64_f64_helper(double %p)
define void @test_i64_f64(double* %p, i64* %q) {
; SOFT-LABEL: test_i64_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_i64_f64_helper
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    strd r0, r1, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_i64_f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_i64_f64_helper
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    strd r0, r1, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load double, double* %p
    %2 = fadd double %1, %1
    %3 = call i64 @test_i64_f64_helper(double %2)
    %4 = add i64 %3, %3
    store i64 %4, i64* %q
    ret void
}

declare i64 @test_i64_v1i64_helper(<1 x i64> %p)
define void @test_i64_v1i64(<1 x i64>* %p, i64* %q) {
; SOFT-LABEL: test_i64_v1i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_i64_v1i64_helper
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    strd r0, r1, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_i64_v1i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 d0, d16, d16
; HARD-NEXT:    bl test_i64_v1i64_helper
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    strd r0, r1, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <1 x i64>, <1 x i64>* %p
    %2 = add <1 x i64> %1, %1
    %3 = call i64 @test_i64_v1i64_helper(<1 x i64> %2)
    %4 = add i64 %3, %3
    store i64 %4, i64* %q
    ret void
}

declare i64 @test_i64_v2f32_helper(<2 x float> %p)
define void @test_i64_v2f32(<2 x float>* %p, i64* %q) {
; SOFT-LABEL: test_i64_v2f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_i64_v2f32_helper
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    strd r0, r1, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_i64_v2f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_i64_v2f32_helper
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    strd r0, r1, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x float>, <2 x float>* %p
    %2 = fadd <2 x float> %1, %1
    %3 = call i64 @test_i64_v2f32_helper(<2 x float> %2)
    %4 = add i64 %3, %3
    store i64 %4, i64* %q
    ret void
}

declare i64 @test_i64_v2i32_helper(<2 x i32> %p)
define void @test_i64_v2i32(<2 x i32>* %p, i64* %q) {
; SOFT-LABEL: test_i64_v2i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_i64_v2i32_helper
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    strd r0, r1, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_i64_v2i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_i64_v2i32_helper
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    strd r0, r1, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i32>, <2 x i32>* %p
    %2 = add <2 x i32> %1, %1
    %3 = call i64 @test_i64_v2i32_helper(<2 x i32> %2)
    %4 = add i64 %3, %3
    store i64 %4, i64* %q
    ret void
}

declare i64 @test_i64_v4i16_helper(<4 x i16> %p)
define void @test_i64_v4i16(<4 x i16>* %p, i64* %q) {
; SOFT-LABEL: test_i64_v4i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_i64_v4i16_helper
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    strd r0, r1, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_i64_v4i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d0, d16
; HARD-NEXT:    bl test_i64_v4i16_helper
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    strd r0, r1, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i16>, <4 x i16>* %p
    %2 = add <4 x i16> %1, %1
    %3 = call i64 @test_i64_v4i16_helper(<4 x i16> %2)
    %4 = add i64 %3, %3
    store i64 %4, i64* %q
    ret void
}

declare i64 @test_i64_v8i8_helper(<8 x i8> %p)
define void @test_i64_v8i8(<8 x i8>* %p, i64* %q) {
; SOFT-LABEL: test_i64_v8i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_i64_v8i8_helper
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    strd r0, r1, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_i64_v8i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d0, d16
; HARD-NEXT:    bl test_i64_v8i8_helper
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    strd r0, r1, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i8>, <8 x i8>* %p
    %2 = add <8 x i8> %1, %1
    %3 = call i64 @test_i64_v8i8_helper(<8 x i8> %2)
    %4 = add i64 %3, %3
    store i64 %4, i64* %q
    ret void
}

declare double @test_f64_i64_helper(i64 %p)
define void @test_f64_i64(i64* %p, double* %q) {
; SOFT-LABEL: test_f64_i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldrd r0, r1, [r0]
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    bl test_f64_i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f64_i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    ldrd r0, r1, [r0]
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    bl test_f64_i64_helper
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load i64, i64* %p
    %2 = add i64 %1, %1
    %3 = call double @test_f64_i64_helper(i64 %2)
    %4 = fadd double %3, %3
    store double %4, double* %q
    ret void
}

declare double @test_f64_v1i64_helper(<1 x i64> %p)
define void @test_f64_v1i64(<1 x i64>* %p, double* %q) {
; SOFT-LABEL: test_f64_v1i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_f64_v1i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f64_v1i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 d0, d16, d16
; HARD-NEXT:    bl test_f64_v1i64_helper
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <1 x i64>, <1 x i64>* %p
    %2 = add <1 x i64> %1, %1
    %3 = call double @test_f64_v1i64_helper(<1 x i64> %2)
    %4 = fadd double %3, %3
    store double %4, double* %q
    ret void
}

declare double @test_f64_v2f32_helper(<2 x float> %p)
define void @test_f64_v2f32(<2 x float>* %p, double* %q) {
; SOFT-LABEL: test_f64_v2f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_f64_v2f32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f64_v2f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_f64_v2f32_helper
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x float>, <2 x float>* %p
    %2 = fadd <2 x float> %1, %1
    %3 = call double @test_f64_v2f32_helper(<2 x float> %2)
    %4 = fadd double %3, %3
    store double %4, double* %q
    ret void
}

declare double @test_f64_v2i32_helper(<2 x i32> %p)
define void @test_f64_v2i32(<2 x i32>* %p, double* %q) {
; SOFT-LABEL: test_f64_v2i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_f64_v2i32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f64_v2i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_f64_v2i32_helper
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i32>, <2 x i32>* %p
    %2 = add <2 x i32> %1, %1
    %3 = call double @test_f64_v2i32_helper(<2 x i32> %2)
    %4 = fadd double %3, %3
    store double %4, double* %q
    ret void
}

declare double @test_f64_v4i16_helper(<4 x i16> %p)
define void @test_f64_v4i16(<4 x i16>* %p, double* %q) {
; SOFT-LABEL: test_f64_v4i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_f64_v4i16_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f64_v4i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d0, d16
; HARD-NEXT:    bl test_f64_v4i16_helper
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i16>, <4 x i16>* %p
    %2 = add <4 x i16> %1, %1
    %3 = call double @test_f64_v4i16_helper(<4 x i16> %2)
    %4 = fadd double %3, %3
    store double %4, double* %q
    ret void
}

declare double @test_f64_v8i8_helper(<8 x i8> %p)
define void @test_f64_v8i8(<8 x i8>* %p, double* %q) {
; SOFT-LABEL: test_f64_v8i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_f64_v8i8_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f64_v8i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d0, d16
; HARD-NEXT:    bl test_f64_v8i8_helper
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i8>, <8 x i8>* %p
    %2 = add <8 x i8> %1, %1
    %3 = call double @test_f64_v8i8_helper(<8 x i8> %2)
    %4 = fadd double %3, %3
    store double %4, double* %q
    ret void
}

declare <1 x i64> @test_v1i64_i64_helper(i64 %p)
define void @test_v1i64_i64(i64* %p, <1 x i64>* %q) {
; SOFT-LABEL: test_v1i64_i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldrd r0, r1, [r0]
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    bl test_v1i64_i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v1i64_i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    ldrd r0, r1, [r0]
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    bl test_v1i64_i64_helper
; HARD-NEXT:    vadd.i64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load i64, i64* %p
    %2 = add i64 %1, %1
    %3 = call <1 x i64> @test_v1i64_i64_helper(i64 %2)
    %4 = add <1 x i64> %3, %3
    store <1 x i64> %4, <1 x i64>* %q
    ret void
}

declare <1 x i64> @test_v1i64_f64_helper(double %p)
define void @test_v1i64_f64(double* %p, <1 x i64>* %q) {
; SOFT-LABEL: test_v1i64_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v1i64_f64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v1i64_f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v1i64_f64_helper
; HARD-NEXT:    vadd.i64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load double, double* %p
    %2 = fadd double %1, %1
    %3 = call <1 x i64> @test_v1i64_f64_helper(double %2)
    %4 = add <1 x i64> %3, %3
    store <1 x i64> %4, <1 x i64>* %q
    ret void
}

declare <1 x i64> @test_v1i64_v2f32_helper(<2 x float> %p)
define void @test_v1i64_v2f32(<2 x float>* %p, <1 x i64>* %q) {
; SOFT-LABEL: test_v1i64_v2f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v1i64_v2f32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v1i64_v2f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v1i64_v2f32_helper
; HARD-NEXT:    vadd.i64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x float>, <2 x float>* %p
    %2 = fadd <2 x float> %1, %1
    %3 = call <1 x i64> @test_v1i64_v2f32_helper(<2 x float> %2)
    %4 = add <1 x i64> %3, %3
    store <1 x i64> %4, <1 x i64>* %q
    ret void
}

declare <1 x i64> @test_v1i64_v2i32_helper(<2 x i32> %p)
define void @test_v1i64_v2i32(<2 x i32>* %p, <1 x i64>* %q) {
; SOFT-LABEL: test_v1i64_v2i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v1i64_v2i32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v1i64_v2i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v1i64_v2i32_helper
; HARD-NEXT:    vadd.i64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i32>, <2 x i32>* %p
    %2 = add <2 x i32> %1, %1
    %3 = call <1 x i64> @test_v1i64_v2i32_helper(<2 x i32> %2)
    %4 = add <1 x i64> %3, %3
    store <1 x i64> %4, <1 x i64>* %q
    ret void
}

declare <1 x i64> @test_v1i64_v4i16_helper(<4 x i16> %p)
define void @test_v1i64_v4i16(<4 x i16>* %p, <1 x i64>* %q) {
; SOFT-LABEL: test_v1i64_v4i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v1i64_v4i16_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v1i64_v4i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d0, d16
; HARD-NEXT:    bl test_v1i64_v4i16_helper
; HARD-NEXT:    vadd.i64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i16>, <4 x i16>* %p
    %2 = add <4 x i16> %1, %1
    %3 = call <1 x i64> @test_v1i64_v4i16_helper(<4 x i16> %2)
    %4 = add <1 x i64> %3, %3
    store <1 x i64> %4, <1 x i64>* %q
    ret void
}

declare <1 x i64> @test_v1i64_v8i8_helper(<8 x i8> %p)
define void @test_v1i64_v8i8(<8 x i8>* %p, <1 x i64>* %q) {
; SOFT-LABEL: test_v1i64_v8i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v1i64_v8i8_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v1i64_v8i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d0, d16
; HARD-NEXT:    bl test_v1i64_v8i8_helper
; HARD-NEXT:    vadd.i64 d16, d0, d0
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i8>, <8 x i8>* %p
    %2 = add <8 x i8> %1, %1
    %3 = call <1 x i64> @test_v1i64_v8i8_helper(<8 x i8> %2)
    %4 = add <1 x i64> %3, %3
    store <1 x i64> %4, <1 x i64>* %q
    ret void
}

declare <2 x float> @test_v2f32_i64_helper(i64 %p)
define void @test_v2f32_i64(i64* %p, <2 x float>* %q) {
; SOFT-LABEL: test_v2f32_i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldrd r0, r1, [r0]
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    bl test_v2f32_i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f32_i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    ldrd r0, r1, [r0]
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    bl test_v2f32_i64_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load i64, i64* %p
    %2 = add i64 %1, %1
    %3 = call <2 x float> @test_v2f32_i64_helper(i64 %2)
    %4 = fadd <2 x float> %3, %3
    store <2 x float> %4, <2 x float>* %q
    ret void
}

declare <2 x float> @test_v2f32_f64_helper(double %p)
define void @test_v2f32_f64(double* %p, <2 x float>* %q) {
; SOFT-LABEL: test_v2f32_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2f32_f64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f32_f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v2f32_f64_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load double, double* %p
    %2 = fadd double %1, %1
    %3 = call <2 x float> @test_v2f32_f64_helper(double %2)
    %4 = fadd <2 x float> %3, %3
    store <2 x float> %4, <2 x float>* %q
    ret void
}

declare <2 x float> @test_v2f32_v1i64_helper(<1 x i64> %p)
define void @test_v2f32_v1i64(<1 x i64>* %p, <2 x float>* %q) {
; SOFT-LABEL: test_v2f32_v1i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2f32_v1i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f32_v1i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 d0, d16, d16
; HARD-NEXT:    bl test_v2f32_v1i64_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <1 x i64>, <1 x i64>* %p
    %2 = add <1 x i64> %1, %1
    %3 = call <2 x float> @test_v2f32_v1i64_helper(<1 x i64> %2)
    %4 = fadd <2 x float> %3, %3
    store <2 x float> %4, <2 x float>* %q
    ret void
}

declare <2 x float> @test_v2f32_v2i32_helper(<2 x i32> %p)
define void @test_v2f32_v2i32(<2 x i32>* %p, <2 x float>* %q) {
; SOFT-LABEL: test_v2f32_v2i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2f32_v2i32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f32_v2i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v2f32_v2i32_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i32>, <2 x i32>* %p
    %2 = add <2 x i32> %1, %1
    %3 = call <2 x float> @test_v2f32_v2i32_helper(<2 x i32> %2)
    %4 = fadd <2 x float> %3, %3
    store <2 x float> %4, <2 x float>* %q
    ret void
}

declare <2 x float> @test_v2f32_v4i16_helper(<4 x i16> %p)
define void @test_v2f32_v4i16(<4 x i16>* %p, <2 x float>* %q) {
; SOFT-LABEL: test_v2f32_v4i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2f32_v4i16_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f32_v4i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d0, d16
; HARD-NEXT:    bl test_v2f32_v4i16_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i16>, <4 x i16>* %p
    %2 = add <4 x i16> %1, %1
    %3 = call <2 x float> @test_v2f32_v4i16_helper(<4 x i16> %2)
    %4 = fadd <2 x float> %3, %3
    store <2 x float> %4, <2 x float>* %q
    ret void
}

declare <2 x float> @test_v2f32_v8i8_helper(<8 x i8> %p)
define void @test_v2f32_v8i8(<8 x i8>* %p, <2 x float>* %q) {
; SOFT-LABEL: test_v2f32_v8i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2f32_v8i8_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f32_v8i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d0, d16
; HARD-NEXT:    bl test_v2f32_v8i8_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i8>, <8 x i8>* %p
    %2 = add <8 x i8> %1, %1
    %3 = call <2 x float> @test_v2f32_v8i8_helper(<8 x i8> %2)
    %4 = fadd <2 x float> %3, %3
    store <2 x float> %4, <2 x float>* %q
    ret void
}

declare <2 x i32> @test_v2i32_i64_helper(i64 %p)
define void @test_v2i32_i64(i64* %p, <2 x i32>* %q) {
; SOFT-LABEL: test_v2i32_i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldrd r0, r1, [r0]
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    bl test_v2i32_i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i32_i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    ldrd r0, r1, [r0]
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    bl test_v2i32_i64_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load i64, i64* %p
    %2 = add i64 %1, %1
    %3 = call <2 x i32> @test_v2i32_i64_helper(i64 %2)
    %4 = add <2 x i32> %3, %3
    store <2 x i32> %4, <2 x i32>* %q
    ret void
}

declare <2 x i32> @test_v2i32_f64_helper(double %p)
define void @test_v2i32_f64(double* %p, <2 x i32>* %q) {
; SOFT-LABEL: test_v2i32_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2i32_f64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i32_f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v2i32_f64_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load double, double* %p
    %2 = fadd double %1, %1
    %3 = call <2 x i32> @test_v2i32_f64_helper(double %2)
    %4 = add <2 x i32> %3, %3
    store <2 x i32> %4, <2 x i32>* %q
    ret void
}

declare <2 x i32> @test_v2i32_v1i64_helper(<1 x i64> %p)
define void @test_v2i32_v1i64(<1 x i64>* %p, <2 x i32>* %q) {
; SOFT-LABEL: test_v2i32_v1i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2i32_v1i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i32_v1i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 d0, d16, d16
; HARD-NEXT:    bl test_v2i32_v1i64_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <1 x i64>, <1 x i64>* %p
    %2 = add <1 x i64> %1, %1
    %3 = call <2 x i32> @test_v2i32_v1i64_helper(<1 x i64> %2)
    %4 = add <2 x i32> %3, %3
    store <2 x i32> %4, <2 x i32>* %q
    ret void
}

declare <2 x i32> @test_v2i32_v2f32_helper(<2 x float> %p)
define void @test_v2i32_v2f32(<2 x float>* %p, <2 x i32>* %q) {
; SOFT-LABEL: test_v2i32_v2f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2i32_v2f32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i32_v2f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v2i32_v2f32_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x float>, <2 x float>* %p
    %2 = fadd <2 x float> %1, %1
    %3 = call <2 x i32> @test_v2i32_v2f32_helper(<2 x float> %2)
    %4 = add <2 x i32> %3, %3
    store <2 x i32> %4, <2 x i32>* %q
    ret void
}

declare <2 x i32> @test_v2i32_v4i16_helper(<4 x i16> %p)
define void @test_v2i32_v4i16(<4 x i16>* %p, <2 x i32>* %q) {
; SOFT-LABEL: test_v2i32_v4i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2i32_v4i16_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i32_v4i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d0, d16
; HARD-NEXT:    bl test_v2i32_v4i16_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i16>, <4 x i16>* %p
    %2 = add <4 x i16> %1, %1
    %3 = call <2 x i32> @test_v2i32_v4i16_helper(<4 x i16> %2)
    %4 = add <2 x i32> %3, %3
    store <2 x i32> %4, <2 x i32>* %q
    ret void
}

declare <2 x i32> @test_v2i32_v8i8_helper(<8 x i8> %p)
define void @test_v2i32_v8i8(<8 x i8>* %p, <2 x i32>* %q) {
; SOFT-LABEL: test_v2i32_v8i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v2i32_v8i8_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i32_v8i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d0, d16
; HARD-NEXT:    bl test_v2i32_v8i8_helper
; HARD-NEXT:    vrev64.32 d16, d0
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i8>, <8 x i8>* %p
    %2 = add <8 x i8> %1, %1
    %3 = call <2 x i32> @test_v2i32_v8i8_helper(<8 x i8> %2)
    %4 = add <2 x i32> %3, %3
    store <2 x i32> %4, <2 x i32>* %q
    ret void
}

declare <4 x i16> @test_v4i16_i64_helper(i64 %p)
define void @test_v4i16_i64(i64* %p, <4 x i16>* %q) {
; SOFT-LABEL: test_v4i16_i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldrd r0, r1, [r0]
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    bl test_v4i16_i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i16_i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    ldrd r0, r1, [r0]
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    bl test_v4i16_i64_helper
; HARD-NEXT:    vrev64.16 d16, d0
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load i64, i64* %p
    %2 = add i64 %1, %1
    %3 = call <4 x i16> @test_v4i16_i64_helper(i64 %2)
    %4 = add <4 x i16> %3, %3
    store <4 x i16> %4, <4 x i16>* %q
    ret void
}

declare <4 x i16> @test_v4i16_f64_helper(double %p)
define void @test_v4i16_f64(double* %p, <4 x i16>* %q) {
; SOFT-LABEL: test_v4i16_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v4i16_f64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i16_f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v4i16_f64_helper
; HARD-NEXT:    vrev64.16 d16, d0
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load double, double* %p
    %2 = fadd double %1, %1
    %3 = call <4 x i16> @test_v4i16_f64_helper(double %2)
    %4 = add <4 x i16> %3, %3
    store <4 x i16> %4, <4 x i16>* %q
    ret void
}

declare <4 x i16> @test_v4i16_v1i64_helper(<1 x i64> %p)
define void @test_v4i16_v1i64(<1 x i64>* %p, <4 x i16>* %q) {
; SOFT-LABEL: test_v4i16_v1i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v4i16_v1i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i16_v1i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 d0, d16, d16
; HARD-NEXT:    bl test_v4i16_v1i64_helper
; HARD-NEXT:    vrev64.16 d16, d0
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <1 x i64>, <1 x i64>* %p
    %2 = add <1 x i64> %1, %1
    %3 = call <4 x i16> @test_v4i16_v1i64_helper(<1 x i64> %2)
    %4 = add <4 x i16> %3, %3
    store <4 x i16> %4, <4 x i16>* %q
    ret void
}

declare <4 x i16> @test_v4i16_v2f32_helper(<2 x float> %p)
define void @test_v4i16_v2f32(<2 x float>* %p, <4 x i16>* %q) {
; SOFT-LABEL: test_v4i16_v2f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v4i16_v2f32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i16_v2f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v4i16_v2f32_helper
; HARD-NEXT:    vrev64.16 d16, d0
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x float>, <2 x float>* %p
    %2 = fadd <2 x float> %1, %1
    %3 = call <4 x i16> @test_v4i16_v2f32_helper(<2 x float> %2)
    %4 = add <4 x i16> %3, %3
    store <4 x i16> %4, <4 x i16>* %q
    ret void
}

declare <4 x i16> @test_v4i16_v2i32_helper(<2 x i32> %p)
define void @test_v4i16_v2i32(<2 x i32>* %p, <4 x i16>* %q) {
; SOFT-LABEL: test_v4i16_v2i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v4i16_v2i32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i16_v2i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v4i16_v2i32_helper
; HARD-NEXT:    vrev64.16 d16, d0
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i32>, <2 x i32>* %p
    %2 = add <2 x i32> %1, %1
    %3 = call <4 x i16> @test_v4i16_v2i32_helper(<2 x i32> %2)
    %4 = add <4 x i16> %3, %3
    store <4 x i16> %4, <4 x i16>* %q
    ret void
}

declare <4 x i16> @test_v4i16_v8i8_helper(<8 x i8> %p)
define void @test_v4i16_v8i8(<8 x i8>* %p, <4 x i16>* %q) {
; SOFT-LABEL: test_v4i16_v8i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v4i16_v8i8_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i16_v8i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d0, d16
; HARD-NEXT:    bl test_v4i16_v8i8_helper
; HARD-NEXT:    vrev64.16 d16, d0
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i8>, <8 x i8>* %p
    %2 = add <8 x i8> %1, %1
    %3 = call <4 x i16> @test_v4i16_v8i8_helper(<8 x i8> %2)
    %4 = add <4 x i16> %3, %3
    store <4 x i16> %4, <4 x i16>* %q
    ret void
}

declare <8 x i8> @test_v8i8_i64_helper(i64 %p)
define void @test_v8i8_i64(i64* %p, <8 x i8>* %q) {
; SOFT-LABEL: test_v8i8_i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldrd r0, r1, [r0]
; SOFT-NEXT:    adds r1, r1, r1
; SOFT-NEXT:    adc r0, r0, r0
; SOFT-NEXT:    bl test_v8i8_i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i8_i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    ldrd r0, r1, [r0]
; HARD-NEXT:    adds r1, r1, r1
; HARD-NEXT:    adc r0, r0, r0
; HARD-NEXT:    bl test_v8i8_i64_helper
; HARD-NEXT:    vrev64.8 d16, d0
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load i64, i64* %p
    %2 = add i64 %1, %1
    %3 = call <8 x i8> @test_v8i8_i64_helper(i64 %2)
    %4 = add <8 x i8> %3, %3
    store <8 x i8> %4, <8 x i8>* %q
    ret void
}

declare <8 x i8> @test_v8i8_f64_helper(double %p)
define void @test_v8i8_f64(double* %p, <8 x i8>* %q) {
; SOFT-LABEL: test_v8i8_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v8i8_f64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i8_f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v8i8_f64_helper
; HARD-NEXT:    vrev64.8 d16, d0
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load double, double* %p
    %2 = fadd double %1, %1
    %3 = call <8 x i8> @test_v8i8_f64_helper(double %2)
    %4 = add <8 x i8> %3, %3
    store <8 x i8> %4, <8 x i8>* %q
    ret void
}

declare <8 x i8> @test_v8i8_v1i64_helper(<1 x i64> %p)
define void @test_v8i8_v1i64(<1 x i64>* %p, <8 x i8>* %q) {
; SOFT-LABEL: test_v8i8_v1i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 d16, d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v8i8_v1i64_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i8_v1i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 d0, d16, d16
; HARD-NEXT:    bl test_v8i8_v1i64_helper
; HARD-NEXT:    vrev64.8 d16, d0
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <1 x i64>, <1 x i64>* %p
    %2 = add <1 x i64> %1, %1
    %3 = call <8 x i8> @test_v8i8_v1i64_helper(<1 x i64> %2)
    %4 = add <8 x i8> %3, %3
    store <8 x i8> %4, <8 x i8>* %q
    ret void
}

declare <8 x i8> @test_v8i8_v2f32_helper(<2 x float> %p)
define void @test_v8i8_v2f32(<2 x float>* %p, <8 x i8>* %q) {
; SOFT-LABEL: test_v8i8_v2f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.f32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v8i8_v2f32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i8_v2f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.f32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v8i8_v2f32_helper
; HARD-NEXT:    vrev64.8 d16, d0
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x float>, <2 x float>* %p
    %2 = fadd <2 x float> %1, %1
    %3 = call <8 x i8> @test_v8i8_v2f32_helper(<2 x float> %2)
    %4 = add <8 x i8> %3, %3
    store <8 x i8> %4, <8 x i8>* %q
    ret void
}

declare <8 x i8> @test_v8i8_v2i32_helper(<2 x i32> %p)
define void @test_v8i8_v2i32(<2 x i32>* %p, <8 x i8>* %q) {
; SOFT-LABEL: test_v8i8_v2i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vadd.i32 d16, d16, d16
; SOFT-NEXT:    vrev64.32 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v8i8_v2i32_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i8_v2i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 d16, d16
; HARD-NEXT:    vadd.i32 d16, d16, d16
; HARD-NEXT:    vrev64.32 d0, d16
; HARD-NEXT:    bl test_v8i8_v2i32_helper
; HARD-NEXT:    vrev64.8 d16, d0
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i32>, <2 x i32>* %p
    %2 = add <2 x i32> %1, %1
    %3 = call <8 x i8> @test_v8i8_v2i32_helper(<2 x i32> %2)
    %4 = add <8 x i8> %3, %3
    store <8 x i8> %4, <8 x i8>* %q
    ret void
}

declare <8 x i8> @test_v8i8_v4i16_helper(<4 x i16> %p)
define void @test_v8i8_v4i16(<4 x i16>* %p, <8 x i8>* %q) {
; SOFT-LABEL: test_v8i8_v4i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vadd.i16 d16, d16, d16
; SOFT-NEXT:    vrev64.16 d16, d16
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    bl test_v8i8_v4i16_helper
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vadd.i8 d16, d16, d16
; SOFT-NEXT:    vrev64.8 d16, d16
; SOFT-NEXT:    vstr d16, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i8_v4i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vldr d16, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 d16, d16
; HARD-NEXT:    vadd.i16 d16, d16, d16
; HARD-NEXT:    vrev64.16 d0, d16
; HARD-NEXT:    bl test_v8i8_v4i16_helper
; HARD-NEXT:    vrev64.8 d16, d0
; HARD-NEXT:    vadd.i8 d16, d16, d16
; HARD-NEXT:    vrev64.8 d16, d16
; HARD-NEXT:    vstr d16, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i16>, <4 x i16>* %p
    %2 = add <4 x i16> %1, %1
    %3 = call <8 x i8> @test_v8i8_v4i16_helper(<4 x i16> %2)
    %4 = add <8 x i8> %3, %3
    store <8 x i8> %4, <8 x i8>* %q
    ret void
}

declare fp128 @test_f128_v2f64_helper(<2 x double> %p)
define void @test_f128_v2f64(<2 x double>* %p, fp128* %q) {
; SOFT-LABEL: test_f128_v2f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d18, d16, d16
; SOFT-NEXT:    vadd.f64 d16, d17, d17
; SOFT-NEXT:    vmov r1, r0, d18
; SOFT-NEXT:    vmov r3, r2, d16
; SOFT-NEXT:    bl test_f128_v2f64_helper
; SOFT-NEXT:    stm sp, {r0, r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    stm r4, {r0, r1, r2, r3}
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f128_v2f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d1, d17, d17
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_f128_v2f64_helper
; HARD-NEXT:    stm sp, {r0, r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    stm r4, {r0, r1, r2, r3}
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x double>, <2 x double>* %p
    %2 = fadd <2 x double> %1, %1
    %3 = call fp128 @test_f128_v2f64_helper(<2 x double> %2)
    %4 = fadd fp128 %3, %3
    store fp128 %4, fp128* %q
    ret void
}

declare fp128 @test_f128_v2i64_helper(<2 x i64> %p)
define void @test_f128_v2i64(<2 x i64>* %p, fp128* %q) {
; SOFT-LABEL: test_f128_v2i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_f128_v2i64_helper
; SOFT-NEXT:    stm sp, {r0, r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    stm r4, {r0, r1, r2, r3}
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f128_v2i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 q0, q8, q8
; HARD-NEXT:    bl test_f128_v2i64_helper
; HARD-NEXT:    stm sp, {r0, r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    stm r4, {r0, r1, r2, r3}
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i64>, <2 x i64>* %p
    %2 = add <2 x i64> %1, %1
    %3 = call fp128 @test_f128_v2i64_helper(<2 x i64> %2)
    %4 = fadd fp128 %3, %3
    store fp128 %4, fp128* %q
    ret void
}

declare fp128 @test_f128_v4f32_helper(<4 x float> %p)
define void @test_f128_v4f32(<4 x float>* %p, fp128* %q) {
; SOFT-LABEL: test_f128_v4f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_f128_v4f32_helper
; SOFT-NEXT:    stm sp, {r0, r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    stm r4, {r0, r1, r2, r3}
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f128_v4f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_f128_v4f32_helper
; HARD-NEXT:    stm sp, {r0, r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    stm r4, {r0, r1, r2, r3}
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x float>, <4 x float>* %p
    %2 = fadd <4 x float> %1, %1
    %3 = call fp128 @test_f128_v4f32_helper(<4 x float> %2)
    %4 = fadd fp128 %3, %3
    store fp128 %4, fp128* %q
    ret void
}

declare fp128 @test_f128_v4i32_helper(<4 x i32> %p)
define void @test_f128_v4i32(<4 x i32>* %p, fp128* %q) {
; SOFT-LABEL: test_f128_v4i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_f128_v4i32_helper
; SOFT-NEXT:    stm sp, {r0, r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    stm r4, {r0, r1, r2, r3}
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f128_v4i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_f128_v4i32_helper
; HARD-NEXT:    stm sp, {r0, r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    stm r4, {r0, r1, r2, r3}
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i32>, <4 x i32>* %p
    %2 = add <4 x i32> %1, %1
    %3 = call fp128 @test_f128_v4i32_helper(<4 x i32> %2)
    %4 = fadd fp128 %3, %3
    store fp128 %4, fp128* %q
    ret void
}

declare fp128 @test_f128_v8i16_helper(<8 x i16> %p)
define void @test_f128_v8i16(<8 x i16>* %p, fp128* %q) {
; SOFT-LABEL: test_f128_v8i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_f128_v8i16_helper
; SOFT-NEXT:    stm sp, {r0, r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    stm r4, {r0, r1, r2, r3}
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f128_v8i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q0, q8
; HARD-NEXT:    bl test_f128_v8i16_helper
; HARD-NEXT:    stm sp, {r0, r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    stm r4, {r0, r1, r2, r3}
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i16>, <8 x i16>* %p
    %2 = add <8 x i16> %1, %1
    %3 = call fp128 @test_f128_v8i16_helper(<8 x i16> %2)
    %4 = fadd fp128 %3, %3
    store fp128 %4, fp128* %q
    ret void
}

declare fp128 @test_f128_v16i8_helper(<16 x i8> %p)
define void @test_f128_v16i8(<16 x i8>* %p, fp128* %q) {
; SOFT-LABEL: test_f128_v16i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_f128_v16i8_helper
; SOFT-NEXT:    stm sp, {r0, r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    stm r4, {r0, r1, r2, r3}
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_f128_v16i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q0, q8
; HARD-NEXT:    bl test_f128_v16i8_helper
; HARD-NEXT:    stm sp, {r0, r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    stm r4, {r0, r1, r2, r3}
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, pc}
    %1 = load <16 x i8>, <16 x i8>* %p
    %2 = add <16 x i8> %1, %1
    %3 = call fp128 @test_f128_v16i8_helper(<16 x i8> %2)
    %4 = fadd fp128 %3, %3
    store fp128 %4, fp128* %q
    ret void
}

declare <2 x double> @test_v2f64_f128_helper(fp128 %p)
define void @test_v2f64_f128(fp128* %p, <2 x double>* %q) {
; SOFT-LABEL: test_v2f64_f128:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r11, lr}
; SOFT-NEXT:    push {r4, r5, r11, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    ldr r4, [r0]
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    ldmib r0, {r1, r2, r3}
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    str r4, [sp]
; SOFT-NEXT:    stmib sp, {r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    bl test_v2f64_f128_helper
; SOFT-NEXT:    vmov d16, r3, r2
; SOFT-NEXT:    vmov d17, r1, r0
; SOFT-NEXT:    vadd.f64 d19, d16, d16
; SOFT-NEXT:    vadd.f64 d18, d17, d17
; SOFT-NEXT:    vst1.64 {d18, d19}, [r5]
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, r5, r11, pc}
;
; HARD-LABEL: test_v2f64_f128:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, r5, r11, lr}
; HARD-NEXT:    push {r4, r5, r11, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    ldr r4, [r0]
; HARD-NEXT:    mov r5, r1
; HARD-NEXT:    ldmib r0, {r1, r2, r3}
; HARD-NEXT:    mov r0, r4
; HARD-NEXT:    str r4, [sp]
; HARD-NEXT:    stmib sp, {r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    bl test_v2f64_f128_helper
; HARD-NEXT:    vadd.f64 d17, d1, d1
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vst1.64 {d16, d17}, [r5]
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, r5, r11, pc}
    %1 = load fp128, fp128* %p
    %2 = fadd fp128 %1, %1
    %3 = call <2 x double> @test_v2f64_f128_helper(fp128 %2)
    %4 = fadd <2 x double> %3, %3
    store <2 x double> %4, <2 x double>* %q
    ret void

}

declare <2 x double> @test_v2f64_v2i64_helper(<2 x i64> %p)
define void @test_v2f64_v2i64(<2 x i64>* %p, <2 x double>* %q) {
; SOFT-LABEL: test_v2f64_v2i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2f64_v2i64_helper
; SOFT-NEXT:    vmov d16, r3, r2
; SOFT-NEXT:    vmov d17, r1, r0
; SOFT-NEXT:    vadd.f64 d19, d16, d16
; SOFT-NEXT:    vadd.f64 d18, d17, d17
; SOFT-NEXT:    vst1.64 {d18, d19}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f64_v2i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 q0, q8, q8
; HARD-NEXT:    bl test_v2f64_v2i64_helper
; HARD-NEXT:    vadd.f64 d17, d1, d1
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i64>, <2 x i64>* %p
    %2 = add <2 x i64> %1, %1
    %3 = call <2 x double> @test_v2f64_v2i64_helper(<2 x i64> %2)
    %4 = fadd <2 x double> %3, %3
    store <2 x double> %4, <2 x double>* %q
    ret void
}

declare <2 x double> @test_v2f64_v4f32_helper(<4 x float> %p)
define void @test_v2f64_v4f32(<4 x float>* %p, <2 x double>* %q) {
; SOFT-LABEL: test_v2f64_v4f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2f64_v4f32_helper
; SOFT-NEXT:    vmov d16, r3, r2
; SOFT-NEXT:    vmov d17, r1, r0
; SOFT-NEXT:    vadd.f64 d19, d16, d16
; SOFT-NEXT:    vadd.f64 d18, d17, d17
; SOFT-NEXT:    vst1.64 {d18, d19}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f64_v4f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v2f64_v4f32_helper
; HARD-NEXT:    vadd.f64 d17, d1, d1
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x float>, <4 x float>* %p
    %2 = fadd <4 x float> %1, %1
    %3 = call <2 x double> @test_v2f64_v4f32_helper(<4 x float> %2)
    %4 = fadd <2 x double> %3, %3
    store <2 x double> %4, <2 x double>* %q
    ret void
}

declare <2 x double> @test_v2f64_v4i32_helper(<4 x i32> %p)
define void @test_v2f64_v4i32(<4 x i32>* %p, <2 x double>* %q) {
; SOFT-LABEL: test_v2f64_v4i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2f64_v4i32_helper
; SOFT-NEXT:    vmov d16, r3, r2
; SOFT-NEXT:    vmov d17, r1, r0
; SOFT-NEXT:    vadd.f64 d19, d16, d16
; SOFT-NEXT:    vadd.f64 d18, d17, d17
; SOFT-NEXT:    vst1.64 {d18, d19}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f64_v4i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v2f64_v4i32_helper
; HARD-NEXT:    vadd.f64 d17, d1, d1
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i32>, <4 x i32>* %p
    %2 = add <4 x i32> %1, %1
    %3 = call <2 x double> @test_v2f64_v4i32_helper(<4 x i32> %2)
    %4 = fadd <2 x double> %3, %3
    store <2 x double> %4, <2 x double>* %q
    ret void
}

declare <2 x double> @test_v2f64_v8i16_helper(<8 x i16> %p)
define void @test_v2f64_v8i16(<8 x i16>* %p, <2 x double>* %q) {
; SOFT-LABEL: test_v2f64_v8i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2f64_v8i16_helper
; SOFT-NEXT:    vmov d16, r3, r2
; SOFT-NEXT:    vmov d17, r1, r0
; SOFT-NEXT:    vadd.f64 d19, d16, d16
; SOFT-NEXT:    vadd.f64 d18, d17, d17
; SOFT-NEXT:    vst1.64 {d18, d19}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f64_v8i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q0, q8
; HARD-NEXT:    bl test_v2f64_v8i16_helper
; HARD-NEXT:    vadd.f64 d17, d1, d1
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i16>, <8 x i16>* %p
    %2 = add <8 x i16> %1, %1
    %3 = call <2 x double> @test_v2f64_v8i16_helper(<8 x i16> %2)
    %4 = fadd <2 x double> %3, %3
    store <2 x double> %4, <2 x double>* %q
    ret void
}

declare <2 x double> @test_v2f64_v16i8_helper(<16 x i8> %p)
define void @test_v2f64_v16i8(<16 x i8>* %p, <2 x double>* %q) {
; SOFT-LABEL: test_v2f64_v16i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2f64_v16i8_helper
; SOFT-NEXT:    vmov d16, r3, r2
; SOFT-NEXT:    vmov d17, r1, r0
; SOFT-NEXT:    vadd.f64 d19, d16, d16
; SOFT-NEXT:    vadd.f64 d18, d17, d17
; SOFT-NEXT:    vst1.64 {d18, d19}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2f64_v16i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q0, q8
; HARD-NEXT:    bl test_v2f64_v16i8_helper
; HARD-NEXT:    vadd.f64 d17, d1, d1
; HARD-NEXT:    vadd.f64 d16, d0, d0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <16 x i8>, <16 x i8>* %p
    %2 = add <16 x i8> %1, %1
    %3 = call <2 x double> @test_v2f64_v16i8_helper(<16 x i8> %2)
    %4 = fadd <2 x double> %3, %3
    store <2 x double> %4, <2 x double>* %q
    ret void
}

declare <2 x i64> @test_v2i64_f128_helper(fp128 %p)
define void @test_v2i64_f128(fp128* %p, <2 x i64>* %q) {
; SOFT-LABEL: test_v2i64_f128:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r11, lr}
; SOFT-NEXT:    push {r4, r5, r11, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    ldr r4, [r0]
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    ldmib r0, {r1, r2, r3}
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    str r4, [sp]
; SOFT-NEXT:    stmib sp, {r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    bl test_v2i64_f128_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r5]
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, r5, r11, pc}
;
; HARD-LABEL: test_v2i64_f128:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, r5, r11, lr}
; HARD-NEXT:    push {r4, r5, r11, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    ldr r4, [r0]
; HARD-NEXT:    mov r5, r1
; HARD-NEXT:    ldmib r0, {r1, r2, r3}
; HARD-NEXT:    mov r0, r4
; HARD-NEXT:    str r4, [sp]
; HARD-NEXT:    stmib sp, {r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    bl test_v2i64_f128_helper
; HARD-NEXT:    vadd.i64 q8, q0, q0
; HARD-NEXT:    vst1.64 {d16, d17}, [r5]
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, r5, r11, pc}
    %1 = load fp128, fp128* %p
    %2 = fadd fp128 %1, %1
    %3 = call <2 x i64> @test_v2i64_f128_helper(fp128 %2)
    %4 = add <2 x i64> %3, %3
    store <2 x i64> %4, <2 x i64>* %q
    ret void
}

declare <2 x i64> @test_v2i64_v2f64_helper(<2 x double> %p)
define void @test_v2i64_v2f64(<2 x double>* %p, <2 x i64>* %q) {
; SOFT-LABEL: test_v2i64_v2f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d18, d16, d16
; SOFT-NEXT:    vadd.f64 d16, d17, d17
; SOFT-NEXT:    vmov r1, r0, d18
; SOFT-NEXT:    vmov r3, r2, d16
; SOFT-NEXT:    bl test_v2i64_v2f64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i64_v2f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d1, d17, d17
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v2i64_v2f64_helper
; HARD-NEXT:    vadd.i64 q8, q0, q0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x double>, <2 x double>* %p
    %2 = fadd <2 x double> %1, %1
    %3 = call <2 x i64> @test_v2i64_v2f64_helper(<2 x double> %2)
    %4 = add <2 x i64> %3, %3
    store <2 x i64> %4, <2 x i64>* %q
    ret void
}

declare <2 x i64> @test_v2i64_v4f32_helper(<4 x float> %p)
define void @test_v2i64_v4f32(<4 x float>* %p, <2 x i64>* %q) {
; SOFT-LABEL: test_v2i64_v4f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2i64_v4f32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i64_v4f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v2i64_v4f32_helper
; HARD-NEXT:    vadd.i64 q8, q0, q0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x float>, <4 x float>* %p
    %2 = fadd <4 x float> %1, %1
    %3 = call <2 x i64> @test_v2i64_v4f32_helper(<4 x float> %2)
    %4 = add <2 x i64> %3, %3
    store <2 x i64> %4, <2 x i64>* %q
    ret void
}

declare <2 x i64> @test_v2i64_v4i32_helper(<4 x i32> %p)
define void @test_v2i64_v4i32(<4 x i32>* %p, <2 x i64>* %q) {
; SOFT-LABEL: test_v2i64_v4i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2i64_v4i32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i64_v4i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v2i64_v4i32_helper
; HARD-NEXT:    vadd.i64 q8, q0, q0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i32>, <4 x i32>* %p
    %2 = add <4 x i32> %1, %1
    %3 = call <2 x i64> @test_v2i64_v4i32_helper(<4 x i32> %2)
    %4 = add <2 x i64> %3, %3
    store <2 x i64> %4, <2 x i64>* %q
    ret void
}

declare <2 x i64> @test_v2i64_v8i16_helper(<8 x i16> %p)
define void @test_v2i64_v8i16(<8 x i16>* %p, <2 x i64>* %q) {
; SOFT-LABEL: test_v2i64_v8i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2i64_v8i16_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i64_v8i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q0, q8
; HARD-NEXT:    bl test_v2i64_v8i16_helper
; HARD-NEXT:    vadd.i64 q8, q0, q0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i16>, <8 x i16>* %p
    %2 = add <8 x i16> %1, %1
    %3 = call <2 x i64> @test_v2i64_v8i16_helper(<8 x i16> %2)
    %4 = add <2 x i64> %3, %3
    store <2 x i64> %4, <2 x i64>* %q
    ret void
}

declare <2 x i64> @test_v2i64_v16i8_helper(<16 x i8> %p)
define void @test_v2i64_v16i8(<16 x i8>* %p, <2 x i64>* %q) {
; SOFT-LABEL: test_v2i64_v16i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v2i64_v16i8_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v2i64_v16i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q0, q8
; HARD-NEXT:    bl test_v2i64_v16i8_helper
; HARD-NEXT:    vadd.i64 q8, q0, q0
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <16 x i8>, <16 x i8>* %p
    %2 = add <16 x i8> %1, %1
    %3 = call <2 x i64> @test_v2i64_v16i8_helper(<16 x i8> %2)
    %4 = add <2 x i64> %3, %3
    store <2 x i64> %4, <2 x i64>* %q
    ret void
}

declare <4 x float> @test_v4f32_f128_helper(fp128 %p)
define void @test_v4f32_f128(fp128* %p, <4 x float>* %q) {
; SOFT-LABEL: test_v4f32_f128:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r11, lr}
; SOFT-NEXT:    push {r4, r5, r11, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    ldr r4, [r0]
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    ldmib r0, {r1, r2, r3}
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    str r4, [sp]
; SOFT-NEXT:    stmib sp, {r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    bl test_v4f32_f128_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r5]
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, r5, r11, pc}
;
; HARD-LABEL: test_v4f32_f128:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, r5, r11, lr}
; HARD-NEXT:    push {r4, r5, r11, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    ldr r4, [r0]
; HARD-NEXT:    mov r5, r1
; HARD-NEXT:    ldmib r0, {r1, r2, r3}
; HARD-NEXT:    mov r0, r4
; HARD-NEXT:    str r4, [sp]
; HARD-NEXT:    stmib sp, {r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    bl test_v4f32_f128_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r5]
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, r5, r11, pc}
    %1 = load fp128, fp128* %p
    %2 = fadd fp128 %1, %1
    %3 = call <4 x float> @test_v4f32_f128_helper(fp128 %2)
    %4 = fadd <4 x float> %3, %3
    store <4 x float> %4, <4 x float>* %q
    ret void
}

declare <4 x float> @test_v4f32_v2f64_helper(<2 x double> %p)
define void @test_v4f32_v2f64(<2 x double>* %p, <4 x float>* %q) {
; SOFT-LABEL: test_v4f32_v2f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d18, d16, d16
; SOFT-NEXT:    vadd.f64 d16, d17, d17
; SOFT-NEXT:    vmov r1, r0, d18
; SOFT-NEXT:    vmov r3, r2, d16
; SOFT-NEXT:    bl test_v4f32_v2f64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4f32_v2f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d1, d17, d17
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v4f32_v2f64_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x double>, <2 x double>* %p
    %2 = fadd <2 x double> %1, %1
    %3 = call <4 x float> @test_v4f32_v2f64_helper(<2 x double> %2)
    %4 = fadd <4 x float> %3, %3
    store <4 x float> %4, <4 x float>* %q
    ret void
}

declare <4 x float> @test_v4f32_v2i64_helper(<2 x i64> %p)
define void @test_v4f32_v2i64(<2 x i64>* %p, <4 x float>* %q) {
; SOFT-LABEL: test_v4f32_v2i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4f32_v2i64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4f32_v2i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 q0, q8, q8
; HARD-NEXT:    bl test_v4f32_v2i64_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i64>, <2 x i64>* %p
    %2 = add <2 x i64> %1, %1
    %3 = call <4 x float> @test_v4f32_v2i64_helper(<2 x i64> %2)
    %4 = fadd <4 x float> %3, %3
    store <4 x float> %4, <4 x float>* %q
    ret void
}

declare <4 x float> @test_v4f32_v4i32_helper(<4 x i32> %p)
define void @test_v4f32_v4i32(<4 x i32>* %p, <4 x float>* %q) {
; SOFT-LABEL: test_v4f32_v4i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4f32_v4i32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4f32_v4i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v4f32_v4i32_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i32>, <4 x i32>* %p
    %2 = add <4 x i32> %1, %1
    %3 = call <4 x float> @test_v4f32_v4i32_helper(<4 x i32> %2)
    %4 = fadd <4 x float> %3, %3
    store <4 x float> %4, <4 x float>* %q
    ret void
}

declare <4 x float> @test_v4f32_v8i16_helper(<8 x i16> %p)
define void @test_v4f32_v8i16(<8 x i16>* %p, <4 x float>* %q) {
; SOFT-LABEL: test_v4f32_v8i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4f32_v8i16_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4f32_v8i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q0, q8
; HARD-NEXT:    bl test_v4f32_v8i16_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i16>, <8 x i16>* %p
    %2 = add <8 x i16> %1, %1
    %3 = call <4 x float> @test_v4f32_v8i16_helper(<8 x i16> %2)
    %4 = fadd <4 x float> %3, %3
    store <4 x float> %4, <4 x float>* %q
    ret void
}

declare <4 x float> @test_v4f32_v16i8_helper(<16 x i8> %p)
define void @test_v4f32_v16i8(<16 x i8>* %p, <4 x float>* %q) {
; SOFT-LABEL: test_v4f32_v16i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4f32_v16i8_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4f32_v16i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q0, q8
; HARD-NEXT:    bl test_v4f32_v16i8_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <16 x i8>, <16 x i8>* %p
    %2 = add <16 x i8> %1, %1
    %3 = call <4 x float> @test_v4f32_v16i8_helper(<16 x i8> %2)
    %4 = fadd <4 x float> %3, %3
    store <4 x float> %4, <4 x float>* %q
    ret void
}

declare <4 x i32> @test_v4i32_f128_helper(fp128 %p)
define void @test_v4i32_f128(fp128* %p, <4 x i32>* %q) {
; SOFT-LABEL: test_v4i32_f128:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r11, lr}
; SOFT-NEXT:    push {r4, r5, r11, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    ldr r4, [r0]
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    ldmib r0, {r1, r2, r3}
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    str r4, [sp]
; SOFT-NEXT:    stmib sp, {r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    bl test_v4i32_f128_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r5]
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, r5, r11, pc}
;
; HARD-LABEL: test_v4i32_f128:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, r5, r11, lr}
; HARD-NEXT:    push {r4, r5, r11, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    ldr r4, [r0]
; HARD-NEXT:    mov r5, r1
; HARD-NEXT:    ldmib r0, {r1, r2, r3}
; HARD-NEXT:    mov r0, r4
; HARD-NEXT:    str r4, [sp]
; HARD-NEXT:    stmib sp, {r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    bl test_v4i32_f128_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r5]
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, r5, r11, pc}
    %1 = load fp128, fp128* %p
    %2 = fadd fp128 %1, %1
    %3 = call <4 x i32> @test_v4i32_f128_helper(fp128 %2)
    %4 = add <4 x i32> %3, %3
    store <4 x i32> %4, <4 x i32>* %q
    ret void
}

declare <4 x i32> @test_v4i32_v2f64_helper(<2 x double> %p)
define void @test_v4i32_v2f64(<2 x double>* %p, <4 x i32>* %q) {
; SOFT-LABEL: test_v4i32_v2f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d18, d16, d16
; SOFT-NEXT:    vadd.f64 d16, d17, d17
; SOFT-NEXT:    vmov r1, r0, d18
; SOFT-NEXT:    vmov r3, r2, d16
; SOFT-NEXT:    bl test_v4i32_v2f64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i32_v2f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d1, d17, d17
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v4i32_v2f64_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x double>, <2 x double>* %p
    %2 = fadd <2 x double> %1, %1
    %3 = call <4 x i32> @test_v4i32_v2f64_helper(<2 x double> %2)
    %4 = add <4 x i32> %3, %3
    store <4 x i32> %4, <4 x i32>* %q
    ret void
}

declare <4 x i32> @test_v4i32_v2i64_helper(<2 x i64> %p)
define void @test_v4i32_v2i64(<2 x i64>* %p, <4 x i32>* %q) {
; SOFT-LABEL: test_v4i32_v2i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4i32_v2i64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i32_v2i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 q0, q8, q8
; HARD-NEXT:    bl test_v4i32_v2i64_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i64>, <2 x i64>* %p
    %2 = add <2 x i64> %1, %1
    %3 = call <4 x i32> @test_v4i32_v2i64_helper(<2 x i64> %2)
    %4 = add <4 x i32> %3, %3
    store <4 x i32> %4, <4 x i32>* %q
    ret void
}

declare <4 x i32> @test_v4i32_v4f32_helper(<4 x float> %p)
define void @test_v4i32_v4f32(<4 x float>* %p, <4 x i32>* %q) {
; SOFT-LABEL: test_v4i32_v4f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4i32_v4f32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i32_v4f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v4i32_v4f32_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x float>, <4 x float>* %p
    %2 = fadd <4 x float> %1, %1
    %3 = call <4 x i32> @test_v4i32_v4f32_helper(<4 x float> %2)
    %4 = add <4 x i32> %3, %3
    store <4 x i32> %4, <4 x i32>* %q
    ret void
}

declare <4 x i32> @test_v4i32_v8i16_helper(<8 x i16> %p)
define void @test_v4i32_v8i16(<8 x i16>* %p, <4 x i32>* %q) {
; SOFT-LABEL: test_v4i32_v8i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4i32_v8i16_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i32_v8i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q0, q8
; HARD-NEXT:    bl test_v4i32_v8i16_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i16>, <8 x i16>* %p
    %2 = add <8 x i16> %1, %1
    %3 = call <4 x i32> @test_v4i32_v8i16_helper(<8 x i16> %2)
    %4 = add <4 x i32> %3, %3
    store <4 x i32> %4, <4 x i32>* %q
    ret void
}

declare <4 x i32> @test_v4i32_v16i8_helper(<16 x i8> %p)
define void @test_v4i32_v16i8(<16 x i8>* %p, <4 x i32>* %q) {
; SOFT-LABEL: test_v4i32_v16i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v4i32_v16i8_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v4i32_v16i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q0, q8
; HARD-NEXT:    bl test_v4i32_v16i8_helper
; HARD-NEXT:    vrev64.32 q8, q0
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <16 x i8>, <16 x i8>* %p
    %2 = add <16 x i8> %1, %1
    %3 = call <4 x i32> @test_v4i32_v16i8_helper(<16 x i8> %2)
    %4 = add <4 x i32> %3, %3
    store <4 x i32> %4, <4 x i32>* %q
    ret void
}

declare <8 x i16> @test_v8i16_f128_helper(fp128 %p)
define void @test_v8i16_f128(fp128* %p, <8 x i16>* %q) {
; SOFT-LABEL: test_v8i16_f128:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r11, lr}
; SOFT-NEXT:    push {r4, r5, r11, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    ldr r4, [r0]
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    ldmib r0, {r1, r2, r3}
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    str r4, [sp]
; SOFT-NEXT:    stmib sp, {r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    bl test_v8i16_f128_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r5]
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, r5, r11, pc}
;
; HARD-LABEL: test_v8i16_f128:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, r5, r11, lr}
; HARD-NEXT:    push {r4, r5, r11, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    ldr r4, [r0]
; HARD-NEXT:    mov r5, r1
; HARD-NEXT:    ldmib r0, {r1, r2, r3}
; HARD-NEXT:    mov r0, r4
; HARD-NEXT:    str r4, [sp]
; HARD-NEXT:    stmib sp, {r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    bl test_v8i16_f128_helper
; HARD-NEXT:    vrev64.16 q8, q0
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r5]
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, r5, r11, pc}
    %1 = load fp128, fp128* %p
    %2 = fadd fp128 %1, %1
    %3 = call <8 x i16> @test_v8i16_f128_helper(fp128 %2)
    %4 = add <8 x i16> %3, %3
    store <8 x i16> %4, <8 x i16>* %q
    ret void
}

declare <8 x i16> @test_v8i16_v2f64_helper(<2 x double> %p)
define void @test_v8i16_v2f64(<2 x double>* %p, <8 x i16>* %q) {
; SOFT-LABEL: test_v8i16_v2f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d18, d16, d16
; SOFT-NEXT:    vadd.f64 d16, d17, d17
; SOFT-NEXT:    vmov r1, r0, d18
; SOFT-NEXT:    vmov r3, r2, d16
; SOFT-NEXT:    bl test_v8i16_v2f64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i16_v2f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d1, d17, d17
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v8i16_v2f64_helper
; HARD-NEXT:    vrev64.16 q8, q0
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x double>, <2 x double>* %p
    %2 = fadd <2 x double> %1, %1
    %3 = call <8 x i16> @test_v8i16_v2f64_helper(<2 x double> %2)
    %4 = add <8 x i16> %3, %3
    store <8 x i16> %4, <8 x i16>* %q
    ret void
}

declare <8 x i16> @test_v8i16_v2i64_helper(<2 x i64> %p)
define void @test_v8i16_v2i64(<2 x i64>* %p, <8 x i16>* %q) {
; SOFT-LABEL: test_v8i16_v2i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v8i16_v2i64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i16_v2i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 q0, q8, q8
; HARD-NEXT:    bl test_v8i16_v2i64_helper
; HARD-NEXT:    vrev64.16 q8, q0
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i64>, <2 x i64>* %p
    %2 = add <2 x i64> %1, %1
    %3 = call <8 x i16> @test_v8i16_v2i64_helper(<2 x i64> %2)
    %4 = add <8 x i16> %3, %3
    store <8 x i16> %4, <8 x i16>* %q
    ret void
}

declare <8 x i16> @test_v8i16_v4f32_helper(<4 x float> %p)
define void @test_v8i16_v4f32(<4 x float>* %p, <8 x i16>* %q) {
; SOFT-LABEL: test_v8i16_v4f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v8i16_v4f32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i16_v4f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v8i16_v4f32_helper
; HARD-NEXT:    vrev64.16 q8, q0
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x float>, <4 x float>* %p
    %2 = fadd <4 x float> %1, %1
    %3 = call <8 x i16> @test_v8i16_v4f32_helper(<4 x float> %2)
    %4 = add <8 x i16> %3, %3
    store <8 x i16> %4, <8 x i16>* %q
    ret void
}

declare <8 x i16> @test_v8i16_v4i32_helper(<4 x i32> %p)
define void @test_v8i16_v4i32(<4 x i32>* %p, <8 x i16>* %q) {
; SOFT-LABEL: test_v8i16_v4i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v8i16_v4i32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i16_v4i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v8i16_v4i32_helper
; HARD-NEXT:    vrev64.16 q8, q0
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i32>, <4 x i32>* %p
    %2 = add <4 x i32> %1, %1
    %3 = call <8 x i16> @test_v8i16_v4i32_helper(<4 x i32> %2)
    %4 = add <8 x i16> %3, %3
    store <8 x i16> %4, <8 x i16>* %q
    ret void
}

declare <8 x i16> @test_v8i16_v16i8_helper(<16 x i8> %p)
define void @test_v8i16_v16i8(<16 x i8>* %p, <8 x i16>* %q) {
; SOFT-LABEL: test_v8i16_v16i8:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v8i16_v16i8_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v8i16_v16i8:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q0, q8
; HARD-NEXT:    bl test_v8i16_v16i8_helper
; HARD-NEXT:    vrev64.16 q8, q0
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <16 x i8>, <16 x i8>* %p
    %2 = add <16 x i8> %1, %1
    %3 = call <8 x i16> @test_v8i16_v16i8_helper(<16 x i8> %2)
    %4 = add <8 x i16> %3, %3
    store <8 x i16> %4, <8 x i16>* %q
    ret void
}

declare <16 x i8> @test_v16i8_f128_helper(fp128 %p)
define void @test_v16i8_f128(fp128* %p, <16 x i8>* %q) {
; SOFT-LABEL: test_v16i8_f128:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r11, lr}
; SOFT-NEXT:    push {r4, r5, r11, lr}
; SOFT-NEXT:    .pad #16
; SOFT-NEXT:    sub sp, sp, #16
; SOFT-NEXT:    ldr r4, [r0]
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    ldmib r0, {r1, r2, r3}
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    str r4, [sp]
; SOFT-NEXT:    stmib sp, {r1, r2, r3}
; SOFT-NEXT:    bl __addtf3
; SOFT-NEXT:    bl test_v16i8_f128_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r5]
; SOFT-NEXT:    add sp, sp, #16
; SOFT-NEXT:    pop {r4, r5, r11, pc}
;
; HARD-LABEL: test_v16i8_f128:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, r5, r11, lr}
; HARD-NEXT:    push {r4, r5, r11, lr}
; HARD-NEXT:    .pad #16
; HARD-NEXT:    sub sp, sp, #16
; HARD-NEXT:    ldr r4, [r0]
; HARD-NEXT:    mov r5, r1
; HARD-NEXT:    ldmib r0, {r1, r2, r3}
; HARD-NEXT:    mov r0, r4
; HARD-NEXT:    str r4, [sp]
; HARD-NEXT:    stmib sp, {r1, r2, r3}
; HARD-NEXT:    bl __addtf3
; HARD-NEXT:    bl test_v16i8_f128_helper
; HARD-NEXT:    vrev64.8 q8, q0
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r5]
; HARD-NEXT:    add sp, sp, #16
; HARD-NEXT:    pop {r4, r5, r11, pc}
    %1 = load fp128, fp128* %p
    %2 = fadd fp128 %1, %1
    %3 = call <16 x i8> @test_v16i8_f128_helper(fp128 %2)
    %4 = add <16 x i8> %3, %3
    store <16 x i8> %4, <16 x i8>* %q
    ret void
}

declare <16 x i8> @test_v16i8_v2f64_helper(<2 x double> %p)
define void @test_v16i8_v2f64(<2 x double>* %p, <16 x i8>* %q) {
; SOFT-LABEL: test_v16i8_v2f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.f64 d18, d16, d16
; SOFT-NEXT:    vadd.f64 d16, d17, d17
; SOFT-NEXT:    vmov r1, r0, d18
; SOFT-NEXT:    vmov r3, r2, d16
; SOFT-NEXT:    bl test_v16i8_v2f64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v16i8_v2f64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.f64 d1, d17, d17
; HARD-NEXT:    vadd.f64 d0, d16, d16
; HARD-NEXT:    bl test_v16i8_v2f64_helper
; HARD-NEXT:    vrev64.8 q8, q0
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x double>, <2 x double>* %p
    %2 = fadd <2 x double> %1, %1
    %3 = call <16 x i8> @test_v16i8_v2f64_helper(<2 x double> %2)
    %4 = add <16 x i8> %3, %3
    store <16 x i8> %4, <16 x i8>* %q
    ret void
}

declare <16 x i8> @test_v16i8_v2i64_helper(<2 x i64> %p)
define void @test_v16i8_v2i64(<2 x i64>* %p, <16 x i8>* %q) {
; SOFT-LABEL: test_v16i8_v2i64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vadd.i64 q8, q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v16i8_v2i64_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v16i8_v2i64:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vadd.i64 q0, q8, q8
; HARD-NEXT:    bl test_v16i8_v2i64_helper
; HARD-NEXT:    vrev64.8 q8, q0
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <2 x i64>, <2 x i64>* %p
    %2 = add <2 x i64> %1, %1
    %3 = call <16 x i8> @test_v16i8_v2i64_helper(<2 x i64> %2)
    %4 = add <16 x i8> %3, %3
    store <16 x i8> %4, <16 x i8>* %q
    ret void
}

declare <16 x i8> @test_v16i8_v4f32_helper(<4 x float> %p)
define void @test_v16i8_v4f32(<4 x float>* %p, <16 x i8>* %q) {
; SOFT-LABEL: test_v16i8_v4f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.f32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v16i8_v4f32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v16i8_v4f32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.f32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v16i8_v4f32_helper
; HARD-NEXT:    vrev64.8 q8, q0
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x float>, <4 x float>* %p
    %2 = fadd <4 x float> %1, %1
    %3 = call <16 x i8> @test_v16i8_v4f32_helper(<4 x float> %2)
    %4 = add <16 x i8> %3, %3
    store <16 x i8> %4, <16 x i8>* %q
    ret void
}

declare <16 x i8> @test_v16i8_v4i32_helper(<4 x i32> %p)
define void @test_v16i8_v4i32(<4 x i32>* %p, <16 x i8>* %q) {
; SOFT-LABEL: test_v16i8_v4i32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vadd.i32 q8, q8, q8
; SOFT-NEXT:    vrev64.32 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v16i8_v4i32_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v16i8_v4i32:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.32 q8, q8
; HARD-NEXT:    vadd.i32 q8, q8, q8
; HARD-NEXT:    vrev64.32 q0, q8
; HARD-NEXT:    bl test_v16i8_v4i32_helper
; HARD-NEXT:    vrev64.8 q8, q0
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <4 x i32>, <4 x i32>* %p
    %2 = add <4 x i32> %1, %1
    %3 = call <16 x i8> @test_v16i8_v4i32_helper(<4 x i32> %2)
    %4 = add <16 x i8> %3, %3
    store <16 x i8> %4, <16 x i8>* %q
    ret void
}

declare <16 x i8> @test_v16i8_v8i16_helper(<8 x i16> %p)
define void @test_v16i8_v8i16(<8 x i16>* %p, <16 x i8>* %q) {
; SOFT-LABEL: test_v16i8_v8i16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vadd.i16 q8, q8, q8
; SOFT-NEXT:    vrev64.16 q8, q8
; SOFT-NEXT:    vmov r1, r0, d16
; SOFT-NEXT:    vmov r3, r2, d17
; SOFT-NEXT:    bl test_v16i8_v8i16_helper
; SOFT-NEXT:    vmov d17, r3, r2
; SOFT-NEXT:    vmov d16, r1, r0
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vadd.i8 q8, q8, q8
; SOFT-NEXT:    vrev64.8 q8, q8
; SOFT-NEXT:    vst1.64 {d16, d17}, [r4]
; SOFT-NEXT:    pop {r4, pc}
;
; HARD-LABEL: test_v16i8_v8i16:
; HARD:       @ %bb.0:
; HARD-NEXT:    .save {r4, lr}
; HARD-NEXT:    push {r4, lr}
; HARD-NEXT:    vld1.64 {d16, d17}, [r0]
; HARD-NEXT:    mov r4, r1
; HARD-NEXT:    vrev64.16 q8, q8
; HARD-NEXT:    vadd.i16 q8, q8, q8
; HARD-NEXT:    vrev64.16 q0, q8
; HARD-NEXT:    bl test_v16i8_v8i16_helper
; HARD-NEXT:    vrev64.8 q8, q0
; HARD-NEXT:    vadd.i8 q8, q8, q8
; HARD-NEXT:    vrev64.8 q8, q8
; HARD-NEXT:    vst1.64 {d16, d17}, [r4]
; HARD-NEXT:    pop {r4, pc}
    %1 = load <8 x i16>, <8 x i16>* %p
    %2 = add <8 x i16> %1, %1
    %3 = call <16 x i8> @test_v16i8_v8i16_helper(<8 x i16> %2)
    %4 = add <16 x i8> %3, %3
    store <16 x i8> %4, <16 x i8>* %q
    ret void
}
