; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

;
; Sign-extend
;

define i32 @vscale_SExt_i8toi32() vscale_range(1, 127) {
; CHECK-LABEL: @vscale_SExt_i8toi32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.vscale.i32()
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = sext i8 %0 to i32
  ret i32 %1
}

define i32 @vscale_SExt_i8toi32_poison() vscale_range(1, 128) {
; CHECK-LABEL: @vscale_SExt_i8toi32_poison(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i8 @llvm.vscale.i8()
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = sext i8 %0 to i32
  ret i32 %1
}

;
; Zero-extend
;

define i32 @vscale_ZExt_i8toi32() vscale_range(1, 128) {
; CHECK-LABEL: @vscale_ZExt_i8toi32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.vscale.i32()
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = zext i8 %0 to i32
  ret i32 %1
}

define i32 @vscale_ZExt_i8toi32_poison() vscale_range(1, 256) {
; CHECK-LABEL: @vscale_ZExt_i8toi32_poison(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i8 @llvm.vscale.i8()
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = zext i8 %0 to i32
  ret i32 %1
}

;
; No vscale_range attribute
;

define i32 @vscale_ZExt_i8toi32_unknown() {
; CHECK-LABEL: @vscale_ZExt_i8toi32_unknown(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i8 @llvm.vscale.i8()
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = zext i8 %0 to i32
  ret i32 %1
}

;
; unbounded vscale_range maximum (0)
;

define i32 @vscale_SExt_i8toi32_unbounded() vscale_range(1, 0) {
; CHECK-LABEL: @vscale_SExt_i8toi32_unbounded(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i8 @llvm.vscale.i8()
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = sext i8 %0 to i32
  ret i32 %1
}

define i32 @vscale_ZExt_i8toi32_unbounded() vscale_range(1, 0) {
; CHECK-LABEL: @vscale_ZExt_i8toi32_unbounded(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i8 @llvm.vscale.i8()
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  entry:
  %0 = call i8 @llvm.vscale.i8()
  %1 = zext i8 %0 to i32
  ret i32 %1
}

declare i8  @llvm.vscale.i8()
