; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define <4 x i32> @const_folding(<4 x i32> %x) {
; CHECK-LABEL: @const_folding(
; CHECK-NEXT:    ret <4 x i32> zeroinitializer
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> zeroinitializer, <4 x i32> <i32 5, i32 4, i32 5, i32 4>
  ret <4 x i32> %shuf
}

define <4 x i32> @const_folding1(<4 x i32> %x) {
; CHECK-LABEL: @const_folding1(
; CHECK-NEXT:    ret <4 x i32> <i32 5, i32 5, i32 5, i32 5>
;
  %shuf = shufflevector <4 x i32> <i32 5, i32 4, i32 5, i32 4>, <4 x i32> %x, <4 x i32> zeroinitializer
  ret <4 x i32> %shuf
}

define <4 x i32> @const_folding_negative(<3 x i32> %x) {
; CHECK-LABEL: @const_folding_negative(
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <3 x i32> [[X:%.*]], <3 x i32> zeroinitializer, <4 x i32> <i32 2, i32 4, i32 5, i32 4>
; CHECK-NEXT:    ret <4 x i32> [[SHUF]]
;
  %shuf = shufflevector <3 x i32> %x, <3 x i32> zeroinitializer, <4 x i32> <i32 2, i32 4, i32 5, i32 4>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand(<4 x i32> %x) {
; CHECK-LABEL: @splat_operand(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    ret <4 x i32> [[SPLAT]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> undef, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand_poison(<4 x i32> %x) {
; CHECK-LABEL: @splat_operand_poison(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    ret <4 x i32> [[SPLAT]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> poison, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand1(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @splat_operand1(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> [[Y:%.*]], <4 x i32> zeroinitializer
; CHECK-NEXT:    ret <4 x i32> [[SPLAT]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> %y, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> undef, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand2(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @splat_operand2(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    ret <4 x i32> [[SPLAT]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> %y, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand3(<4 x i32> %x) {
; CHECK-LABEL: @splat_operand3(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    ret <4 x i32> [[SPLAT]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> zeroinitializer, <4 x i32> %splat, <4 x i32> <i32 7, i32 6, i32 5, i32 5>
  ret <4 x i32> %shuf
}

define <8 x i32> @splat_operand_negative(<4 x i32> %x) {
; CHECK-LABEL: @splat_operand_negative(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i32> [[SPLAT]], <4 x i32> undef, <8 x i32> <i32 0, i32 3, i32 2, i32 1, i32 poison, i32 poison, i32 poison, i32 poison>
; CHECK-NEXT:    ret <8 x i32> [[SHUF]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> undef, <8 x i32> <i32 0, i32 3, i32 2, i32 1, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i32> %shuf
}

define <4 x i32> @splat_operand_negative2(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @splat_operand_negative2(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i32> [[SPLAT]], <4 x i32> [[Y:%.*]], <4 x i32> <i32 0, i32 3, i32 4, i32 1>
; CHECK-NEXT:    ret <4 x i32> [[SHUF]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> %y, <4 x i32> <i32 0, i32 3, i32 4, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand_negative3(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @splat_operand_negative3(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i32> [[Y:%.*]], <4 x i32> [[SPLAT]], <4 x i32> <i32 0, i32 3, i32 4, i32 1>
; CHECK-NEXT:    ret <4 x i32> [[SHUF]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> zeroinitializer
  %shuf = shufflevector <4 x i32> %y, <4 x i32> %splat, <4 x i32> <i32 0, i32 3, i32 4, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @splat_operand_negative4(<4 x i32> %x) {
; CHECK-LABEL: @splat_operand_negative4(
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> <i32 2, i32 poison, i32 2, i32 poison>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i32> [[SPLAT]], <4 x i32> undef, <4 x i32> <i32 0, i32 2, i32 poison, i32 poison>
; CHECK-NEXT:    ret <4 x i32> [[SHUF]]
;
  %splat = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> <i32 2, i32 undef, i32 2, i32 undef>
  %shuf = shufflevector <4 x i32> %splat, <4 x i32> undef, <4 x i32> <i32 0, i32 2, i32 undef, i32 undef>
  ret <4 x i32> %shuf
}

define <4 x i32> @undef_mask(<4 x i32> %x) {
; CHECK-LABEL: @undef_mask(
; CHECK-NEXT:    ret <4 x i32> poison
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> undef
  ret <4 x i32> %shuf
}

define <4 x i32> @undef_mask_1(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: @undef_mask_1(
; CHECK-NEXT:    ret <4 x i32> poison
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> %y, <4 x i32> undef
  ret <4 x i32> %shuf
}

define <4 x i32> @identity_mask_0(<4 x i32> %x) {
; CHECK-LABEL: @identity_mask_0(
; CHECK-NEXT:    ret <4 x i32> [[X:%.*]]
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %shuf
}

define <4 x i32> @identity_mask_1(<4 x i32> %x) {
; CHECK-LABEL: @identity_mask_1(
; CHECK-NEXT:    ret <4 x i32> [[X:%.*]]
;
  %shuf = shufflevector <4 x i32> undef, <4 x i32> %x, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  ret <4 x i32> %shuf
}

define <4 x i32> @pseudo_identity_mask(<4 x i32> %x) {
; CHECK-LABEL: @pseudo_identity_mask(
; CHECK-NEXT:    ret <4 x i32> [[X:%.*]]
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x i32> %shuf
}

define <4 x i32> @not_identity_mask(<4 x i32> %x) {
; CHECK-LABEL: @not_identity_mask(
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> [[X]], <4 x i32> <i32 0, i32 1, i32 2, i32 6>
; CHECK-NEXT:    ret <4 x i32> [[SHUF]]
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> %x, <4 x i32> <i32 0, i32 1, i32 2, i32 6>
  ret <4 x i32> %shuf
}

; TODO: Should we simplify if the mask has an undef element?

define <4 x i32> @possible_identity_mask(<4 x i32> %x) {
; CHECK-LABEL: @possible_identity_mask(
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 poison>
; CHECK-NEXT:    ret <4 x i32> [[SHUF]]
;
  %shuf = shufflevector <4 x i32> %x, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 undef>
  ret <4 x i32> %shuf
}

define <4 x i32> @const_operand(<4 x i32> %x) {
; CHECK-LABEL: @const_operand(
; CHECK-NEXT:    ret <4 x i32> <i32 42, i32 45, i32 44, i32 43>
;
  %shuf = shufflevector <4 x i32> <i32 42, i32 43, i32 44, i32 45>, <4 x i32> %x, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  ret <4 x i32> %shuf
}

define <4 x i32> @merge(<4 x i32> %x) {
; CHECK-LABEL: @merge(
; CHECK-NEXT:    ret <4 x i32> [[X:%.*]]
;
  %lower = shufflevector <4 x i32> %x, <4 x i32> undef, <2 x i32> <i32 1, i32 0>
  %upper = shufflevector <4 x i32> %x, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %merged = shufflevector <2 x i32> %upper, <2 x i32> %lower, <4 x i32> <i32 3, i32 2, i32 0, i32 1>
  ret <4 x i32> %merged
}

; This crosses lanes from the source op.

define <4 x i32> @not_merge(<4 x i32> %x) {
; CHECK-LABEL: @not_merge(
; CHECK-NEXT:    [[L:%.*]] = shufflevector <4 x i32> [[X:%.*]], <4 x i32> undef, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[U:%.*]] = shufflevector <4 x i32> [[X]], <4 x i32> undef, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[MERGED:%.*]] = shufflevector <2 x i32> [[U]], <2 x i32> [[L]], <4 x i32> <i32 3, i32 2, i32 0, i32 1>
; CHECK-NEXT:    ret <4 x i32> [[MERGED]]
;
  %l = shufflevector <4 x i32> %x, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %u = shufflevector <4 x i32> %x, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %merged = shufflevector <2 x i32> %u, <2 x i32> %l, <4 x i32> <i32 3, i32 2, i32 0, i32 1>
  ret <4 x i32> %merged
}

define <8 x double> @extract_and_concat(<8 x double> %x) {
; CHECK-LABEL: @extract_and_concat(
; CHECK-NEXT:    ret <8 x double> [[X:%.*]]
;
  %s1 = shufflevector <8 x double> %x, <8 x double> undef, <2 x i32> <i32 0, i32 1>
  %s2 = shufflevector <8 x double> %x, <8 x double> undef, <2 x i32> <i32 2, i32 3>
  %s3 = shufflevector <8 x double> %x, <8 x double> undef, <2 x i32> <i32 4, i32 5>
  %s4 = shufflevector <8 x double> %x, <8 x double> undef, <2 x i32> <i32 6, i32 7>
  %s5 = shufflevector <2 x double> %s1, <2 x double> %s2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s6 = shufflevector <2 x double> %s3, <2 x double> %s4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s7 = shufflevector <4 x double> %s5, <4 x double> %s6, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x double> %s7
}

; This case has intermediate lane crossings.

define <8 x i64> @PR30630(<8 x i64> %x) {
; CHECK-LABEL: @PR30630(
; CHECK-NEXT:    ret <8 x i64> [[X:%.*]]
;
  %s1 = shufflevector <8 x i64> %x, <8 x i64> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x i64> %x, <8 x i64> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x i64> %x, <8 x i64> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x i64> %x, <8 x i64> undef, <2 x i32> <i32 3, i32 7>
  %s5 = shufflevector <2 x i64> %s1, <2 x i64> %s2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s6 = shufflevector <2 x i64> %s3, <2 x i64> %s4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s7 = shufflevector <4 x i64> %s5, <4 x i64> %s6, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  ret <8 x i64> %s7
}

; This case covers internal canonicalization of shuffles with one constant input vector.

;FIXME: Another issue exposed here, this whole function could be simplified to:
;         ret <2 x float> zeroinitializer
define <2 x float> @PR32872(<2 x float> %x) {
; CHECK-LABEL: @PR32872(
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x float> [[X:%.*]], <2 x float> zeroinitializer, <4 x i32> <i32 2, i32 2, i32 0, i32 1>
; CHECK-NEXT:    [[TMP4:%.*]] = shufflevector <4 x float> zeroinitializer, <4 x float> [[TMP1]], <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    ret <2 x float> [[TMP4]]
;
  %tmp1 = shufflevector <2 x float> %x, <2 x float> zeroinitializer, <4 x i32> <i32 2, i32 2, i32 0, i32 1>
  %tmp4 = shufflevector <4 x float> zeroinitializer, <4 x float> %tmp1, <2 x i32> <i32 4, i32 5>
  ret <2 x float> %tmp4
}

define <5 x i8> @splat_inserted_constant(<4 x i8> %x) {
; CHECK-LABEL: @splat_inserted_constant(
; CHECK-NEXT:    ret <5 x i8> <i8 42, i8 42, i8 42, i8 42, i8 42>
;
  %ins3 = insertelement <4 x i8> %x, i8 42, i64 3
  %splat5 = shufflevector <4 x i8> %ins3, <4 x i8> undef, <5 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3>
  ret <5 x i8> %splat5
}

define <4 x float> @splat_inserted_constant_undef_elt(<4 x float> %x) {
; CHECK-LABEL: @splat_inserted_constant_undef_elt(
; CHECK-NEXT:    ret <4 x float> <float 1.200000e+01, float 1.200000e+01, float poison, float 1.200000e+01>
;
  %ins1 = insertelement <4 x float> %x, float 12.0, i32 1
  %splat1 = shufflevector <4 x float> %ins1, <4 x float> undef, <4 x i32> <i32 1, i32 1, i32 undef, i32 1>
  ret <4 x float> %splat1
}

define <2 x i8> @splat_inserted_constant_not_canonical(<3 x i8> %x, <3 x i8> %y) {
; CHECK-LABEL: @splat_inserted_constant_not_canonical(
; CHECK-NEXT:    ret <2 x i8> <i8 poison, i8 23>
;
  %ins2 = insertelement <3 x i8> %x, i8 23, i7 2
  %splat2 = shufflevector <3 x i8> %y, <3 x i8> %ins2, <2 x i32> <i32 undef, i32 5>
  ret <2 x i8> %splat2
}
