// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _

// expected-no-diagnostics

// Check code generation
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -std=c++20 -fclang-abi-compat=latest -fopenmp -fopenmp-version=60 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1

// Check same results after serialization round-trip
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -std=c++20 -fclang-abi-compat=latest -fopenmp -fopenmp-version=60 -emit-pch -o %t %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -std=c++20 -fclang-abi-compat=latest -fopenmp -fopenmp-version=60 -include-pch %t -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK2

#ifndef HEADER
#define HEADER

// placeholder for loop body code.
extern "C" void body(...) {}


struct S {
  int i;
  S() {
#pragma omp reverse
    for (i = 7; i < 17; i += 3)
      body(i);
  }
} s;


extern "C" void foo1(int start, int end, int step) {
  int i;
#pragma omp reverse
  for (i = start; i < end; i += step)
    body(i);
}


extern "C" void foo2() {
#pragma omp for
#pragma omp reverse
    for (int i = 7; i < 17; i += 3)
        body(i);
}


extern "C" void foo3() {
#pragma omp for collapse(3)
  for (int k = 7; k < 17; k += 3)
#pragma omp reverse
    for (int i = 7; i < 17; i += 3)
      for (int j = 7; j < 17; j += 3)
        body(k, i, j);
}


extern "C" void foo4() {
#pragma omp parallel for
#pragma omp reverse
  for (int i = 7; i < 17; i += 3)
    body(i);
}


template<typename T, T Step>
void foo5(T start, T end) {
#pragma omp reverse
  for (T i = start; i < end; i += Step)
    body(i);
}

extern "C" void tfoo5() {
  foo5<int,3>(0, 42);
}


extern "C" void foo6() {
  double arr[128];
#pragma omp reverse
  for (int c = 42; auto && v : arr)
    body(v, c);
}


extern "C" void foo7() {
  double A[128];

#pragma omp for collapse(3)
  for (int k = 7; k < 17; k += 3)
#pragma omp reverse
    for (int c = 42; auto && v : A)
      for (int j = 7; j < 17; j += 3)
        body(k, c, v, j);
}

#endif /* HEADER */

// CHECK1-LABEL: define {{[^@]+}}@body
// CHECK1-SAME: (...) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK1-SAME: () #[[ATTR1:[0-9]+]] section ".text.startup" {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_ZN1SC1Ev(ptr noundef nonnull align 4 dereferenceable(4) @s)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SC1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SC2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[I2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK1-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[I3]], ptr [[I2]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    br label [[FOR_COND:%.*]]
// CHECK1:       for.cond:
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP0]], 4
// CHECK1-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK1:       for.body:
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 3, [[TMP1]]
// CHECK1-NEXT:    store i32 [[SUB]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP2]], 3
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 7, [[MUL]]
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[I2]], align 8
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[I2]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP5]])
// CHECK1-NEXT:    br label [[FOR_INC:%.*]]
// CHECK1:       for.inc:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK1:       for.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo1
// CHECK1-SAME: (i32 noundef [[START:%.*]], i32 noundef [[END:%.*]], i32 noundef [[STEP:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[START_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[END_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[STEP_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTNEW_STEP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[START]], ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[END]], ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[STEP]], ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 [[TMP4]], [[TMP5]]
// CHECK1-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], [[TMP6]]
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], [[TMP7]]
// CHECK1-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    br label [[FOR_COND:%.*]]
// CHECK1:       for.cond:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD5:%.*]] = add i32 [[TMP9]], 1
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP8]], [[ADD5]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK1:       for.body:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add i32 [[TMP10]], 1
// CHECK1-NEXT:    [[SUB7:%.*]] = sub i32 [[ADD6]], 1
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[SUB8:%.*]] = sub i32 [[SUB7]], [[TMP11]]
// CHECK1-NEXT:    store i32 [[SUB8]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    [[ADD9:%.*]] = add i32 [[TMP12]], [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD9]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP15]])
// CHECK1-NEXT:    br label [[FOR_INC:%.*]]
// CHECK1:       for.inc:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add i32 [[TMP16]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK1:       for.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo2
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2:[0-9]+]])
// CHECK1-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 3, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP0]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], 3
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP2]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP4]], [[TMP5]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP6]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 3, [[TMP7]]
// CHECK1-NEXT:    store i32 [[SUB]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP8]], 3
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 7, [[MUL2]]
// CHECK1-NEXT:    store i32 [[ADD3]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP9]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3:[0-9]+]], i32 [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo3
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2]])
// CHECK1-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 63, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP0]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], 63
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 63, [[COND_TRUE]] ], [ [[TMP2]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP4]], [[TMP5]]
// CHECK1-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP6]], 16
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV]], 3
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 7, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[K]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[DIV4:%.*]] = sdiv i32 [[TMP8]], 16
// CHECK1-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[DIV4]], 16
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], [[MUL5]]
// CHECK1-NEXT:    [[DIV6:%.*]] = sdiv i32 [[SUB]], 4
// CHECK1-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[DIV6]], 1
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL7]]
// CHECK1-NEXT:    store i32 [[ADD8]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[DIV9:%.*]] = sdiv i32 [[TMP10]], 16
// CHECK1-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 16
// CHECK1-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP9]], [[MUL10]]
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[DIV12:%.*]] = sdiv i32 [[TMP12]], 16
// CHECK1-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[DIV12]], 16
// CHECK1-NEXT:    [[SUB14:%.*]] = sub nsw i32 [[TMP11]], [[MUL13]]
// CHECK1-NEXT:    [[DIV15:%.*]] = sdiv i32 [[SUB14]], 4
// CHECK1-NEXT:    [[MUL16:%.*]] = mul nsw i32 [[DIV15]], 4
// CHECK1-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[SUB11]], [[MUL16]]
// CHECK1-NEXT:    [[MUL18:%.*]] = mul nsw i32 [[SUB17]], 3
// CHECK1-NEXT:    [[ADD19:%.*]] = add nsw i32 7, [[MUL18]]
// CHECK1-NEXT:    store i32 [[ADD19]], ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[SUB20:%.*]] = sub nsw i32 3, [[TMP13]]
// CHECK1-NEXT:    store i32 [[SUB20]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[MUL21:%.*]] = mul nsw i32 [[TMP14]], 3
// CHECK1-NEXT:    [[ADD22:%.*]] = add nsw i32 7, [[MUL21]]
// CHECK1-NEXT:    store i32 [[ADD22]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[K]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[J]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP15]], i32 noundef [[TMP16]], i32 noundef [[TMP17]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD23:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    store i32 [[ADD23]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo4
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 0, ptr @foo4.omp_outlined)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo4.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 3, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP1]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 3, [[TMP8]]
// CHECK1-NEXT:    store i32 [[SUB]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP9]], 3
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 7, [[MUL2]]
// CHECK1-NEXT:    store i32 [[ADD3]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP10]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@tfoo5
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_Z4foo5IiTnT_Li3EEvS0_S0_(i32 noundef 0, i32 noundef 42)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z4foo5IiTnT_Li3EEvS0_S0_
// CHECK1-SAME: (i32 noundef [[START:%.*]], i32 noundef [[END:%.*]]) #[[ATTR0]] comdat {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[START_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[END_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[START]], ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[END]], ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK1-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], 3
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 3
// CHECK1-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    br label [[FOR_COND:%.*]]
// CHECK1:       for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD5:%.*]] = add i32 [[TMP6]], 1
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP5]], [[ADD5]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK1:       for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add i32 [[TMP7]], 1
// CHECK1-NEXT:    [[SUB7:%.*]] = sub i32 [[ADD6]], 1
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[SUB8:%.*]] = sub i32 [[SUB7]], [[TMP8]]
// CHECK1-NEXT:    store i32 [[SUB8]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul i32 [[TMP10]], 3
// CHECK1-NEXT:    [[ADD9:%.*]] = add i32 [[TMP9]], [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD9]], ptr [[I]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP11]])
// CHECK1-NEXT:    br label [[FOR_INC:%.*]]
// CHECK1:       for.inc:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add i32 [[TMP12]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK1-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK1:       for.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo6
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[ARR:%.*]] = alloca [128 x double], align 16
// CHECK1-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTFORWARD_IV___BEGIN2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTREVERSED_IV___BEGIN2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK1-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP0]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 128
// CHECK1-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY1:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP1]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY1]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY2:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY2]], ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[DOTCAPTURE_EXPR_3]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_3]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK1-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP4]] to i64
// CHECK1-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP5]] to i64
// CHECK1-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK1-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i64 [[SUB]], 1
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD]], 1
// CHECK1-NEXT:    [[SUB5:%.*]] = sub nsw i64 [[DIV]], 1
// CHECK1-NEXT:    store i64 [[SUB5]], ptr [[DOTCAPTURE_EXPR_4]], align 8
// CHECK1-NEXT:    store i64 0, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK1-NEXT:    br label [[FOR_COND:%.*]]
// CHECK1:       for.cond:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_4]], align 8
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i64 [[TMP7]], 1
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i64 [[TMP6]], [[ADD6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK1:       for.body:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_4]], align 8
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i64 [[TMP8]], 1
// CHECK1-NEXT:    [[SUB8:%.*]] = sub nsw i64 [[ADD7]], 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK1-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[SUB8]], [[TMP9]]
// CHECK1-NEXT:    store i64 [[SUB9]], ptr [[DOTREVERSED_IV___BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTREVERSED_IV___BEGIN2]], align 8
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP11]], 1
// CHECK1-NEXT:    [[ADD_PTR10:%.*]] = getelementptr inbounds double, ptr [[TMP10]], i64 [[MUL]]
// CHECK1-NEXT:    store ptr [[ADD_PTR10]], ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK1-NEXT:    store ptr [[TMP12]], ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load double, ptr [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[C]], align 4
// CHECK1-NEXT:    call void (...) @body(double noundef [[TMP14]], i32 noundef [[TMP15]])
// CHECK1-NEXT:    br label [[FOR_INC:%.*]]
// CHECK1:       for.inc:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i64 [[TMP16]], 1
// CHECK1-NEXT:    store i64 [[INC]], ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK1-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK1:       for.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@foo7
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A:%.*]] = alloca [128 x double], align 16
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[__RANGE3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__END3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__BEGIN3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV___BEGIN3:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[K15:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTFORWARD_IV___BEGIN316:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[J17:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREVERSED_IV___BEGIN3:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2]])
// CHECK1-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK1-NEXT:    store ptr [[A]], ptr [[__RANGE3]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[__RANGE3]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP1]], i64 0, i64 0
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 128
// CHECK1-NEXT:    store ptr [[ADD_PTR]], ptr [[__END3]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[__RANGE3]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY3:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY3]], ptr [[__BEGIN3]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[__RANGE3]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY4:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[ARRAYDECAY4]], ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[__END3]], align 8
// CHECK1-NEXT:    store ptr [[TMP4]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK1-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP5]] to i64
// CHECK1-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP6]] to i64
// CHECK1-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK1-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i64 [[SUB]], 1
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD]], 1
// CHECK1-NEXT:    [[SUB7:%.*]] = sub nsw i64 [[DIV]], 1
// CHECK1-NEXT:    store i64 [[SUB7]], ptr [[DOTCAPTURE_EXPR_6]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_6]], align 8
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i64 [[TMP7]], 1
// CHECK1-NEXT:    store i64 [[ADD9]], ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB11:%.*]] = sub nsw i64 [[TMP8]], 0
// CHECK1-NEXT:    [[DIV12:%.*]] = sdiv i64 [[SUB11]], 1
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i64 4, [[DIV12]]
// CHECK1-NEXT:    [[MUL13:%.*]] = mul nsw i64 [[MUL]], 4
// CHECK1-NEXT:    [[SUB14:%.*]] = sub nsw i64 [[MUL13]], 1
// CHECK1-NEXT:    store i64 [[SUB14]], ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    store i32 7, ptr [[K]], align 4
// CHECK1-NEXT:    store i64 0, ptr [[DOTFORWARD_IV___BEGIN3]], align 8
// CHECK1-NEXT:    store i32 7, ptr [[J]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i64 0, [[TMP9]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB1]], i32 [[TMP0]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    [[CMP18:%.*]] = icmp sgt i64 [[TMP11]], [[TMP12]]
// CHECK1-NEXT:    br i1 [[CMP18]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i64 [[COND]], ptr [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP19:%.*]] = icmp sle i64 [[TMP16]], [[TMP17]]
// CHECK1-NEXT:    br i1 [[CMP19]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB20:%.*]] = sub nsw i64 [[TMP19]], 0
// CHECK1-NEXT:    [[DIV21:%.*]] = sdiv i64 [[SUB20]], 1
// CHECK1-NEXT:    [[MUL22:%.*]] = mul nsw i64 1, [[DIV21]]
// CHECK1-NEXT:    [[MUL23:%.*]] = mul nsw i64 [[MUL22]], 4
// CHECK1-NEXT:    [[DIV24:%.*]] = sdiv i64 [[TMP18]], [[MUL23]]
// CHECK1-NEXT:    [[MUL25:%.*]] = mul nsw i64 [[DIV24]], 3
// CHECK1-NEXT:    [[ADD26:%.*]] = add nsw i64 7, [[MUL25]]
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[ADD26]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], ptr [[K15]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB27:%.*]] = sub nsw i64 [[TMP22]], 0
// CHECK1-NEXT:    [[DIV28:%.*]] = sdiv i64 [[SUB27]], 1
// CHECK1-NEXT:    [[MUL29:%.*]] = mul nsw i64 1, [[DIV28]]
// CHECK1-NEXT:    [[MUL30:%.*]] = mul nsw i64 [[MUL29]], 4
// CHECK1-NEXT:    [[DIV31:%.*]] = sdiv i64 [[TMP21]], [[MUL30]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB32:%.*]] = sub nsw i64 [[TMP23]], 0
// CHECK1-NEXT:    [[DIV33:%.*]] = sdiv i64 [[SUB32]], 1
// CHECK1-NEXT:    [[MUL34:%.*]] = mul nsw i64 1, [[DIV33]]
// CHECK1-NEXT:    [[MUL35:%.*]] = mul nsw i64 [[MUL34]], 4
// CHECK1-NEXT:    [[MUL36:%.*]] = mul nsw i64 [[DIV31]], [[MUL35]]
// CHECK1-NEXT:    [[SUB37:%.*]] = sub nsw i64 [[TMP20]], [[MUL36]]
// CHECK1-NEXT:    [[DIV38:%.*]] = sdiv i64 [[SUB37]], 4
// CHECK1-NEXT:    [[MUL39:%.*]] = mul nsw i64 [[DIV38]], 1
// CHECK1-NEXT:    [[ADD40:%.*]] = add nsw i64 0, [[MUL39]]
// CHECK1-NEXT:    store i64 [[ADD40]], ptr [[DOTFORWARD_IV___BEGIN316]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB41:%.*]] = sub nsw i64 [[TMP26]], 0
// CHECK1-NEXT:    [[DIV42:%.*]] = sdiv i64 [[SUB41]], 1
// CHECK1-NEXT:    [[MUL43:%.*]] = mul nsw i64 1, [[DIV42]]
// CHECK1-NEXT:    [[MUL44:%.*]] = mul nsw i64 [[MUL43]], 4
// CHECK1-NEXT:    [[DIV45:%.*]] = sdiv i64 [[TMP25]], [[MUL44]]
// CHECK1-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB46:%.*]] = sub nsw i64 [[TMP27]], 0
// CHECK1-NEXT:    [[DIV47:%.*]] = sdiv i64 [[SUB46]], 1
// CHECK1-NEXT:    [[MUL48:%.*]] = mul nsw i64 1, [[DIV47]]
// CHECK1-NEXT:    [[MUL49:%.*]] = mul nsw i64 [[MUL48]], 4
// CHECK1-NEXT:    [[MUL50:%.*]] = mul nsw i64 [[DIV45]], [[MUL49]]
// CHECK1-NEXT:    [[SUB51:%.*]] = sub nsw i64 [[TMP24]], [[MUL50]]
// CHECK1-NEXT:    [[TMP28:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB52:%.*]] = sub nsw i64 [[TMP30]], 0
// CHECK1-NEXT:    [[DIV53:%.*]] = sdiv i64 [[SUB52]], 1
// CHECK1-NEXT:    [[MUL54:%.*]] = mul nsw i64 1, [[DIV53]]
// CHECK1-NEXT:    [[MUL55:%.*]] = mul nsw i64 [[MUL54]], 4
// CHECK1-NEXT:    [[DIV56:%.*]] = sdiv i64 [[TMP29]], [[MUL55]]
// CHECK1-NEXT:    [[TMP31:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK1-NEXT:    [[SUB57:%.*]] = sub nsw i64 [[TMP31]], 0
// CHECK1-NEXT:    [[DIV58:%.*]] = sdiv i64 [[SUB57]], 1
// CHECK1-NEXT:    [[MUL59:%.*]] = mul nsw i64 1, [[DIV58]]
// CHECK1-NEXT:    [[MUL60:%.*]] = mul nsw i64 [[MUL59]], 4
// CHECK1-NEXT:    [[MUL61:%.*]] = mul nsw i64 [[DIV56]], [[MUL60]]
// CHECK1-NEXT:    [[SUB62:%.*]] = sub nsw i64 [[TMP28]], [[MUL61]]
// CHECK1-NEXT:    [[DIV63:%.*]] = sdiv i64 [[SUB62]], 4
// CHECK1-NEXT:    [[MUL64:%.*]] = mul nsw i64 [[DIV63]], 4
// CHECK1-NEXT:    [[SUB65:%.*]] = sub nsw i64 [[SUB51]], [[MUL64]]
// CHECK1-NEXT:    [[MUL66:%.*]] = mul nsw i64 [[SUB65]], 3
// CHECK1-NEXT:    [[ADD67:%.*]] = add nsw i64 7, [[MUL66]]
// CHECK1-NEXT:    [[CONV68:%.*]] = trunc i64 [[ADD67]] to i32
// CHECK1-NEXT:    store i32 [[CONV68]], ptr [[J17]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_6]], align 8
// CHECK1-NEXT:    [[ADD69:%.*]] = add nsw i64 [[TMP32]], 1
// CHECK1-NEXT:    [[SUB70:%.*]] = sub nsw i64 [[ADD69]], 1
// CHECK1-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN316]], align 8
// CHECK1-NEXT:    [[SUB71:%.*]] = sub nsw i64 [[SUB70]], [[TMP33]]
// CHECK1-NEXT:    store i64 [[SUB71]], ptr [[DOTREVERSED_IV___BEGIN3]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = load i64, ptr [[DOTREVERSED_IV___BEGIN3]], align 8
// CHECK1-NEXT:    [[MUL72:%.*]] = mul nsw i64 [[TMP35]], 1
// CHECK1-NEXT:    [[ADD_PTR73:%.*]] = getelementptr inbounds double, ptr [[TMP34]], i64 [[MUL72]]
// CHECK1-NEXT:    store ptr [[ADD_PTR73]], ptr [[__BEGIN3]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[__BEGIN3]], align 8
// CHECK1-NEXT:    store ptr [[TMP36]], ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, ptr [[K15]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, ptr [[C]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load ptr, ptr [[V]], align 8
// CHECK1-NEXT:    [[TMP40:%.*]] = load double, ptr [[TMP39]], align 8
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, ptr [[J17]], align 4
// CHECK1-NEXT:    call void (...) @body(i32 noundef [[TMP37]], i32 noundef [[TMP38]], double noundef [[TMP40]], i32 noundef [[TMP41]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP42:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[ADD74:%.*]] = add nsw i64 [[TMP42]], 1
// CHECK1-NEXT:    store i64 [[ADD74]], ptr [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_reverse_codegen.cpp
// CHECK1-SAME: () #[[ATTR1]] section ".text.startup" {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__cxx_global_var_init()
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK2-SAME: () #[[ATTR0:[0-9]+]] section ".text.startup" {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_ZN1SC1Ev(ptr noundef nonnull align 4 dereferenceable(4) @s)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SC1Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN1SC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SC2Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[I2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK2-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[I3]], ptr [[I2]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    br label [[FOR_COND:%.*]]
// CHECK2:       for.cond:
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP0]], 4
// CHECK2-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK2:       for.body:
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 3, [[TMP1]]
// CHECK2-NEXT:    store i32 [[SUB]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP2]], 3
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 7, [[MUL]]
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[I2]], align 8
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[TMP3]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[I2]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP5]])
// CHECK2-NEXT:    br label [[FOR_INC:%.*]]
// CHECK2:       for.inc:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK2:       for.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@body
// CHECK2-SAME: (...) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo1
// CHECK2-SAME: (i32 noundef [[START:%.*]], i32 noundef [[END:%.*]], i32 noundef [[STEP:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[START_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[END_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[STEP_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTNEW_STEP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32 [[START]], ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[END]], ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[STEP]], ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[STEP_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub i32 [[TMP4]], [[TMP5]]
// CHECK2-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], [[TMP6]]
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], [[TMP7]]
// CHECK2-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    br label [[FOR_COND:%.*]]
// CHECK2:       for.cond:
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD5:%.*]] = add i32 [[TMP9]], 1
// CHECK2-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP8]], [[ADD5]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK2:       for.body:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD6:%.*]] = add i32 [[TMP10]], 1
// CHECK2-NEXT:    [[SUB7:%.*]] = sub i32 [[ADD6]], 1
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[SUB8:%.*]] = sub i32 [[SUB7]], [[TMP11]]
// CHECK2-NEXT:    store i32 [[SUB8]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTNEW_STEP]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    [[ADD9:%.*]] = add i32 [[TMP12]], [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD9]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP15]])
// CHECK2-NEXT:    br label [[FOR_INC:%.*]]
// CHECK2:       for.inc:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add i32 [[TMP16]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK2:       for.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo2
// CHECK2-SAME: () #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2:[0-9]+]])
// CHECK2-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 3, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP0]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], 3
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP2]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP4]], [[TMP5]]
// CHECK2-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP6]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 3, [[TMP7]]
// CHECK2-NEXT:    store i32 [[SUB]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP8]], 3
// CHECK2-NEXT:    [[ADD3:%.*]] = add nsw i32 7, [[MUL2]]
// CHECK2-NEXT:    store i32 [[ADD3]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP9]])
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK2-NEXT:    store i32 [[ADD4]], ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3:[0-9]+]], i32 [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo3
// CHECK2-SAME: () #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2]])
// CHECK2-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 63, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP0]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP1]], 63
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 63, [[COND_TRUE]] ], [ [[TMP2]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP4]], [[TMP5]]
// CHECK2-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP6]], 16
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV]], 3
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 7, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[K]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[DIV4:%.*]] = sdiv i32 [[TMP8]], 16
// CHECK2-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[DIV4]], 16
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], [[MUL5]]
// CHECK2-NEXT:    [[DIV6:%.*]] = sdiv i32 [[SUB]], 4
// CHECK2-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[DIV6]], 1
// CHECK2-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL7]]
// CHECK2-NEXT:    store i32 [[ADD8]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[DIV9:%.*]] = sdiv i32 [[TMP10]], 16
// CHECK2-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 16
// CHECK2-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP9]], [[MUL10]]
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[DIV12:%.*]] = sdiv i32 [[TMP12]], 16
// CHECK2-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[DIV12]], 16
// CHECK2-NEXT:    [[SUB14:%.*]] = sub nsw i32 [[TMP11]], [[MUL13]]
// CHECK2-NEXT:    [[DIV15:%.*]] = sdiv i32 [[SUB14]], 4
// CHECK2-NEXT:    [[MUL16:%.*]] = mul nsw i32 [[DIV15]], 4
// CHECK2-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[SUB11]], [[MUL16]]
// CHECK2-NEXT:    [[MUL18:%.*]] = mul nsw i32 [[SUB17]], 3
// CHECK2-NEXT:    [[ADD19:%.*]] = add nsw i32 7, [[MUL18]]
// CHECK2-NEXT:    store i32 [[ADD19]], ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[SUB20:%.*]] = sub nsw i32 3, [[TMP13]]
// CHECK2-NEXT:    store i32 [[SUB20]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[MUL21:%.*]] = mul nsw i32 [[TMP14]], 3
// CHECK2-NEXT:    [[ADD22:%.*]] = add nsw i32 7, [[MUL21]]
// CHECK2-NEXT:    store i32 [[ADD22]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[K]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, ptr [[J]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP15]], i32 noundef [[TMP16]], i32 noundef [[TMP17]])
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD23:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK2-NEXT:    store i32 [[ADD23]], ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo4
// CHECK2-SAME: () #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 0, ptr @foo4.omp_outlined)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo4.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR4:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32 7, ptr [[I]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 3, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP1]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK2-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 3, [[TMP8]]
// CHECK2-NEXT:    store i32 [[SUB]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP9]], 3
// CHECK2-NEXT:    [[ADD3:%.*]] = add nsw i32 7, [[MUL2]]
// CHECK2-NEXT:    store i32 [[ADD3]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP10]])
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK2-NEXT:    store i32 [[ADD4]], ptr [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo6
// CHECK2-SAME: () #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[ARR:%.*]] = alloca [128 x double], align 16
// CHECK2-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTFORWARD_IV___BEGIN2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTREVERSED_IV___BEGIN2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK2-NEXT:    store ptr [[ARR]], ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP0]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 128
// CHECK2-NEXT:    store ptr [[ADD_PTR]], ptr [[__END2]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY1:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP1]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY1]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[__RANGE2]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY2:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY2]], ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[__END2]], align 8
// CHECK2-NEXT:    store ptr [[TMP3]], ptr [[DOTCAPTURE_EXPR_3]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_3]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK2-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP4]] to i64
// CHECK2-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP5]] to i64
// CHECK2-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK2-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i64 [[SUB]], 1
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD]], 1
// CHECK2-NEXT:    [[SUB5:%.*]] = sub nsw i64 [[DIV]], 1
// CHECK2-NEXT:    store i64 [[SUB5]], ptr [[DOTCAPTURE_EXPR_4]], align 8
// CHECK2-NEXT:    store i64 0, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK2-NEXT:    br label [[FOR_COND:%.*]]
// CHECK2:       for.cond:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_4]], align 8
// CHECK2-NEXT:    [[ADD6:%.*]] = add nsw i64 [[TMP7]], 1
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i64 [[TMP6]], [[ADD6]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK2:       for.body:
// CHECK2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_4]], align 8
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i64 [[TMP8]], 1
// CHECK2-NEXT:    [[SUB8:%.*]] = sub nsw i64 [[ADD7]], 1
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK2-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[SUB8]], [[TMP9]]
// CHECK2-NEXT:    store i64 [[SUB9]], ptr [[DOTREVERSED_IV___BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTREVERSED_IV___BEGIN2]], align 8
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP11]], 1
// CHECK2-NEXT:    [[ADD_PTR10:%.*]] = getelementptr inbounds double, ptr [[TMP10]], i64 [[MUL]]
// CHECK2-NEXT:    store ptr [[ADD_PTR10]], ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[__BEGIN2]], align 8
// CHECK2-NEXT:    store ptr [[TMP12]], ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = load double, ptr [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[C]], align 4
// CHECK2-NEXT:    call void (...) @body(double noundef [[TMP14]], i32 noundef [[TMP15]])
// CHECK2-NEXT:    br label [[FOR_INC:%.*]]
// CHECK2:       for.inc:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i64 [[TMP16]], 1
// CHECK2-NEXT:    store i64 [[INC]], ptr [[DOTFORWARD_IV___BEGIN2]], align 8
// CHECK2-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK2:       for.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@foo7
// CHECK2-SAME: () #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A:%.*]] = alloca [128 x double], align 16
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[__RANGE3:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__END3:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__BEGIN3:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[K:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV___BEGIN3:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[K15:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV___BEGIN316:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[J17:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV___BEGIN3:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[V:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2]])
// CHECK2-NEXT:    store i32 42, ptr [[C]], align 4
// CHECK2-NEXT:    store ptr [[A]], ptr [[__RANGE3]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[__RANGE3]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP1]], i64 0, i64 0
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds double, ptr [[ARRAYDECAY]], i64 128
// CHECK2-NEXT:    store ptr [[ADD_PTR]], ptr [[__END3]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[__RANGE3]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY3:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY3]], ptr [[__BEGIN3]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[__RANGE3]], align 8
// CHECK2-NEXT:    [[ARRAYDECAY4:%.*]] = getelementptr inbounds [128 x double], ptr [[TMP3]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[ARRAYDECAY4]], ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[__END3]], align 8
// CHECK2-NEXT:    store ptr [[TMP4]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_5]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK2-NEXT:    [[SUB_PTR_LHS_CAST:%.*]] = ptrtoint ptr [[TMP5]] to i64
// CHECK2-NEXT:    [[SUB_PTR_RHS_CAST:%.*]] = ptrtoint ptr [[TMP6]] to i64
// CHECK2-NEXT:    [[SUB_PTR_SUB:%.*]] = sub i64 [[SUB_PTR_LHS_CAST]], [[SUB_PTR_RHS_CAST]]
// CHECK2-NEXT:    [[SUB_PTR_DIV:%.*]] = sdiv exact i64 [[SUB_PTR_SUB]], 8
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i64 [[SUB_PTR_DIV]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i64 [[SUB]], 1
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD]], 1
// CHECK2-NEXT:    [[SUB7:%.*]] = sub nsw i64 [[DIV]], 1
// CHECK2-NEXT:    store i64 [[SUB7]], ptr [[DOTCAPTURE_EXPR_6]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_6]], align 8
// CHECK2-NEXT:    [[ADD9:%.*]] = add nsw i64 [[TMP7]], 1
// CHECK2-NEXT:    store i64 [[ADD9]], ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB11:%.*]] = sub nsw i64 [[TMP8]], 0
// CHECK2-NEXT:    [[DIV12:%.*]] = sdiv i64 [[SUB11]], 1
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i64 4, [[DIV12]]
// CHECK2-NEXT:    [[MUL13:%.*]] = mul nsw i64 [[MUL]], 4
// CHECK2-NEXT:    [[SUB14:%.*]] = sub nsw i64 [[MUL13]], 1
// CHECK2-NEXT:    store i64 [[SUB14]], ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    store i32 7, ptr [[K]], align 4
// CHECK2-NEXT:    store i64 0, ptr [[DOTFORWARD_IV___BEGIN3]], align 8
// CHECK2-NEXT:    store i32 7, ptr [[J]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i64 0, [[TMP9]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB]], align 8
// CHECK2-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB1]], i32 [[TMP0]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    [[CMP18:%.*]] = icmp sgt i64 [[TMP11]], [[TMP12]]
// CHECK2-NEXT:    br i1 [[CMP18]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_10]], align 8
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i64 [[COND]], ptr [[DOTOMP_UB]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK2-NEXT:    store i64 [[TMP15]], ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK2-NEXT:    [[CMP19:%.*]] = icmp sle i64 [[TMP16]], [[TMP17]]
// CHECK2-NEXT:    br i1 [[CMP19]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB20:%.*]] = sub nsw i64 [[TMP19]], 0
// CHECK2-NEXT:    [[DIV21:%.*]] = sdiv i64 [[SUB20]], 1
// CHECK2-NEXT:    [[MUL22:%.*]] = mul nsw i64 1, [[DIV21]]
// CHECK2-NEXT:    [[MUL23:%.*]] = mul nsw i64 [[MUL22]], 4
// CHECK2-NEXT:    [[DIV24:%.*]] = sdiv i64 [[TMP18]], [[MUL23]]
// CHECK2-NEXT:    [[MUL25:%.*]] = mul nsw i64 [[DIV24]], 3
// CHECK2-NEXT:    [[ADD26:%.*]] = add nsw i64 7, [[MUL25]]
// CHECK2-NEXT:    [[CONV:%.*]] = trunc i64 [[ADD26]] to i32
// CHECK2-NEXT:    store i32 [[CONV]], ptr [[K15]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB27:%.*]] = sub nsw i64 [[TMP22]], 0
// CHECK2-NEXT:    [[DIV28:%.*]] = sdiv i64 [[SUB27]], 1
// CHECK2-NEXT:    [[MUL29:%.*]] = mul nsw i64 1, [[DIV28]]
// CHECK2-NEXT:    [[MUL30:%.*]] = mul nsw i64 [[MUL29]], 4
// CHECK2-NEXT:    [[DIV31:%.*]] = sdiv i64 [[TMP21]], [[MUL30]]
// CHECK2-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB32:%.*]] = sub nsw i64 [[TMP23]], 0
// CHECK2-NEXT:    [[DIV33:%.*]] = sdiv i64 [[SUB32]], 1
// CHECK2-NEXT:    [[MUL34:%.*]] = mul nsw i64 1, [[DIV33]]
// CHECK2-NEXT:    [[MUL35:%.*]] = mul nsw i64 [[MUL34]], 4
// CHECK2-NEXT:    [[MUL36:%.*]] = mul nsw i64 [[DIV31]], [[MUL35]]
// CHECK2-NEXT:    [[SUB37:%.*]] = sub nsw i64 [[TMP20]], [[MUL36]]
// CHECK2-NEXT:    [[DIV38:%.*]] = sdiv i64 [[SUB37]], 4
// CHECK2-NEXT:    [[MUL39:%.*]] = mul nsw i64 [[DIV38]], 1
// CHECK2-NEXT:    [[ADD40:%.*]] = add nsw i64 0, [[MUL39]]
// CHECK2-NEXT:    store i64 [[ADD40]], ptr [[DOTFORWARD_IV___BEGIN316]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB41:%.*]] = sub nsw i64 [[TMP26]], 0
// CHECK2-NEXT:    [[DIV42:%.*]] = sdiv i64 [[SUB41]], 1
// CHECK2-NEXT:    [[MUL43:%.*]] = mul nsw i64 1, [[DIV42]]
// CHECK2-NEXT:    [[MUL44:%.*]] = mul nsw i64 [[MUL43]], 4
// CHECK2-NEXT:    [[DIV45:%.*]] = sdiv i64 [[TMP25]], [[MUL44]]
// CHECK2-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB46:%.*]] = sub nsw i64 [[TMP27]], 0
// CHECK2-NEXT:    [[DIV47:%.*]] = sdiv i64 [[SUB46]], 1
// CHECK2-NEXT:    [[MUL48:%.*]] = mul nsw i64 1, [[DIV47]]
// CHECK2-NEXT:    [[MUL49:%.*]] = mul nsw i64 [[MUL48]], 4
// CHECK2-NEXT:    [[MUL50:%.*]] = mul nsw i64 [[DIV45]], [[MUL49]]
// CHECK2-NEXT:    [[SUB51:%.*]] = sub nsw i64 [[TMP24]], [[MUL50]]
// CHECK2-NEXT:    [[TMP28:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB52:%.*]] = sub nsw i64 [[TMP30]], 0
// CHECK2-NEXT:    [[DIV53:%.*]] = sdiv i64 [[SUB52]], 1
// CHECK2-NEXT:    [[MUL54:%.*]] = mul nsw i64 1, [[DIV53]]
// CHECK2-NEXT:    [[MUL55:%.*]] = mul nsw i64 [[MUL54]], 4
// CHECK2-NEXT:    [[DIV56:%.*]] = sdiv i64 [[TMP29]], [[MUL55]]
// CHECK2-NEXT:    [[TMP31:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_8]], align 8
// CHECK2-NEXT:    [[SUB57:%.*]] = sub nsw i64 [[TMP31]], 0
// CHECK2-NEXT:    [[DIV58:%.*]] = sdiv i64 [[SUB57]], 1
// CHECK2-NEXT:    [[MUL59:%.*]] = mul nsw i64 1, [[DIV58]]
// CHECK2-NEXT:    [[MUL60:%.*]] = mul nsw i64 [[MUL59]], 4
// CHECK2-NEXT:    [[MUL61:%.*]] = mul nsw i64 [[DIV56]], [[MUL60]]
// CHECK2-NEXT:    [[SUB62:%.*]] = sub nsw i64 [[TMP28]], [[MUL61]]
// CHECK2-NEXT:    [[DIV63:%.*]] = sdiv i64 [[SUB62]], 4
// CHECK2-NEXT:    [[MUL64:%.*]] = mul nsw i64 [[DIV63]], 4
// CHECK2-NEXT:    [[SUB65:%.*]] = sub nsw i64 [[SUB51]], [[MUL64]]
// CHECK2-NEXT:    [[MUL66:%.*]] = mul nsw i64 [[SUB65]], 3
// CHECK2-NEXT:    [[ADD67:%.*]] = add nsw i64 7, [[MUL66]]
// CHECK2-NEXT:    [[CONV68:%.*]] = trunc i64 [[ADD67]] to i32
// CHECK2-NEXT:    store i32 [[CONV68]], ptr [[J17]], align 4
// CHECK2-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_6]], align 8
// CHECK2-NEXT:    [[ADD69:%.*]] = add nsw i64 [[TMP32]], 1
// CHECK2-NEXT:    [[SUB70:%.*]] = sub nsw i64 [[ADD69]], 1
// CHECK2-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTFORWARD_IV___BEGIN316]], align 8
// CHECK2-NEXT:    [[SUB71:%.*]] = sub nsw i64 [[SUB70]], [[TMP33]]
// CHECK2-NEXT:    store i64 [[SUB71]], ptr [[DOTREVERSED_IV___BEGIN3]], align 8
// CHECK2-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[DOTCAPTURE_EXPR_]], align 8
// CHECK2-NEXT:    [[TMP35:%.*]] = load i64, ptr [[DOTREVERSED_IV___BEGIN3]], align 8
// CHECK2-NEXT:    [[MUL72:%.*]] = mul nsw i64 [[TMP35]], 1
// CHECK2-NEXT:    [[ADD_PTR73:%.*]] = getelementptr inbounds double, ptr [[TMP34]], i64 [[MUL72]]
// CHECK2-NEXT:    store ptr [[ADD_PTR73]], ptr [[__BEGIN3]], align 8
// CHECK2-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[__BEGIN3]], align 8
// CHECK2-NEXT:    store ptr [[TMP36]], ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP37:%.*]] = load i32, ptr [[K15]], align 4
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, ptr [[C]], align 4
// CHECK2-NEXT:    [[TMP39:%.*]] = load ptr, ptr [[V]], align 8
// CHECK2-NEXT:    [[TMP40:%.*]] = load double, ptr [[TMP39]], align 8
// CHECK2-NEXT:    [[TMP41:%.*]] = load i32, ptr [[J17]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP37]], i32 noundef [[TMP38]], double noundef [[TMP40]], i32 noundef [[TMP41]])
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP42:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    [[ADD74:%.*]] = add nsw i64 [[TMP42]], 1
// CHECK2-NEXT:    store i64 [[ADD74]], ptr [[DOTOMP_IV]], align 8
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB3]], i32 [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@tfoo5
// CHECK2-SAME: () #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_Z4foo5IiTnT_Li3EEvS0_S0_(i32 noundef 0, i32 noundef 42)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z4foo5IiTnT_Li3EEvS0_S0_
// CHECK2-SAME: (i32 noundef [[START:%.*]], i32 noundef [[END:%.*]]) #[[ATTR1]] comdat {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[START_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[END_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTFORWARD_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREVERSED_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32 [[START]], ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[END]], ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[START_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[END_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK2-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], 3
// CHECK2-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 3
// CHECK2-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    br label [[FOR_COND:%.*]]
// CHECK2:       for.cond:
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD5:%.*]] = add i32 [[TMP6]], 1
// CHECK2-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP5]], [[ADD5]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK2:       for.body:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD6:%.*]] = add i32 [[TMP7]], 1
// CHECK2-NEXT:    [[SUB7:%.*]] = sub i32 [[ADD6]], 1
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[SUB8:%.*]] = sub i32 [[SUB7]], [[TMP8]]
// CHECK2-NEXT:    store i32 [[SUB8]], ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTREVERSED_IV_I]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul i32 [[TMP10]], 3
// CHECK2-NEXT:    [[ADD9:%.*]] = add i32 [[TMP9]], [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD9]], ptr [[I]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4
// CHECK2-NEXT:    call void (...) @body(i32 noundef [[TMP11]])
// CHECK2-NEXT:    br label [[FOR_INC:%.*]]
// CHECK2:       for.inc:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add i32 [[TMP12]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[DOTFORWARD_IV_I]], align 4
// CHECK2-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK2:       for.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_reverse_codegen.cpp
// CHECK2-SAME: () #[[ATTR0]] section ".text.startup" {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__cxx_global_var_init()
// CHECK2-NEXT:    ret void

