; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=+sse4.1 | FileCheck %s --check-prefix=CHECK --check-prefix=SSE41
; RUN: llc < %s -mtriple=i386-apple-darwin -mcpu=knl | FileCheck %s --check-prefix=CHECK --check-prefix=KNL

define <2 x double> @test_x86_sse41_blendvpd(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2) {
; SSE41-LABEL: test_x86_sse41_blendvpd:
; SSE41:       ## BB#0:
; SSE41-NEXT:    movapd %xmm0, %xmm3
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm1, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_blendvpd:
; KNL:       ## BB#0:
; KNL-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.blendvpd(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.blendvpd(<2 x double>, <2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse41_blendvps(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2) {
; SSE41-LABEL: test_x86_sse41_blendvps:
; SSE41:       ## BB#0:
; SSE41-NEXT:    movaps %xmm0, %xmm3
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm1, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_blendvps:
; KNL:       ## BB#0:
; KNL-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.blendvps(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.blendvps(<4 x float>, <4 x float>, <4 x float>) nounwind readnone


define <2 x double> @test_x86_sse41_dppd(<2 x double> %a0, <2 x double> %a1) {
; SSE41-LABEL: test_x86_sse41_dppd:
; SSE41:       ## BB#0:
; SSE41-NEXT:    dppd $7, %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_dppd:
; KNL:       ## BB#0:
; KNL-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.dppd(<2 x double> %a0, <2 x double> %a1, i8 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.dppd(<2 x double>, <2 x double>, i8) nounwind readnone


define <4 x float> @test_x86_sse41_dpps(<4 x float> %a0, <4 x float> %a1) {
; SSE41-LABEL: test_x86_sse41_dpps:
; SSE41:       ## BB#0:
; SSE41-NEXT:    dpps $7, %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_dpps:
; KNL:       ## BB#0:
; KNL-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.dpps(<4 x float> %a0, <4 x float> %a1, i8 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.dpps(<4 x float>, <4 x float>, i8) nounwind readnone


define <4 x float> @test_x86_sse41_insertps(<4 x float> %a0, <4 x float> %a1) {
; SSE41-LABEL: test_x86_sse41_insertps:
; SSE41:       ## BB#0:
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3]
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_insertps:
; KNL:       ## BB#0:
; KNL-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],xmm0[2,3]
; KNL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.insertps(<4 x float> %a0, <4 x float> %a1, i8 17) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.insertps(<4 x float>, <4 x float>, i8) nounwind readnone



define <8 x i16> @test_x86_sse41_mpsadbw(<16 x i8> %a0, <16 x i8> %a1) {
; SSE41-LABEL: test_x86_sse41_mpsadbw:
; SSE41:       ## BB#0:
; SSE41-NEXT:    mpsadbw $7, %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_mpsadbw:
; KNL:       ## BB#0:
; KNL-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8>, <16 x i8>, i8) nounwind readnone


define <8 x i16> @test_x86_sse41_packusdw(<4 x i32> %a0, <4 x i32> %a1) {
; SSE41-LABEL: test_x86_sse41_packusdw:
; SSE41:       ## BB#0:
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_packusdw:
; KNL:       ## BB#0:
; KNL-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32> %a0, <4 x i32> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32>, <4 x i32>) nounwind readnone


define <16 x i8> @test_x86_sse41_pblendvb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> %a2) {
; SSE41-LABEL: test_x86_sse41_pblendvb:
; SSE41:       ## BB#0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pblendvb:
; KNL:       ## BB#0:
; KNL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> %a2) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8>, <16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse41_phminposuw(<8 x i16> %a0) {
; SSE41-LABEL: test_x86_sse41_phminposuw:
; SSE41:       ## BB#0:
; SSE41-NEXT:    phminposuw %xmm0, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_phminposuw:
; KNL:       ## BB#0:
; KNL-NEXT:    vphminposuw %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16> %a0) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse41_pmaxsb(<16 x i8> %a0, <16 x i8> %a1) {
; SSE41-LABEL: test_x86_sse41_pmaxsb:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pmaxsb %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pmaxsb:
; KNL:       ## BB#0:
; KNL-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8>, <16 x i8>) nounwind readnone


define <4 x i32> @test_x86_sse41_pmaxsd(<4 x i32> %a0, <4 x i32> %a1) {
; SSE41-LABEL: test_x86_sse41_pmaxsd:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pmaxsd %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pmaxsd:
; KNL:       ## BB#0:
; KNL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32>, <4 x i32>) nounwind readnone


define <4 x i32> @test_x86_sse41_pmaxud(<4 x i32> %a0, <4 x i32> %a1) {
; SSE41-LABEL: test_x86_sse41_pmaxud:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pmaxud %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pmaxud:
; KNL:       ## BB#0:
; KNL-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_sse41_pmaxuw(<8 x i16> %a0, <8 x i16> %a1) {
; SSE41-LABEL: test_x86_sse41_pmaxuw:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pmaxuw %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pmaxuw:
; KNL:       ## BB#0:
; KNL-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse41_pminsb(<16 x i8> %a0, <16 x i8> %a1) {
; SSE41-LABEL: test_x86_sse41_pminsb:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pminsb %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pminsb:
; KNL:       ## BB#0:
; KNL-NEXT:    vpminsb %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8>, <16 x i8>) nounwind readnone


define <4 x i32> @test_x86_sse41_pminsd(<4 x i32> %a0, <4 x i32> %a1) {
; SSE41-LABEL: test_x86_sse41_pminsd:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pminsd %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pminsd:
; KNL:       ## BB#0:
; KNL-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32>, <4 x i32>) nounwind readnone


define <4 x i32> @test_x86_sse41_pminud(<4 x i32> %a0, <4 x i32> %a1) {
; SSE41-LABEL: test_x86_sse41_pminud:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pminud %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pminud:
; KNL:       ## BB#0:
; KNL-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pminud(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pminud(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_sse41_pminuw(<8 x i16> %a0, <8 x i16> %a1) {
; SSE41-LABEL: test_x86_sse41_pminuw:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pminuw %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pminuw:
; KNL:       ## BB#0:
; KNL-NEXT:    vpminuw %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16>, <8 x i16>) nounwind readnone


define <2 x i64> @test_x86_sse41_pmuldq(<4 x i32> %a0, <4 x i32> %a1) {
; SSE41-LABEL: test_x86_sse41_pmuldq:
; SSE41:       ## BB#0:
; SSE41-NEXT:    pmuldq %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_pmuldq:
; KNL:       ## BB#0:
; KNL-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32> %a0, <4 x i32> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32>, <4 x i32>) nounwind readnone


define i32 @test_x86_sse41_ptestc(<2 x i64> %a0, <2 x i64> %a1) {
; SSE41-LABEL: test_x86_sse41_ptestc:
; SSE41:       ## BB#0:
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    sbbl %eax, %eax
; SSE41-NEXT:    andl $1, %eax
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_ptestc:
; KNL:       ## BB#0:
; KNL-NEXT:    vptest %xmm1, %xmm0
; KNL-NEXT:    sbbl %eax, %eax
; KNL-NEXT:    andl $1, %eax
; KNL-NEXT:    retl
  %res = call i32 @llvm.x86.sse41.ptestc(<2 x i64> %a0, <2 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse41.ptestc(<2 x i64>, <2 x i64>) nounwind readnone


define i32 @test_x86_sse41_ptestnzc(<2 x i64> %a0, <2 x i64> %a1) {
; SSE41-LABEL: test_x86_sse41_ptestnzc:
; SSE41:       ## BB#0:
; SSE41-NEXT:    xorl %eax, %eax
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    seta %al
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_ptestnzc:
; KNL:       ## BB#0:
; KNL-NEXT:    xorl %eax, %eax
; KNL-NEXT:    vptest %xmm1, %xmm0
; KNL-NEXT:    seta %al
; KNL-NEXT:    retl
  %res = call i32 @llvm.x86.sse41.ptestnzc(<2 x i64> %a0, <2 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse41.ptestnzc(<2 x i64>, <2 x i64>) nounwind readnone


define i32 @test_x86_sse41_ptestz(<2 x i64> %a0, <2 x i64> %a1) {
; SSE41-LABEL: test_x86_sse41_ptestz:
; SSE41:       ## BB#0:
; SSE41-NEXT:    xorl %eax, %eax
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_ptestz:
; KNL:       ## BB#0:
; KNL-NEXT:    xorl %eax, %eax
; KNL-NEXT:    vptest %xmm1, %xmm0
; KNL-NEXT:    sete %al
; KNL-NEXT:    retl
  %res = call i32 @llvm.x86.sse41.ptestz(<2 x i64> %a0, <2 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse41.ptestz(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x double> @test_x86_sse41_round_pd(<2 x double> %a0) {
; SSE41-LABEL: test_x86_sse41_round_pd:
; SSE41:       ## BB#0:
; SSE41-NEXT:    roundpd $7, %xmm0, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_round_pd:
; KNL:       ## BB#0:
; KNL-NEXT:    vroundpd $7, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.round.pd(<2 x double> %a0, i32 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.round.pd(<2 x double>, i32) nounwind readnone


define <4 x float> @test_x86_sse41_round_ps(<4 x float> %a0) {
; SSE41-LABEL: test_x86_sse41_round_ps:
; SSE41:       ## BB#0:
; SSE41-NEXT:    roundps $7, %xmm0, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_round_ps:
; KNL:       ## BB#0:
; KNL-NEXT:    vroundps $7, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.round.ps(<4 x float> %a0, i32 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.round.ps(<4 x float>, i32) nounwind readnone


define <2 x double> @test_x86_sse41_round_sd(<2 x double> %a0, <2 x double> %a1) {
; SSE41-LABEL: test_x86_sse41_round_sd:
; SSE41:       ## BB#0:
; SSE41-NEXT:    roundsd $7, %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_round_sd:
; KNL:       ## BB#0:
; KNL-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.round.sd(<2 x double> %a0, <2 x double> %a1, i32 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.round.sd(<2 x double>, <2 x double>, i32) nounwind readnone


define <4 x float> @test_x86_sse41_round_ss(<4 x float> %a0, <4 x float> %a1) {
; SSE41-LABEL: test_x86_sse41_round_ss:
; SSE41:       ## BB#0:
; SSE41-NEXT:    roundss $7, %xmm1, %xmm0
; SSE41-NEXT:    retl
;
; KNL-LABEL: test_x86_sse41_round_ss:
; KNL:       ## BB#0:
; KNL-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm0
; KNL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.round.ss(<4 x float> %a0, <4 x float> %a1, i32 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.round.ss(<4 x float>, <4 x float>, i32) nounwind readnone
