; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX --check-prefix=X32-AVX1
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX --check-prefix=X32-AVX2
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX512 --check-prefix=X32-AVX512F
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX512 --check-prefix=X32-AVX512BW
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX512 --check-prefix=X32-AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX --check-prefix=X64-AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX --check-prefix=X64-AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512 --check-prefix=X64-AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512 --check-prefix=X64-AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512 --check-prefix=X64-AVX512DQ

;
; Subvector Load + Broadcast
;

define <4 x double> @test_broadcast_2f64_4f64(<2 x double> *%p) nounwind {
; X32-LABEL: test_broadcast_2f64_4f64:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_2f64_4f64:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-NEXT:    retq
 %1 = load <2 x double>, <2 x double> *%p
 %2 = shufflevector <2 x double> %1, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x double> %2
}

define <8 x double> @test_broadcast_2f64_8f64(<2 x double> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_2f64_8f64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_2f64_8f64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2f64_8f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_2f64_8f64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <2 x double>, <2 x double> *%p
 %2 = shufflevector <2 x double> %1, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
 ret <8 x double> %2
}

define <8 x double> @test_broadcast_4f64_8f64(<4 x double> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4f64_8f64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4f64_8f64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4f64_8f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4f64_8f64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x double>, <4 x double> *%p
 %2 = shufflevector <4 x double> %1, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x double> %2
}

define <4 x i64> @test_broadcast_2i64_4i64(<2 x i64> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_2i64_4i64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_2i64_4i64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2i64_4i64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_2i64_4i64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512-NEXT:    retq
 %1 = load <2 x i64>, <2 x i64> *%p
 %2 = shufflevector <2 x i64> %1, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x i64> %2
}

define <8 x i64> @test_broadcast_2i64_8i64(<2 x i64> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_2i64_8i64:
; X32-AVX1:       # %bb.0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_2i64_8i64:
; X32-AVX2:       # %bb.0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_2i64_8i64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_2i64_8i64:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_2i64_8i64:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_2i64_8i64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <2 x i64>, <2 x i64> *%p
 %2 = shufflevector <2 x i64> %1, <2 x i64> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
 ret <8 x i64> %2
}

define <8 x i64> @test_broadcast_4i64_8i64(<4 x i64> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4i64_8i64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i64_8i64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i64_8i64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i64_8i64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i64>, <4 x i64> *%p
 %2 = shufflevector <4 x i64> %1, <4 x i64> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i64> %2
}

define <8 x float> @test_broadcast_4f32_8f32(<4 x float> *%p) nounwind {
; X32-LABEL: test_broadcast_4f32_8f32:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_4f32_8f32:
; X64:       # %bb.0:
; X64-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-NEXT:    retq
 %1 = load <4 x float>, <4 x float> *%p
 %2 = shufflevector <4 x float> %1, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x float> %2
}

define <16 x float> @test_broadcast_4f32_16f32(<4 x float> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4f32_16f32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4f32_16f32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4f32_16f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4f32_16f32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x float>, <4 x float> *%p
 %2 = shufflevector <4 x float> %1, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <16 x float> %2
}

define <16 x float> @test_broadcast_8f32_16f32(<8 x float> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_8f32_16f32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_8f32_16f32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8f32_16f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_8f32_16f32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <8 x float>, <8 x float> *%p
 %2 = shufflevector <8 x float> %1, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x float> %2
}

define <8 x i32> @test_broadcast_4i32_8i32(<4 x i32> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4i32_8i32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i32_8i32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_8i32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i32_8i32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i32>, <4 x i32> *%p
 %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i32> %2
}

define <16 x i32> @test_broadcast_4i32_16i32(<4 x i32> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_4i32_16i32:
; X32-AVX1:       # %bb.0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_4i32_16i32:
; X32-AVX2:       # %bb.0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i32_16i32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_4i32_16i32:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_4i32_16i32:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i32_16i32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i32>, <4 x i32> *%p
 %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <16 x i32> %2
}

define <16 x i32> @test_broadcast_8i32_16i32(<8 x i32> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_8i32_16i32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_8i32_16i32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8i32_16i32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_8i32_16i32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <8 x i32>, <8 x i32> *%p
 %2 = shufflevector <8 x i32> %1, <8 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i32> %2
}

define <16 x i16> @test_broadcast_8i16_16i16(<8 x i16> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_8i16_16i16:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_8i16_16i16:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8i16_16i16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_8i16_16i16:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512-NEXT:    retq
 %1 = load <8 x i16>, <8 x i16> *%p
 %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i16> %2
}

define <32 x i16> @test_broadcast_8i16_32i16(<8 x i16> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_8i16_32i16:
; X32-AVX1:       # %bb.0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_8i16_32i16:
; X32-AVX2:       # %bb.0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_8i16_32i16:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512F-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_8i16_32i16:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_8i16_32i16:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512DQ-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_8i16_32i16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_8i16_32i16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_8i16_32i16:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512F-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_8i16_32i16:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_8i16_32i16:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512DQ-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <8 x i16>, <8 x i16> *%p
 %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <32 x i16> %2
}

define <32 x i16> @test_broadcast_16i16_32i16(<16 x i16> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_16i16_32i16:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_16i16_32i16:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_16i16_32i16:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_16i16_32i16:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_16i16_32i16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_16i16_32i16:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_16i16_32i16:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_16i16_32i16:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <16 x i16>, <16 x i16> *%p
 %2 = shufflevector <16 x i16> %1, <16 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i16> %2
}

define <32 x i8> @test_broadcast_16i8_32i8(<16 x i8> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_16i8_32i8:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_16i8_32i8:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_16i8_32i8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_16i8_32i8:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512-NEXT:    retq
 %1 = load <16 x i8>, <16 x i8> *%p
 %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i8> %2
}

define <64 x i8> @test_broadcast_16i8_64i8(<16 x i8> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_16i8_64i8:
; X32-AVX1:       # %bb.0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_16i8_64i8:
; X32-AVX2:       # %bb.0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_16i8_64i8:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512F-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_16i8_64i8:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_16i8_64i8:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512DQ-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_16i8_64i8:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_16i8_64i8:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_16i8_64i8:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512F-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_16i8_64i8:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_16i8_64i8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512DQ-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <16 x i8>, <16 x i8> *%p
 %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <64 x i8> %2
}

define <64 x i8> @test_broadcast_32i8_64i8(<32 x i8> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_32i8_64i8:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_32i8_64i8:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_32i8_64i8:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_32i8_64i8:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_32i8_64i8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_32i8_64i8:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_32i8_64i8:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_32i8_64i8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <32 x i8>, <32 x i8> *%p
 %2 = shufflevector <32 x i8> %1, <32 x i8> undef, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
 ret <64 x i8> %2
}

;
; Subvector Load + Broadcast + Store
;

define <4 x double> @test_broadcast_2f64_4f64_reuse(<2 x double>* %p0, <2 x double>* %p1) {
; X32-LABEL: test_broadcast_2f64_4f64_reuse:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    vmovaps (%ecx), %xmm0
; X32-NEXT:    vmovaps %xmm0, (%eax)
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_2f64_4f64_reuse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps (%rdi), %xmm0
; X64-NEXT:    vmovaps %xmm0, (%rsi)
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = load <2 x double>, <2 x double>* %p0
 store <2 x double> %1, <2 x double>* %p1
 %2 = shufflevector <2 x double> %1, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x double> %2
}

define <4 x i64> @test_broadcast_2i64_4i64_reuse(<2 x i64>* %p0, <2 x i64>* %p1) {
; X32-LABEL: test_broadcast_2i64_4i64_reuse:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    vmovaps (%ecx), %xmm0
; X32-NEXT:    vmovaps %xmm0, (%eax)
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_2i64_4i64_reuse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps (%rdi), %xmm0
; X64-NEXT:    vmovaps %xmm0, (%rsi)
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = load <2 x i64>, <2 x i64>* %p0
 store <2 x i64> %1, <2 x i64>* %p1
 %2 = shufflevector <2 x i64> %1, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x i64> %2
}

define <8 x float> @test_broadcast_4f32_8f32_reuse(<4 x float>* %p0, <4 x float>* %p1) {
; X32-LABEL: test_broadcast_4f32_8f32_reuse:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    vmovaps (%ecx), %xmm0
; X32-NEXT:    vmovaps %xmm0, (%eax)
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_4f32_8f32_reuse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps (%rdi), %xmm0
; X64-NEXT:    vmovaps %xmm0, (%rsi)
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = load <4 x float>, <4 x float>* %p0
 store <4 x float> %1, <4 x float>* %p1
 %2 = shufflevector <4 x float> %1, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x float> %2
}

define <8 x i32> @test_broadcast_4i32_8i32_reuse(<4 x i32>* %p0, <4 x i32>* %p1) {
; X32-LABEL: test_broadcast_4i32_8i32_reuse:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    vmovaps (%ecx), %xmm0
; X32-NEXT:    vmovaps %xmm0, (%eax)
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_4i32_8i32_reuse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps (%rdi), %xmm0
; X64-NEXT:    vmovaps %xmm0, (%rsi)
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = load <4 x i32>, <4 x i32>* %p0
 store <4 x i32> %1, <4 x i32>* %p1
 %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i32> %2
}

define <16 x i16> @test_broadcast_8i16_16i16_reuse(<8 x i16> *%p0, <8 x i16> *%p1) nounwind {
; X32-LABEL: test_broadcast_8i16_16i16_reuse:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    vmovaps (%ecx), %xmm0
; X32-NEXT:    vmovaps %xmm0, (%eax)
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_8i16_16i16_reuse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps (%rdi), %xmm0
; X64-NEXT:    vmovaps %xmm0, (%rsi)
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = load <8 x i16>, <8 x i16> *%p0
 store <8 x i16> %1, <8 x i16>* %p1
 %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i16> %2
}

define <32 x i8> @test_broadcast_16i8_32i8_reuse(<16 x i8> *%p0, <16 x i8> *%p1) nounwind {
; X32-LABEL: test_broadcast_16i8_32i8_reuse:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    vmovaps (%ecx), %xmm0
; X32-NEXT:    vmovaps %xmm0, (%eax)
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_broadcast_16i8_32i8_reuse:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps (%rdi), %xmm0
; X64-NEXT:    vmovaps %xmm0, (%rsi)
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = load <16 x i8>, <16 x i8> *%p0
 store <16 x i8> %1, <16 x i8>* %p1
 %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i8> %2
}

;
; Subvector Load + Broadcast with Separate Store
;

define <8 x i32> @test_broadcast_4i32_8i32_chain(<4 x i32>* %p0, <4 x float>* %p1) {
; X32-AVX-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX512F-NEXT:    vmovdqa %xmm1, (%eax)
; X32-AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX512BW-NEXT:    vmovdqa %xmm1, (%eax)
; X32-AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX512DQ-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512F-NEXT:    vmovdqa %xmm1, (%rsi)
; X64-AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512BW-NEXT:    vmovdqa %xmm1, (%rsi)
; X64-AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %p0
  store <4 x float> zeroinitializer, <4 x float>* %p1
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <8 x i32> %2
}

define <16 x i32> @test_broadcast_4i32_16i32_chain(<4 x i32>* %p0, <4 x float>* %p1) {
; X32-AVX-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovdqa (%ecx), %xmm0
; X32-AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX512F-NEXT:    vmovdqa %xmm1, (%eax)
; X32-AVX512F-NEXT:    vshufi32x4 {{.*#+}} zmm0 = zmm0[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovdqa (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X32-AVX512BW-NEXT:    vmovdqa %xmm1, (%eax)
; X32-AVX512BW-NEXT:    vshufi32x4 {{.*#+}} zmm0 = zmm0[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovdqa (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX512DQ-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX512DQ-NEXT:    vshufi32x4 {{.*#+}} zmm0 = zmm0[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; X64-AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512F-NEXT:    vmovdqa %xmm1, (%rsi)
; X64-AVX512F-NEXT:    vshufi32x4 {{.*#+}} zmm0 = zmm0[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX512BW-NEXT:    vmovdqa %xmm1, (%rsi)
; X64-AVX512BW-NEXT:    vshufi32x4 {{.*#+}} zmm0 = zmm0[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX512DQ-NEXT:    vshufi32x4 {{.*#+}} zmm0 = zmm0[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512DQ-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %p0
  store <4 x float> zeroinitializer, <4 x float>* %p1
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <16 x i32> %2
}

;
; subvector Load with multiple uses + broadcast
; Fallback to the broadcast should be done
;

@ga4 = global <4 x i64> zeroinitializer, align 8
@gb4 = global <8 x i64> zeroinitializer, align 8

define void @fallback_broadcast_v4i64_to_v8i64(<4 x i64> %a, <8 x i64> %b) {
; X32-AVX1-LABEL: fallback_broadcast_v4i64_to_v8i64:
; X32-AVX1:       # %bb.0: # %entry
; X32-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X32-AVX1-NEXT:    vmovdqa {{.*#+}} ymm4 = [1,0,2,0,3,0,4,0]
; X32-AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; X32-AVX1-NEXT:    vpaddq %xmm5, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm0
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; X32-AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; X32-AVX1-NEXT:    vpaddq %xmm5, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddq %xmm4, %xmm2, %xmm2
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; X32-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; X32-AVX1-NEXT:    vpaddq %xmm5, %xmm3, %xmm3
; X32-AVX1-NEXT:    vpaddq %xmm4, %xmm1, %xmm1
; X32-AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; X32-AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; X32-AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; X32-AVX1-NEXT:    vmovups %ymm0, ga4
; X32-AVX1-NEXT:    vmovups %ymm2, gb4+32
; X32-AVX1-NEXT:    vmovups %ymm1, gb4
; X32-AVX1-NEXT:    vzeroupper
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: fallback_broadcast_v4i64_to_v8i64:
; X32-AVX2:       # %bb.0: # %entry
; X32-AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,0,2,0,3,0,4,0]
; X32-AVX2-NEXT:    vpaddq %ymm3, %ymm0, %ymm0
; X32-AVX2-NEXT:    vpaddq %ymm3, %ymm2, %ymm2
; X32-AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; X32-AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; X32-AVX2-NEXT:    vmovdqu %ymm0, ga4
; X32-AVX2-NEXT:    vmovdqu %ymm2, gb4+32
; X32-AVX2-NEXT:    vmovdqu %ymm1, gb4
; X32-AVX2-NEXT:    vzeroupper
; X32-AVX2-NEXT:    retl
;
; X32-AVX512-LABEL: fallback_broadcast_v4i64_to_v8i64:
; X32-AVX512:       # %bb.0: # %entry
; X32-AVX512-NEXT:    vpaddq {{\.LCPI.*}}, %ymm0, %ymm0
; X32-AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [1,0,2,0,3,0,4,0,1,0,2,0,3,0,4,0]
; X32-AVX512-NEXT:    vpaddq %zmm2, %zmm1, %zmm1
; X32-AVX512-NEXT:    vpandq %zmm2, %zmm1, %zmm1
; X32-AVX512-NEXT:    vmovdqu %ymm0, ga4
; X32-AVX512-NEXT:    vmovdqu64 %zmm1, gb4
; X32-AVX512-NEXT:    vzeroupper
; X32-AVX512-NEXT:    retl
;
; X64-AVX1-LABEL: fallback_broadcast_v4i64_to_v8i64:
; X64-AVX1:       # %bb.0: # %entry
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X64-AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [3,4]
; X64-AVX1-NEXT:    vpaddq %xmm4, %xmm3, %xmm3
; X64-AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [1,2]
; X64-AVX1-NEXT:    vpaddq %xmm5, %xmm0, %xmm0
; X64-AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; X64-AVX1-NEXT:    vmovaps {{.*#+}} ymm3 = [1,2,3,4]
; X64-AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; X64-AVX1-NEXT:    vpaddq %xmm4, %xmm6, %xmm6
; X64-AVX1-NEXT:    vpaddq %xmm5, %xmm2, %xmm2
; X64-AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm2
; X64-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; X64-AVX1-NEXT:    vpaddq %xmm4, %xmm6, %xmm4
; X64-AVX1-NEXT:    vpaddq %xmm5, %xmm1, %xmm1
; X64-AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; X64-AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; X64-AVX1-NEXT:    vandps %ymm3, %ymm2, %ymm2
; X64-AVX1-NEXT:    vmovups %ymm0, {{.*}}(%rip)
; X64-AVX1-NEXT:    vmovups %ymm2, gb4+{{.*}}(%rip)
; X64-AVX1-NEXT:    vmovups %ymm1, {{.*}}(%rip)
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fallback_broadcast_v4i64_to_v8i64:
; X64-AVX2:       # %bb.0: # %entry
; X64-AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,3,4]
; X64-AVX2-NEXT:    vpaddq %ymm3, %ymm0, %ymm0
; X64-AVX2-NEXT:    vpaddq %ymm3, %ymm2, %ymm2
; X64-AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; X64-AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; X64-AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; X64-AVX2-NEXT:    vmovdqu %ymm0, {{.*}}(%rip)
; X64-AVX2-NEXT:    vmovdqu %ymm2, gb4+{{.*}}(%rip)
; X64-AVX2-NEXT:    vmovdqu %ymm1, {{.*}}(%rip)
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: fallback_broadcast_v4i64_to_v8i64:
; X64-AVX512:       # %bb.0: # %entry
; X64-AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [1,2,3,4]
; X64-AVX512-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; X64-AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; X64-AVX512-NEXT:    vpaddq %zmm2, %zmm1, %zmm1
; X64-AVX512-NEXT:    vpandq %zmm2, %zmm1, %zmm1
; X64-AVX512-NEXT:    vmovdqu %ymm0, {{.*}}(%rip)
; X64-AVX512-NEXT:    vmovdqu64 %zmm1, {{.*}}(%rip)
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
entry:
  %0 = add <4 x i64> %a, <i64 1, i64 2, i64 3, i64 4>
  %1 = add <8 x i64> %b, <i64 1, i64 2, i64 3, i64 4, i64 1, i64 2, i64 3, i64 4>
  %2 = and <8 x i64> %1, <i64 1, i64 2, i64 3, i64 4, i64 1, i64 2, i64 3, i64 4>
  store <4 x i64> %0, <4 x i64>* @ga4, align 8
  store <8 x i64> %2, <8 x i64>* @gb4, align 8
  ret void
}


@ga2 = global <4 x double> zeroinitializer, align 8
@gb2 = global <8 x double> zeroinitializer, align 8

define void @fallback_broadcast_v4f64_to_v8f64(<4 x double> %a, <8 x double> %b) {
; X32-AVX-LABEL: fallback_broadcast_v4f64_to_v8f64:
; X32-AVX:       # %bb.0: # %entry
; X32-AVX-NEXT:    vmovapd {{.*#+}} ymm3 = [1.000000e+00,2.000000e+00,3.000000e+00,4.000000e+00]
; X32-AVX-NEXT:    vaddpd %ymm3, %ymm0, %ymm0
; X32-AVX-NEXT:    vaddpd %ymm3, %ymm2, %ymm2
; X32-AVX-NEXT:    vaddpd %ymm3, %ymm1, %ymm1
; X32-AVX-NEXT:    vdivpd %ymm3, %ymm1, %ymm1
; X32-AVX-NEXT:    vdivpd %ymm3, %ymm2, %ymm2
; X32-AVX-NEXT:    vmovupd %ymm0, ga2
; X32-AVX-NEXT:    vmovupd %ymm2, gb2+32
; X32-AVX-NEXT:    vmovupd %ymm1, gb2
; X32-AVX-NEXT:    vzeroupper
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: fallback_broadcast_v4f64_to_v8f64:
; X32-AVX512:       # %bb.0: # %entry
; X32-AVX512-NEXT:    vmovapd {{.*#+}} ymm2 = [1.000000e+00,2.000000e+00,3.000000e+00,4.000000e+00]
; X32-AVX512-NEXT:    vaddpd %ymm2, %ymm0, %ymm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm2, %zmm2, %zmm2
; X32-AVX512-NEXT:    vaddpd %zmm2, %zmm1, %zmm1
; X32-AVX512-NEXT:    vdivpd %zmm2, %zmm1, %zmm1
; X32-AVX512-NEXT:    vmovupd %ymm0, ga2
; X32-AVX512-NEXT:    vmovupd %zmm1, gb2
; X32-AVX512-NEXT:    vzeroupper
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: fallback_broadcast_v4f64_to_v8f64:
; X64-AVX:       # %bb.0: # %entry
; X64-AVX-NEXT:    vmovapd {{.*#+}} ymm3 = [1.000000e+00,2.000000e+00,3.000000e+00,4.000000e+00]
; X64-AVX-NEXT:    vaddpd %ymm3, %ymm0, %ymm0
; X64-AVX-NEXT:    vaddpd %ymm3, %ymm2, %ymm2
; X64-AVX-NEXT:    vaddpd %ymm3, %ymm1, %ymm1
; X64-AVX-NEXT:    vdivpd %ymm3, %ymm1, %ymm1
; X64-AVX-NEXT:    vdivpd %ymm3, %ymm2, %ymm2
; X64-AVX-NEXT:    vmovupd %ymm0, {{.*}}(%rip)
; X64-AVX-NEXT:    vmovupd %ymm2, gb2+{{.*}}(%rip)
; X64-AVX-NEXT:    vmovupd %ymm1, {{.*}}(%rip)
; X64-AVX-NEXT:    vzeroupper
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: fallback_broadcast_v4f64_to_v8f64:
; X64-AVX512:       # %bb.0: # %entry
; X64-AVX512-NEXT:    vmovapd {{.*#+}} ymm2 = [1.000000e+00,2.000000e+00,3.000000e+00,4.000000e+00]
; X64-AVX512-NEXT:    vaddpd %ymm2, %ymm0, %ymm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm2, %zmm2, %zmm2
; X64-AVX512-NEXT:    vaddpd %zmm2, %zmm1, %zmm1
; X64-AVX512-NEXT:    vdivpd %zmm2, %zmm1, %zmm1
; X64-AVX512-NEXT:    vmovupd %ymm0, {{.*}}(%rip)
; X64-AVX512-NEXT:    vmovupd %zmm1, {{.*}}(%rip)
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
entry:
  %0 = fadd <4 x double> %a, <double 1.0, double 2.0, double 3.0, double 4.0>
  %1 = fadd <8 x double> %b, <double 1.0, double 2.0, double 3.0, double 4.0, double 1.0, double 2.0, double 3.0, double 4.0>
  %2 = fdiv <8 x double> %1, <double 1.0, double 2.0, double 3.0, double 4.0, double 1.0, double 2.0, double 3.0, double 4.0>
  store <4 x double> %0, <4 x double>* @ga2, align 8
  store <8 x double> %2, <8 x double>* @gb2, align 8
  ret void
}

;
; Subvector Broadcast from register
;

define <4 x double> @reg_broadcast_2f64_4f64(<2 x double> %a0) nounwind {
; X32-LABEL: reg_broadcast_2f64_4f64:
; X32:       # %bb.0:
; X32-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: reg_broadcast_2f64_4f64:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = shufflevector <2 x double> %a0, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x double> %1
}

define <8 x double> @reg_broadcast_2f64_8f64(<2 x double> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_2f64_8f64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_2f64_8f64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_2f64_8f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_2f64_8f64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <2 x double> %a0, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
 ret <8 x double> %1
}

define <8 x double> @reg_broadcast_4f64_8f64(<4 x double> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_4f64_8f64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_4f64_8f64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_4f64_8f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_4f64_8f64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <4 x double> %a0, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x double> %1
}

define <4 x i64> @reg_broadcast_2i64_4i64(<2 x i64> %a0) nounwind {
; X32-LABEL: reg_broadcast_2i64_4i64:
; X32:       # %bb.0:
; X32-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: reg_broadcast_2i64_4i64:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = shufflevector <2 x i64> %a0, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x i64> %1
}

define <8 x i64> @reg_broadcast_2i64_8i64(<2 x i64> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_2i64_8i64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_2i64_8i64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_2i64_8i64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_2i64_8i64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <2 x i64> %a0, <2 x i64> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
 ret <8 x i64> %1
}

define <8 x i64> @reg_broadcast_4i64_8i64(<4 x i64> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_4i64_8i64:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_4i64_8i64:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_4i64_8i64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_4i64_8i64:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <4 x i64> %a0, <4 x i64> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i64> %1
}

define <8 x float> @reg_broadcast_4f32_8f32(<4 x float> %a0) nounwind {
; X32-LABEL: reg_broadcast_4f32_8f32:
; X32:       # %bb.0:
; X32-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: reg_broadcast_4f32_8f32:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = shufflevector <4 x float> %a0, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x float> %1
}

define <16 x float> @reg_broadcast_4f32_16f32(<4 x float> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_4f32_16f32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_4f32_16f32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_4f32_16f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_4f32_16f32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <4 x float> %a0, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <16 x float> %1
}

define <16 x float> @reg_broadcast_8f32_16f32(<8 x float> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_8f32_16f32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_8f32_16f32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_8f32_16f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_8f32_16f32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <8 x float> %a0, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x float> %1
}

define <8 x i32> @reg_broadcast_4i32_8i32(<4 x i32> %a0) nounwind {
; X32-LABEL: reg_broadcast_4i32_8i32:
; X32:       # %bb.0:
; X32-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: reg_broadcast_4i32_8i32:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = shufflevector <4 x i32> %a0, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i32> %1
}

define <16 x i32> @reg_broadcast_4i32_16i32(<4 x i32> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_4i32_16i32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_4i32_16i32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_4i32_16i32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_4i32_16i32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <4 x i32> %a0, <4 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <16 x i32> %1
}

define <16 x i32> @reg_broadcast_8i32_16i32(<8 x i32> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_8i32_16i32:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: reg_broadcast_8i32_16i32:
; X32-AVX512:       # %bb.0:
; X32-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X32-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_8i32_16i32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: reg_broadcast_8i32_16i32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X64-AVX512-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512-NEXT:    retq
 %1 = shufflevector <8 x i32> %a0, <8 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i32> %1
}

define <16 x i16> @reg_broadcast_8i16_16i16(<8 x i16> %a0) nounwind {
; X32-LABEL: reg_broadcast_8i16_16i16:
; X32:       # %bb.0:
; X32-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: reg_broadcast_8i16_16i16:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i16> %1
}

define <32 x i16> @reg_broadcast_8i16_32i16(<8 x i16> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_8i16_32i16:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: reg_broadcast_8i16_32i16:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: reg_broadcast_8i16_32i16:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: reg_broadcast_8i16_32i16:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_8i16_32i16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: reg_broadcast_8i16_32i16:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: reg_broadcast_8i16_32i16:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: reg_broadcast_8i16_32i16:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <32 x i16> %1
}

define <32 x i16> @reg_broadcast_16i16_32i16(<16 x i16> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_16i16_32i16:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: reg_broadcast_16i16_32i16:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: reg_broadcast_16i16_32i16:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X32-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: reg_broadcast_16i16_32i16:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_16i16_32i16:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: reg_broadcast_16i16_32i16:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: reg_broadcast_16i16_32i16:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X64-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: reg_broadcast_16i16_32i16:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = shufflevector <16 x i16> %a0, <16 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i16> %1
}

define <32 x i8> @reg_broadcast_16i8_32i8(<16 x i8> %a0) nounwind {
; X32-LABEL: reg_broadcast_16i8_32i8:
; X32:       # %bb.0:
; X32-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: reg_broadcast_16i8_32i8:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-NEXT:    retq
 %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i8> %1
}

define <64 x i8> @reg_broadcast_16i8_64i8(<16 x i8> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_16i8_64i8:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: reg_broadcast_16i8_64i8:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: reg_broadcast_16i8_64i8:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: reg_broadcast_16i8_64i8:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X32-AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_16i8_64i8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: reg_broadcast_16i8_64i8:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: reg_broadcast_16i8_64i8:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512BW-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: reg_broadcast_16i8_64i8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    # kill: def %xmm0 killed %xmm0 def %ymm0
; X64-AVX512DQ-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <64 x i8> %1
}

define <64 x i8> @reg_broadcast_32i8_64i8(<32 x i8> %a0) nounwind {
; X32-AVX-LABEL: reg_broadcast_32i8_64i8:
; X32-AVX:       # %bb.0:
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: reg_broadcast_32i8_64i8:
; X32-AVX512F:       # %bb.0:
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: reg_broadcast_32i8_64i8:
; X32-AVX512BW:       # %bb.0:
; X32-AVX512BW-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X32-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: reg_broadcast_32i8_64i8:
; X32-AVX512DQ:       # %bb.0:
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: reg_broadcast_32i8_64i8:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: reg_broadcast_32i8_64i8:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: reg_broadcast_32i8_64i8:
; X64-AVX512BW:       # %bb.0:
; X64-AVX512BW-NEXT:    # kill: def %ymm0 killed %ymm0 def %zmm0
; X64-AVX512BW-NEXT:    vinsertf64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: reg_broadcast_32i8_64i8:
; X64-AVX512DQ:       # %bb.0:
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = shufflevector <32 x i8> %a0, <32 x i8> undef, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
 ret <64 x i8> %1
}
