# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -iterations=100 -resource-pressure=false -timeline -timeline-max-iterations=3 < %s | FileCheck %s

# movss/movsd explicitly zeroes out the high bits of xmm,
# so addps can start immediately, without waiting for sqrtss to finish.
# AMD SOG for the AMD family 10h and 12h processors, 4.8 Partial-Register Writes

# LLVM-MCA-BEGIN
sqrtss %xmm0, %xmm0
movss  (%eax), %xmm0
addps  %xmm0, %xmm0
# LLVM-MCA-END

# LLVM-MCA-BEGIN
sqrtsd %xmm0, %xmm0
movsd  (%eax), %xmm0
addps  %xmm0, %xmm0
# LLVM-MCA-END

# CHECK:      [0] Code Region

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      300
# CHECK-NEXT: Total Cycles:      1403
# CHECK-NEXT: Total uOps:        300

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    0.21
# CHECK-NEXT: IPC:               0.21
# CHECK-NEXT: Block RThroughput: 14.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      14    14.00                       sqrtss	%xmm0, %xmm0
# CHECK-NEXT:  1      6     0.50    *                   movss	(%eax), %xmm0
# CHECK-NEXT:  1      3     1.00                        addps	%xmm0, %xmm0

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          01234

# CHECK:      [0,0]     DeeeeeeeeeeeeeeER   .    .    .    .    .   .   sqrtss	%xmm0, %xmm0
# CHECK-NEXT: [0,1]     DeeeeeeE--------R   .    .    .    .    .   .   movss	(%eax), %xmm0
# CHECK-NEXT: [0,2]     D======eeeE-----R   .    .    .    .    .   .   addps	%xmm0, %xmm0
# CHECK-NEXT: [1,0]     D==============eeeeeeeeeeeeeeER    .    .   .   sqrtss	%xmm0, %xmm0
# CHECK-NEXT: [1,1]     .DeeeeeeE---------------------R    .    .   .   movss	(%eax), %xmm0
# CHECK-NEXT: [1,2]     .D======eeeE------------------R    .    .   .   addps	%xmm0, %xmm0
# CHECK-NEXT: [2,0]     .D===========================eeeeeeeeeeeeeeER   sqrtss	%xmm0, %xmm0
# CHECK-NEXT: [2,1]     .DeeeeeeE-----------------------------------R   movss	(%eax), %xmm0
# CHECK-NEXT: [2,2]     . D======eeeE-------------------------------R   addps	%xmm0, %xmm0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     3     14.7   8.0    0.0       sqrtss	%xmm0, %xmm0
# CHECK-NEXT: 1.     3     1.0    1.0    21.3      movss	(%eax), %xmm0
# CHECK-NEXT: 2.     3     7.0    0.3    18.0      addps	%xmm0, %xmm0

# CHECK:      [1] Code Region

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      300
# CHECK-NEXT: Total Cycles:      2103
# CHECK-NEXT: Total uOps:        300

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    0.14
# CHECK-NEXT: IPC:               0.14
# CHECK-NEXT: Block RThroughput: 21.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      21    21.00                       sqrtsd	%xmm0, %xmm0
# CHECK-NEXT:  1      6     0.50    *                   movsd	(%eax), %xmm0
# CHECK-NEXT:  1      3     1.00                        addps	%xmm0, %xmm0

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          012345

# CHECK:      [0,0]     DeeeeeeeeeeeeeeeeeeeeeER .    .    .    .    .    .    .    .    .   sqrtsd	%xmm0, %xmm0
# CHECK-NEXT: [0,1]     DeeeeeeE---------------R .    .    .    .    .    .    .    .    .   movsd	(%eax), %xmm0
# CHECK-NEXT: [0,2]     D======eeeE------------R .    .    .    .    .    .    .    .    .   addps	%xmm0, %xmm0
# CHECK-NEXT: [1,0]     D=====================eeeeeeeeeeeeeeeeeeeeeER.    .    .    .    .   sqrtsd	%xmm0, %xmm0
# CHECK-NEXT: [1,1]     .DeeeeeeE-----------------------------------R.    .    .    .    .   movsd	(%eax), %xmm0
# CHECK-NEXT: [1,2]     .D======eeeE--------------------------------R.    .    .    .    .   addps	%xmm0, %xmm0
# CHECK-NEXT: [2,0]     .D=========================================eeeeeeeeeeeeeeeeeeeeeER   sqrtsd	%xmm0, %xmm0
# CHECK-NEXT: [2,1]     .DeeeeeeE--------------------------------------------------------R   movsd	(%eax), %xmm0
# CHECK-NEXT: [2,2]     . D======eeeE----------------------------------------------------R   addps	%xmm0, %xmm0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     3     21.7   15.0   0.0       sqrtsd	%xmm0, %xmm0
# CHECK-NEXT: 1.     3     1.0    1.0    35.3      movsd	(%eax), %xmm0
# CHECK-NEXT: 2.     3     7.0    0.3    32.0      addps	%xmm0, %xmm0
