import os
import subprocess
import unittest

import apt_pkg


class AddNvidiaRepositoriesTest(unittest.TestCase):

    @classmethod
    def setUpClass(self):
        apt_pkg.init()
        self.cache = apt_pkg.Cache()
        self.policy = apt_pkg.Policy(self.cache)
        self.policy.read_pinfile(apt_pkg.config.find_file("Dir::Etc::preferences"))
        self.policy.read_pindir(apt_pkg.config.find_file("Dir::Etc::preferencesparts"))

    def test_nvidia_cuda_package_file(self):
        pkgfile = next((f for f in self.cache.file_list if f.label == "NVIDIA CUDA"), None)
        self.assertTrue(pkgfile, "No NVIDIA CUDA package file")
        prio = self.policy.get_priority(pkgfile)
        self.assertEqual(prio, 400, "Wrong priority of the NVIDIA CUDA package file"),
        self.assertEqual(pkgfile.site, "developer.download.nvidia.com", "Wrong site in the NVIDIA CUDA package file")

    def test_nvidia_cuda_package_records(self):
        self.assertIn("cuda-toolkit", self.cache, "No cuda-toolkit package available")
        pkg = self.cache["cuda-toolkit"]
        ver = self.policy.get_candidate_ver(pkg)
        self.assertIsNotNone(ver, "No cuda-toolkit package candidates")
        verfile = ver.file_list[0]
        pkgfile = verfile[0]
        self.assertEqual(pkgfile.label, "NVIDIA CUDA", "Wrong label of the cuda-toolkit's package file")
        self.assertEqual(pkgfile.site, "developer.download.nvidia.com", "Wrong site of the cuda-toolkit's package file")
        records = apt_pkg.PackageRecords(self.cache)
        records.lookup(verfile)
        self.assertEqual(records.maintainer, "cudatools <cudatools@nvidia.com>", "Wrong maintainer of the cuda-toolkit package")

    @unittest.skip("too slow")
    def test_nvidia_cuda_package_install(self):
        cmd = "apt-get install -y cuda-toolkit"
        result = subprocess.run(cmd, shell=True, env=dict(os.environ, DEBIAN_FRONTEND="noninteractive"))
        self.assertEqual(result.returncode, 0, "cuda-toolkit installation failed: " + cmd)
