/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_OSTD.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfg_ostkDel(struct Cfg_Getopt * const optstru,
		struct Cfg_oStackGetopt * where);

 * Remove the specified output stack item from the ring
 *
 *	Before the item is removed, the clArg function is executed.
 *	If where == NULL, the function does nothing.
 *
 *	Return:
 *		0: Ring is empty
 *		else: ring is not empty

ob(ject): cfg_ostkDel
su(bsystem): cmdline
ty(pe): LH
sy(nopsis): 
sh(ort description): Remove an output stack item
he(ader files): 
lo(ng description): Remove a specified output stack item. Calls any necessary functions, such as the item's close function etc.
pr(erequistes): 
va(lue): 0: output stack empty \item else: removed or \para{where} == NULL
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_ostd.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_OSTD.C 1.5 2001/02/27 01:28:04 ska Exp ska $";
#endif

int cfg_ostkDel(struct Cfg_Getopt * const optstru
	, struct Cfg_oStackGetopt * where)
{	DBG_ENTER("cfg_ostkDel", Suppl_cmdline)

	assert(optstru);

	chkHeap
	if(!C(_oHead))		/* ring empty? */
		DBG_RETURN_I( 0)
	if(!where)			/* nothing to remove, but ring not empty */
		DBG_RETURN_I( 1)

	if(where->C_clArg)
		(where->C_clArg)(optstru, where);

	if(where->C_nxt == where) {		/* ring becomes empty */
		C(_oCur) = C(_oHead) = 0;
		free(where);
		DBG_RETURN_I( 0)
	}

	chkHeap
	if(C(_oHead) == where)			/* first item removed */
		C(_oHead) = where->C_nxt;
	if(C(_oCur) == where)
		C(_oCur) = where->C_nxt;

	where->C_prv->C_nxt = where->C_nxt;
	where->C_nxt->C_prv = where->C_prv;
	chkHeap
	free(where);

	chkHeap
	DBG_RETURN_I( 1)
}
