/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* $RCSfile: GM_CMEM.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): Ecalloc
su(bsystem): error
ty(pe): 0H
sh(ort description): Allocate a chunk of memory
lo(ng description): Allocates a chunk of memory from the heap
	dynamically and clears it with zeros.\par
	If \tok{len == 0}, the behaviour is undefined.
	On failure, the program is terminated with the error message:
	"Out of memory".
pr(erequistes): len != 0
va(lue): pointer to newly allocated chunk
re(lated to): 
se(condary subsystems): dynstr
in(itialized by): 
wa(rning): 
bu(gs): 
co(mpilers): 

*/

#include "initsupl.loc"

#include <assert.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#endif /*#	!defined(_MICROC_) */
#include <portable.h>
#include "msgs.h"

#include "dynstr.h"


#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: GM_CMEM.C 1.6 2000/03/31 09:09:24 ska Exp ska $";
#endif /*#	defined(RCS_Version) */

/*
 *	Allocate a chunk of memory and erase the contents to zero
 *	On failure: Termiante with an error message
 */
void *Ecalloc(size_t len)
{	byte *h;

	DBG_ENTER("Ecalloc", Suppl_error)
	DBG_ARGUMENTS( ("len=%u", len) )

	chkHeap
	memset(h = Emalloc(len), 0, len);

	chkHeap
	DBG_RETURN_P( h)
}
