/*
 Copyright (C) 2009-2013 wxLauncher Team
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MOD_INI_KEYS_H
#define MOD_INI_KEYS_H

#include <wx/string.h>

/** \defgroup modkeys Keys used in mod.ini file */
/** @{*/
extern const wxString MOD_INI_KEY_LAUNCHER_MOD_NAME;
extern const wxString MOD_INI_KEY_LAUNCHER_IMAGE_255X112;
extern const wxString MOD_INI_KEY_LAUNCHER_IMAGE_182X80;
extern const wxString MOD_INI_KEY_LAUNCHER_INFO_TEXT;
extern const wxString MOD_INI_KEY_LAUNCHER_AUTHOR;
extern const wxString MOD_INI_KEY_LAUNCHER_NOTES;
extern const wxString MOD_INI_KEY_LAUNCHER_WARN;

extern const wxString MOD_INI_KEY_LAUNCHER_WEBSITE;
extern const wxString MOD_INI_KEY_LAUNCHER_FORUM;
extern const wxString MOD_INI_KEY_LAUNCHER_BUGS;
extern const wxString MOD_INI_KEY_LAUNCHER_SUPPORT;

extern const wxString MOD_INI_KEY_RESOLUTION_MIN_VERTICAL_RES;
extern const wxString MOD_INI_KEY_RESOLUTION_MIN_HORIZONTAL_RES;

extern const wxString MOD_INI_KEY_EXTREMEFORCE_FORCED_FLAGS_ON;
extern const wxString MOD_INI_KEY_EXTREMEFORCE_FORCED_FLAGS_OFF;

extern const wxString MOD_INI_KEY_MULTIMOD_PRIMARY_LIST;
extern const wxString MOD_INI_KEY_MULTIMOD_SECONDRY_LIST;
extern const wxString MOD_INI_KEY_MULTIMOD_SECONDARY_LIST;

// TODO: /flagsetideal and /flagset#

extern const wxString MOD_INI_KEY_SKIN_WINDOW_TITLE;
extern const wxString MOD_INI_KEY_SKIN_WINDOW_ICON;
extern const wxString MOD_INI_KEY_SKIN_BANNER;
extern const wxString MOD_INI_KEY_SKIN_WELCOME_TEXT;

extern const wxString MOD_INI_KEY_SKIN_MOD_IMAGE_255X112;
extern const wxString MOD_INI_KEY_SKIN_MOD_IMAGE_182X80;

extern const wxString MOD_INI_KEY_SKIN_ICON_OK;
extern const wxString MOD_INI_KEY_SKIN_ICON_WARNING;
extern const wxString MOD_INI_KEY_SKIN_ICON_WARNING_BIG;
extern const wxString MOD_INI_KEY_SKIN_ICON_ERROR;
extern const wxString MOD_INI_KEY_SKIN_ICON_INFO;
extern const wxString MOD_INI_KEY_SKIN_ICON_INFO_BIG;
extern const wxString MOD_INI_KEY_SKIN_ICON_HELP;
extern const wxString MOD_INI_KEY_SKIN_ICON_HELP_BIG;
extern const wxString MOD_INI_KEY_SKIN_ICON_IDEAL;

extern const wxString MOD_INI_KEY_SKIN_NEWS_SOURCE;

// TODO: mod text localization?

extern const wxString MOD_INI_KEY_RECOMMENDED_LIGHTING_NAME;
extern const wxString MOD_INI_KEY_RECOMMENDED_LIGHTING_FLAGSET;

/** @}*/

#endif
