# GENtle - Open Source Cloning Tool

GENtle is a powerful software designed for DNA and amino acid editing, database management, plasmid maps, restriction and ligation, alignments, sequencer data import, calculators, gel image display, PCR, and much more.

## Features

- DNA and amino acid editing capabilities
- Database management for easy organization of genetic data
- Visualization of plasmid maps for effective analysis
- Restriction and ligation tools for molecular cloning tasks
- Alignments to compare and analyze genetic sequences
- Import functionality for sequencer data
- Calculators to aid in various molecular biology calculations
- Gel image display for visualizing experimental results
- PCR (Polymerase Chain Reaction) tools for amplification analysis

## Project Background

GENtle was born out of the necessity to handle DNA sequences that exceed the amplification limits of PCR.
In the past, cloning was a crucial step to integrate unknown DNA into circular DNA, which was well described, to prepare it for sequencing.
Today, advancements in sequencing technologies have reduced costs, and selected sequencing with established primer pairs has become more common.

However, there is a renewed interest in plasmid design, just the direction of the DNA-flow has reversed:
Synthetic biology has advanced, structure (= function) prediction has advanced, and for many diseases, researchers have identified the most dominant sequence variants in patients and controls.
To investigate disease-causing mechanisms further, modifying cells by introducing specific DNA sequences has become a crucial approach to deepen our understanding, support drug discovery or prove a drug's method of action.

## Future Development

The current version of GENtle requires updates to maintain compatibility with version 3.2 of the wxWidget library.
The Debian community has been actively involved in addressing these compatibility issues, and the necessary changes will be integrated into this repository over the upcoming weeks.

This effort aims to make GENtle fully functional again, serving as the go-to Open Source suite for molecular cloning tasks.

## Contributing

We welcome contributions from the community to enhance GENtle and make it even more powerful and user-friendly.

## See also

Please also inspect the

 * [GENtle documentation](git@github.com:GENtle-persons/gentle-m.git)
 * [GENtle home page](http://gentle.magnusmanske.de/)

## License

GENtle is released as free and open-source software under the GPLv2+ license.
You can access the source code in the repository [here](https://github.com/GENtle-persons/gentle-m).
