/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.util;

import java.io.File;

public final class FileExtensionHelper {
    public static final String[] FASTX_FILE_EXTS = new String[]{".fa.gz", ".fna.gz", ".fasta.gz", ".fq.gz", ".fnq.gz", ".fastq.gz", ".csfasta", ".csfasta.gz", ".csfastq", ".csfastq.gz", ".csfa", ".csfa.gz", ".csfq", ".csfq.gz", ".fa", ".fna", ".fasta", ".fq", ".fnq", ".fastq", ".txt", ".txt.gz", ".gz"};
    public static final String[] COMPACT_READS_FILE_EXTS = new String[]{".compact-reads"};
    public static final String[] COMPACT_ALIGNMENT_FILE_EXTS = new String[]{".entries", ".header", ".tmh", ".stats", ".counts", ".index"};

    public static CompactFileType determineCompactFileType(File file) {
        return FileExtensionHelper.determineCompactFileType(file.toString());
    }

    public static CompactFileType determineCompactFileType(String file) {
        if (FileExtensionHelper.hasCompactAlignmentExtension(file) || new File(file + ".entries").canRead()) {
            return CompactFileType.alignment;
        }
        if (FileExtensionHelper.hasCompactReadsExtension(file) || new File(file + ".compact-reads").canRead()) {
            return CompactFileType.reads;
        }
        return CompactFileType.unknown;
    }

    public static boolean hasCompactReadsExtension(File file) {
        return FileExtensionHelper.hasCompactReadsExtension(file.toString());
    }

    public static boolean hasCompactReadsExtension(String file) {
        for (String ext : COMPACT_READS_FILE_EXTS) {
            if (!file.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCompactAlignmentExtension(File file) {
        return FileExtensionHelper.hasCompactAlignmentExtension(file.toString());
    }

    public static boolean hasCompactAlignmentExtension(String file) {
        for (String ext : COMPACT_ALIGNMENT_FILE_EXTS) {
            if (!file.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private FileExtensionHelper() {
    }

    public static enum CompactFileType {
        alignment,
        reads,
        unknown;

    }
}

