/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class WindowsDesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;
    private float fontSize = -1.0f;
    private int fontStyle = -1;

    private static synchronized void setUpdatePending(boolean bl) {
        updatePending = bl;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            WindowsDesktopProperty.updateWindowUI(frame);
        }
    }

    private static void updateWindowUI(Window window) {
        Window[] windowArray;
        SwingUtilities.updateComponentTreeUI(window);
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            WindowsDesktopProperty.updateWindowUI(window2);
        }
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit, float f) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        this.fontSize = f;
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit, float f, int n) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        this.fontSize = f;
        this.fontStyle = n;
    }

    @Override
    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected Object getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        Object object = this.toolkit.getDesktopProperty(this.getKey());
        this.pcl = new WeakPCL(this, this.toolkit);
        this.toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        return object;
    }

    protected Object getDefaultValue() {
        if (this.fallback instanceof String) {
            return UIDefaultsLookup.get(this.fallback);
        }
        return this.fallback;
    }

    public void invalidate() {
        if (this.pcl != null) {
            this.toolkit.removePropertyChangeListener(this.getKey(), this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected void updateUI() {
        if (!WindowsDesktopProperty.isUpdatePending()) {
            WindowsDesktopProperty.setUpdatePending(true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WindowsDesktopProperty.updateAllUIs();
                    WindowsDesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                if (this.fontSize != -1.0f && (float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontStyle, this.fontSize));
                }
                if (this.fontSize != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontSize));
                }
                if ((float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontStyle));
                }
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.ProxyLazyValue) {
                object = ((UIDefaults.ProxyLazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    protected String getKey() {
        return this.key;
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;

        WeakPCL(Object object, Toolkit toolkit) {
            super(object);
            this.kit = toolkit;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WindowsDesktopProperty windowsDesktopProperty = (WindowsDesktopProperty)this.get();
            if (windowsDesktopProperty == null) {
                this.kit.removePropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
            } else {
                windowsDesktopProperty.invalidate();
                windowsDesktopProperty.updateUI();
            }
        }
    }
}

