/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.samples;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.DeclareCudaModulesProcess;
import com.nvidia.cuda.ide.samples.InstantiateCudaSampleRunnable;
import com.nvidia.cuda.ide.samples.SamplesImportWizard;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ImportCUDASample
implements IEditorLauncher {
    private static int[] getAllArchitecturesMasks() {
        int[] result = new int[2];
        Architecture[] architectureArray = Architecture.all();
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (!architecture.isPhysicalOnly()) {
                result[0] = result[0] | architecture.getBit();
            }
            result[1] = result[1] | architecture.getBit();
            ++n2;
        }
        return result;
    }

    private static int[] getDefaultArchitecturesMasks() {
        int sass = DeclareCudaModulesProcess.getDefaultSassArchitectures();
        int ptx = DeclareCudaModulesProcess.getDefaultPtxArchitectures();
        int[] result = new int[]{sass, ptx};
        return result;
    }

    private static int[] getArchitecturesMasks() {
        if (ImportCUDASample.isTestingSamplesImport()) {
            return ImportCUDASample.getAllArchitecturesMasks();
        }
        return ImportCUDASample.getDefaultArchitecturesMasks();
    }

    private static int getLowestBitIfTesing(int mask) {
        if (ImportCUDASample.isTestingSamplesImport()) {
            return CoreUtil.getLowestSetBit((int)mask);
        }
        return mask;
    }

    public void open(IPath file) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
            final IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            File f = file.toFile();
            if (f.isFile()) {
                try {
                    final ProjectSample sample = new ProjectSample(f);
                    if (sample.isNsightCompatible() && sample.compatible(Platform.getOS(), Platform.getOSArch())) {
                        int[] masks = ImportCUDASample.getArchitecturesMasks();
                        int[] archs = sample.getDefaultArchitectures(masks[0], masks[1]);
                        int samplePtx = sample.getCudaSpecs().getVirtual().getBit();
                        final int ptx = ImportCUDASample.getLowestBitIfTesing(archs[0] != 0 ? archs[0] : samplePtx);
                        final int sass = ImportCUDASample.getLowestBitIfTesing(archs[1]);
                        if (ImportCUDASample.isTestingSamplesImport() || this.isSilentImport()) {
                            window.run(true, true, (IRunnableWithProgress)new InstantiateCudaSampleRunnable(sample, ImportCUDASample.generateProjectName(sample), null, Activator.getDefault().getPreferenceStore().getString("newproject.source.location"), ptx, sass, DeclareCudaModulesProcess.getDeviceLinkerDefault(), true, this.isSilentImport()));
                        } else {
                            workbench.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)new SamplesImportWizard(ImportCUDASample.generateProjectName(sample), sample, ptx, sass));
                                    dialog.open();
                                }
                            });
                        }
                    } else if (!ImportCUDASample.isTestingSamplesImport() && !this.isSilentImport()) {
                        workbench.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String message = String.format("Importing CUDA sample \"%s\" is not supported by Nsight Eclipse Edition", sample.getName());
                                new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), "Unsupported CUDA Sample", null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
                catch (InvocationTargetException e) {
                    Activator.log(e);
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
            }
        }
    }

    private static String generateProjectName(ProjectSample sample) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String shortName = sample.getShortName();
        int i = 0;
        String name;
        IProject project;
        while ((project = root.getProject(name = i == 0 ? shortName : String.format("%s_%d", shortName, i))) != null && project.exists()) {
            ++i;
        }
        return name;
    }

    private boolean isSilentImport() {
        String[] args;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.trim().equalsIgnoreCase("-nsight.silentSampleImport")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTestingSamplesImport() {
        String[] args;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.trim().equalsIgnoreCase("-nsight.samplesTest")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

