/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ERandomAccessFile
extends RandomAccessFile {
    private boolean isle;
    private long ptr_offset;
    int[] val = new int[4];

    public ERandomAccessFile(String file, String mode) throws IOException {
        super(file, mode);
    }

    public ERandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
    }

    public void setEndian(boolean le) {
        this.isle = le;
    }

    public final short readShortE() throws IOException {
        this.val[0] = this.read();
        this.val[1] = this.read();
        if ((this.val[0] | this.val[1]) < 0) {
            throw new EOFException();
        }
        if (this.isle) {
            return (short)((this.val[1] << 8) + this.val[0]);
        }
        return (short)((this.val[0] << 8) + this.val[1]);
    }

    public final long readIntE() throws IOException {
        this.val[0] = this.read();
        this.val[1] = this.read();
        this.val[2] = this.read();
        this.val[3] = this.read();
        if ((this.val[0] | this.val[1] | this.val[2] | this.val[3]) < 0) {
            throw new EOFException();
        }
        if (this.isle) {
            return (this.val[3] << 24) + (this.val[2] << 16) + (this.val[1] << 8) + this.val[0];
        }
        return (this.val[0] << 24) + (this.val[1] << 16) + (this.val[2] << 8) + this.val[3];
    }

    public final long readLongE() throws IOException {
        byte[] bytes = new byte[8];
        long result = 0L;
        super.readFully(bytes);
        int shift = 0;
        if (this.isle) {
            int i = 7;
            while (i >= 0) {
                shift = i * 8;
                result += (long)bytes[i] << shift & 255L << shift;
                --i;
            }
        } else {
            int i = 0;
            while (i <= 7) {
                shift = (7 - i) * 8;
                result += (long)bytes[i] << shift & 255L << shift;
                ++i;
            }
        }
        return result;
    }

    public final void readFullyE(byte[] bytes) throws IOException {
        super.readFully(bytes);
        byte tmp = 0;
        if (this.isle) {
            int i = 0;
            while (i < bytes.length / 2) {
                tmp = bytes[i];
                bytes[i] = bytes[bytes.length - i - 1];
                bytes[bytes.length - i - 1] = tmp;
                ++i;
            }
        }
    }

    public void setFileOffset(long offset) throws IOException {
        this.ptr_offset = offset;
        super.seek(offset);
    }

    @Override
    public long getFilePointer() throws IOException {
        long ptr = super.getFilePointer();
        return ptr -= this.ptr_offset;
    }

    @Override
    public void seek(long pos) throws IOException {
        long real_pos = pos + this.ptr_offset;
        super.seek(real_pos);
    }
}

