/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ContentElementHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExpressionListHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.OperatorUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IFilterConditionElementModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public class FilterConditionElementHandle
extends ContentElementHandle
implements IFilterConditionElementModel {
    public FilterConditionElementHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public String getExpr() {
        return this.getStringProperty("expr");
    }

    public void setExpr(String filterExpr) throws SemanticException {
        this.setProperty("expr", filterExpr);
    }

    public String getOperator() {
        return this.getStringProperty("operator");
    }

    public void setOperator(String operator) throws SemanticException {
        ActivityStack stack = this.getModule().getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"operator"}));
        try {
            this.setProperty("operator", operator);
            int level = OperatorUtil.computeFilterOperatorLevel(operator);
            switch (level) {
                case 1: {
                    this.setValue2(null);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    this.setValue2(null);
                    this.setValue1((List)null);
                    break;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public String getValue1() {
        List valueList = this.getValue1List();
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        return (String)valueList.get(0);
    }

    public List getValue1List() {
        List valueList = (List)this.getProperty("value1");
        if (valueList == null || valueList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(ModelUtil.getExpressionCompatibleList(valueList));
    }

    public ExpressionListHandle getValue1ExpressionList() {
        return new ExpressionListHandle((DesignElementHandle)this, (ElementPropertyDefn)this.getPropertyDefn("value1"));
    }

    public void setValue1(String value1Expr) throws SemanticException {
        this.setProperty("value1", value1Expr);
    }

    public void setValue1(List value1List) throws SemanticException {
        this.setProperty("value1", value1List);
    }

    public String getValue2() {
        return this.getStringProperty("value2");
    }

    public void setValue2(String value2Expr) throws SemanticException {
        this.setStringProperty("value2", value2Expr);
    }

    public String getFilterTarget() {
        return (String)this.getProperty("filterTarget");
    }

    public void setFilterTarget(String filterTarget) throws SemanticException {
        this.setStringProperty("filterTarget", filterTarget);
    }

    public MemberValueHandle getMember() {
        List contents = this.getContents("member");
        if (contents != null && contents.size() > 0) {
            return (MemberValueHandle)contents.get(0);
        }
        return null;
    }

    public boolean isOptional() {
        return this.getBooleanProperty("isOptional");
    }

    public void setOptional(boolean isOptional) throws SemanticException {
        this.setBooleanProperty("isOptional", isOptional);
    }

    public String getExtensionName() {
        return this.getStringProperty("extensionName");
    }

    public String getExtensionExprId() {
        return this.getStringProperty("extensionExprId");
    }

    public boolean pushDown() {
        return this.getBooleanProperty("pushDown");
    }

    public String getDynamicFilterParameter() {
        return this.getStringProperty("dynamicFilterParameter");
    }

    public void setExtensionName(String extensionName) throws SemanticException {
        this.setStringProperty("extensionName", extensionName);
    }

    public void setExtensionExprId(String extensionExprId) throws SemanticException {
        this.setStringProperty("extensionExprId", extensionExprId);
    }

    public void setPushDown(boolean pushDown) throws SemanticException {
        this.setBooleanProperty("pushDown", pushDown);
    }

    public void setDynamicFilterParameter(String parameterName) throws SemanticException {
        this.setStringProperty("dynamicFilterParameter", parameterName);
    }

    public String getType() {
        return this.getStringProperty("type");
    }

    public void setType(String type) throws SemanticException {
        this.setProperty("type", type);
    }

    public boolean updateAggregation() {
        return this.getBooleanProperty("updateAggregation");
    }

    public void setUpdateAggregation(boolean updateAggregation) throws SemanticException {
        this.setBooleanProperty("updateAggregation", updateAggregation);
    }
}

