/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BasicConfigurationDialog
extends TitleAreaDialog {
    private Button dontShowAgain;
    private StoredConfig userScopedConfig;
    private Text email;
    private Text userName;
    private boolean needsUpdate = false;

    public static void show(Repository ... repositories) {
        if (Activator.getDefault().getPreferenceStore().getBoolean("show_initial_config_dialog") && BasicConfigurationDialog.isImplicitUserConfig(repositories)) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    new BasicConfigurationDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).open();
                }
            });
        }
    }

    private static boolean isImplicitUserConfig(Repository ... repositories) {
        if (repositories == null) {
            return false;
        }
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            UserConfig uc = (UserConfig)BasicConfigurationDialog.loadRepoScopedConfig(repository).get(UserConfig.KEY);
            if (uc.isAuthorNameImplicit() || uc.isAuthorEmailImplicit() || uc.isCommitterNameImplicit() || uc.isCommitterEmailImplicit()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static StoredConfig loadUserScopedConfig() {
        FileBasedConfig c = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
        try {
            c.load();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (ConfigInvalidException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return c;
    }

    private static StoredConfig loadRepoScopedConfig(Repository repo) {
        StoredConfig c = repo.getConfig();
        try {
            c.load();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (ConfigInvalidException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return c;
    }

    public BasicConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.userScopedConfig = BasicConfigurationDialog.loadUserScopedConfig();
        UserConfig userConfig = (UserConfig)this.userScopedConfig.get(UserConfig.KEY);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label userNameLabel = new Label(main, 0);
        userNameLabel.setText(UIText.BasicConfigurationDialog_UserNameLabel);
        this.userName = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.userName);
        String currentName = null;
        if (userConfig != null) {
            currentName = userConfig.getAuthorName();
        }
        if (currentName != null) {
            this.userName.setText(currentName);
        }
        this.userName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicConfigurationDialog.this.needsUpdate = true;
            }
        });
        Label emailLabel = new Label(main, 0);
        emailLabel.setText(UIText.BasicConfigurationDialog_UserEmailLabel);
        this.email = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.email);
        String currentMail = null;
        if (userConfig != null) {
            currentMail = userConfig.getAuthorEmail();
        }
        if (currentMail != null) {
            this.email.setText(currentMail);
        }
        this.email.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicConfigurationDialog.this.needsUpdate = true;
            }
        });
        this.dontShowAgain = new Button(main, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.dontShowAgain);
        this.dontShowAgain.setText("&Don't show this dialog again");
        this.dontShowAgain.setSelection(true);
        Link link = new Link(main, 4);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)link);
        link.setText("Open the <a>Git Configuration</a> Preference Page");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)BasicConfigurationDialog.this.getShell(), (String)"org.eclipse.egit.ui.internal.preferences.GlobalConfigurationPreferencePage", null, null).open();
            }
        });
        BasicConfigurationDialog.applyDialogFont((Control)main);
        return main;
    }

    public void create() {
        super.create();
        this.setTitle(UIText.BasicConfigurationDialog_DialogTitle);
        this.setMessage(UIText.BasicConfigurationDialog_DialogMessage);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.BasicConfigurationDialog_WindowTitle);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.needsUpdate) {
                this.userScopedConfig.setString("user", null, "name", this.userName.getText());
                this.userScopedConfig.setString("user", null, "email", this.email.getText());
                try {
                    this.userScopedConfig.save();
                }
                catch (IOException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
            if (this.dontShowAgain.getSelection()) {
                Activator.getDefault().getPreferenceStore().setValue("show_initial_config_dialog", false);
            }
        }
        super.buttonPressed(buttonId);
    }
}

