/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.launch.CudaBackend;
import com.nvidia.cuda.ide.debug.launch.CudaCSourceLookup;
import com.nvidia.cuda.ide.debug.launch.CudaControl;
import com.nvidia.cuda.ide.debug.launch.CudaRunControl;
import com.nvidia.cuda.ide.debug.service.CudaBreakpointsManager;
import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import com.nvidia.cuda.ide.debug.service.CudaDebugUISessionState;
import com.nvidia.cuda.ide.debug.service.CudaExpressionsService;
import com.nvidia.cuda.ide.debug.service.CudaMemory;
import com.nvidia.cuda.ide.debug.service.CudaProcesses;
import com.nvidia.cuda.ide.debug.service.CudaRegisters;
import com.nvidia.cuda.ide.debug.service.CudaStack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CudaDebugServicesFactory
extends GdbDebugServicesFactory {
    private final AtomicBoolean debugUIStateInitialized = new AtomicBoolean(false);

    public CudaDebugServicesFactory(String version) {
        super("7.4");
    }

    protected IMIBackend createBackendGDBService(DsfSession session, ILaunchConfiguration lc) {
        if (this.debugUIStateInitialized.compareAndSet(false, true)) {
            new CudaDebugUISessionState(session, lc).initialize(new RequestMonitor(ImmediateExecutor.getInstance(), null));
        }
        return new CudaBackend(session, lc);
    }

    protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
        return new CudaControl(session, config, new CudaCommandFactory());
    }

    protected IProcesses createProcessesService(DsfSession session) {
        return new CudaProcesses(session);
    }

    protected IStack createStackService(DsfSession session) {
        return new CudaStack(session);
    }

    protected ISourceLookup createSourceLookupService(DsfSession session) {
        return new CudaCSourceLookup(session);
    }

    protected IExpressions createExpressionService(DsfSession session) {
        return new CudaExpressionsService(session);
    }

    protected IGDBTraceControl createTraceControlService(DsfSession session, ILaunchConfiguration config) {
        return null;
    }

    protected IRegisters createRegistersService(DsfSession session) {
        return new CudaRegisters(session);
    }

    protected MIBreakpointsManager createBreakpointManagerService(DsfSession session) {
        return new CudaBreakpointsManager(session, "org.eclipse.cdt.debug.core");
    }

    protected IRunControl createRunControlService(DsfSession session) {
        return new CudaRunControl(session);
    }

    protected IMemory createMemoryService(DsfSession session) {
        return new CudaMemory(session);
    }
}

