/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPPointerType
implements IPointerType,
ITypeContainer,
ISerializableType {
    protected IType type;
    private boolean isConst;
    private boolean isVolatile;
    private boolean isRestrict;

    public CPPPointerType(IType type, boolean isConst, boolean isVolatile, boolean isRestrict) {
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isRestrict = isRestrict;
        this.setType(type);
    }

    public CPPPointerType(IType type, IASTPointer operator) {
        this(type, operator.isConst(), operator.isVolatile(), operator.isRestrict());
    }

    public CPPPointerType(IType type) {
        this(type, false, false, false);
    }

    @Override
    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof IPointerType)) {
            return false;
        }
        if (this instanceof ICPPPointerToMemberType != o instanceof ICPPPointerToMemberType) {
            return false;
        }
        if (this.type == null) {
            return false;
        }
        IPointerType pt = (IPointerType)o;
        if (this.isConst == pt.isConst() && this.isVolatile == pt.isVolatile() && this.isRestrict == pt.isRestrict()) {
            return this.type.isSameType(pt.getType());
        }
        return false;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public void setType(IType t) {
        assert (t != null);
        this.type = t;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isRestrict() {
        return this.isRestrict;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 2;
        if (this.isConst()) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.isVolatile()) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        if (this.isRestrict()) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        buffer.putShort(firstBytes);
        IType nestedType = this.getType();
        buffer.marshalType(nestedType);
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPPPointerType(nested, (firstBytes & 0x20) != 0, (firstBytes & 0x40) != 0, (firstBytes & 0x80) != 0);
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

