/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.cache.BasicCachedArray;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.script.BottomNEvaluator;
import org.eclipse.birt.data.engine.script.FilterPassController;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.data.engine.script.TopNEvaluator;
import org.mozilla.javascript.Scriptable;

public abstract class NEvaluator {
    private BasicCachedArray valueList;
    private BasicCachedArray rowIdList;
    private int firstPassRowNumberCounter = 0;
    private int secondPassRowNumberCounter = 0;
    private int qualifiedRowCounter = 0;
    private int N = -1;
    private boolean n_percent = false;
    private IScriptExpression op_expr;
    private IScriptExpression n_expr;
    private FilterPassController filterPassController;
    private String tempDir;

    public static NEvaluator newInstance(String tempDir, int operator, IScriptExpression op_expr, IScriptExpression n_expr, FilterPassController filterPassController) throws DataException {
        NEvaluator instance = null;
        switch (operator) {
            case 14: {
                instance = new TopNEvaluator();
                instance.n_percent = false;
                break;
            }
            case 16: {
                instance = new TopNEvaluator();
                instance.n_percent = true;
                break;
            }
            case 15: {
                instance = new BottomNEvaluator();
                instance.n_percent = false;
                break;
            }
            case 17: {
                instance = new BottomNEvaluator();
                instance.n_percent = true;
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        instance.op_expr = op_expr;
        instance.n_expr = n_expr;
        instance.filterPassController = filterPassController;
        instance.tempDir = tempDir;
        return instance;
    }

    public boolean evaluate(ScriptContext cx, Scriptable scope, DataSetRuntime dataSet) throws DataException {
        if (this.filterPassController.getForceReset()) {
            this.doReset();
            this.filterPassController.setForceReset(false);
        }
        if (this.N == -1) {
            Object n_object = null;
            try {
                n_object = ExprEvaluateUtil.evaluateRawExpression2(this.n_expr, scope, cx, dataSet);
            }
            catch (BirtException e1) {
                throw DataException.wrap(e1);
            }
            double n_value = -1.0;
            try {
                n_value = DataTypeUtil.toDouble((Object)n_object);
            }
            catch (BirtException e) {
                throw new DataException("data.engine.InvalidTopBottomArgument", e);
            }
            if (this.n_percent) {
                if (n_value < 0.0 || n_value > 100.0) {
                    throw new DataException("data.engine.InvalidTopBottomPercentArgument");
                }
                this.N = (int)Math.round(n_value / 100.0 * (double)this.filterPassController.getRowCount());
            } else {
                if (n_value < 0.0) {
                    throw new DataException("data.engine.InvalidTopBottomNArgument");
                }
                this.N = (int)n_value;
            }
        }
        Object value = ScriptEvalUtil.evalExpr(this.op_expr, cx.newContext((Object)scope), ScriptExpression.defaultID, 0);
        if (this.filterPassController.getPassLevel() == 1) {
            return this.doFirstPass(value);
        }
        if (this.filterPassController.getPassLevel() == 2) {
            return this.doSecondPass();
        }
        return false;
    }

    private boolean doFirstPass(Object value) throws DataException {
        ++this.firstPassRowNumberCounter;
        if (this.valueList == null) {
            this.valueList = new BasicCachedArray(this.tempDir, this.N);
            this.rowIdList = new BasicCachedArray(this.tempDir, this.N);
        }
        if (value != null) {
            this.populateValueListAndRowIdList(value, this.N);
        }
        return true;
    }

    private void populateValueListAndRowIdList(Object value, int N) throws DataException {
        assert (N >= 0);
        int activeCount = N < this.firstPassRowNumberCounter ? N : this.firstPassRowNumberCounter;
        int i = 0;
        while (i < activeCount) {
            if (this.valueList.get(i) == null) {
                this.valueList.set(i, value);
                this.rowIdList.set(i, this.firstPassRowNumberCounter);
                break;
            }
            Object result = this.doCompare(value, this.valueList.get(i));
            try {
                if (DataTypeUtil.toBoolean((Object)result).booleanValue()) {
                    int j = activeCount - 1;
                    while (j > i) {
                        this.valueList.set(j, this.valueList.get(j - 1));
                        this.rowIdList.set(j, this.rowIdList.get(j - 1));
                        --j;
                    }
                    this.valueList.set(i, value);
                    this.rowIdList.set(i, this.firstPassRowNumberCounter);
                    break;
                }
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            ++i;
        }
    }

    private boolean doSecondPass() {
        ++this.secondPassRowNumberCounter;
        if (this.secondPassRowNumberCounter > this.filterPassController.getSecondPassRowCount()) {
            this.filterPassController.setSecondPassRowCount(this.secondPassRowNumberCounter);
        } else {
            this.secondPassRowNumberCounter = this.filterPassController.getSecondPassRowCount();
        }
        if (this.qualifiedRowCounter < this.N) {
            int i = 0;
            while (i < this.N) {
                int rowId = 0;
                if (this.rowIdList.get(i) != null) {
                    rowId = (Integer)this.rowIdList.get(i);
                }
                if (rowId == this.secondPassRowNumberCounter) {
                    ++this.qualifiedRowCounter;
                    this.reset();
                    return true;
                }
                ++i;
            }
            return false;
        }
        this.reset();
        return false;
    }

    private void reset() {
        if (this.firstPassRowNumberCounter == this.secondPassRowNumberCounter) {
            this.doReset();
        }
    }

    private void doReset() {
        this.firstPassRowNumberCounter = 0;
        this.secondPassRowNumberCounter = 0;
        this.qualifiedRowCounter = 0;
        this.rowIdList = null;
        this.valueList = null;
        this.N = -1;
    }

    protected abstract Object doCompare(Object var1, Object var2) throws DataException;
}

