/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui.widgets;

import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.internal.core.RemoteServicesDescriptor;
import org.eclipse.remote.internal.core.RemoteServicesImpl;
import org.eclipse.remote.internal.core.preferences.Preferences;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteConnectionWidget
extends Composite {
    public static final String DEFAULT_CONNECTION_NAME = "Remote Host";
    public static int FLAG_FORCE_PROVIDER_SELECTION = 1;
    public static int FLAG_NO_LOCAL_SELECTION = 2;
    private static final String EMPTY_STRING = "";
    private Combo fServicesCombo = null;
    private Button fLocalButton;
    private Button fRemoteButton;
    private final Combo fConnectionCombo;
    private final Button fNewConnectionButton;
    private final List<RemoteServicesDescriptor> fRemoteServices;
    private IRemoteConnection fSelectedConnection;
    private IRemoteServices fDefaultServices;
    private boolean fSelectionListernersEnabled = true;
    private boolean fEnabled = true;
    private final IRunnableContext fContext;
    private final ListenerList fSelectionListeners = new ListenerList();
    private final WidgetListener fWidgetListener = new WidgetListener();

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags) {
        this(parent, style, title, flags, null);
    }

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags, IRunnableContext context) {
        super(parent, style);
        String id;
        this.fContext = context;
        RemoteConnectionWidget body = this;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (title != null) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            GridLayout groupLayout = new GridLayout(1, false);
            groupLayout.marginHeight = 0;
            groupLayout.marginWidth = 0;
            groupLayout.numColumns = 4;
            group.setLayout((Layout)groupLayout);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            layout.numColumns = 1;
            body = group;
        }
        if ((flags & FLAG_FORCE_PROVIDER_SELECTION) == 0 && (id = Preferences.getString((String)"remoteServicesId")) != null) {
            this.fDefaultServices = this.getRemoteServices(id);
        }
        if (this.fDefaultServices == null) {
            Label label = new Label((Composite)body, 0);
            label.setText(Messages.RemoteConnectionWidget_remoteServiceProvider);
            label.setLayoutData((Object)new GridData());
            this.fServicesCombo = new Combo((Composite)body, 12);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.horizontalSpan = 3;
            this.fServicesCombo.setLayoutData((Object)gd);
            this.fServicesCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fServicesCombo.setFocus();
        }
        if ((flags & FLAG_NO_LOCAL_SELECTION) == 0 && (flags & FLAG_FORCE_PROVIDER_SELECTION) == 0) {
            this.fLocalButton = new Button((Composite)body, 16);
            this.fLocalButton.setText(Messages.RemoteConnectionWidget_Local);
            this.fLocalButton.setLayoutData((Object)new GridData());
            this.fLocalButton.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fLocalButton.setSelection(false);
            this.fRemoteButton = new Button((Composite)body, 16);
            this.fRemoteButton.setText(Messages.RemoteConnectionWidget_Remote);
            this.fRemoteButton.setLayoutData((Object)new GridData());
        } else {
            Label remoteLabel = new Label((Composite)body, 0);
            remoteLabel.setText(Messages.RemoteConnectionWidget_connectionName);
            remoteLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        }
        this.fConnectionCombo = new Combo((Composite)body, 12);
        this.fConnectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fConnectionCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (this.fDefaultServices != null) {
            this.fConnectionCombo.setFocus();
        }
        this.fConnectionCombo.setEnabled(false);
        this.fNewConnectionButton = new Button((Composite)body, 8);
        this.fNewConnectionButton.setText(Messages.RemoteConnectionWidget_new);
        this.fNewConnectionButton.setLayoutData((Object)new GridData());
        this.fNewConnectionButton.addSelectionListener((SelectionListener)this.fWidgetListener);
        this.fRemoteServices = RemoteServicesImpl.getRemoteServiceDescriptors();
        if (this.fServicesCombo != null) {
            this.initializeRemoteServicesCombo(null);
        }
        this.handleRemoteServiceSelected(null);
        if (this.fLocalButton != null) {
            this.handleButtonSelected();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public Button getButton() {
        return this.fNewConnectionButton;
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    private IRemoteConnection getRemoteConnection(IRemoteServices services, String name) {
        IRemoteConnectionManager manager = this.getRemoteConnectionManager(services);
        if (manager != null) {
            return manager.getConnection(name);
        }
        return null;
    }

    private IRemoteConnection getRemoteConnection(String name) {
        IRemoteServices services = this.getSelectedServices();
        if (this.fDefaultServices != null && name.equals("Local")) {
            services = RemoteServices.getLocalServices();
        }
        return this.getRemoteConnection(services, name);
    }

    protected IRemoteConnectionManager getRemoteConnectionManager(IRemoteServices services) {
        if (services != null) {
            return services.getConnectionManager();
        }
        return null;
    }

    protected IRemoteServices getRemoteServices(String id) {
        if (id != null && !id.equals(EMPTY_STRING)) {
            return RemoteUIServices.getRemoteServices(id, this.fContext);
        }
        return null;
    }

    private IRemoteServices getSelectedServices() {
        if (this.fDefaultServices != null) {
            return this.fDefaultServices;
        }
        int selectionIndex = this.fServicesCombo.getSelectionIndex();
        if (this.fRemoteServices.size() > 0 && selectionIndex > 0) {
            return RemoteServices.getRemoteServices((String)this.fRemoteServices.get(selectionIndex - 1).getId());
        }
        return null;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteServices services = this.getSelectedServices();
        if (services != null) {
            return RemoteUIServices.getRemoteUIServices(services).getUIConnectionManager();
        }
        return null;
    }

    private void handleButtonSelected() {
        this.fRemoteButton.setSelection(!this.fLocalButton.getSelection());
        this.updateEnablement();
        this.handleConnectionSelected();
    }

    protected void handleConnectionSelected() {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        IRemoteConnection selectedConnection = null;
        if (this.fLocalButton != null && this.fLocalButton.getSelection()) {
            selectedConnection = RemoteServices.getLocalServices().getConnectionManager().getConnection("Local");
        } else {
            int currentSelection = this.fConnectionCombo.getSelectionIndex();
            if (currentSelection > 0) {
                String connectionName = this.fConnectionCombo.getItem(currentSelection);
                selectedConnection = this.getRemoteConnection(connectionName);
            }
        }
        if (selectedConnection == null || this.fSelectedConnection == null || !selectedConnection.getName().equals(this.fSelectedConnection.getName())) {
            this.fSelectedConnection = selectedConnection;
            Event evt = new Event();
            evt.widget = this;
            this.notifyListeners(new SelectionEvent(evt));
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    protected void handleNewRemoteConnectionSelected() {
        IRemoteUIConnectionWizard wizard;
        if (this.getUIConnectionManager() != null && (wizard = this.getUIConnectionManager().getConnectionWizard(this.getShell())) != null) {
            wizard.setConnectionName(this.initialConnectionName());
            IRemoteConnectionWorkingCopy conn = wizard.open();
            if (conn != null) {
                this.handleRemoteServiceSelected(conn.save());
                this.handleConnectionSelected();
            }
        }
    }

    protected void handleRemoteServiceSelected(IRemoteConnection conn) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        try {
            IRemoteServices selectedServices = this.getSelectedServices();
            if (conn != null) {
                selectedServices = conn.getRemoteServices();
            }
            if (this.fDefaultServices == null && conn != null) {
                int index = 0;
                while (index < this.fRemoteServices.size()) {
                    if (this.fRemoteServices.get(index).getId().equals(selectedServices.getId())) {
                        this.fServicesCombo.select(index + 1);
                        break;
                    }
                    ++index;
                }
            }
            this.fConnectionCombo.removeAll();
            this.fConnectionCombo.add(Messages.RemoteConnectionWidget_selectConnection);
            if (selectedServices == null) {
                this.fConnectionCombo.select(0);
                this.fConnectionCombo.setEnabled(false);
                this.fNewConnectionButton.setEnabled(false);
            } else {
                this.fConnectionCombo.setEnabled(true);
                IRemoteConnectionManager connectionManager = selectedServices.getConnectionManager();
                int selected = 0;
                int offset = 1;
                TreeSet sorted = new TreeSet(connectionManager.getConnections());
                for (IRemoteConnection s : sorted) {
                    this.fConnectionCombo.add(s.getName());
                    if (conn != null && s.getName().equals(conn.getName())) {
                        selected = offset;
                    }
                    ++offset;
                }
                this.fConnectionCombo.select(selected);
                this.handleConnectionSelected();
                this.fNewConnectionButton.setEnabled((selectedServices.getCapabilities() & 1) != 0);
            }
        }
        finally {
            this.fWidgetListener.setEnabled(enabled);
        }
    }

    private String initialConnectionName() {
        String name = DEFAULT_CONNECTION_NAME;
        int count = 1;
        while (this.getSelectedServices().getConnectionManager().getConnection(name) != null) {
            name = "Remote Host " + count++;
        }
        return name;
    }

    protected void initializeRemoteServicesCombo(String id) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        IRemoteServices defService = null;
        if (id != null) {
            defService = this.getRemoteServices(id);
        }
        this.fServicesCombo.removeAll();
        int offset = 1;
        int defIndex = 0;
        this.fServicesCombo.add(Messages.RemoteConnectionWidget_selectRemoteProvider);
        int i = 0;
        while (i < this.fRemoteServices.size()) {
            this.fServicesCombo.add(this.fRemoteServices.get(i).getName());
            if (defService != null && this.fRemoteServices.get(i).equals(defService)) {
                defIndex = i + offset;
            }
            ++i;
        }
        if (this.fRemoteServices.size() > 0) {
            this.fServicesCombo.select(defIndex);
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    private void notifyListeners(SelectionEvent e) {
        if (this.fSelectionListernersEnabled) {
            Object[] objectArray = this.fSelectionListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((SelectionListener)listener).widgetSelected(e);
                ++n2;
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteConnection connection) {
        this.fSelectionListernersEnabled = false;
        if (this.fLocalButton != null && connection != null && connection.getRemoteServices() == RemoteServices.getLocalServices()) {
            this.fLocalButton.setSelection(true);
            this.handleButtonSelected();
        } else {
            this.handleRemoteServiceSelected(connection);
        }
        this.handleConnectionSelected();
        this.updateEnablement();
        this.fSelectionListernersEnabled = true;
    }

    public void setConnection(String id, String name) {
        IRemoteConnection connection;
        IRemoteServices services = this.getRemoteServices(id);
        if (services != null && (connection = this.getRemoteConnection(services, name)) != null) {
            this.setConnection(connection);
        }
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.updateEnablement();
    }

    private void updateEnablement() {
        if (this.fDefaultServices != null) {
            boolean isRemote = true;
            if (this.fLocalButton != null) {
                this.fLocalButton.setEnabled(this.fEnabled);
                this.fRemoteButton.setEnabled(this.fEnabled);
                isRemote = !this.fLocalButton.getSelection();
            }
            this.fConnectionCombo.setEnabled(this.fEnabled && isRemote);
            this.fNewConnectionButton.setEnabled(this.fEnabled && isRemote && (this.fDefaultServices.getCapabilities() & 1) != 0);
        } else {
            IRemoteServices services = this.getSelectedServices();
            this.fConnectionCombo.setEnabled(this.fEnabled && services != null);
            this.fNewConnectionButton.setEnabled(this.fEnabled && services != null && (services.getCapabilities() & 1) != 0);
            this.fServicesCombo.setEnabled(this.fEnabled);
        }
    }

    protected class WidgetListener
    implements SelectionListener {
        private boolean listenerEnabled = true;

        protected WidgetListener() {
        }

        public void disable() {
            this.setEnabled(false);
        }

        protected void doWidgetDefaultSelected(SelectionEvent e) {
        }

        public void enable() {
            this.setEnabled(true);
        }

        public synchronized boolean isEnabled() {
            return this.listenerEnabled;
        }

        public synchronized void setEnabled(boolean enabled) {
            this.listenerEnabled = enabled;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                this.widgetSelected(e);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                Object source = e.getSource();
                if (source == RemoteConnectionWidget.this.fServicesCombo) {
                    RemoteConnectionWidget.this.handleRemoteServiceSelected(null);
                } else if (source == RemoteConnectionWidget.this.fConnectionCombo) {
                    RemoteConnectionWidget.this.handleConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fNewConnectionButton) {
                    RemoteConnectionWidget.this.handleNewRemoteConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fLocalButton) {
                    RemoteConnectionWidget.this.handleButtonSelected();
                }
            }
        }
    }
}

