/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDisplayHint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVar;

public class MIVarCreateInfo
extends MIInfo {
    String name = "";
    int numChild;
    String type = "";
    MIVar child;
    String value = null;
    private boolean isDynamic = false;
    private boolean hasMore = false;
    private MIDisplayHint displayHint = MIDisplayHint.NONE;

    public MIVarCreateInfo(MIOutput record) {
        super(record);
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue resultVal = results[i].getMIValue();
                String str = "";
                if (resultVal instanceof MIConst) {
                    str = ((MIConst)resultVal).getString();
                }
                if (var.equals("name")) {
                    this.name = str;
                } else if (var.equals("numchild")) {
                    try {
                        this.numChild = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("type")) {
                    this.type = str;
                } else if (var.equals("value")) {
                    this.value = str;
                } else if (var.equals("dynamic") && str.trim().equals("1")) {
                    this.isDynamic = true;
                } else if (var.equals("has_more") && str.trim().equals("1")) {
                    this.hasMore = true;
                } else if (var.equals("displayhint")) {
                    this.displayHint = new MIDisplayHint(str);
                }
                ++i;
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public int getNumChildren() {
        return this.numChild;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public MIDisplayHint getDisplayHint() {
        return this.displayHint;
    }

    public MIVar getMIVar() {
        if (this.child == null) {
            this.child = new MIVar(this.name, this.isDynamic, this.numChild, this.hasMore, this.type, this.displayHint);
        }
        return this.child;
    }
}

