/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.properties;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.util.YesNoMaybe;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTarget;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTargetEntry;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public final class ManagedProjectRemoteTargetEntry
extends RemoteTargetEntry {
    private final ComboViewer cpu;
    private IObservableValue cpuObservable;
    private final Button manageToolkits;
    private final Text toolkit;
    private final ToolkitObservable toolkitObservable = new ToolkitObservable(String.class);
    private IObservableValue toolkitNameObservable;

    public ManagedProjectRemoteTargetEntry(Composite parent, int style) {
        super(parent, style | 0x800 | 0x10);
        Label lblToolkit = new Label(this.body, 0);
        lblToolkit.setText("Toolkit:");
        this.toolkit = new Text(this.body, 2056);
        this.manageToolkits = new Button(this.body, 0);
        this.manageToolkits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedProjectRemoteTargetEntry.this.editToolkit();
            }
        });
        this.manageToolkits.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.manageToolkits.setText("Manage...");
        Label archLabel = new Label(this.body, 0);
        archLabel.setText("CPU Architecture:");
        this.cpu = new ComboViewer(this.body, 2056);
        this.cpu.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cpu.setFilters(new ViewerFilter[]{new CpuFilter()});
        this.cpu.setInput((Object)Cpu.values());
        new Label(this.body, 0);
        this.setupBindings();
    }

    protected void editToolkit() {
        if (this.remoteTarget != null) {
            try {
                CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                    public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                        return service.editToolkit(ManagedProjectRemoteTargetEntry.this.remoteTarget.getName());
                    }
                });
            }
            catch (CoreException e) {
                ManagedProjectRemoteTargetEntry.handle(e);
            }
            this.toolkitObservable.invalidate();
        }
    }

    @Override
    protected void refresh() {
        this.cpu.refresh(true);
    }

    @Override
    public void setTarget(RemoteTarget target) {
        super.setTarget(target);
        boolean isLocal = target.isLocal();
        SWTUtil.setVisible((Control)this.manageToolkits, (!isLocal ? 1 : 0) != 0);
        GridData toolkitLD = new GridData(4, 0x1000000, true, false, isLocal ? 2 : 1, 1);
        this.toolkit.setLayoutData((Object)toolkitLD);
        this.toolkit.setEnabled(!isLocal);
        this.cpu.refresh();
    }

    private void setupBindings() {
        this.toolkitNameObservable = BeansObservables.observeDetailValue((IObservableValue)this.target, (String)"toolkitName", String.class);
        this.toolkitNameObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ManagedProjectRemoteTargetEntry.this.toolkitObservable.invalidate();
            }
        });
        this.cpuObservable = BeansObservables.observeDetailValue((IObservableValue)this.target, (String)"cpu", Cpu.class);
        this.context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.toolkit), (IObservableValue)this.toolkitObservable);
        this.context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.cpu), this.cpuObservable);
    }

    @Override
    protected IStatus validateTargetSettings(RemoteTarget value) {
        IStatus status = super.validateTargetSettings(value);
        if (!status.isOK()) {
            return status;
        }
        if (this.toolkitObservable.getValue() == null) {
            return CoreUtil.errorStatus((String)"Toolkit for connection %s is not selected", (Object[])new Object[]{this.remoteTarget.getName()});
        }
        Cpu cpu = (Cpu)this.cpuObservable.getValue();
        if (this.remoteTarget.isLocal() && cpu != null && cpu.isSupportedOnLocalSystem() == YesNoMaybe.Maybe) {
            return CoreUtil.warningStatus((String)"Make sure CUDA toolkit support for %s architecture is installed", (Object[])new Object[]{cpu});
        }
        return CoreUtil.OK_STATUS;
    }

    public final class CpuFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return ManagedProjectRemoteTargetEntry.this.remoteTarget == null || !ManagedProjectRemoteTargetEntry.this.remoteTarget.isLocal() || ((Cpu)element).isSupportedOnLocalSystem() != YesNoMaybe.No;
        }
    }

    private final class ToolkitObservable
    extends ComputedValue {
        private ToolkitObservable(Object valueType) {
            super(valueType);
        }

        protected Object calculate() {
            RemoteTarget value = (RemoteTarget)ManagedProjectRemoteTargetEntry.this.target.getValue();
            if (value != null) {
                return this.getToolkitName(value);
            }
            return null;
        }

        private String getToolkitName(final RemoteTarget target) {
            try {
                ICudaToolkit toolkit = (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                    public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                        if (target.isLocal()) {
                            String tkName = target.getToolkitName();
                            ICudaToolkit tk = tkName != null ? service.getToolkitByName(tkName) : null;
                            return tk != null ? tk : service.getDefaultToolkit();
                        }
                        return service.getToolkit(target.getConnectionName());
                    }
                });
                return toolkit != null ? toolkit.getName() : null;
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
                return null;
            }
        }

        public void invalidate() {
            this.makeDirty();
        }
    }
}

