/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.CuptiActivityPCSamplingRecordInfo;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.PCSamplingResultGraphicFactory;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.jni.NativeDemangler;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;

public class AnalysisResultPCSampling
extends AnalysisResultSourceLevel {
    private Map<String, Integer> functionIdMap;
    private Map<Integer, Long> functionIdSamplesMap;
    private Map<Integer, Long> functionIdLatencySamplesMap;
    private Map<Integer, Long> functionIdInstIssuedSamplesMap;
    private Map<String, Long> fileSamplesMap;
    private Map<String, Long> fileLatencySamplesMap;
    private Map<String, Long> fileInstIssuedSamplesMap;
    private Map<String, Integer> fileLineMap;
    private Long totalSamples = 0L;
    private Long totalLatencySamples = 0L;
    private Long totalInstIssuedSamples = 0L;
    private boolean initialize = false;

    public AnalysisResultPCSampling(Session session, ITimelineInterval interval, AnalysisDescriptor desc) {
        super(session, interval, desc);
    }

    private int getPeriodValue(long periodInCycles) {
        int i = 0;
        while (periodInCycles > 1L) {
            periodInCycles >>= 1;
            ++i;
        }
        return i;
    }

    @Override
    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        return "";
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new PCSamplingResultGraphicFactory();
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        CuptiActivityPCSamplingRecordInfo recordInfo = this.getInterval().getPCSamplingRecordInfo();
        Long periodInCycles = recordInfo != null ? recordInfo.periodInCycles : 128L;
        int periodValue = this.getPeriodValue(periodInCycles);
        Set<ICuptiActivitySourceLevelResult> sourceLevelResults = this.getSourceLevelResults();
        if (sourceLevelResults.size() == 1 && sourceLevelResults.iterator().next().isNullResult() && periodInCycles > 32L) {
            String desc = ViperMessages.Pc_Sampling_NoSamples_Desc;
            desc = desc.replaceAll("%PERIOD%", String.valueOf(periodInCycles));
            desc = desc.replaceAll("%PERIODVALUE%", String.valueOf(periodValue));
            return desc;
        }
        String desc = super.getDescription(otpt);
        desc = desc.replaceAll("%PERIOD%", String.valueOf(periodInCycles));
        desc = desc.replaceAll("%PERIODVALUE%", String.valueOf(periodValue));
        CuptiActivityPCSamplingStallReason[] cuptiActivityPCSamplingStallReasonArray = CuptiActivityPCSamplingStallReason.values();
        int n = cuptiActivityPCSamplingStallReasonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityPCSamplingStallReason reason = cuptiActivityPCSamplingStallReasonArray[n2];
            if (!reason.equals((Object)CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID)) {
                desc = String.valueOf(desc) + "\n\t" + reason.getDesc();
            }
            ++n2;
        }
        return desc;
    }

    @Override
    public Action getMoreAction() {
        return new MoreAction();
    }

    private void initAnalysisSummary(Session activeSession) {
        if (this.initialize) {
            return;
        }
        this.functionIdMap = new HashMap<String, Integer>();
        this.functionIdSamplesMap = new TreeMap<Integer, Long>();
        this.functionIdLatencySamplesMap = new TreeMap<Integer, Long>();
        this.functionIdInstIssuedSamplesMap = new TreeMap<Integer, Long>();
        this.fileSamplesMap = new TreeMap<String, Long>();
        this.fileInstIssuedSamplesMap = new TreeMap<String, Long>();
        this.fileLatencySamplesMap = new TreeMap<String, Long>();
        this.fileLineMap = new HashMap<String, Integer>();
        this.totalSamples = 0L;
        this.totalLatencySamples = 0L;
        this.totalInstIssuedSamples = 0L;
        for (ICuptiActivitySourceLevelResult result : this.getSourceLevelResults()) {
            CuptiActivityFunction function;
            if (!(result instanceof CuptiActivityPCSampling)) continue;
            CuptiActivityPCSampling pcSampling = (CuptiActivityPCSampling)result;
            CuptiActivitySourceLocator locator = activeSession.getSourceLocator().getLocation(pcSampling.getSourceLocatorId());
            if (locator != null) {
                String fileName = locator.fileName;
                int lineNumber = locator.lineNumber;
                if (!this.fileLineMap.containsKey(fileName)) {
                    this.fileLineMap.put(fileName, lineNumber);
                } else if (lineNumber < this.fileLineMap.get(fileName)) {
                    this.fileLineMap.put(fileName, lineNumber);
                }
                long samples = pcSampling.samples;
                if (this.fileSamplesMap.containsKey(fileName)) {
                    samples += this.fileSamplesMap.get(fileName).longValue();
                }
                this.fileSamplesMap.put(fileName, samples);
                long latencySamples = pcSampling.latencySamples;
                if (this.fileLatencySamplesMap.containsKey(fileName)) {
                    latencySamples += this.fileLatencySamplesMap.get(fileName).longValue();
                }
                this.fileLatencySamplesMap.put(fileName, latencySamples);
                if (CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE.getCode() == pcSampling.stallReason) {
                    long instIssued = pcSampling.samples;
                    if (this.fileInstIssuedSamplesMap.containsKey(fileName)) {
                        instIssued += this.fileInstIssuedSamplesMap.get(fileName).longValue();
                    }
                    this.fileInstIssuedSamplesMap.put(fileName, instIssued);
                }
            }
            if ((function = activeSession.getCudaFunctionManager().getFunction(pcSampling.functionId)) != null) {
                String funcName = NativeDemangler.demangle(function.name);
                if (funcName == null) {
                    funcName = function.name;
                }
                if (!this.functionIdMap.containsKey(funcName)) {
                    this.functionIdMap.put(funcName, function.id);
                }
            }
            long samples = pcSampling.samples;
            this.totalSamples = this.totalSamples + pcSampling.samples;
            this.totalLatencySamples = this.totalLatencySamples + pcSampling.latencySamples;
            if (this.functionIdSamplesMap.containsKey(pcSampling.functionId)) {
                samples += this.functionIdSamplesMap.get(pcSampling.functionId).longValue();
            }
            this.functionIdSamplesMap.put(pcSampling.functionId, samples);
            long latencySamples = pcSampling.latencySamples;
            if (this.functionIdLatencySamplesMap.containsKey(pcSampling.functionId)) {
                latencySamples += this.functionIdLatencySamplesMap.get(pcSampling.functionId).longValue();
            }
            this.functionIdLatencySamplesMap.put(pcSampling.functionId, latencySamples);
            if (CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE.getCode() != pcSampling.stallReason) continue;
            long instIssued = pcSampling.samples;
            this.totalInstIssuedSamples = this.totalInstIssuedSamples + pcSampling.samples;
            if (this.functionIdInstIssuedSamplesMap.containsKey(pcSampling.functionId)) {
                instIssued += this.functionIdInstIssuedSamplesMap.get(pcSampling.functionId).longValue();
            }
            this.functionIdInstIssuedSamplesMap.put(pcSampling.functionId, instIssued);
        }
        this.initialize = true;
    }

    public String[] getFunctionNameList(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdMap != null) {
            return this.functionIdMap.keySet().toArray(new String[this.functionIdMap.size()]);
        }
        return null;
    }

    public String[] getSourceFileNameList(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileLineMap != null) {
            return this.fileLineMap.keySet().toArray(new String[this.fileLineMap.size()]);
        }
        return null;
    }

    public int getFunctionId(String function, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdMap != null) {
            return this.functionIdMap.get(function);
        }
        return 0;
    }

    public int getFileLineNumber(String function, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileLineMap != null) {
            return this.fileLineMap.get(function);
        }
        return 0;
    }

    public long getSampleCount(String filename, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileSamplesMap != null) {
            return this.fileSamplesMap.get(filename);
        }
        return 0L;
    }

    public long getSampleCount(int functionId, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdSamplesMap != null) {
            return this.functionIdSamplesMap.get(functionId);
        }
        return 0L;
    }

    public long getLatencySampleCount(String filename, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileLatencySamplesMap != null && this.fileLatencySamplesMap.containsKey(filename)) {
            return this.fileLatencySamplesMap.get(filename);
        }
        return 0L;
    }

    public long getInstIssuedSampleCount(String filename, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileInstIssuedSamplesMap != null && this.fileInstIssuedSamplesMap.containsKey(filename)) {
            return this.fileInstIssuedSamplesMap.get(filename);
        }
        return 0L;
    }

    public long getIssuePipeBusySampleCount(String fileName, Session activeSession) {
        return this.getSampleCount(fileName, activeSession) - this.getInstIssuedSampleCount(fileName, activeSession) - this.getLatencySampleCount(fileName, activeSession);
    }

    public long getInstIssuedSampleCount(int functionId, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdInstIssuedSamplesMap != null && this.functionIdInstIssuedSamplesMap.containsKey(functionId)) {
            return this.functionIdInstIssuedSamplesMap.get(functionId);
        }
        return 0L;
    }

    public long getLatencySampleCount(int functionId, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdLatencySamplesMap != null && this.functionIdLatencySamplesMap.containsKey(functionId)) {
            return this.functionIdLatencySamplesMap.get(functionId);
        }
        return 0L;
    }

    public long getIssuePipeBusySampleCount(int functionId, Session activeSession) {
        return this.getSampleCount(functionId, activeSession) - this.getInstIssuedSampleCount(functionId, activeSession) - this.getLatencySampleCount(functionId, activeSession);
    }

    public double getTotalSamples(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalSamples.longValue();
    }

    public double getTotalLatencySamples(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalLatencySamples.longValue();
    }

    @Override
    public AnalysisResultSourceLevelKind getAnalysisResultSourceLevelKind() {
        if (this.getKernel().getMajorComputeCapability() > 5) {
            return AnalysisResultSourceLevelKind.PC_SAMPLING_LATENCY_KIND;
        }
        return AnalysisResultSourceLevelKind.PC_SAMPLING_KIND;
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            ViperHelp.displayHelp(ViperHelp.PC_SAMPLING);
        }
    }
}

