/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.cuda.ide.util.ISourceIntegration;
import com.nvidia.cuda.ide.util.ISourceMarker;
import com.nvidia.viper.analysis.AnalysisSourceMarker;
import com.nvidia.viper.jni.CallTree;
import com.nvidia.viper.jni.CpuThread;
import com.nvidia.viper.model.Session;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public class CpuSample {
    private String fileName;
    private int lineNo;
    private static HashMap<String, HashMap<Integer, ArrayList<CpuSample>>> sampleMap = new HashMap();
    private String functionName;

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public CpuSample(CallTree call, String fileName, String functionName, int lineNo, Map<CpuThread, Integer> threadHitMap, int cumulativeHits) {
        HashMap<Integer, ArrayList<CpuSample>> lineMap;
        this.fileName = fileName;
        this.functionName = functionName;
        this.lineNo = lineNo;
        if (sampleMap.get(fileName) == null) {
            HashMap hash = new HashMap();
            sampleMap.put(fileName, hash);
        }
        if ((lineMap = sampleMap.get(fileName)).get(lineNo) == null) {
            ArrayList list = new ArrayList();
            lineMap.put(lineNo, list);
        }
        ArrayList<CpuSample> sampleList = lineMap.get(lineNo);
        sampleList.add(this);
    }

    public static void addMarkers(Session session, ISourceIntegration sourceIntegration, String fileName) throws URISyntaxException, CoreException {
        HashMap<Integer, ArrayList<CpuSample>> hash = sampleMap.get(fileName);
        if (hash != null) {
            for (ArrayList<CpuSample> samples : hash.values()) {
                AnalysisSourceMarker marker = new AnalysisSourceMarker(session, new URI("file:///" + samples.get((int)0).fileName), samples.get((int)0).lineNo, new Integer(samples.size()).toString());
                sourceIntegration.addMarkers(null, new ISourceMarker[]{marker});
                sourceIntegration.openEditor((ISourceMarker)marker);
            }
        }
    }

    public static HashMap<Integer, ArrayList<CpuSample>> getSamples(String fileName) {
        HashMap<Integer, ArrayList<CpuSample>> hash = sampleMap.get(fileName);
        return hash;
    }

    public static HashMap<Integer, ArrayList<CpuSample>> getSamples(String fileName, String functionName) {
        HashMap<Integer, ArrayList<CpuSample>> hash = sampleMap.get(fileName);
        HashMap<Integer, ArrayList<CpuSample>> functionHash = new HashMap<Integer, ArrayList<CpuSample>>();
        if (hash != null) {
            for (ArrayList<CpuSample> samples : hash.values()) {
                if (samples.get((int)0).functionName.compareTo(functionName) != 0) continue;
                functionHash.put(samples.get((int)0).lineNo, samples);
            }
        }
        return functionHash;
    }
}

