// DO NOT MODIFY.
// This file was created automatically by CMake.

// QuadDPlugin is the primary UI library for the product.
AppLib.logInfo("Loading QuadDPlugin");

var states = {
    ShowProjectExplorer: "$$.ShowProjectExplorer",
};

addPlugin({
    pluginDependencies: ["CorePlugin"],
    pluginLibrary: "QuadDPlugin",

    layouts: {
        "default": "Plugins/$$/default.layout",
    },

    hostApplication: {
        title: qsTr("NVIDIA Nsight Systems"),
        version: "2019.3.7",
        defaultWidth: 1366,
        defaultHeight: 768,
        multiTargetEnabled: true,
        icon: ":/icons/Product.png",

        productName: "NVIDIA Nsight Systems",
        organizationName: "NVIDIA Corporation",

        versionUpdates: {
            enabled: true,
            tableUrl: "http://developer.download.nvidia.com/NsightSystems/VersionUpgrades-CTK.json",
        },

        commandBars: {
            "$$.FileMenu": { order: 100 },
            "$$.ViewMenu": { order: 200 },
            "$$.ToolsMenu": { order: 300 },
            "$$.HelpMenu": { order: 9999 },
            "$$.DeviceListToolbar": { order: 400 },
        },
    },

    documents:
    {
        fileTypes:
        {
            "qdrep":
            {
                icon: "",
                factoryName: "ReportFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "qdstrm":
            {
                icon: "",
                factoryName: "ReportFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "qdproj":
            {
                icon: "",
                factoryName: "ProjectFactory",
                viewFactories:
                [
                    { factoryName: "ProjectWindowFactory", priority: 50 }
                ]
            },
            "qdprogress":
            {
                icon: "",
                factoryName: "ProfilingProgressFactory",
                viewFactories:
                [
                    { factoryName: "ProfilingProgressWindowFactory", priority: 50 }
                ]
            },
        },
        fileFilters: {
            "Projects": { extensions: ["qdproj"], sortPriority: 50 },
            "Reports": { extensions: ["qdrep"], sortPriority: 50 }
        }
    },

    toolWindows: {
        "$$.ProjectExplorerWindow": {
            text: qsTr("Project Explorer"),
            sizeMode: "percent",
            deleteOnClose: true,
            layout: "dockWest",
            isFixed: false,
            persistable: true,
            defaultWidth: 250,
            commandBars: {
            },
        }

    },

    commands: {
        "$$.RestoreDefaultLayout": {
            text: qsTr("&Restore Default Layout"),
        },
        "$$.SaveLayout": {
            text: qsTr("Save Layout"),
            shortcut: codeTr("Alt+Shift+S"),
        },
        "$$.NewProject": {
            text: qsTr("&New Project"),
            shortcut: codeTr("Ctrl+N"),
        },
        "$$.OpenFile": {
            text: qsTr("&Open..."),
            shortcut: codeTr("Ctrl+O"),
        },
        "$$.Import": {
            text: qsTr("&Import..."),
            shortcut: codeTr("Ctrl+I"),
        },
        "$$.SaveFileAs": {
            text: qsTr("Save &As..."),
            shortcut: codeTr("Ctrl+Shift+S"),
            enabled: false,
        },
        "$$.ShowProjectExplorer": {
            text: qsTr("&Show Project Explorer"),
            checkedWithFlags: [states.ShowProjectExplorer],
        },
        "$$.ShowAboutWindow": {
            text: qsTr("&About"),
        },
        "$$.ShowPreferencesWindow": {
            text: qsTr("&Preferences..."),
        },
    },

    commandGroups: {
        "$$.ProjectGroup": {
            "$$.NewProject": { order: 100 },
            "$$.OpenFile": { order: 200 },
            "$$.Import": { order: 300 },
        },
        "$$.FileGroup": {
            "CorePlugin.CloseFile": { order: 150 },
        },
        "$$.ViewToolWindowsGroup": {
            "$$.ShowProjectExplorer": { order: 100 },
        },
        "$$.DocumentationGroup": {
            "CorePlugin.CheckForUpdatesCommand": {order: 100},
        },
        "$$.AboutGroup": {
            "$$.ShowAboutWindow": { order: 100 },
        },
        "$$.LayoutGroup": {
            "$$.RestoreDefaultLayout": { order: 110 },
            "$$.SaveLayout": { order: 110 },
        }
    },

    commandBars: {
        "$$.FileMenu": {
            type: "menu",
            text: qsTr("&File"),
            commandGroups: {
                "$$.ProjectGroup": { order: 100 },
                "$$.FileGroup": { order: 150 },
                "CorePlugin.ExitGroup": { order: 200 },
            },
        },
        "$$.ViewMenu": {
            type: "menu",
            text: qsTr("&View"),
            commandGroups: {
                "$$.ViewToolWindowsGroup": { order: 100 },
                "$$.LayoutGroup": { order: 210 },
            },
        },
        "$$.HelpMenu": {
            type: "menu",
            text: qsTr("&Help"),
            commandGroups: {
                "$$.DocumentationGroup": { order: 100 },
                "$$.AboutGroup": { order: 110 },
            },
        },
        "$$.ToolsMenu": {
            type: "menu",
            text: qsTr("&Tools"),
            commandGroups: {
                "CorePlugin.SettingsGroup": { order: 100 },
            },
        },
    },

    settings: {
        // This is a workaround to disable color theme switching in QuadD
        // because it doesn't switch smoothly, requires to be restarted
        // and some items are not colored correctly.
        //
        // If we just make it invisible, somehow the combobox in the Feedback
        // section gets invisible after opening the Settings dialog twice.
        // It seems to be a bug in AppLib or QtPropertyBrowser.
        "CorePlugin.Environment": {
            properties: {
                "CorePlugin.ColorTheme": {
                    type: "enum",
                    enumValues: {
                        "lightTheme": {
                            order: 100,
                            text: qsTr("Light"),
                        },
                    }
                },
            },
        },

        // TODO (DTSP-2632): This is a workaround for this problem:
        // http://devtools-ru-s1.nvidia.com/gitlab/agora/quadd/merge_requests/4647#note_90779
        "CorePlugin.Privacy": {
            properties: {
                "CorePlugin.AllowAnalytics": {
                    category: qsTr("Help Improve NVIDIA Software    "),
                }
            }
        }
    }
});
