/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.security.SecureRandom;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.util.Base64;

public class GUID
extends StringID {
    private static final long serialVersionUID = 3545794369039972407L;
    public static final String SR_DEFAULT_ALGO = null;
    public static final String SR_DEFAULT_PROVIDER = null;
    public static final int DEFAULT_BYTE_LENGTH = 20;
    protected static transient SecureRandom random;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected GUID(Namespace n, String algo, String provider, int byteLength) throws IDCreateException {
        super(n, "");
        try {
            GUID.getRandom(algo, provider);
        }
        catch (Exception e) {
            throw new IDCreateException("GUID creation failure: " + e.getMessage());
        }
        if (byteLength <= 0) {
            byteLength = 1;
        }
        byte[] newBytes = new byte[byteLength];
        random.nextBytes(newBytes);
        this.value = Base64.encode(newBytes);
    }

    protected GUID(Namespace n, String value) {
        super(n, value);
    }

    protected GUID(Namespace n, int byteLength) throws IDCreateException {
        this(n, SR_DEFAULT_ALGO, SR_DEFAULT_PROVIDER, byteLength);
    }

    protected GUID(Namespace n) throws IDCreateException {
        this(n, 20);
    }

    protected static synchronized SecureRandom getRandom(String algo, String provider) throws Exception {
        if (random == null) {
            GUID.initializeRandom(algo, provider);
        }
        return random;
    }

    protected static synchronized void initializeRandom(String algo, String provider) throws Exception {
        if (provider == null) {
            if (algo == null) {
                try {
                    random = SecureRandom.getInstance("IBMSECURERANDOM");
                }
                catch (Exception e) {
                    random = SecureRandom.getInstance("SHA1PRNG");
                }
            } else {
                random = SecureRandom.getInstance(algo);
            }
        } else {
            random = SecureRandom.getInstance(algo, provider);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GUID[");
        sb.append(this.value).append("]");
        return sb.toString();
    }

    public static class GUIDNamespace
    extends Namespace {
        private static final long serialVersionUID = -8546568877571886386L;

        public GUIDNamespace() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.GUID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(clazz.getName(), "GUID Namespace");
        }

        public ID createInstance(Object[] args) throws IDCreateException {
            try {
                String init = this.getInitStringFromExternalForm(args);
                if (init != null) {
                    return new GUID((Namespace)this, init);
                }
                if (args == null || args.length <= 0) {
                    return new GUID(this);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new GUID((Namespace)this, (Integer)args[0]);
                }
                if (args.length == 1 && args[0] instanceof String) {
                    return new GUID((Namespace)this, (String)args[0]);
                }
                return new GUID(this);
            }
            catch (Exception e) {
                throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", e);
            }
        }

        public String getScheme() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.GUID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getName();
        }

        public Class[][] getSupportedParameterTypes() {
            Class[][] classArray = new Class[2][];
            classArray[0] = new Class[0];
            Class[] classArray2 = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz;
            classArray[1] = classArray2;
            return classArray;
        }
    }
}

