/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractUpdateIndexAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!(this.fSelection instanceof IStructuredSelection) && !(this.fSelection instanceof ITextSelection)) {
            return;
        }
        ICProject[] projects = this.getSelectedCProjects();
        this.doRun(projects);
    }

    protected void doRun(ICProject[] projects) {
        try {
            CCorePlugin.getIndexManager().update((ICElement[])projects, this.getUpdateOptions());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    protected abstract int getUpdateOptions();

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public boolean isEnabledFor(ISelection selection) {
        this.selectionChanged(null, selection);
        ICProject[] project = this.getSelectedCProjects();
        return project.length > 0;
    }

    protected ICProject[] getSelectedCProjects() {
        ICProject cproject;
        IProject project;
        ArrayList<ICProject> tuSelection = new ArrayList<ICProject>();
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection resources = SelectionConverter.convertSelectionToResources(this.fSelection);
            for (Object o : resources) {
                ICProject cproject2;
                if (!(o instanceof IResource) || (cproject2 = CCorePlugin.getDefault().getCoreModel().create(((IResource)o).getProject())) == null) continue;
                tuSelection.add(cproject2);
            }
        } else if ((this.fSelection == null || this.fSelection instanceof ITextSelection) && (project = EditorUtility.getProjectForActiveEditor()) != null && (cproject = CCorePlugin.getDefault().getCoreModel().create(project)) != null) {
            tuSelection.add(cproject);
        }
        return tuSelection.toArray(new ICProject[tuSelection.size()]);
    }
}

