/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class RepositoriesViewLabelProvider
extends ColumnLabelProvider
implements IStateListener,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Map<Image, Image> decoratedImages = new HashMap<Image, Image>();
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Image annotatedTagImage = this.resourceManager.createImage(UIIcons.TAG_ANNOTATED);
    private Image gerritRepoImage = this.resourceManager.createImage(UIIcons.REPOSITORY_GERRIT);
    private final State verboseBranchModeState;
    private boolean verboseBranchMode = false;

    public RepositoriesViewLabelProvider() {
        ICommandService srv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.verboseBranchModeState = srv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchCommit").getState("org.eclipse.ui.commands.toggleState");
        this.verboseBranchModeState.addListener((IStateListener)this);
        try {
            this.verboseBranchMode = (Boolean)this.verboseBranchModeState.getValue();
        }
        catch (Exception e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    public Image getImage(Object element) {
        Repository r;
        Object object;
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        RepositoryTreeNodeType type = node.getType();
        if (type == RepositoryTreeNodeType.TAG) {
            TagNode tagNode = (TagNode)node;
            if (tagNode.isAnnotated()) {
                return this.decorateImage(this.annotatedTagImage, element);
            }
        } else if (type == RepositoryTreeNodeType.FILE) {
            Object object2 = node.getObject();
            if (object2 instanceof File) {
                ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(((File)object2).getName());
                return this.decorateImage((Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor), element);
            }
        } else if (type == RepositoryTreeNodeType.REPO && (object = node.getObject()) instanceof Repository && ResourcePropertyTester.hasGerritConfiguration(r = (Repository)object)) {
            return this.gerritRepoImage;
        }
        return this.decorateImage(node.getType().getIcon(), element);
    }

    public String getText(Object element) {
        if (!(element instanceof RepositoryTreeNode)) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        return this.getSimpleText(node);
    }

    public void dispose() {
        this.verboseBranchModeState.removeListener((IStateListener)this);
        for (Image image : this.decoratedImages.values()) {
            image.dispose();
        }
        this.resourceManager.dispose();
        this.decoratedImages.clear();
        super.dispose();
    }

    /*
     * Unable to fully structure code
     */
    private Image decorateImage(Image image, Object element) {
        node = (RepositoryTreeNode)element;
        switch (RepositoriesViewLabelProvider.$SWITCH_TABLE$org$eclipse$egit$ui$internal$repository$tree$RepositoryTreeNodeType()[node.getType().ordinal()]) {
            case 3: 
            case 9: 
            case 10: {
                refName = ((Ref)node.getObject()).getName();
                leaf = ((Ref)node.getObject()).getLeaf();
                try {
                    branchName = node.getRepository().getFullBranch();
                    if (branchName == null) {
                        return image;
                    }
                    if (!refName.startsWith("refs/heads/")) ** GOTO lbl13
                    compareString = refName;
                    ** GOTO lbl39
lbl13:
                    // 1 sources

                    if (!refName.startsWith("refs/tags/")) ** GOTO lbl17
                    tagNode = (TagNode)node;
                    compareString = tagNode.getCommitId();
                    ** GOTO lbl39
lbl17:
                    // 1 sources

                    if (!refName.startsWith("refs/remotes/")) ** GOTO lbl29
                    id = node.getRepository().resolve(refName);
                    if (id == null) {
                        return image;
                    }
                    rw = new RevWalk(node.getRepository());
                    try {
                        commit = rw.parseCommit((AnyObjectId)id);
                        compareString = commit.getId().name();
                        ** GOTO lbl39
                    }
                    finally {
                        rw.release();
                    }
lbl29:
                    // 1 sources

                    if (refName.equals("HEAD")) {
                        return this.getDecoratedImage(image);
                    }
                    leafname = leaf.getName();
                    if (leafname.startsWith("refs/") && leafname.equals(node.getRepository().getFullBranch())) {
                        return this.getDecoratedImage(image);
                    }
                    if (leaf.getObjectId().equals((AnyObjectId)node.getRepository().resolve("HEAD"))) {
                        return this.getDecoratedImage(image);
                    }
                    return image;
                }
                catch (IOException v0) {
                    return image;
                }
lbl39:
                // 3 sources

                if (compareString != null && compareString.equals(branchName)) {
                    return this.getDecoratedImage(image);
                }
                return image;
            }
        }
        return image;
    }

    private Image getDecoratedImage(final Image image) {
        Image decoratedImage = this.decoratedImages.get(image);
        if (decoratedImage == null) {
            CompositeImageDescriptor cd = new CompositeImageDescriptor(){

                protected Point getSize() {
                    Rectangle bounds = image.getBounds();
                    return new Point(bounds.width, bounds.height);
                }

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(image.getImageData(), 0, 0);
                    this.drawImage(UIIcons.OVR_CHECKEDOUT.getImageData(), 0, 0);
                }
            };
            decoratedImage = cd.createImage();
            this.decoratedImages.put(image, decoratedImage);
        }
        return decoratedImage;
    }

    private RevCommit getLatestCommit(RepositoryTreeNode node) {
        Ref ref = (Ref)node.getObject();
        ObjectId id = ref.isSymbolic() ? ref.getLeaf().getObjectId() : ref.getObjectId();
        if (id == null) {
            return null;
        }
        RevWalk walk = new RevWalk(node.getRepository());
        walk.setRetainBody(true);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)id);
            return revCommit;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            walk.release();
        }
    }

    private String abbreviate(ObjectId id) {
        if (id != null) {
            return id.abbreviate(7).name();
        }
        return ObjectId.zeroId().abbreviate(7).name();
    }

    protected StyledString getStyledTextForSubmodule(RepositoryTreeNode node) {
        Ref head;
        StyledString string = new StyledString();
        Repository repository = (Repository)node.getObject();
        String path = Repository.stripWorkDir((File)node.getParent().getRepository().getWorkTree(), (File)repository.getWorkTree());
        string.append(path);
        try {
            head = repository.getRef("HEAD");
        }
        catch (IOException iOException) {
            return string;
        }
        if (head != null) {
            string.append(' ');
            string.append('[', StyledString.DECORATIONS_STYLER);
            if (head.isSymbolic()) {
                string.append(Repository.shortenRefName((String)head.getLeaf().getName()), StyledString.DECORATIONS_STYLER);
            } else if (head.getObjectId() != null) {
                string.append(this.abbreviate(head.getObjectId()), StyledString.DECORATIONS_STYLER);
            }
            string.append(']', StyledString.DECORATIONS_STYLER);
            if (this.verboseBranchMode && head.getObjectId() != null) {
                RevWalk walk = new RevWalk(repository);
                try {
                    try {
                        RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
                        string.append(' ');
                        string.append(commit.getShortMessage(), StyledString.QUALIFIER_STYLER);
                    }
                    catch (IOException iOException) {
                        walk.release();
                    }
                }
                finally {
                    walk.release();
                }
            }
        }
        return string;
    }

    protected StyledString getStyledTextForCommit(StashedCommitNode node) {
        StyledString string = new StyledString();
        RevCommit commit = (RevCommit)node.getObject();
        string.append(MessageFormat.format("{0}@'{'{1}'}'", "stash", node.getIndex()));
        string.append(' ');
        string.append('[', StyledString.DECORATIONS_STYLER);
        string.append(this.abbreviate((ObjectId)commit), StyledString.DECORATIONS_STYLER);
        string.append(']', StyledString.DECORATIONS_STYLER);
        string.append(' ');
        string.append(commit.getShortMessage(), StyledString.QUALIFIER_STYLER);
        return string;
    }

    public StyledString getStyledText(Object element) {
        if (!(element instanceof RepositoryTreeNode)) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        try {
            switch (node.getType()) {
                case REPO: {
                    if (node.getParent() != null && node.getParent().getType() == RepositoryTreeNodeType.SUBMODULES) {
                        return this.getStyledTextForSubmodule(node);
                    }
                    return GitLabelProvider.getStyledTextFor((Repository)node.getObject());
                }
                case ADDITIONALREF: {
                    ObjectId refId;
                    Ref ref = (Ref)node.getObject();
                    StyledString refName = new StyledString(Repository.shortenRefName((String)ref.getName()));
                    if (ref.isSymbolic()) {
                        refName.append(' ');
                        refName.append('[', StyledString.DECORATIONS_STYLER);
                        refName.append(ref.getLeaf().getName(), StyledString.DECORATIONS_STYLER);
                        refName.append(']', StyledString.DECORATIONS_STYLER);
                        refId = ref.getLeaf().getObjectId();
                    } else {
                        refId = ref.getObjectId();
                    }
                    refName.append(' ');
                    RevCommit commit = this.getLatestCommit(node);
                    if (commit != null) {
                        refName.append(this.abbreviate((ObjectId)commit), StyledString.QUALIFIER_STYLER).append(' ').append(commit.getShortMessage(), StyledString.QUALIFIER_STYLER);
                    } else {
                        refName.append(this.abbreviate(refId), StyledString.QUALIFIER_STYLER);
                    }
                    return refName;
                }
                case WORKINGDIR: {
                    StyledString dirString = new StyledString(UIText.RepositoriesView_WorkingDir_treenode);
                    dirString.append(" - ", StyledString.QUALIFIER_STYLER);
                    dirString.append(node.getRepository().getWorkTree().getAbsolutePath(), StyledString.QUALIFIER_STYLER);
                    return dirString;
                }
                case REF: {
                    StyledString styled = null;
                    String nodeText = this.getSimpleText(node);
                    if (nodeText != null) {
                        RevCommit latest;
                        styled = new StyledString(nodeText);
                        if (this.verboseBranchMode && (latest = this.getLatestCommit(node)) != null) {
                            styled.append(' ').append(this.abbreviate((ObjectId)latest), StyledString.QUALIFIER_STYLER).append(' ').append(latest.getShortMessage(), StyledString.QUALIFIER_STYLER);
                        }
                    }
                    return styled;
                }
                case TAG: {
                    return this.getStyledTextForTag((TagNode)node);
                }
                case STASHED_COMMIT: {
                    return this.getStyledTextForCommit((StashedCommitNode)node);
                }
                case BRANCHES: 
                case LOCAL: 
                case BRANCHHIERARCHY: 
                case REMOTETRACKING: 
                case TAGS: 
                case ADDITIONALREFS: 
                case FILE: 
                case FOLDER: 
                case REMOTES: 
                case REMOTE: 
                case FETCH: 
                case PUSH: 
                case SUBMODULES: 
                case STASH: 
                case ERROR: {
                    String label = this.getSimpleText(node);
                    if (label != null) {
                        return new StyledString(label);
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private StyledString getStyledTextForTag(TagNode node) {
        String tagText = this.getSimpleText(node);
        if (tagText != null) {
            StyledString styled = new StyledString(tagText);
            if (this.verboseBranchMode && node.getCommitId() != null && node.getCommitId().length() > 0) {
                styled.append(' ').append(node.getCommitId().substring(0, 7), StyledString.QUALIFIER_STYLER).append(' ').append(node.getCommitShortMessage(), StyledString.QUALIFIER_STYLER);
            }
            return styled;
        }
        return null;
    }

    public String getToolTipText(Object element) {
        if (element instanceof AdditionalRefNode) {
            AdditionalRefNode additionalRefNode = (AdditionalRefNode)element;
            Ref ref = (Ref)additionalRefNode.getObject();
            return GitLabelProvider.getRefDescription(ref);
        }
        return null;
    }

    private String getSimpleText(RepositoryTreeNode node) {
        switch (node.getType()) {
            case REPO: {
                Repository repository = (Repository)node.getObject();
                return GitLabelProvider.getSimpleTextFor(repository);
            }
            case FILE: 
            case FOLDER: {
                return ((File)node.getObject()).getName();
            }
            case BRANCHES: {
                return UIText.RepositoriesView_Branches_Nodetext;
            }
            case LOCAL: {
                return UIText.RepositoriesViewLabelProvider_LocalNodetext;
            }
            case REMOTETRACKING: {
                return UIText.RepositoriesViewLabelProvider_RemoteTrackingNodetext;
            }
            case BRANCHHIERARCHY: {
                IPath fullPath = (IPath)node.getObject();
                return fullPath.lastSegment();
            }
            case TAGS: {
                return UIText.RepositoriesViewLabelProvider_TagsNodeText;
            }
            case ADDITIONALREFS: {
                return UIText.RepositoriesViewLabelProvider_SymbolicRefNodeText;
            }
            case REMOTES: {
                return UIText.RepositoriesView_RemotesNodeText;
            }
            case SUBMODULES: {
                return UIText.RepositoriesViewLabelProvider_SubmodulesNodeText;
            }
            case STASH: {
                return UIText.RepositoriesViewLabelProvider_StashNodeText;
            }
            case STASHED_COMMIT: {
                return MessageFormat.format("{0}@'{'{1}'}'", "stash", ((StashedCommitNode)node).getIndex());
            }
            case REF: 
            case TAG: {
                Ref ref = (Ref)node.getObject();
                String refName = Repository.shortenRefName((String)ref.getName());
                if (node.getParent().getType() == RepositoryTreeNodeType.BRANCHHIERARCHY) {
                    int index = refName.lastIndexOf(47);
                    refName = refName.substring(index + 1);
                }
                return refName;
            }
            case ADDITIONALREF: {
                Ref ref = (Ref)node.getObject();
                String refName = Repository.shortenRefName((String)ref.getName());
                refName = ref.isSymbolic() ? String.valueOf(refName) + " - " + ref.getLeaf().getName() + " - " + ObjectId.toString((ObjectId)ref.getLeaf().getObjectId()) : String.valueOf(refName) + " - " + ObjectId.toString((ObjectId)ref.getObjectId());
                return refName;
            }
            case WORKINGDIR: {
                return String.valueOf(UIText.RepositoriesView_WorkingDir_treenode) + " - " + node.getRepository().getWorkTree().getAbsolutePath();
            }
            case REMOTE: 
            case FETCH: 
            case PUSH: 
            case ERROR: {
                return (String)node.getObject();
            }
        }
        return null;
    }

    public void handleStateChange(State state, Object oldValue) {
        try {
            this.verboseBranchMode = (Boolean)state.getValue();
        }
        catch (Exception e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
    }
}

