/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferencesMapper
implements IPreferenceStore {
    private Preferences preferences = null;
    private boolean listening = true;
    private Map listeners = new HashMap();

    public PreferencesMapper(Preferences preferences) {
        this.preferences = preferences;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.listeners.containsKey(listener)) {
            MyPropertyChangeListener l = new MyPropertyChangeListener(listener);
            this.listeners.put(listener, l);
            this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)l);
        }
    }

    public boolean contains(String name) {
        return this.preferences.contains(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        for (IPropertyChangeListener listener : this.listeners.keySet()) {
            PropertyChangeEvent e = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            listener.propertyChange(e);
        }
    }

    public boolean getBoolean(String name) {
        return this.preferences.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.preferences.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.preferences.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.preferences.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.preferences.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.preferences.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.preferences.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.preferences.getDouble(name);
    }

    public float getFloat(String name) {
        return this.preferences.getFloat(name);
    }

    public int getInt(String name) {
        return this.preferences.getInt(name);
    }

    public long getLong(String name) {
        return this.preferences.getLong(name);
    }

    public String getString(String name) {
        return null;
    }

    public boolean isDefault(String name) {
        return this.preferences.isDefault(name);
    }

    public boolean needsSaving() {
        return this.preferences.needsSaving();
    }

    public void putValue(String name, String value) {
        this.listening = false;
        this.preferences.setValue(name, value);
        this.listening = true;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        Object candidate = this.listeners.get(listener);
        if (candidate instanceof MyPropertyChangeListener) {
            MyPropertyChangeListener l = (MyPropertyChangeListener)candidate;
            this.preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)l);
        }
        this.listeners.remove(listener);
    }

    public void setDefault(String name, double value) {
        this.preferences.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.preferences.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.preferences.setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.preferences.setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.preferences.setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.preferences.setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.preferences.setToDefault(name);
    }

    public void setValue(String name, double value) {
        this.preferences.setValue(name, value);
    }

    public void setValue(String name, float value) {
        this.preferences.setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.preferences.setValue(name, value);
    }

    public void setValue(String name, long value) {
        this.preferences.setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.preferences.setValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.preferences.setValue(name, value);
    }

    private class MyPropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        private IPropertyChangeListener containedListener = null;

        public MyPropertyChangeListener(IPropertyChangeListener containedListener) {
            this.containedListener = containedListener;
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (PreferencesMapper.this.listening) {
                String property = event.getProperty();
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                PropertyChangeEvent newEvent = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
                this.containedListener.propertyChange(newEvent);
            }
        }
    }
}

