/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInheritance;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StyledString;

public class CElementLabelComposer {
    private static final StyledString.Styler QUALIFIER_STYLE = StyledString.QUALIFIER_STYLER;
    private static final StyledString.Styler DECORATIONS_STYLE = StyledString.DECORATIONS_STYLER;
    private final FlexibleBuffer fBuffer;

    public CElementLabelComposer(FlexibleBuffer buffer) {
        this.fBuffer = buffer;
    }

    public CElementLabelComposer(StyledString buffer) {
        this(new FlexibleStyledString(buffer));
    }

    public CElementLabelComposer(StringBuilder buffer) {
        this(new FlexibleStringBuffer(buffer));
    }

    public void appendElementLabel(ICElement element, long flags) {
        int type = element.getElementType();
        ISourceRoot root = null;
        if (!(type == 10 || type == 11 || type == 12 && element instanceof ISourceRoot)) {
            root = CElementLabelComposer.getSourceRoot(element);
        }
        if (root != null && CElementLabelComposer.getFlag(flags, 0x10000000L)) {
            this.getSourceRootLabel(root, 0x2000000L);
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
        }
        switch (type) {
            case 79: {
                this.appendMacroLabel((IMacro)element, flags);
                break;
            }
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                this.appendMethodLabel((IMethodDeclaration)element, flags);
                break;
            }
            case 73: 
            case 74: 
            case 88: 
            case 89: {
                this.appendFunctionLabel((IFunctionDeclaration)element, flags);
                break;
            }
            case 72: {
                this.appendFieldLabel((IField)element, flags);
                break;
            }
            case 76: 
            case 77: {
                this.appendVariableLabel((IVariableDeclaration)element, flags);
                break;
            }
            case 81: {
                this.appendEnumeratorLabel((IEnumerator)element, flags);
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                this.appendTypeLabel(element, flags);
                break;
            }
            case 80: {
                this.appendTypeDefLabel((ITypeDef)element, flags);
                break;
            }
            case 60: {
                this.appendTranslationUnitLabel((ITranslationUnit)element, flags);
                break;
            }
            case 12: {
                ICContainer container = (ICContainer)element;
                if (container instanceof ISourceRoot) {
                    this.getSourceRootLabel((ISourceRoot)container, flags);
                    break;
                }
                this.appendContainerLabel(container, flags);
                break;
            }
            case 10: 
            case 11: {
                this.fBuffer.append(element.getElementName());
                break;
            }
            default: {
                this.fBuffer.append(element.getElementName());
            }
        }
        if (root != null && CElementLabelComposer.getFlag(flags, 0x8000000L)) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.getSourceRootLabel(root, 0x2000000L);
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
        if (element instanceof IBinary) {
            IBinary bin = (IBinary)element;
            this.fBuffer.append(" - [" + bin.getCPU() + "/" + (bin.isLittleEndian() ? "le" : "be") + "]");
        }
    }

    public void appendMacroLabel(IMacro macro, long flags) {
        IPath path;
        this.fBuffer.append(macro.getElementName());
        if (CElementLabelComposer.getFlag(flags, 1L) && macro.isFunctionStyle()) {
            this.fBuffer.append("()");
        }
        if (CElementLabelComposer.getFlag(flags, 0x80000000L) && (path = macro.getPath()) != null) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.fBuffer.append(path.toString());
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendMethodLabel(IMethodDeclaration method, long flags) {
        try {
            IPath path;
            int offset;
            String typeName;
            int i;
            String[] types;
            ICElement parent;
            if (CElementLabelComposer.getFlag(flags, 16L) && method.exists() && !method.isConstructor()) {
                this.fBuffer.append(method.getReturnType());
                this.fBuffer.append(' ');
            }
            if (CElementLabelComposer.getFlag(flags, 32L) && (parent = method.getParent()) != null && parent.exists() && !(parent instanceof ITranslationUnit)) {
                this.appendTypeLabel(parent, 0x2000L | flags & 0x4000L);
                this.fBuffer.append("::");
            }
            if (CElementLabelComposer.getFlag(flags, 2L)) {
                this.fBuffer.append(CElementLabelComposer.getSimpleName(method.getElementName()));
            } else {
                this.fBuffer.append(method.getElementName());
            }
            if (method instanceof ITemplate) {
                this.appendTemplateParameters((ITemplate)method, flags);
            }
            if (CElementLabelComposer.getFlag(flags, 1L)) {
                this.fBuffer.append('(');
                types = method.getParameterTypes();
                if (types != null) {
                    i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            this.fBuffer.append(CElementLabels.COMMA_STRING);
                        }
                        this.fBuffer.append(types[i]);
                        ++i;
                    }
                }
                this.fBuffer.append(')');
            }
            if (CElementLabelComposer.getFlag(flags, 4L) && method.exists() && (types = method.getExceptions()).length > 0) {
                this.fBuffer.append(" throw (");
                i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        this.fBuffer.append(CElementLabels.COMMA_STRING);
                    }
                    this.fBuffer.append(types[i]);
                    ++i;
                }
                this.fBuffer.append(")");
            }
            if (CElementLabelComposer.getFlag(flags, 8L) && method.exists() && !method.isConstructor() && !method.isDestructor() && (typeName = method.getReturnType()) != null && typeName.length() > 0) {
                offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.DECL_STRING);
                this.fBuffer.append(typeName);
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (CElementLabelComposer.getFlag(flags, 64L)) {
                int offset2 = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.CONCAT_STRING);
                this.appendTypeLabel(method.getParent(), 0x2000L | flags & 0x4000L);
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset2, this.fBuffer.length() - offset2, QUALIFIER_STYLE);
                }
            }
            if (CElementLabelComposer.getFlag(flags, 0x80000000L) && (path = method.getPath()) != null) {
                offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.CONCAT_STRING);
                this.fBuffer.append(path.toString());
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
    }

    private static String getSimpleName(String elementName) {
        int idx = elementName.lastIndexOf("::");
        if (idx >= 0) {
            return elementName.substring(idx + 2);
        }
        return elementName;
    }

    private void appendTemplateParameters(ITemplate template, long flags) {
        String[] args = null;
        if (CElementLabelComposer.getFlag(flags, 16384L)) {
            args = template.getTemplateArguments();
        } else if (CElementLabelComposer.getFlag(flags, 128L)) {
            args = template.getTemplateParameterTypes();
        } else {
            return;
        }
        this.fBuffer.append('<');
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    this.fBuffer.append(',');
                }
                this.fBuffer.append(args[i]);
                ++i;
            }
        }
        this.fBuffer.append('>');
    }

    public void appendFieldLabel(IField field, long flags) {
        try {
            IPath path;
            ICElement parent;
            if (CElementLabelComposer.getFlag(flags, 1024L) && field.exists()) {
                this.fBuffer.append(field.getTypeName());
                this.fBuffer.append(' ');
            }
            if (CElementLabelComposer.getFlag(flags, 2048L) && (parent = field.getParent()) != null && parent.exists()) {
                this.appendTypeLabel(parent, 0x2000L | flags & 0x80L);
                this.fBuffer.append("::");
            }
            if (CElementLabelComposer.getFlag(flags, 256L)) {
                this.fBuffer.append(CElementLabelComposer.getSimpleName(field.getElementName()));
            } else {
                this.fBuffer.append(field.getElementName());
            }
            if (CElementLabelComposer.getFlag(flags, 512L) && field.exists()) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.DECL_STRING);
                this.fBuffer.append(field.getTypeName());
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (CElementLabelComposer.getFlag(flags, 4096L)) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.CONCAT_STRING);
                this.appendTypeLabel(field.getParent(), 0x2000L | flags & 0x80L);
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            }
            if (CElementLabelComposer.getFlag(flags, 0x80000000L) && (path = field.getPath()) != null) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.CONCAT_STRING);
                this.fBuffer.append(path.toString());
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
    }

    public void appendVariableLabel(IVariableDeclaration var, long flags) {
        try {
            ICElement parent;
            if (CElementLabelComposer.getFlag(flags, 1024L) && var.exists()) {
                this.fBuffer.append(var.getTypeName());
                this.fBuffer.append(' ');
            }
            if (CElementLabelComposer.getFlag(flags, 2048L) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
                this.appendTypeLabel(parent, 8192L);
                this.fBuffer.append("::");
            }
            this.fBuffer.append(var.getElementName());
            if (CElementLabelComposer.getFlag(flags, 512L) && var.exists()) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.DECL_STRING);
                this.fBuffer.append(var.getTypeName());
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (CElementLabelComposer.getFlag(flags, 4096L) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
                int offset = this.fBuffer.length();
                this.fBuffer.append(CElementLabels.CONCAT_STRING);
                this.appendTypeLabel(var.getParent(), 8192L);
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (CElementLabelComposer.getFlag(flags, 0x80000000L)) {
                int offset = this.fBuffer.length();
                IPath path = var.getPath();
                if (path != null) {
                    this.fBuffer.append(CElementLabels.CONCAT_STRING);
                    this.fBuffer.append(path.toString());
                }
                if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
    }

    public void appendEnumeratorLabel(IEnumerator var, long flags) {
        ICElement parent;
        if (CElementLabelComposer.getFlag(flags, 2048L) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            this.appendTypeLabel(parent, 8192L);
            this.fBuffer.append("::");
        }
        this.fBuffer.append(var.getElementName());
        if (CElementLabelComposer.getFlag(flags, 4096L) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.appendTypeLabel(var.getParent(), 8192L);
        }
        if (CElementLabelComposer.getFlag(flags, 0x80000000L)) {
            int offset = this.fBuffer.length();
            IPath path = var.getPath();
            if (path != null) {
                this.fBuffer.append(CElementLabels.CONCAT_STRING);
                this.fBuffer.append(path.toString());
            }
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendFunctionLabel(IFunctionDeclaration func, long flags) {
        IPath path;
        int offset;
        String typeName;
        int i;
        String[] types;
        ICElement parent;
        if (CElementLabelComposer.getFlag(flags, 16L) && func.exists()) {
            this.fBuffer.append(func.getReturnType());
            this.fBuffer.append(' ');
        }
        if (CElementLabelComposer.getFlag(flags, 32L) && (parent = func.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            this.appendTypeLabel(parent, 8192L);
            this.fBuffer.append("::");
        }
        this.fBuffer.append(func.getElementName());
        if (func instanceof ITemplate) {
            this.appendTemplateParameters((ITemplate)func, flags);
        }
        if (CElementLabelComposer.getFlag(flags, 1L)) {
            this.fBuffer.append('(');
            types = func.getParameterTypes();
            if (types != null) {
                i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        this.fBuffer.append(CElementLabels.COMMA_STRING);
                    }
                    this.fBuffer.append(types[i]);
                    ++i;
                }
            }
            this.fBuffer.append(')');
        }
        if (CElementLabelComposer.getFlag(flags, 4L) && func.exists() && (types = func.getExceptions()).length > 0) {
            this.fBuffer.append(" throw (");
            i = 0;
            while (i < types.length) {
                if (i > 0) {
                    this.fBuffer.append(CElementLabels.COMMA_STRING);
                }
                this.fBuffer.append(types[i]);
                ++i;
            }
            this.fBuffer.append(")");
        }
        if (CElementLabelComposer.getFlag(flags, 8L) && func.exists() && (typeName = func.getReturnType()) != null && typeName.length() > 0) {
            offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.DECL_STRING);
            this.fBuffer.append(typeName);
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
            }
        }
        if (CElementLabelComposer.getFlag(flags, 64L) && (parent = func.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.appendTypeLabel(func.getParent(), 8192L);
        }
        if (CElementLabelComposer.getFlag(flags, 0x80000000L) && (path = func.getPath()) != null) {
            offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.fBuffer.append(path.toString());
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void appendTypeDefLabel(ITypeDef typedef, long flags) {
        IPath path;
        int offset;
        String typeName;
        ICElement parent;
        if (CElementLabelComposer.getFlag(flags, 1024L) && typedef.exists()) {
            this.fBuffer.append(typedef.getTypeName());
            this.fBuffer.append(' ');
        }
        if (CElementLabelComposer.getFlag(flags, 2048L) && (parent = typedef.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            this.appendTypeLabel(parent, 8192L);
            this.fBuffer.append("::");
        }
        this.fBuffer.append(typedef.getElementName());
        if (CElementLabelComposer.getFlag(flags, 512L) && typedef.exists() && (typeName = typedef.getTypeName()) != null && typeName.length() > 0) {
            offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.DECL_STRING);
            this.fBuffer.append(typeName);
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, DECORATIONS_STYLE);
            }
        }
        if (CElementLabelComposer.getFlag(flags, 4096L) && (parent = typedef.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.appendTypeLabel(typedef.getParent(), 8192L);
        }
        if (CElementLabelComposer.getFlag(flags, 0x80000000L) && (path = typedef.getPath()) != null) {
            offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.fBuffer.append(path.toString());
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public void getSourceRootLabel(ISourceRoot root, long flags) {
        this.appendFolderLabel((ICContainer)root, flags);
    }

    public void appendContainerLabel(ICContainer container, long flags) {
        this.appendFolderLabel(container, flags);
    }

    private void appendFolderLabel(ICContainer container, long flags) {
        IResource resource = container.getResource();
        boolean rootQualified = CElementLabelComposer.getFlag(flags, 0x2000000L);
        if (rootQualified) {
            this.fBuffer.append(container.getPath().makeRelative().toString());
        } else {
            if (CCorePlugin.showSourceRootsAtTopOfProject()) {
                this.fBuffer.append(container.getElementName());
            } else {
                String elementName = container.getElementName();
                Path path = new Path(elementName);
                this.fBuffer.append(path.lastSegment());
            }
            if (CElementLabelComposer.getFlag(flags, 0x2000000L)) {
                if (resource != null && container instanceof ISourceRoot && CElementLabelComposer.isReferenced((ISourceRoot)container)) {
                    this.fBuffer.append(CElementLabels.CONCAT_STRING);
                    this.fBuffer.append(resource.getProject().getName());
                } else {
                    this.fBuffer.append(CElementLabels.CONCAT_STRING);
                    this.fBuffer.append(container.getParent().getElementName());
                }
            }
        }
    }

    public void appendTranslationUnitLabel(ITranslationUnit tu, long flags) {
        IResource r = tu.getResource();
        IPath path = r != null ? r.getFullPath().makeRelative() : tu.getPath();
        if (path == null) {
            this.fBuffer.append(tu.getElementName());
        } else if (CElementLabelComposer.getFlag(flags, 0x100000L)) {
            this.fBuffer.append(path.toString());
        } else if (CElementLabelComposer.getFlag(flags, 0x200000L)) {
            this.fBuffer.append(path.lastSegment());
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.fBuffer.append(path.removeLastSegments(1).toString());
        } else {
            this.fBuffer.append(path.lastSegment());
        }
    }

    private void appendTypeLabel(ICElement elem, long flags) {
        IPath path;
        IInheritance inheritance;
        String[] superclassNames;
        String typeName;
        if (CElementLabelComposer.getFlag(flags, 8192L)) {
            ICElement parent = elem.getParent();
            boolean isQualifier = true;
            if (parent != null) {
                switch (parent.getElementType()) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 18: 
                    case 30: 
                    case 60: {
                        isQualifier = false;
                    }
                }
            }
            if (isQualifier && !CElementLabelComposer.isCLanguage(parent)) {
                long qflags = flags & 0xFFFFFFFF7FFFFFFFL;
                this.appendTypeLabel(parent, qflags);
                this.fBuffer.append("::");
            }
        }
        if ((typeName = elem.getElementName()).length() == 0) {
            typeName = CoreModelMessages.getString((String)"CElementLabels.anonymous");
        }
        this.fBuffer.append(typeName);
        if (CElementLabelComposer.getFlag(flags, 65536L) && elem instanceof IInheritance && (superclassNames = (inheritance = (IInheritance)elem).getSuperClassesNames()) != null && superclassNames.length > 0) {
            this.fBuffer.append(CElementLabels.DECL_STRING);
            int i = 0;
            while (i < superclassNames.length) {
                if (i > 0) {
                    this.fBuffer.append(CElementLabels.COMMA_STRING);
                }
                String superclass = superclassNames[i];
                String visibility = CElementLabelComposer.getVisibility(inheritance.getSuperClassAccess(superclass));
                this.fBuffer.append(visibility).append(' ').append(superclass);
                ++i;
            }
        }
        if (elem instanceof ITemplate) {
            this.appendTemplateParameters((ITemplate)elem, flags);
        }
        if (CElementLabelComposer.getFlag(flags, 0x80000000L) && (path = elem.getPath()) != null) {
            int offset = this.fBuffer.length();
            this.fBuffer.append(CElementLabels.CONCAT_STRING);
            this.fBuffer.append(path.toString());
            if (CElementLabelComposer.getFlag(flags, 0x100000000L)) {
                this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static boolean isCLanguage(ICElement elem) {
        while (elem != null) {
            if (!((elem = elem.getParent()) instanceof ITranslationUnit)) continue;
            return ((ITranslationUnit)elem).isCLanguage();
        }
        return false;
    }

    private static String getVisibility(ASTAccessVisibility access) {
        if (access == ASTAccessVisibility.PUBLIC) {
            return "public";
        }
        if (access == ASTAccessVisibility.PROTECTED) {
            return "protected";
        }
        return "private";
    }

    private static boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static ISourceRoot getSourceRoot(ICElement element) {
        ICElement root = element;
        while (root != null) {
            if (root instanceof ISourceRoot) {
                return (ISourceRoot)root;
            }
            ICElement parent = root.getAncestor(12);
            if (parent == root) {
                return null;
            }
            root = parent;
        }
        return null;
    }

    public static boolean isReferenced(ISourceRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            IProject container = root.getCProject().getProject();
            return !container.equals((Object)project);
        }
        return false;
    }

    public static abstract class FlexibleBuffer {
        public abstract FlexibleBuffer append(char var1);

        public abstract FlexibleBuffer append(String var1);

        public abstract int length();

        public abstract void setStyle(int var1, int var2, StyledString.Styler var3);
    }

    public static class FlexibleStringBuffer
    extends FlexibleBuffer {
        private final StringBuilder fStringBuilder;

        public FlexibleStringBuffer(StringBuilder stringBuilder) {
            this.fStringBuilder = stringBuilder;
        }

        @Override
        public FlexibleBuffer append(char ch) {
            this.fStringBuilder.append(ch);
            return this;
        }

        @Override
        public FlexibleBuffer append(String string) {
            this.fStringBuilder.append(string);
            return this;
        }

        @Override
        public int length() {
            return this.fStringBuilder.length();
        }

        @Override
        public void setStyle(int offset, int length, StyledString.Styler styler) {
        }

        public String toString() {
            return this.fStringBuilder.toString();
        }
    }

    public static class FlexibleStyledString
    extends FlexibleBuffer {
        private final StyledString fStyledString;

        public FlexibleStyledString(StyledString stringBuffer) {
            this.fStyledString = stringBuffer;
        }

        @Override
        public FlexibleBuffer append(char ch) {
            this.fStyledString.append(ch);
            return this;
        }

        @Override
        public FlexibleBuffer append(String string) {
            this.fStyledString.append(string);
            return this;
        }

        @Override
        public int length() {
            return this.fStyledString.length();
        }

        @Override
        public void setStyle(int offset, int length, StyledString.Styler styler) {
            this.fStyledString.setStyle(offset, length, styler);
        }

        public String toString() {
            return this.fStyledString.toString();
        }
    }
}

