/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.InstructionExecutionResultGraphicFactory;
import com.nvidia.viper.jni.NativeDemangler;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.HashMap;
import java.util.Map;

public class AnalysisResultInstructionExecution
extends AnalysisResultSourceLevel {
    private Map<String, Integer> functionIdMap;
    private Map<String, Integer> fileLineMap;
    private long totalInstExecuted = 0L;
    private long totalNonPredThreadInstExecuted = 0L;
    private long totalThreadInstExecuted = 0L;
    private int maxInstExecuted = 0;
    private int count = 0;
    private boolean initialize = false;

    public AnalysisResultInstructionExecution(Session session, ITimelineInterval interval, AnalysisDescriptor desc) {
        super(session, interval, desc);
    }

    @Override
    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        return "";
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new InstructionExecutionResultGraphicFactory();
    }

    private void initAnalysisSummary(Session activeSession) {
        if (this.initialize) {
            return;
        }
        this.functionIdMap = new HashMap<String, Integer>();
        this.fileLineMap = new HashMap<String, Integer>();
        this.count = 0;
        for (ICuptiActivitySourceLevelResult result : this.getSourceLevelResults()) {
            CuptiActivityFunction function;
            if (!(result instanceof CuptiActivityInstructionExecution)) continue;
            CuptiActivityInstructionExecution instExec = (CuptiActivityInstructionExecution)result;
            CuptiActivitySourceLocator locator = activeSession.getSourceLocator().getLocation(instExec.getSourceLocatorId());
            if (locator != null) {
                String fileName = locator.fileName;
                int lineNumber = locator.lineNumber;
                if (!this.fileLineMap.containsKey(fileName)) {
                    this.fileLineMap.put(fileName, lineNumber);
                } else if (lineNumber < this.fileLineMap.get(fileName)) {
                    this.fileLineMap.put(fileName, lineNumber);
                }
            }
            if ((function = activeSession.getCudaFunctionManager().getFunction(instExec.functionId)) != null) {
                String funcName = NativeDemangler.demangle(function.name);
                if (funcName == null) {
                    funcName = function.name;
                }
                if (!this.functionIdMap.containsKey(funcName)) {
                    this.functionIdMap.put(funcName, function.id);
                }
            }
            if (instExec.executed > this.maxInstExecuted) {
                this.maxInstExecuted = instExec.executed;
            }
            this.totalInstExecuted += (long)instExec.executed;
            this.totalNonPredThreadInstExecuted += instExec.notPredOffThreadsExecuted;
            this.totalThreadInstExecuted += instExec.threadsExecuted;
            ++this.count;
        }
        this.initialize = true;
    }

    public double getWarpNonPredEfficiency(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalInstExecuted != 0L ? (double)this.totalNonPredThreadInstExecuted * 100.0 / (double)(this.totalInstExecuted * 32L) : 0.0;
    }

    public double getWarpEfficiency(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalInstExecuted != 0L ? (double)this.totalThreadInstExecuted * 100.0 / (double)(this.totalInstExecuted * 32L) : 0.0;
    }

    public String[] getFunctionNameList(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdMap != null) {
            return this.functionIdMap.keySet().toArray(new String[this.functionIdMap.size()]);
        }
        return null;
    }

    public String[] getSourceFileNameList(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileLineMap != null) {
            return this.fileLineMap.keySet().toArray(new String[this.fileLineMap.size()]);
        }
        return null;
    }

    public int getFunctionId(String function, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.functionIdMap != null) {
            return this.functionIdMap.get(function);
        }
        return 0;
    }

    public int getFileLineNumber(String function, Session activeSession) {
        this.initAnalysisSummary(activeSession);
        if (this.fileLineMap != null) {
            return this.fileLineMap.get(function);
        }
        return 0;
    }

    public int getMaxInstExecuted(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.maxInstExecuted;
    }

    public int getAvgInstCount(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return (int)(this.totalInstExecuted / (long)this.count);
    }

    public long getTotalInstExecuted(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalInstExecuted;
    }

    public long getTotalThreadInstExecuted(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalThreadInstExecuted;
    }

    public long getTotalNonPredThreadInstExecuted(Session activeSession) {
        this.initAnalysisSummary(activeSession);
        return this.totalNonPredThreadInstExecuted;
    }

    @Override
    public AnalysisResultSourceLevelKind getAnalysisResultSourceLevelKind() {
        return AnalysisResultSourceLevelKind.INSTRUCTION_EXECUTION_KIND;
    }
}

