/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.debug.internal.core.breakpoints.CEventBreakpoint;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.events.MICatchpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.gdb.internal.eventbkpts.GdbCatchpoints;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;

@Immutable
public class MIBreakpointHitEvent
extends MIStoppedEvent {
    int bkptno;

    protected MIBreakpointHitEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, int bkptno) {
        super(ctx, token, results, frame);
        this.bkptno = bkptno;
    }

    public int getNumber() {
        return this.bkptno;
    }

    @ConfinedToDsfExecutor(value="")
    public static MIBreakpointHitEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        int bkptno;
        block12: {
            bkptno = -1;
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("bkptno")) {
                    try {
                        bkptno = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
            IBreakpoints.IBreakpointsTargetDMContext bpsTarget = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
            if (bpsTarget != null) {
                MIBreakpoints.MIBreakpointDMContext bkpt = new MIBreakpoints.MIBreakpointDMContext(dmc.getSessionId(), new IDMContext[]{bpsTarget}, bkptno);
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), dmc.getSessionId());
                try {
                    IBreakpoint platformBkpt;
                    MIBreakpointsManager bkptMgr = (MIBreakpointsManager)((Object)tracker.getService(MIBreakpointsManager.class));
                    if (bkptMgr == null || !((platformBkpt = bkptMgr.findPlatformBreakpoint(bkpt)) instanceof CEventBreakpoint)) break block12;
                    try {
                        String eventTypeID = ((CEventBreakpoint)platformBkpt).getEventType();
                        String gdbKeyword = GdbCatchpoints.eventToGdbCatchpointKeyword((String)eventTypeID);
                        MICatchpointHitEvent mICatchpointHitEvent = MICatchpointHitEvent.parse(dmc, token, results, bkptno, gdbKeyword);
                        return mICatchpointHitEvent;
                    }
                    catch (DebugException debugException) {
                    }
                }
                finally {
                    tracker.dispose();
                }
            }
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MIBreakpointHitEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), bkptno);
    }

    public static /* bridge */ /* synthetic */ MIStoppedEvent parse(IRunControl.IExecutionDMContext iExecutionDMContext, int n, MIResult[] mIResultArray) {
        return MIBreakpointHitEvent.parse(iExecutionDMContext, n, mIResultArray);
    }
}

