/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.core.text;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.core.text.TextSearchVisitor;
import org.eclipse.search.internal.ui.SearchPlugin;

public abstract class TextSearchEngine {
    public static TextSearchEngine create() {
        return SearchPlugin.getDefault().getTextSearchEngineRegistry().getPreferred();
    }

    public static TextSearchEngine createDefault() {
        return new TextSearchEngine(){

            public IStatus search(TextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
                return new TextSearchVisitor(requestor, searchPattern).search(scope, monitor);
            }

            public IStatus search(IFile[] scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
                return new TextSearchVisitor(requestor, searchPattern).search(scope, monitor);
            }
        };
    }

    public abstract IStatus search(TextSearchScope var1, TextSearchRequestor var2, Pattern var3, IProgressMonitor var4);

    public abstract IStatus search(IFile[] var1, TextSearchRequestor var2, Pattern var3, IProgressMonitor var4);

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegex) throws PatternSyntaxException {
        return PatternConstructor.createPattern(pattern, isRegex, true, isCaseSensitive, false);
    }
}

