/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpoints;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.ICWatchpointTarget;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.internal.core.ICWatchpointTarget;
import org.eclipse.cdt.debug.internal.core.model.CMemoryBlockExtension;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.EnableDisableBreakpointRulerAction;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointContext;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public abstract class AbstractToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension2,
IToggleBreakpointsTargetCExtension {
    public boolean canToggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
        if (event != null && (event.stateMask & SWT.MOD2) > 0) {
            if (this.toggleBreakpointEnable(part)) {
                return;
            }
        } else {
            boolean interactive = event != null && (event.stateMask & SWT.MOD1) > 0;
            this.updateBreakpoints(true, interactive, part, selection);
        }
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.updateLineBreakpoints(true, false, part, selection);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ICElement element = this.getCElementFromSelection(part, selection);
        if (element instanceof IFunction || element instanceof IMethod) {
            this.updateMethodBreakpoints(true, false, part, (IDeclaration)element);
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        ICElement element = this.getCElementFromSelection(part, selection);
        return element instanceof IFunction || element instanceof IMethod;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IRepositionableMemoryRendering rendering;
        IVariable variable = this.getVariableFromSelection(part, selection);
        if (variable != null) {
            this.updateVariableWatchpoint(true, false, part, variable);
        }
        if ((rendering = this.getMemoryRendering(part, selection)) != null) {
            this.updateMemoryWatchpoint(true, false, part, rendering);
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return this.getVariableFromSelection(part, selection) != null || this.getMemoryRendering(part, selection) != null || this.getWatchpointTarget(part, selection) != null;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection) || this.canToggleWatchpoints(part, selection) || this.canToggleMethodBreakpoints(part, selection);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.updateBreakpoints(true, false, part, selection);
    }

    @Override
    public boolean canCreateLineBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection) && !this.hasBreakpoint(part);
    }

    @Override
    public void createLineBreakpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.updateLineBreakpoints(false, true, part, selection);
    }

    @Override
    public boolean canCreateWatchpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    @Override
    public void createWatchpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
        ICElement element = this.getCElementFromSelection(part, selection);
        if (element instanceof IVariable) {
            this.updateVariableWatchpoint(false, true, part, (IVariable)element);
            return;
        }
        IRepositionableMemoryRendering rendering = this.getMemoryRendering(part, selection);
        if (rendering != null) {
            this.updateMemoryWatchpoint(false, true, part, rendering);
            return;
        }
        org.eclipse.cdt.debug.core.ICWatchpointTarget watchpointTarget = this.getWatchpointTarget(part, selection);
        if (watchpointTarget != null) {
            this.updateTargetWatchpoint(false, true, part, watchpointTarget);
            return;
        }
        String text = "";
        if (selection instanceof ITextSelection) {
            text = ((ITextSelection)selection).getText();
        }
        this.createWatchpoint(true, part, null, (IResource)ResourcesPlugin.getWorkspace().getRoot(), -1, -1, -1, text, null, "0");
    }

    @Override
    public boolean canCreateEventBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    @Override
    public void createEventBreakpointsInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
        String type = "";
        String arg = "";
        this.createEventBreakpoint(true, part, (IResource)ResourcesPlugin.getWorkspace().getRoot(), type, arg);
    }

    @Override
    public boolean canCreateFunctionBreakpointInteractive(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    @Override
    public void createFunctionBreakpointInteractive(IWorkbenchPart part, ISelection selection) throws CoreException {
        ICElement element = this.getCElementFromSelection(part, selection);
        if (element instanceof IFunction || element instanceof IMethod) {
            this.updateMethodBreakpoints(false, true, part, (IDeclaration)element);
        } else {
            String text = "";
            if (selection instanceof ITextSelection) {
                text = ((ITextSelection)selection).getText();
            }
            this.createFunctionBreakpoint(true, part, null, (IResource)ResourcesPlugin.getWorkspace().getRoot(), text, -1, -1, -1);
        }
    }

    private boolean hasBreakpoint(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)textEditor.getAdapter(IVerticalRulerInfo.class);
            IBreakpoint breakpoint = CDebugUIUtils.getBreakpointFromEditor(textEditor, rulerInfo);
            return breakpoint != null;
        }
        return false;
    }

    private void updateBreakpoints(boolean toggle, boolean interactive, IWorkbenchPart part, ISelection selection) throws CoreException {
        if (this.canToggleLineBreakpoints(part, selection)) {
            this.updateLineBreakpoints(toggle, interactive, part, selection);
        } else {
            ICElement element = this.getCElementFromSelection(part, selection);
            if (element instanceof IFunction || element instanceof IMethod) {
                this.updateMethodBreakpoints(toggle, interactive, part, (IDeclaration)element);
            } else if (element instanceof IVariable) {
                this.updateVariableWatchpoint(toggle, interactive, part, (IVariable)element);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateLineBreakpoints(boolean toggle, boolean interactive, IWorkbenchPart part, ISelection selection) throws CoreException {
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_document_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IResource resource = AbstractToggleBreakpointAdapter.getResource((IWorkbenchPart)textEditor);
        if (resource == null) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Missing_resource_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        int lineNumber = ((ITextSelection)selection).getStartLine() + 1;
        if (lineNumber == -1) {
            errorMessage = ActionMessages.getString("ToggleBreakpointAdapter.Invalid_line_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        String sourceHandle = this.getSourceHandle(input);
        if (interactive && !toggle) {
            this.createLineBreakpoint(true, part, sourceHandle, resource, lineNumber);
            return;
        }
        ICLineBreakpoint breakpoint = this.findLineBreakpoint(sourceHandle, resource, lineNumber);
        if (breakpoint == null) {
            this.createLineBreakpoint(interactive, part, sourceHandle, resource, lineNumber);
            return;
        }
        if (interactive) {
            CDebugUIUtils.editBreakpointProperties(part, (ICBreakpoint)breakpoint);
            return;
        }
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
    }

    private void updateMethodBreakpoints(boolean toggle, boolean interactive, IWorkbenchPart part, IDeclaration declaration) throws CoreException {
        String sourceHandle = this.getSourceHandle(declaration);
        IResource resource = this.getElementResource(declaration);
        String functionName = declaration instanceof IFunction ? this.getFunctionName((IFunction)declaration) : this.getMethodName((IMethod)declaration);
        ICFunctionBreakpoint breakpoint = this.findFunctionBreakpoint(sourceHandle, resource, functionName);
        if (toggle && breakpoint != null) {
            if (interactive) {
                CDebugUIUtils.editBreakpointProperties(part, (ICBreakpoint)breakpoint);
            } else {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
            }
        } else {
            int lineNumber = -1;
            int charStart = -1;
            int charEnd = -1;
            try {
                ISourceRange sourceRange = declaration.getSourceRange();
                if (sourceRange != null) {
                    charStart = sourceRange.getStartPos();
                    charEnd = charStart + sourceRange.getLength();
                    if (charEnd <= 0) {
                        charStart = -1;
                        charEnd = -1;
                    }
                    lineNumber = sourceRange.getStartLine();
                }
            }
            catch (CModelException e) {
                DebugPlugin.log((Throwable)e);
            }
            this.createFunctionBreakpoint(interactive, part, sourceHandle, resource, functionName, charStart, charEnd, lineNumber);
        }
    }

    private void updateVariableWatchpoint(boolean toggle, boolean interactive, IWorkbenchPart part, IVariable variable) throws CoreException {
        String sourceHandle = this.getSourceHandle((IDeclaration)variable);
        IResource resource = this.getElementResource((IDeclaration)variable);
        String expression = this.getVariableName(variable);
        ICWatchpoint watchpoint = this.findWatchpoint(sourceHandle, resource, expression);
        if (toggle && watchpoint != null) {
            if (interactive) {
                CDebugUIUtils.editBreakpointProperties(part, (ICBreakpoint)watchpoint);
            } else {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)watchpoint, true);
            }
        } else {
            int lineNumber = -1;
            int charStart = -1;
            int charEnd = -1;
            try {
                ISourceRange sourceRange = variable.getSourceRange();
                if (sourceRange != null) {
                    charStart = sourceRange.getStartPos();
                    charEnd = charStart + sourceRange.getLength();
                    if (charEnd <= 0) {
                        charStart = -1;
                        charEnd = -1;
                    }
                    lineNumber = sourceRange.getStartLine();
                }
            }
            catch (CModelException e) {
                CDebugUIPlugin.log(e);
            }
            this.createWatchpoint(interactive, part, sourceHandle, resource, charStart, charEnd, lineNumber, expression, null, "0");
        }
    }

    private void updateMemoryWatchpoint(boolean toggle, boolean interactive, IWorkbenchPart part, IRepositionableMemoryRendering rendering) throws CoreException {
        int addressableSize = 1;
        IMemoryBlock memblock = rendering.getMemoryBlock();
        if (memblock instanceof IMemoryBlockExtension) {
            try {
                addressableSize = ((IMemoryBlockExtension)memblock).getAddressableSize();
            }
            catch (DebugException e) {
                CDebugUIPlugin.log(e);
            }
        }
        String memorySpace = this.getMemorySpace(rendering.getMemoryBlock(), null);
        String address = this.getSelectedAddress(rendering.getSelectedAddress(), "");
        String range = this.getRange(rendering.getSelectedAsBytes(), addressableSize, "1");
        this.createWatchpoint(interactive, part, "", (IResource)ResourcesPlugin.getWorkspace().getRoot(), -1, -1, -1, address, memorySpace, range);
    }

    private String getMemorySpace(IMemoryBlock memBlock, String def) {
        if (memBlock != null && memBlock instanceof CMemoryBlockExtension) {
            return ((CMemoryBlockExtension)memBlock).getMemorySpaceID();
        }
        return def;
    }

    private String getSelectedAddress(BigInteger selectedAddress, String def) {
        if (selectedAddress != null) {
            return "0x" + selectedAddress.toString(16);
        }
        return def;
    }

    private String getRange(MemoryByte[] selectedBytes, int addressableSize, String def) {
        if (selectedBytes != null && selectedBytes.length > 0) {
            return Integer.toString(selectedBytes.length / addressableSize);
        }
        return def;
    }

    private void updateTargetWatchpoint(boolean toggle, boolean interactive, IWorkbenchPart part, org.eclipse.cdt.debug.core.ICWatchpointTarget watchpointTarget) throws CoreException {
        String _expr = watchpointTarget.getExpression();
        if (_expr == null) {
            _expr = "";
        }
        String expr = _expr;
        class GetSizeRequest
        extends CRequest
        implements ICWatchpointTarget.GetSizeRequest {
            int fSize = -1;
            private final /* synthetic */ boolean val$interactive;
            private final /* synthetic */ IWorkbenchPart val$part;
            private final /* synthetic */ String val$expr;

            GetSizeRequest(boolean bl, IWorkbenchPart iWorkbenchPart, String string) {
                this.val$interactive = bl;
                this.val$part = iWorkbenchPart;
                this.val$expr = string;
            }

            public int getSize() {
                return this.fSize;
            }

            public void setSize(int size) {
                this.fSize = size;
            }

            public void done() {
                int _size = 0;
                if (this.isSuccess()) {
                    _size = this.getSize();
                    if (!$assertionsDisabled && _size <= 0) {
                        throw new AssertionError((Object)"unexpected variale/expression size");
                    }
                }
                final int size = _size;
                WorkbenchJob job = new WorkbenchJob("open watchpoint dialog"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            AbstractToggleBreakpointAdapter.this.createWatchpoint(val$interactive, val$part, "", (IResource)ResourcesPlugin.getWorkspace().getRoot(), -1, -1, -1, val$expr, null, Integer.toString(size));
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
        watchpointTarget.getSize((ICWatchpointTarget.GetSizeRequest)new GetSizeRequest(interactive, part, expr));
    }

    protected ICElement getCElementFromSelection(IWorkbenchPart part, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            String text = textSelection.getText();
            if (text != null) {
                if (part instanceof ITextEditor) {
                    ICElement editorElement = CDTUITools.getEditorInputCElement((IEditorInput)((ITextEditor)part).getEditorInput());
                    if (editorElement instanceof ITranslationUnit) {
                        ITranslationUnit tu = (ITranslationUnit)editorElement;
                        try {
                            if (tu.isStructureKnown() && tu.isConsistent()) {
                                return tu.getElementAtOffset(textSelection.getOffset());
                            }
                        }
                        catch (CModelException cModelException) {}
                    }
                } else {
                    ITranslationUnit tu;
                    IResource resource = AbstractToggleBreakpointAdapter.getResource(part);
                    if (resource instanceof IFile && (tu = this.getTranslationUnit((IFile)resource)) != null) {
                        try {
                            ICElement element = tu.getElement(text.trim());
                            if (element == null) {
                                element = tu.getElementAtLine(textSelection.getStartLine());
                            }
                            return element;
                        }
                        catch (CModelException cModelException) {}
                    }
                }
            }
        } else if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof ICElement) {
            return (ICElement)object;
        }
        return null;
    }

    protected IVariable getVariableFromSelection(IWorkbenchPart part, ISelection selection) {
        ICElement element = this.getCElementFromSelection(part, selection);
        if (element instanceof IVariable) {
            return (IVariable)element;
        }
        return null;
    }

    protected IRepositionableMemoryRendering getMemoryRendering(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IAdaptable) {
            return (IRepositionableMemoryRendering)((IAdaptable)obj).getAdapter(IRepositionableMemoryRendering.class);
        }
        return null;
    }

    protected org.eclipse.cdt.debug.core.ICWatchpointTarget getWatchpointTarget(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IAdaptable) {
            org.eclipse.cdt.debug.core.ICWatchpointTarget target = (org.eclipse.cdt.debug.core.ICWatchpointTarget)((IAdaptable)obj).getAdapter(org.eclipse.cdt.debug.core.ICWatchpointTarget.class);
            if (target == null) {
                target = (org.eclipse.cdt.debug.core.ICWatchpointTarget)((IAdaptable)obj).getAdapter(ICWatchpointTarget.class);
            }
            return target;
        }
        return null;
    }

    protected void report(String message, IWorkbenchPart part) {
        IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            if (message != null) {
                statusLine.setMessage(true, message, null);
            } else {
                statusLine.setMessage(true, null, null);
            }
        }
        if (message != null && CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected static IResource getResource(IWorkbenchPart part) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (part instanceof IEditorPart) {
            IFile[] files;
            IPath location;
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            IFile resource = null;
            if (editorInput instanceof IFileEditorInput) {
                resource = ((IFileEditorInput)editorInput).getFile();
            } else if (editorInput instanceof ExternalEditorInput) {
                resource = ((ExternalEditorInput)editorInput).getMarkerResource();
            }
            if (resource != null) {
                return resource;
            }
            ILocationProvider provider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
            if (provider != null && (location = provider.getPath((Object)editorInput)) != null && (files = root.findFilesForLocationURI(URIUtil.toURI((IPath)location))).length > 0 && files[0].isAccessible()) {
                return files[0];
            }
        }
        return root;
    }

    private String getSourceHandle(IEditorInput input) throws CoreException {
        return CDebugUIUtils.getEditorFilePath(input);
    }

    protected String getSourceHandle(IDeclaration declaration) {
        IPath location;
        ITranslationUnit tu = declaration.getTranslationUnit();
        if (tu != null && (location = tu.getLocation()) != null) {
            return location.toOSString();
        }
        return "";
    }

    protected IResource getElementResource(IDeclaration declaration) {
        return declaration.getUnderlyingResource();
    }

    private String getFunctionName(IFunction function) {
        String functionName = function.getElementName();
        StringBuffer name = new StringBuffer(functionName);
        ITranslationUnit tu = function.getTranslationUnit();
        if (tu != null && tu.isCXXLanguage()) {
            this.appendParameters(name, (IFunctionDeclaration)function);
        }
        return name.toString();
    }

    private String getMethodName(IMethod method) {
        StringBuffer name = new StringBuffer();
        String methodName = method.getElementName();
        ICElement parent = method.getParent();
        while (parent != null && (parent.getElementType() == 61 || parent.getElementType() == 65 || parent.getElementType() == 67 || parent.getElementType() == 69)) {
            name.append(parent.getElementName()).append("::");
            parent = parent.getParent();
        }
        name.append(methodName);
        this.appendParameters(name, (IFunctionDeclaration)method);
        return name.toString();
    }

    private void appendParameters(StringBuffer sb, IFunctionDeclaration fd) {
        String[] params = fd.getParameterTypes();
        sb.append('(');
        int i = 0;
        while (i < params.length) {
            sb.append(params[i]);
            if (i != params.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(')');
    }

    private String getVariableName(IVariable variable) {
        return variable.getElementName();
    }

    private ITranslationUnit getTranslationUnit(IFile file) {
        ICElement element = CoreModel.getDefault().create(file);
        if (element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return null;
    }

    private boolean toggleBreakpointEnable(IWorkbenchPart part) {
        IVerticalRulerInfo info;
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null && (info = (IVerticalRulerInfo)textEditor.getAdapter(IVerticalRulerInfo.class)) != null) {
            EnableDisableBreakpointRulerAction enableAction = new EnableDisableBreakpointRulerAction(part, info);
            enableAction.update();
            enableAction.run();
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    protected IBreakpoint getBreakpointFromEditor(ITextEditor editor, IVerticalRulerInfo info) {
        IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != info.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    protected void openBreakpointPropertiesDialog(ICBreakpoint bp, IWorkbenchPart part, IResource resource, Map<String, Object> attributes) {
        PreferenceDialog dialog;
        ISelection debugContext = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow()).getActiveContext(part.getSite().getId());
        CBreakpointContext bpContext = new CBreakpointContext(bp, debugContext, resource, attributes);
        String initialPageId = null;
        if (bp.getMarker() == null) {
            initialPageId = "org.eclipse.cdt.debug.ui.propertypages.breakpoint.common";
        }
        if ((dialog = PreferencesUtil.createPropertyDialogOn((Shell)part.getSite().getShell(), (IAdaptable)bpContext, (String)initialPageId, null, null)) != null) {
            dialog.open();
        }
    }

    protected abstract ICLineBreakpoint findLineBreakpoint(String var1, IResource var2, int var3) throws CoreException;

    protected abstract void createLineBreakpoint(boolean var1, IWorkbenchPart var2, String var3, IResource var4, int var5) throws CoreException;

    protected abstract ICFunctionBreakpoint findFunctionBreakpoint(String var1, IResource var2, String var3) throws CoreException;

    protected abstract void createFunctionBreakpoint(boolean var1, IWorkbenchPart var2, String var3, IResource var4, String var5, int var6, int var7, int var8) throws CoreException;

    protected abstract ICWatchpoint findWatchpoint(String var1, IResource var2, String var3) throws CoreException;

    protected abstract void createWatchpoint(boolean var1, IWorkbenchPart var2, String var3, IResource var4, int var5, int var6, int var7, String var8, String var9, String var10) throws CoreException;

    protected abstract void createEventBreakpoint(boolean var1, IWorkbenchPart var2, IResource var3, String var4, String var5) throws CoreException;
}

