/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.DsfSourceDisplayAdapter;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public final class CudaSourceDisplayAdapter
extends DsfSourceDisplayAdapter {
    public CudaSourceDisplayAdapter(DsfSession session, ISourceLookupDirector sourceLocator, SteppingController controller) {
        super(session, sourceLocator, controller);
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean force) {
        if (context instanceof IAdaptable && (context = ((IAdaptable)context).getAdapter(IDMContext.class)) instanceof IDMContext && !(context instanceof IStack.IFrameDMContext)) {
            IStack.IFrameDMContext frame = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMContext)context), IStack.IFrameDMContext.class);
            if (frame == null) {
                IRunControl.IExecutionDMContext execution = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMContext)context), IRunControl.IExecutionDMContext.class);
                if (execution != null) {
                    this.displayForTopFrame(execution, page, force);
                    return;
                }
            } else {
                context = frame;
            }
        }
        CudaSourceDisplayAdapter.getDisplay(page).syncExec(new Runnable(){

            @Override
            public void run() {
                CudaSourceDisplayAdapter.this.fIPManager.removeAllAnnotations();
            }
        });
        super.displaySource(context, page, force);
    }

    private void displayForTopFrame(IRunControl.IExecutionDMContext execution, final IWorkbenchPage page, final boolean force) {
        IStack stack;
        if (DsfSession.isSessionActive((String)execution.getSessionId()) && (stack = (IStack)this.fServicesTracker.getService(IStack.class)) != null) {
            stack.getTopFrame((IDMContext)execution, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>((Executor)DisplayDsfExecutor.getDisplayDsfExecutor((Display)CudaSourceDisplayAdapter.getDisplay(page)), null){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    if (this.getData() != null) {
                        CudaSourceDisplayAdapter.this.displaySource(this.getData(), page, force);
                    }
                }

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleError() {
                }
            });
        }
    }

    private static Display getDisplay(IWorkbenchPage page) {
        return page.getWorkbenchWindow().getShell().getDisplay();
    }
}

