/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteFileManager;

public class LocalFileManager
implements IRemoteFileManager {
    @Override
    public String getDirectorySeparator() {
        return System.getProperty("file.separator", "/");
    }

    @Override
    public IFileStore getResource(String path) {
        return EFS.getLocalFileSystem().getStore((IPath)new Path(path));
    }

    @Override
    public String toPath(URI uri) {
        return URIUtil.toPath((URI)uri).toString();
    }

    @Override
    public URI toURI(IPath path) {
        return URIUtil.toURI((IPath)path);
    }

    @Override
    public URI toURI(String path) {
        return URIUtil.toURI((String)path);
    }
}

