/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.subsystems;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractCredentialsProvider;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ICredentials;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.ICredentialsValidator;
import org.eclipse.rse.ui.dialogs.ISystemPasswordPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemChangePasswordDialog;
import org.eclipse.rse.ui.dialogs.SystemPasswordPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class StandardCredentialsProvider
extends AbstractCredentialsProvider {
    private String userId = null;
    private String password = null;
    private boolean savePassword = false;
    private boolean saveUserId = false;
    private boolean acquiring = false;

    public StandardCredentialsProvider(IConnectorService connectorService) {
        super(connectorService);
    }

    public final void acquireCredentials(boolean reacquire) throws OperationCanceledException {
        PasswordPersistenceManager ppm;
        SystemSignonInformation savedSignonInformation;
        if (this.isSuppressed()) {
            throw new OperationCanceledException();
        }
        ISubSystem subsystem = this.getPrimarySubSystem();
        IHost host = subsystem.getHost();
        String hostName = host.getHostName();
        IRSESystemType systemType = host.getSystemType();
        this.savePassword = false;
        if (this.supportsUserId()) {
            boolean sameHost = hostName.equalsIgnoreCase(this.getConnectorService().getHostName());
            if (!sameHost) {
                this.clearCredentials();
            }
            this.getUserId();
        }
        if (this.supportsPassword() && this.password == null && (savedSignonInformation = (ppm = PasswordPersistenceManager.getInstance()).find(systemType, hostName, this.userId)) != null) {
            this.password = savedSignonInformation.getPassword();
            this.savePassword = true;
        }
        ICredentialsValidator validator = this.getSignonValidator();
        ICredentials credentials = this.getCredentials();
        if (validator != null) {
            SystemMessage m = validator.validate(credentials);
            this.password = credentials.getPassword();
            if (m != null) {
                Shell shell = this.getShell();
                if (shell != null) {
                    SystemMessageDialog dialog = new SystemMessageDialog(shell, m);
                    dialog.open();
                }
                reacquire = true;
            }
        }
        if (this.supportsPassword() || this.supportsUserId()) {
            boolean userIdNeeded;
            boolean passwordNeeded = this.supportsPassword() && this.password == null;
            boolean bl = userIdNeeded = this.supportsUserId() && this.userId == null;
            if (passwordNeeded || userIdNeeded || reacquire) {
                this.promptForCredentials();
                this.acquiring = true;
                if (this.savePassword) {
                    this.getConnectorService().savePassword();
                } else {
                    this.getConnectorService().removePassword();
                }
                if (this.saveUserId) {
                    this.getConnectorService().saveUserId();
                }
                this.acquiring = false;
            }
        }
    }

    public final void clearCredentials() {
        if (!this.acquiring) {
            this.password = null;
            this.userId = null;
        }
    }

    public final void clearPassword() {
        if (!this.acquiring) {
            this.password = null;
        }
    }

    public final ICredentials getCredentials() {
        PasswordPersistenceManager ppm;
        IHost host = this.getConnectorService().getHost();
        String hostName = host.getHostName();
        IRSESystemType systemType = host.getSystemType();
        SystemSignonInformation result = null;
        if (this.password == null && this.savePassword && (result = (ppm = PasswordPersistenceManager.getInstance()).find(systemType, hostName, this.userId)) != null) {
            this.password = result.getPassword();
        }
        if (result == null) {
            result = new SystemSignonInformation(hostName, this.userId, this.password, systemType);
        }
        return result;
    }

    public final String getUserId() {
        if (this.supportsUserId() && this.userId == null) {
            this.userId = this.getSubSystemUserId();
        }
        return this.userId;
    }

    public final void repairCredentials(SystemMessage prompt) throws OperationCanceledException {
        this.promptForNewPassword(prompt);
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setPassword(String matchingUserId, String password, boolean persist) {
        if (this.getPrimarySubSystem().forceUserIdToUpperCase()) {
            matchingUserId = matchingUserId.toUpperCase();
        }
        IConnectorService cs = this.getConnectorService();
        IRSESystemType systemType = cs.getHost().getSystemType();
        String hostName = cs.getHostName();
        SystemSignonInformation signonInformation = new SystemSignonInformation(hostName, matchingUserId, password, systemType);
        this.setSignonInformation(signonInformation);
        if (persist) {
            PasswordPersistenceManager.getInstance().add(signonInformation, true, false);
        } else {
            PasswordPersistenceManager.getInstance().remove(systemType, hostName, this.userId);
        }
    }

    public final void setUserId(String newId) {
        if (this.userId == null || !this.userId.equals(newId)) {
            this.userId = newId;
        }
    }

    protected ISystemPasswordPromptDialog getPasswordPromptDialog(Shell shell) {
        SystemPasswordPromptDialog dlg = new SystemPasswordPromptDialog(shell, this.requiresUserId(), this.requiresPassword());
        return dlg;
    }

    protected ICredentialsValidator getSignonValidator() {
        return null;
    }

    private boolean forcePasswordToUpperCase() {
        return this.getPrimarySubSystem().forceUserIdToUpperCase();
    }

    private ISystemValidator getPasswordValidator() {
        ISubSystemConfiguration subsystemConfiguration = this.getPrimarySubSystem().getSubSystemConfiguration();
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)Platform.getAdapterManager().getAdapter((Object)subsystemConfiguration, ISubSystemConfigurationAdapter.class);
        return adapter.getPasswordValidator(subsystemConfiguration);
    }

    private ISubSystem getPrimarySubSystem() {
        return this.getConnectorService().getPrimarySubSystem();
    }

    private Shell getShell() {
        IWorkbenchWindow window;
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        return shell;
    }

    private String getSubSystemUserId() {
        ISubSystem ss = this.getPrimarySubSystem();
        String result = ss.getUserId();
        return result;
    }

    private ISystemValidator getUserIdValidator() {
        ISubSystemConfiguration subsystemConfiguration = this.getPrimarySubSystem().getSubSystemConfiguration();
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)subsystemConfiguration.getAdapter(ISubSystemConfigurationAdapter.class);
        if (adapter == null) {
            Platform.getAdapterManager().loadAdapter((Object)subsystemConfiguration, ISubSystemConfigurationAdapter.class.getName());
            adapter = (ISubSystemConfigurationAdapter)subsystemConfiguration.getAdapter(ISubSystemConfigurationAdapter.class);
        }
        ISystemValidator validator = adapter.getUserIdValidator(subsystemConfiguration);
        return validator;
    }

    private void logException(Throwable t) {
        Logger log = LoggerFactory.getLogger((Plugin)RSEUIPlugin.getDefault());
        log.logError("Unexpected exception", t);
    }

    private void promptForCredentials() throws OperationCanceledException {
        PromptForCredentials runnable = new PromptForCredentials();
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.isCancelled()) {
            throw new OperationCanceledException();
        }
    }

    private void promptForNewPassword(SystemMessage prompt) throws OperationCanceledException {
        PromptForNewPassword runnable = new PromptForNewPassword(prompt);
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.isCancelled()) {
            throw new OperationCanceledException();
        }
    }

    private void setSignonInformation(SystemSignonInformation signonInfo) {
        this.password = signonInfo.getPassword();
        this.userId = signonInfo.getUserId();
    }

    private class PromptForCredentials
    implements Runnable {
        private boolean cancelled = false;

        private PromptForCredentials() {
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void run() {
            Shell shell = StandardCredentialsProvider.this.getShell();
            if (shell == null) {
                shell = new Shell();
            }
            if (shell != null) {
                ISystemPasswordPromptDialog dialog = StandardCredentialsProvider.this.getPasswordPromptDialog(shell);
                dialog.setSystemInput(StandardCredentialsProvider.this.getConnectorService());
                dialog.setForceToUpperCase(StandardCredentialsProvider.this.forcePasswordToUpperCase());
                dialog.setSignonValidator(StandardCredentialsProvider.this.getSignonValidator());
                if (StandardCredentialsProvider.this.supportsUserId()) {
                    dialog.setUserIdValidator(StandardCredentialsProvider.this.getUserIdValidator());
                }
                if (StandardCredentialsProvider.this.supportsPassword()) {
                    dialog.setSavePassword(StandardCredentialsProvider.this.savePassword);
                    dialog.setPassword(StandardCredentialsProvider.this.password);
                    dialog.setPasswordValidator(StandardCredentialsProvider.this.getPasswordValidator());
                }
                try {
                    dialog.open();
                }
                catch (Exception e) {
                    StandardCredentialsProvider.this.logException(e);
                }
                this.cancelled = dialog.wasCancelled();
                if (!this.cancelled) {
                    StandardCredentialsProvider.this.userId = dialog.getUserId();
                    StandardCredentialsProvider.this.password = dialog.getPassword();
                    StandardCredentialsProvider.this.saveUserId = dialog.getIsUserIdChangePermanent();
                    StandardCredentialsProvider.this.savePassword = dialog.getIsSavePassword();
                }
            } else {
                this.cancelled = true;
            }
        }
    }

    private class PromptForNewPassword
    implements Runnable {
        private SystemMessage message;
        private boolean cancelled = false;

        public PromptForNewPassword(SystemMessage message) {
            this.message = message;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void run() {
            Shell shell = StandardCredentialsProvider.this.getShell();
            if (shell != null) {
                SystemChangePasswordDialog dlg = new SystemChangePasswordDialog(shell, StandardCredentialsProvider.this.getConnectorService().getHostName(), StandardCredentialsProvider.this.getUserId(), this.message);
                dlg.setSavePassword(StandardCredentialsProvider.this.savePassword);
                dlg.open();
                this.cancelled = dlg.wasCancelled();
                if (!this.cancelled) {
                    StandardCredentialsProvider.this.password = dlg.getNewPassword();
                    StandardCredentialsProvider.this.savePassword = dlg.getIsSavePassword();
                }
            } else {
                this.cancelled = true;
            }
        }
    }
}

