/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.ui.ISystemVerifyListener;
import org.eclipse.rse.ui.propertypages.ISystemConnectionWizardErrorUpdater;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.widgets.IServerLauncherForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ServerLauncherPropertyPage
extends SystemBasePropertyPage {
    private IServerLauncherForm _form;
    protected IRSESystemType _systemType;
    private IServerLauncherProperties sl;
    private ISubSystemConfiguration _factory;

    protected Control createContentArea(Composite parent) {
        ISubSystemConfiguration factory = null;
        IAdaptable input = this.getElement();
        IConnectorService connectorService = null;
        if (input instanceof ISubSystem) {
            ISubSystem ss = (ISubSystem)input;
            connectorService = ss.getConnectorService();
            this.sl = connectorService.getRemoteServerLauncherProperties();
            factory = ss.getSubSystemConfiguration();
        } else {
            factory = input instanceof ISubSystemConfiguration ? (ISubSystemConfiguration)input : this._factory;
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)factory.getAdapter(ISubSystemConfigurationAdapter.class);
        this._form = adapter.getServerLauncherForm(factory, this.getShell(), this.getMessageLine());
        this._form.createContents(parent);
        if (this.sl != null && connectorService != null) {
            this._form.setHostname(connectorService.getHost().getHostName());
            this._form.initValues(this.sl);
        }
        return parent;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
        this._factory = factory;
    }

    public void setHostname(String hostName) {
        this._form.setHostname(hostName);
    }

    public boolean applyValues(IConnectorService connectorService) {
        SubSystem ss;
        if (this._form == null) {
            return true;
        }
        if (this.getElement() instanceof SubSystem && !(ss = (SubSystem)this.getElement()).getConnectorService().supportsServerLaunchProperties()) {
            return true;
        }
        if (this._form.verify()) {
            if (this.sl == null) {
                this.sl = connectorService.getRemoteServerLauncherProperties();
            }
            if (this._form.updateValues(this.sl)) {
                try {
                    connectorService.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    public boolean performOk() {
        if (this._form.isDirty()) {
            return this.applyValues(this.sl.getConnectorService());
        }
        return true;
    }

    public boolean isPageComplete() {
        if (this._form.isDirty()) {
            return this._form.verify();
        }
        return true;
    }

    public void addVerifyListener(ISystemVerifyListener listener) {
        if (this._form instanceof ISystemConnectionWizardErrorUpdater) {
            ((ISystemConnectionWizardErrorUpdater)((Object)this._form)).addVerifyListener(listener);
        }
    }

    public String getTheErrorMessage() {
        return this.getErrorMessage();
    }

    public void setSystemType(IRSESystemType systemType) {
        this._systemType = systemType;
    }
}

