/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EclipseObjects {
    public static IWorkbenchPage getActivePage() {
        return EclipseObjects.getActiveWindow().getActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = EclipseObjects.getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        if (page.isEditorAreaVisible() && activeEditor instanceof TextEditor) {
            return activeEditor;
        }
        return null;
    }

    public static IEditorPart getEditorForFile(IFile file) {
        IEditorReference[] editors;
        IWorkbenchPage page = EclipseObjects.getActivePage();
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            CEditor edi;
            IResource resource;
            IEditorReference editor2 = iEditorReferenceArray[n2];
            IEditorPart editor = editor2.getEditor(false);
            if (editor instanceof CEditor && (resource = (edi = (CEditor)editor).getInputCElement().getResource()) instanceof IFile && ((IFile)resource).equals((Object)file)) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    public static IFile getActiveFile() {
        IEditorInput editorInput = EclipseObjects.getActiveEditor().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public static IDocument getActiveDocument() {
        return EclipseObjects.getDocument(EclipseObjects.getActiveEditor());
    }

    public static IDocument getDocument(IEditorPart editor) {
        ITextEditor txtEditor = (ITextEditor)editor;
        IDocumentProvider prov = txtEditor.getDocumentProvider();
        return prov.getDocument((Object)txtEditor.getEditorInput());
    }

    public static IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IDocument getDocument(IFile file) {
        IEditorPart editor = EclipseObjects.getEditorForFile(file);
        return EclipseObjects.getDocument(editor);
    }

    public static IFile getFile(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IFile file = EclipseObjects.getFile((IStructuredSelection)selection);
            return file;
        }
        return EclipseObjects.getActiveFile();
    }

    private static IFile getFile(IStructuredSelection selection) {
        ICElement e;
        IResource r;
        Object o = selection.getFirstElement();
        if (o instanceof ICElement && (r = (e = (ICElement)o).getUnderlyingResource()) instanceof IFile) {
            return (IFile)r;
        }
        return null;
    }

    public static IFile getFileForPathString(String filePath) {
        Path path = new Path(filePath);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
    }
}

