# -*- coding: UTF-8 -*-

# WebLingvoSoft-0.8
# Copyright (c) 2005...2007 Kęstutis Biliūnas <kebil@kaunas.init.lt>
#               2005 Matynas Jocius <mjoc@akl.lt>
#
# This code is licensed under the GNU GPL v2

"""
OpenDict plugin for online LingvoSoft dictionary
(http://www.lingvosoft.com or http://www.lingvozone.com)
"""

import sets
import httplib
import urllib
import socket
import HTMLParser
import string

class MLStripper(HTMLParser.HTMLParser):
    def __init__(self):
        self.reset()
        self.fed = []
    def handle_data(self, d):
        self.fed.append(d)
    def get_fed_data(self):
        return ''.join(self.fed)



class WebLingvoSoft:
    """LingvoZone (LingvoSoft) plugin class"""
    
    def __init__(self, langto="16"):
        """Initialize variables"""

        from lib import errortype, meta

        self.langto = langto

        self.errorModule = errortype
        self.metaModule = meta

        self.encoding = "utf-8"


    def search(self, word):
        """Search for a word. Returns HTML code."""

        result = self.metaModule.SearchResult()

        try:
            word = word.decode('utf-8').lower().encode('utf-8') 
            word = string.strip(word, "\",:!.;()")

            self.conn = httplib.HTTPConnection("www.lingvozone.com")
            self.conn.request("GET", "/onlineforms/dictionary_online_form_wo_adv.jsp?" \
                                     "action=translation_ajax&language_id_from=" \
                                     "23&language_id_to="+self.langto+"&word=" \
                                     +urllib.quote(word))

            response = self.conn.getresponse()
            data = response.read()

            tresult = "<html>"
            tresult += "<head><meta http-equiv=\"Content-Type\" " \
                "content=\"text/html; charset=utf-8\"></head><body>"

            data = data[data.find("<span id=dummyspan></span>"):]
            data = data.strip()

            data = data[: data.find("<h2>Your translation history:</h2>")]
            data = data.strip()

            altWords = []
            lines = data.split('\n')

            if "has not been found in the dictionary" in data:
                if "The closest match is:</b>" in data:

                    altLines = [l for l in lines if '<option value=' in l]

                    for altLine in altLines:
                        s = MLStripper()
                        s.feed(altLine)
                        word = s.get_fed_data()
                        word = word.replace("\t", "")
                        word = word.replace("\x0D", " ")
                        altWords.append(word)

                    data = data[: data.find("The closest match is:</b>")]
                    data = data.strip()

            else:
                data = data[data.find("<font class="):]
                data = data.strip()

                data = data.replace("<input type=\"image\" src=\"/Lingvozone.com" \
                                    "/images/main/k_say.gif\" alt=\"Please allow the audio" \
                                    " file to load and play after click\" align=\"absmiddle\" " \
                                    "onClick=\"playtts()\">", " ")

                data = data.replace("<font class=\"tr_result\"", \
                                    "<table><tr bgcolor=\"#dde2f1\"><td><font><b")

                if "]</font>" in data:
                    data = data.replace("]</font>", "]</b></font></td></tr></table>")
                    data = data.replace("</font> <font class=\"tr_result_2\">[", \
                                        "</b></font> <font><b>[")
                else:
                    data = data.replace("</font> <font class=\"tr_result_2\">", \
                                        "</b></font></td></tr></table>")                    

                data = data.replace("<img src=\"/Lingvozone.com/images/main/arrow.gif\">", \
                                    " -> ")

                data = data.replace("<strong>English Thesaurus:", \
                                    "<br><br><strong>English Thesaurus:")

                data = data.replace("alt=\"Please allow the audio file to load" \
                                    " and play after click\"", " ")
                data = data.replace("input type=\"image\" src=", "aaa ")

                altLines = [l for l in lines if '&nbsp;<a href=\";jsessionid=' in l]

                altWords.append(word)

                for altLine in altLines:
                    s = MLStripper()
                    s.feed(altLine)
                    word = s.get_fed_data()
                    word = word.replace("\t", "")
                    word = word.replace("\x0D", " ")
                    altWords.append(word)

                data = data.replace("href=", "aaa=")

                end = data.find("<h3>Similar words:</h3>")
                data = data[:end]

            altWords = list(sets.Set(altWords))
            altWords.sort()

            data = tresult + data + "</body></html>"

            result.setTranslation(data)
            result.setWordList(altWords)

        except socket.gaierror, e:
            result.setError(self.errorModule.CONNECTION_ERROR)
            return result
        
        except httplib.CannotSendRequest, e:
            result.setError(self.errorModule.CONNECTION_ERROR)
            return result

        except:
            import traceback
            traceback.print_exc()

            result.setError(self.errorModule.INTERNAL_ERROR)

            return result

        return result

