#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Minecraft 4K
# send your bug reports to contact@dotslashplay.it
###

script_version=20230623.2

GAME_ID='minecraft-4k'
GAME_NAME='Minecraft 4K'

ARCHIVE_BASE_0='4K.exe'
ARCHIVE_BASE_0_MD5='c566f5be102e1e1afc153690e47173e5'
ARCHIVE_BASE_0_EXTRACTOR='unzip'
ARCHIVE_BASE_0_SIZE='20'
ARCHIVE_BASE_0_VERSION='1.0-archiveorg180513'
ARCHIVE_BASE_0_URL='https://archive.org/details/Minecraft4K'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
M.class'

APP_MAIN_TYPE='java'
APP_MAIN_EXE='M'

PKG_MAIN_DEPS='java'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# The launcher target is not a .jar archive

launcher_target_presence_check() { true ; }
java_launcher_run() {
	local application
	application="$1"

	cat <<- 'EOF'
	# Run the game

	cd "$PATH_PREFIX"

	EOF

	# Set loading paths for libraries
	native_launcher_libraries

	application_prerun "$application"

	cat <<- 'EOF'
	## Do not exit on application failure,
	## to ensure post-run commands are run.
	set +o errexit

	## Silence ShellCheck false-positive
	## Double quote to prevent globbing and word splitting.
	# shellcheck disable=SC2086
	java $JAVA_OPTIONS "$APP_EXE" $APP_OPTIONS "$@"

	game_exit_status=$?
	set -o errexit

	EOF

	application_postrun "$application"
}

# Extract game data

## Errors during the data extraction from the archive are expected,
## they should be ignored.
archive_extraction 'SOURCE_ARCHIVE' 2>/dev/null || true

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
