#! /usr/bin/env python3
# -*- coding: utf-8 -*-

"""
This documentation is licensed under Creative Commons-BY-SA-4.0.
Please read the provided documentation/LICENSE file or visit
https://creativecommons.org/licenses/by-sa/4.0/legalcode

The documentation is built statically and does not belong to the normal build process with configure and make
Its updating is part of the development process, not packaging and running.
The correct out/ dir is already part of git.

.adoc is asciidoctor, not simple asciidoc.
"""


#Make the readme

import sys
sys.path.append("../engine")
from config import METADATA
import subprocess
from os import getcwd
import os.path
assert os.path.exists(os.path.join(getcwd(), __file__)), (getcwd(), __file__)
import datetime


#Readme

with open("readme.template", "r") as r:
    template_readme = r.read()

template_readme = template_readme.replace("<date>", datetime.datetime.now().isoformat())
template_readme = template_readme.replace("<name>", METADATA["name"])
template_readme = template_readme.replace("<version>", METADATA["version"])
template_readme = template_readme.replace("<shortname>", METADATA["shortName"])
template_readme = template_readme.replace("<description>", METADATA["description"])
template_readme = template_readme.replace("<dependencies>", METADATA["dependencies"])
template_readme = template_readme.replace("<author>", METADATA["author"])

with open ("../README.md", "w") as w:
    w.write(template_readme)

print ("Built /README.md")

#Documentation index

with open("index.adoc.template", "r") as r:
    template_index = r.read()

template_index = template_index.replace("<name>", METADATA["name"])
template_index = template_index.replace("<shortname>", METADATA["shortName"])
template_index = template_index.replace("<version>", METADATA["version"])
template_index = template_index.replace("<author>", METADATA["author"])

with open ("index.adoc", "w") as w:
    w.write(template_index)

#Documentation

METADATA["supportedLanguages"].update({"English":""})
for language in METADATA["supportedLanguages"].keys():

    language = language.lower()

    try:
        with open(f"{language}.adoc.template", "r") as r:
            template = r.read()
    except:
        continue #language not yet supported as manual

    for key, value in METADATA.items(): #all strings
        if type(value) is str:
            template = template.replace(f"<{key}>", value)

    if language == "english":
        template = template.replace("<english-only-description>", "== Introduction\n\n" + METADATA["description"])

    with open (f"{language}.part.adoc", "r") as clientPart:
        template = template.replace("<manual>", clientPart.read())

    with open (f"{language}.adoc", "w") as w:
        w.write(template)


#Create manpage
#Needs help2man
manpage_template = f"""
[name]
{METADATA["name"]} - {METADATA["tagline"]}

[usage]
{METADATA["description"]}

[Reporting bugs]
https://www.laborejo.org/bugs

[copyright]
{METADATA["name"]} {METADATA["version"]} - Copyright {METADATA["year"]}
{METADATA["author"]}
https://www.laborejo.org/

[examples]
Run agordejo. You are now in the session overview. Press the "Quick New" button and add programs
by a double clicking on the list. Try right-clicking on many things to get more options in
context menus.

[see also]
The  full  documentation for {METADATA["name"]} is maintained as a multi-lingual html site to your systems doc-dir.
For example:
    xdg-open file:///usr/share/doc/{METADATA["shortName"]}/index.html

The documentation can also be found online https://www.laborejo.org/documentation/{METADATA["shortName"]}
"""

with open ("manpageinclude.h2m", "w") as w:
    w.write(manpage_template)

command = f"help2man ../{METADATA['shortName']} --no-info --include manpageinclude.h2m > {METADATA['shortName']}.1"
subprocess.run(command, capture_output=True, text=True, shell=True)

#help2man for the much simpler nsm-data
commandNsmDataMNan = "help2man ../tools/nsm-data --no-info > nsm-data.1"
subprocess.run(commandNsmDataMNan, capture_output=True, text=True, shell=True)

print ("Built. You still need to run")
print ("sh build-documentation.sh")
